/*
 * Decompiled with CFR 0.152.
 */
package agorum.api.common.beans.common;

import agorum.api.common.beans.adapters.PropertyDeserializer;
import agorum.api.common.beans.adapters.PropertyMapAdapter;
import agorum.api.common.beans.common.Property;
import agorum.api.common.beans.common.PropertyArray;
import agorum.api.common.beans.common.PropertyBoolean;
import agorum.api.common.beans.common.PropertyDouble;
import agorum.api.common.beans.common.PropertyLong;
import agorum.api.common.beans.common.PropertyString;
import agorum.commons.string.SerializableMap;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlRootElement(name="PropertyMap")
@XmlType(name="PropertyMap")
public class PropertyMap
extends Property {
    private static final long serialVersionUID = 1L;
    @XmlJavaTypeAdapter(value=PropertyMapAdapter.class)
    private final Map<String, Property> properties;

    public PropertyMap() {
        this.properties = new HashMap<String, Property>();
    }

    public PropertyMap(Map<String, Property> properties) {
        this.properties = properties;
    }

    public static PropertyMap fromString(String toParse) {
        try {
            return PropertyDeserializer.deserializeProperty(toParse).getMap();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void putObject(String key, Object value) {
        this.properties.put(key, Property.valueOf(value));
    }

    public void put(String key, Object value) {
        this.properties.put(key, Property.valueOf(value));
    }

    public void put(String key, long value) {
        this.properties.put(key, new PropertyLong(value));
    }

    public void put(String key, Long value) {
        this.properties.put(key, new PropertyLong(value));
    }

    public void put(String key, Double value) {
        this.properties.put(key, new PropertyDouble(value));
    }

    public void put(String key, Boolean value) {
        this.properties.put(key, new PropertyBoolean(value));
    }

    public void put(String key, String value) {
        this.properties.put(key, new PropertyString(value));
    }

    public void put(String key, String[] value) {
        this.properties.put(key, new PropertyArray(value));
    }

    public void putAll(PropertyMap other) {
        this.properties.putAll(other.getProperties());
    }

    public Property remove(String key) {
        return this.properties.remove(key);
    }

    public Object removeObject(String key) {
        return Property.unwrap(this.properties.remove(key));
    }

    public Property get(String key) {
        return this.properties.get(key);
    }

    public Object getObject(String key) {
        return Property.unwrap(this.properties.get(key));
    }

    public Long getLong(String key) {
        Property property = this.properties.get(key);
        if (property != null) {
            return property.getLong();
        }
        return null;
    }

    public long getLong(String key, long defaultValue) {
        Long value;
        Property property = this.properties.get(key);
        if (property != null && (value = property.getLong()) != null) {
            return value;
        }
        return defaultValue;
    }

    public Double getDouble(String key) {
        Property property = this.properties.get(key);
        if (property != null) {
            return property.getDouble();
        }
        return null;
    }

    public double getDouble(String key, double defaultValue) {
        Double value;
        Property property = this.properties.get(key);
        if (property != null && (value = property.getDouble()) != null) {
            return value;
        }
        return defaultValue;
    }

    public Boolean getBoolean(String key) {
        Property property = this.properties.get(key);
        if (property != null) {
            return property.getBoolean();
        }
        return null;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        Boolean value;
        Property property = this.properties.get(key);
        if (property != null && (value = property.getBoolean()) != null) {
            return value;
        }
        return defaultValue;
    }

    public String getString(String key) {
        Property property = this.properties.get(key);
        if (property != null) {
            return property.getString();
        }
        return null;
    }

    public String getString(String key, String defaultValue) {
        String value;
        Property property = this.properties.get(key);
        if (property != null && (value = property.getString()) != null) {
            return value;
        }
        return defaultValue;
    }

    public Date getDate(String key, Date defaultValue) {
        Date value;
        Property property = this.properties.get(key);
        if (property != null && (value = property.getDate()) != null) {
            return value;
        }
        return defaultValue;
    }

    public Date getDateTime(String key, Date defaultValue) {
        Date value;
        Property property = this.properties.get(key);
        if (property != null && (value = property.getDateTime()) != null) {
            return value;
        }
        return defaultValue;
    }

    public PropertyMap getMap(String key) {
        Property property = this.properties.get(key);
        if (property != null) {
            return property.getMap();
        }
        return null;
    }

    public PropertyArray getArray(String key) {
        Property property = this.properties.get(key);
        if (property != null) {
            return property.getArray();
        }
        return null;
    }

    public Long removeLong(String key) {
        Property property = this.properties.remove(key);
        if (property != null) {
            return property.getLong();
        }
        return null;
    }

    public long removeLong(String key, long defaultValue) {
        Long value;
        Property property = this.properties.remove(key);
        if (property != null && (value = property.getLong()) != null) {
            return value;
        }
        return defaultValue;
    }

    public Double removeDouble(String key) {
        Property property = this.properties.remove(key);
        if (property != null) {
            return property.getDouble();
        }
        return null;
    }

    public double removeDouble(String key, double defaultValue) {
        Double value;
        Property property = this.properties.remove(key);
        if (property != null && (value = property.getDouble()) != null) {
            return value;
        }
        return defaultValue;
    }

    public Boolean removeBoolean(String key) {
        Property property = this.properties.remove(key);
        if (property != null) {
            return property.getBoolean();
        }
        return null;
    }

    public boolean removeBoolean(String key, boolean defaultValue) {
        Boolean value;
        Property property = this.properties.remove(key);
        if (property != null && (value = property.getBoolean()) != null) {
            return value;
        }
        return defaultValue;
    }

    public String removeString(String key) {
        Property property = this.properties.remove(key);
        if (property != null) {
            return property.getString();
        }
        return null;
    }

    public String removeString(String key, String defaultValue) {
        String value;
        Property property = this.properties.remove(key);
        if (property != null && (value = property.getString()) != null) {
            return value;
        }
        return defaultValue;
    }

    public Date removeDate(String key, Date defaultValue) {
        Date value;
        Property property = this.properties.remove(key);
        if (property != null && (value = property.getDate()) != null) {
            return value;
        }
        return defaultValue;
    }

    public Date removeDateTime(String key, Date defaultValue) {
        Date value;
        Property property = this.properties.remove(key);
        if (property != null && (value = property.getDateTime()) != null) {
            return value;
        }
        return defaultValue;
    }

    public PropertyMap removeMap(String key) {
        Property property = this.properties.remove(key);
        if (property != null) {
            return property.getMap();
        }
        return null;
    }

    public PropertyArray removeArray(String key) {
        Property property = this.properties.remove(key);
        if (property != null) {
            return property.getArray();
        }
        return null;
    }

    @Override
    public PropertyMap getMap() {
        return this;
    }

    public Map<String, Property> getProperties() {
        return this.properties;
    }

    public int size() {
        return this.properties.size();
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.properties.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.properties.containsValue(value);
    }

    public Property put(String key, Property value) {
        return this.properties.put(key, value);
    }

    public Property get(Object key) {
        return this.properties.get(key);
    }

    public Property remove(Object key) {
        return this.properties.remove(key);
    }

    public Set<Map.Entry<String, Property>> entrySet() {
        return this.properties.entrySet();
    }

    public Set<String> keySet() {
        return this.properties.keySet();
    }

    public Collection<Property> values() {
        return this.properties.values();
    }

    public void putAll(Map<? extends String, ? extends Property> m) {
        this.properties.putAll(m);
    }

    public void clear() {
        this.properties.clear();
    }

    public static SerializableMap toSerializableMap(PropertyMap pmap) {
        if (pmap == null) {
            return new SerializableMap();
        }
        return new SerializableMap(PropertyMap.unwrap(pmap));
    }
}

