/*
 * Decompiled with CFR 0.152.
 */
package agorum.api.common.utils;

import agorum.api.common.beans.common.Property;
import agorum.api.common.beans.common.PropertyArray;
import agorum.api.common.beans.common.PropertyMap;
import agorum.api.common.beans.common.PropertyString;
import agorum.api.common.exceptions.ApiException;
import agorum.api.common.exceptions.server.ApiNotImplementedException;
import agorum.api.common.exceptions.usage.ApiInvalidParameterException;
import agorum.api.common.utils.Objects;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.scripting.Converter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import org.mozilla.javascript.Scriptable;

public final class DataTypes {
    private static final ConcurrentDateFormat dateTimeFormat = new ConcurrentDateFormat(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"), true);
    private static final ConcurrentDateFormat timeFormat = new ConcurrentDateFormat(new SimpleDateFormat("HHmmssZ"), false);
    private static final ConcurrentDateFormat dateFormat = new ConcurrentDateFormat(new SimpleDateFormat("yyyyMMdd"), false);
    private static final int dateFormatLength = 8;
    private static final Object[] EMPTY_ARRAY = new Object[0];

    private DataTypes() {
    }

    public static String dateToString(Date date) {
        return ((DateFormat)dateFormat.get()).format(date);
    }

    public static String dateTimeToString(Date date) {
        return ((DateFormat)dateTimeFormat.get()).format(date);
    }

    public static String timeToString(Date date) {
        return ((DateFormat)timeFormat.get()).format(date);
    }

    public static Date stringToDate(String string) throws ParseException {
        if (string != null) {
            return ((DateFormat)dateFormat.get()).parse(string);
        }
        return null;
    }

    public static Date stringToDateTime(String string) throws ParseException {
        if (string != null) {
            try {
                return DatatypeConverter.parseDateTime((String)string).getTime();
            }
            catch (IllegalArgumentException e) {
                throw new ParseException(e.getMessage(), 0);
            }
        }
        return null;
    }

    public static Object convert(String targetType, Object value) {
        return DataTypes.convert(null, Type.fromString(targetType), value);
    }

    private static Object convertArray(SessionController sc, Type type, Object value, boolean primitive, Class<?> targetClass) {
        if (!(value instanceof PropertyArray)) {
            value = Property.valueOf(value).getArray();
        }
        return DataTypes.convertArray(sc, type, (PropertyArray)value, primitive, targetClass.getComponentType());
    }

    private static Object convertArray(SessionController sc, Type type, PropertyArray value, boolean primitive, Class<?> componentType) {
        Object arrayObject = Array.newInstance(componentType, value.size());
        Object[] array = primitive ? EMPTY_ARRAY : (Object[])arrayObject;
        int c = 0;
        if (type == null) {
            for (Property item : value) {
                array[c] = item.getObject();
                ++c;
            }
        } else {
            switch (type) {
                case STRING: {
                    for (Property item : value) {
                        array[c] = (String)DataTypes.convert(sc, type, (Object)item.getString());
                        ++c;
                    }
                    break;
                }
                case LONG: {
                    if (primitive) {
                        long[] primArray = (long[])arrayObject;
                        for (Property item : value) {
                            primArray[c] = (Long)DataTypes.convert(sc, type, (Object)item.getLong());
                            ++c;
                        }
                    } else {
                        for (Property item : value) {
                            array[c] = (Long)DataTypes.convert(sc, type, (Object)item.getLong());
                            ++c;
                        }
                    }
                    break;
                }
                case BOOLEAN: {
                    if (primitive) {
                        boolean[] primArray = (boolean[])arrayObject;
                        for (Property item : value) {
                            primArray[c] = (Boolean)DataTypes.convert(sc, type, (Object)item.getBoolean());
                            ++c;
                        }
                    } else {
                        for (Property item : value) {
                            array[c] = (Boolean)DataTypes.convert(sc, type, (Object)item.getBoolean());
                            ++c;
                        }
                    }
                    break;
                }
                case FLOAT: {
                    if (primitive) {
                        float[] primArray = (float[])arrayObject;
                        for (Property item : value) {
                            primArray[c] = ((Float)DataTypes.convert(sc, type, (Object)item.getDouble())).floatValue();
                            ++c;
                        }
                    } else {
                        for (Property item : value) {
                            array[c] = (Float)DataTypes.convert(sc, type, (Object)item.getDouble());
                            ++c;
                        }
                    }
                    break;
                }
                case DOUBLE: {
                    if (primitive) {
                        double[] primArray = (double[])arrayObject;
                        for (Property item : value) {
                            primArray[c] = (Double)DataTypes.convert(sc, type, (Object)item.getDouble());
                            ++c;
                        }
                    } else {
                        for (Property item : value) {
                            array[c] = (Double)DataTypes.convert(sc, type, (Object)item.getDouble());
                            ++c;
                        }
                    }
                    break;
                }
                case INT: {
                    if (primitive) {
                        int[] primArray = (int[])arrayObject;
                        for (Property item : value) {
                            primArray[c] = (Integer)DataTypes.convert(sc, type, (Object)item.getLong());
                            ++c;
                        }
                    } else {
                        for (Property item : value) {
                            array[c] = (Integer)DataTypes.convert(sc, type, (Object)item.getLong());
                            ++c;
                        }
                    }
                    break;
                }
                case DATE: {
                    for (Property item : value) {
                        array[c] = (Date)DataTypes.convert(sc, type, (Object)item.getDateTime());
                        ++c;
                    }
                    break;
                }
                case USER: 
                case OBJECT: {
                    for (Property item : value) {
                        array[c] = (SuperObjectClientBean)DataTypes.convert(sc, type, item.getObject());
                        ++c;
                    }
                    break;
                }
                default: {
                    throw new ApiNotImplementedException("Conversion from " + value.getClass() + " to " + type.getValue() + " is not supported");
                }
            }
        }
        return arrayObject;
    }

    public static Object convert(SessionController sc, Type type, Object value) {
        if (type == Type.INLINE) {
            if (!(value instanceof PropertyMap)) {
                throw new ApiInvalidParameterException("Invalid value (map expected): " + value);
            }
            PropertyMap inline = (PropertyMap)value;
            return DataTypes.convert(inline.get("type"), inline.get("value"));
        }
        if (value instanceof AttributeValue) {
            value = ((AttributeValue)value).unwrap();
        }
        if (value instanceof Property) {
            value = Property.unwrap(value);
        }
        if (value instanceof Scriptable) {
            value = Converter.toJava(value);
        }
        if (value instanceof CharSequence) {
            String strValue = ((CharSequence)value).toString();
            switch (type) {
                case STRING: {
                    return strValue;
                }
                case BOOLEAN: {
                    return Boolean.valueOf(strValue);
                }
                case INT: {
                    return strValue.isEmpty() ? null : Integer.valueOf(strValue);
                }
                case LONG: {
                    return strValue.isEmpty() ? null : Long.valueOf(strValue);
                }
                case FLOAT: {
                    return strValue.isEmpty() ? null : Float.valueOf(strValue);
                }
                case DOUBLE: {
                    return strValue.isEmpty() ? null : Double.valueOf(strValue);
                }
                case DATE: {
                    if (strValue.isEmpty()) {
                        return null;
                    }
                    if (strValue.length() == 8) {
                        try {
                            return DataTypes.stringToDate(strValue);
                        }
                        catch (ParseException e) {
                            throw ApiException.get(e);
                        }
                    }
                    try {
                        return DataTypes.stringToDateTime(strValue);
                    }
                    catch (ParseException e) {
                        throw ApiException.get(e);
                    }
                }
                case OBJECT: {
                    return Objects.tryFind(sc, strValue);
                }
                case USER: {
                    Object user = Objects.tryFind(sc, strValue);
                    if (user == null) {
                        try {
                            user = Objects.tryFind(sc.asAdmin(), strValue);
                        }
                        catch (Exception e) {
                            throw ApiException.get(e);
                        }
                        if (user != null) {
                            user = sc.getUnknownUserObject();
                        }
                    }
                    return user;
                }
            }
        } else if (value instanceof Number) {
            Number numberValue = (Number)value;
            switch (type) {
                case STRING: {
                    return numberValue.toString();
                }
                case INT: {
                    return numberValue.intValue();
                }
                case LONG: {
                    return numberValue.longValue();
                }
                case FLOAT: {
                    return Float.valueOf(numberValue.floatValue());
                }
                case DOUBLE: {
                    return numberValue.doubleValue();
                }
                case DATE: {
                    return new Date(numberValue.longValue());
                }
                case USER: 
                case OBJECT: {
                    return Objects.find(sc, numberValue.longValue());
                }
            }
        } else if (value instanceof Boolean) {
            Boolean booleanValue = (Boolean)value;
            switch (type) {
                case STRING: {
                    return booleanValue.toString();
                }
                case BOOLEAN: {
                    return booleanValue;
                }
            }
        } else if (value instanceof Date) {
            Date dateValue = (Date)value;
            switch (type) {
                case LONG: {
                    return dateValue.getTime();
                }
                case STRING: {
                    return DataTypes.dateTimeToString(dateValue);
                }
                case DATE: {
                    return dateValue;
                }
            }
        } else if (value == null) {
            return null;
        }
        throw new ApiNotImplementedException("Conversion from " + value.getClass() + " to " + type.getValue() + " is not supported");
    }

    public static Object wrap(String type, Object value) {
        return DataTypes.wrap(Type.fromString(type), value);
    }

    public static Object wrap(Type type, Object value) {
        if (type == Type.INLINE) {
            Property property = Property.valueOf(value);
            PropertyMap inline = new PropertyMap();
            inline.put("type", DataTypes.getType(property));
            inline.put("value", property);
            return inline;
        }
        return value;
    }

    public static Object convert(Property type, Property value) {
        if (type == null) {
            return Property.unwrap(value);
        }
        if (value instanceof PropertyMap) {
            if (!(type instanceof PropertyMap)) {
                throw new ApiInvalidParameterException("Invalid type info (expected map): " + type);
            }
            PropertyMap typeMap = (PropertyMap)type;
            PropertyMap valueMap = (PropertyMap)value;
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (Map.Entry<String, Property> entry : valueMap.entrySet()) {
                String key = entry.getKey();
                result.put(key, DataTypes.convert(typeMap.get(key), entry.getValue()));
            }
            return result;
        }
        if (value instanceof PropertyArray) {
            if (!(type instanceof PropertyArray)) {
                throw new ApiInvalidParameterException("Invalid type info (expected array): " + type);
            }
            PropertyArray typeArray = (PropertyArray)type;
            PropertyArray valueArray = (PropertyArray)value;
            ArrayList<Object> result = new ArrayList<Object>();
            Iterator<Property> typeIter = typeArray.iterator();
            Iterator<Property> valueIter = valueArray.iterator();
            Property itemType = null;
            while (valueIter.hasNext()) {
                if (typeIter.hasNext()) {
                    itemType = typeIter.next();
                }
                result.add(DataTypes.convert(itemType, valueIter.next()));
            }
            return result;
        }
        if (value == null) {
            return null;
        }
        if (!(type instanceof PropertyString)) {
            throw new ApiInvalidParameterException("Invalid type info (expected string): " + type);
        }
        return DataTypes.convert(type.getString(), value.getObject());
    }

    private static Property getType(Property value) {
        if (value instanceof PropertyMap) {
            PropertyMap type = new PropertyMap();
            for (Map.Entry<String, Property> entry : ((PropertyMap)value).entrySet()) {
                type.put(entry.getKey(), DataTypes.getType(entry.getValue()));
            }
            return type;
        }
        if (value instanceof PropertyArray) {
            PropertyArray type = new PropertyArray(((PropertyArray)value).size());
            for (Property item : (PropertyArray)value) {
                type.add(DataTypes.getType(item));
            }
            return type;
        }
        return new PropertyString(DataTypes.getTypeName(value.getObject()));
    }

    public static String getTypeName(Object object) {
        Type type = Type.fromObject(object);
        if (type != null) {
            return type.getValue();
        }
        return null;
    }

    public static String canonicalTypeName(String typeName) {
        return Type.fromString(typeName).getValue();
    }

    public static Object convert(SessionController sc, Class<?> targetClass, Object value) throws ParseException {
        if (value instanceof Property && targetClass == Object.class) {
            return Property.unwrap(value);
        }
        if (targetClass.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (value instanceof Property && !(value instanceof PropertyArray) && !(value instanceof PropertyMap)) {
            value = Property.unwrap(value);
        }
        if (value instanceof SuperObjectClientBean) {
            SuperObjectClientBean socbValue = (SuperObjectClientBean)value;
            if (String.class.isAssignableFrom(targetClass)) {
                return Objects.getIdOrThrow(socbValue).toString();
            }
            if (Long.class.isAssignableFrom(targetClass)) {
                return Objects.getIdOrThrow(socbValue);
            }
        }
        if (SuperObjectClientBean.class.isAssignableFrom(targetClass)) {
            return Objects.findObject(sc, (String)DataTypes.convert(sc, Type.STRING, value));
        }
        if (LocalDate.class.isAssignableFrom(targetClass)) {
            String date = (String)DataTypes.convert(sc, Type.STRING, value);
            if (date.length() == 10) {
                return LocalDate.parse(date);
            }
            return LocalDateTime.parse(date, DateTimeFormatter.ISO_DATE_TIME).toLocalDate();
        }
        if (LocalDateTime.class.isAssignableFrom(targetClass)) {
            return LocalDateTime.parse((String)DataTypes.convert(sc, Type.STRING, value), DateTimeFormatter.ISO_DATE_TIME);
        }
        if (Date.class.isAssignableFrom(targetClass)) {
            return DataTypes.convert(sc, Type.DATE, value);
        }
        if (Long.TYPE.isAssignableFrom(targetClass) || Long.class.isAssignableFrom(targetClass)) {
            return DataTypes.convert(sc, Type.LONG, value);
        }
        if (Integer.TYPE.isAssignableFrom(targetClass) || Integer.class.isAssignableFrom(targetClass)) {
            return DataTypes.convert(sc, Type.INT, value);
        }
        if (Double.TYPE.isAssignableFrom(targetClass) || Double.class.isAssignableFrom(targetClass)) {
            return DataTypes.convert(sc, Type.DOUBLE, value);
        }
        if (Float.TYPE.isAssignableFrom(targetClass) || Float.class.isAssignableFrom(targetClass)) {
            return DataTypes.convert(sc, Type.FLOAT, value);
        }
        if (Boolean.TYPE.isAssignableFrom(targetClass) || Boolean.class.isAssignableFrom(targetClass)) {
            return DataTypes.convert(sc, Type.BOOLEAN, value);
        }
        if (String.class.isAssignableFrom(targetClass)) {
            return DataTypes.convert(sc, Type.STRING, value);
        }
        if (long[].class.isAssignableFrom(targetClass)) {
            return DataTypes.convertArray(sc, Type.LONG, value, true, targetClass);
        }
        if (Long[].class.isAssignableFrom(targetClass)) {
            return DataTypes.convertArray(sc, Type.LONG, value, false, targetClass);
        }
        if (int[].class.isAssignableFrom(targetClass)) {
            return DataTypes.convertArray(sc, Type.INT, value, true, targetClass);
        }
        if (Integer[].class.isAssignableFrom(targetClass)) {
            return DataTypes.convertArray(sc, Type.INT, value, false, targetClass);
        }
        if (double[].class.isAssignableFrom(targetClass)) {
            return DataTypes.convertArray(sc, Type.DOUBLE, value, true, targetClass);
        }
        if (Double[].class.isAssignableFrom(targetClass)) {
            return DataTypes.convertArray(sc, Type.DOUBLE, value, false, targetClass);
        }
        if (float[].class.isAssignableFrom(targetClass)) {
            return DataTypes.convertArray(sc, Type.FLOAT, value, true, targetClass);
        }
        if (Float[].class.isAssignableFrom(targetClass)) {
            return DataTypes.convertArray(sc, Type.FLOAT, value, false, targetClass);
        }
        if (boolean[].class.isAssignableFrom(targetClass)) {
            return DataTypes.convertArray(sc, Type.BOOLEAN, value, true, targetClass);
        }
        if (Boolean[].class.isAssignableFrom(targetClass)) {
            return DataTypes.convertArray(sc, Type.BOOLEAN, value, false, targetClass);
        }
        if (String[].class.isAssignableFrom(targetClass)) {
            return DataTypes.convertArray(sc, Type.STRING, value, false, targetClass);
        }
        if (SuperObjectClientBean[].class.isAssignableFrom(targetClass)) {
            return DataTypes.convertArray(sc, Type.OBJECT, value, false, targetClass);
        }
        if (Object[].class.isAssignableFrom(targetClass)) {
            return DataTypes.convertArray(sc, null, value, false, targetClass);
        }
        if (value instanceof PropertyArray && (List.class.isAssignableFrom(targetClass) || Collection.class.isAssignableFrom(targetClass) || Iterable.class.isAssignableFrom(targetClass))) {
            return Property.unwrap(value);
        }
        if (value instanceof PropertyMap && Map.class.isAssignableFrom(targetClass)) {
            return Property.unwrap(value);
        }
        try {
            Constructor<?> constructor = targetClass.getConstructor(value.getClass());
            if (constructor != null) {
                return constructor.newInstance(value);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    public static enum Type {
        STRING("string"),
        BOOLEAN("boolean"),
        INT("int"),
        LONG("long"),
        FLOAT("float"),
        DOUBLE("double"),
        DATE("date"),
        OBJECT("object"),
        USER("user"),
        INLINE("inline");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public static Type fromString(String str) {
            switch (str) {
                case "string": {
                    return STRING;
                }
                case "bool": 
                case "boolean": {
                    return BOOLEAN;
                }
                case "int": 
                case "integer": {
                    return INT;
                }
                case "long": {
                    return LONG;
                }
                case "float": {
                    return FLOAT;
                }
                case "double": {
                    return DOUBLE;
                }
                case "date": {
                    return DATE;
                }
                case "": 
                case "inline": {
                    return INLINE;
                }
            }
            throw new IllegalArgumentException("Unknown data type: " + str);
        }

        public static Type fromObject(Object object) {
            if (object instanceof String || object == null) {
                return STRING;
            }
            if (object instanceof Boolean) {
                return BOOLEAN;
            }
            if (object instanceof Integer) {
                return INT;
            }
            if (object instanceof Long) {
                return LONG;
            }
            if (object instanceof Float) {
                return FLOAT;
            }
            if (object instanceof Double) {
                return DOUBLE;
            }
            if (object instanceof Date) {
                return DATE;
            }
            return null;
        }

        public String getValue() {
            return this.value;
        }
    }

    private static class ConcurrentDateFormat
    extends ThreadLocal<DateFormat> {
        private final DateFormat format;

        public ConcurrentDateFormat(DateFormat format, boolean useZulu) {
            if (useZulu) {
                format.setTimeZone(TimeZone.getTimeZone("Zulu"));
            }
            this.format = format;
        }

        @Override
        protected DateFormat initialValue() {
            return (DateFormat)this.format.clone();
        }
    }
}

