/*
 * Decompiled with CFR 0.152.
 */
package agorum.api.common.utils;

import agorum.api.common.exceptions.ApiException;
import agorum.api.common.exceptions.server.ApiInternalServerErrorException;
import agorum.api.common.exceptions.usage.ApiMissingParameterException;
import agorum.api.common.exceptions.usage.ApiNotFoundException;
import agorum.api.common.exceptions.usage.ApiTypeMismatchException;
import agorum.roi.ejb.client.beans.AccessControlListObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.common.FolderObjectClientBeanWrapper;
import agorum.roi.ejb.common.RemoteRelationUtils;
import agorum.roi.ejb.common.RoiFileSystem;
import agorum.roi.ejb.common.SessionController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Objects {
    public static final String TREE_SEPARATOR = "|";
    private static Map<String, NamespaceHandler> handlers = new HashMap<String, NamespaceHandler>();

    private Objects() {
    }

    public static <T> T tryFind(SessionController sessionController, String id) {
        try {
            return Objects.find(sessionController, id);
        }
        catch (ApiNotFoundException e) {
            return null;
        }
    }

    public static <T> T find(SessionController sessionController, String id) {
        try {
            Object result = null;
            int i = id.lastIndexOf(TREE_SEPARATOR);
            if (i < 0) {
                result = Objects.namespaceHandlers(sessionController, id);
                if (result != null) {
                    return (T)result;
                }
                if (id.length() == 36 && id.charAt(0) != '/' && id.charAt(8) == '-' && id.charAt(13) == '-' && id.charAt(18) == '-' && id.charAt(23) == '-') {
                    result = sessionController.getGlobalObjectByUUID(id);
                    if (result == null) {
                        result = sessionController.getInternalObjectByUUID(id);
                    }
                } else {
                    try {
                        result = sessionController.findGlobalObjectByPathOrIdNoLookup(id);
                    }
                    catch (Exception e) {
                        try {
                            result = sessionController.getInternalObjectById(Long.valueOf(id));
                        }
                        catch (Exception subE) {
                            throw e;
                        }
                    }
                }
            } else {
                result = Objects.find(sessionController, id.substring(i + 1));
            }
            if (result != null) {
                return (T)result;
            }
            throw new ApiNotFoundException("Object " + id + " not found");
        }
        catch (ApiException e) {
            throw e;
        }
        catch (ClassCastException e) {
            throw new ApiTypeMismatchException("Object " + id + " is not of the required type");
        }
        catch (Exception e) {
            throw new ApiNotFoundException("Object " + id + " not found");
        }
    }

    public static <T> T find(SessionController sessionController, Long id) {
        try {
            GlobalObjectClientBean result = sessionController.getGlobalObjectById(id);
            if (result != null) {
                return (T)result;
            }
            throw new ApiNotFoundException("Object " + id + " not found");
        }
        catch (ClassCastException e) {
            throw new ApiTypeMismatchException("Object " + id + " is not of the required type");
        }
        catch (Exception e) {
            throw new ApiNotFoundException("Object " + id + " not found");
        }
    }

    public static FolderObjectClientBean root(SessionController sessionController) {
        try {
            return sessionController.getRootFolder();
        }
        catch (Exception e) {
            throw new ApiInternalServerErrorException("Could not look up root folder", e);
        }
    }

    public static FolderObjectClientBean createPath(SessionController sessionController, String path) {
        return Objects.createPath(sessionController, path, null, null, false);
    }

    public static FolderObjectClientBean createPath(SessionController sessionController, String path, FolderObjectClientBean rootFolder) {
        return Objects.createPath(sessionController, path, rootFolder, null, false);
    }

    public static FolderObjectClientBean createPath(SessionController sessionController, String path, FolderObjectClientBean rootFolder, AccessControlListObjectClientBean acl, boolean inheritOwner) {
        RoiFileSystem rfs = new RoiFileSystem(sessionController);
        try {
            return rfs.createFullpath(path, rootFolder, acl, inheritOwner);
        }
        catch (Exception e) {
            throw new ApiInternalServerErrorException("Could not create path " + path + " beneath object " + Objects.getId(rootFolder));
        }
    }

    public static Long getId(SuperObjectClientBean object) {
        try {
            return object.getId();
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public static String getUuid(SuperObjectClientBean object) {
        try {
            return object.getUUID();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Long getIdOrThrow(SuperObjectClientBean object) {
        try {
            return object.getId();
        }
        catch (Exception e) {
            throw new ApiInternalServerErrorException("Could not get object id", e);
        }
    }

    public static String lastIdFromNodeId(String nodeId) {
        int i = nodeId.lastIndexOf(TREE_SEPARATOR);
        if (i >= 0) {
            nodeId = nodeId.substring(i + 1);
        }
        return nodeId;
    }

    public static void registerNamespace(String prefix, NamespaceHandler handler) {
        handlers.put(prefix, handler);
    }

    private static Object namespaceHandlers(SessionController sessionController, String id) throws Exception {
        NamespaceHandler handler;
        String namespace;
        int i = id.indexOf("://");
        if (i < 0) {
            i = id.indexOf(":\\\\");
        }
        if (i > 0) {
            namespace = id.substring(0, i);
            id = id.substring(i + 3);
        } else {
            i = id.indexOf(":");
            if (i < 0) {
                return null;
            }
            namespace = id.substring(0, i);
            id = id.substring(i + 1);
        }
        ArrayList<String> parameters = new ArrayList<String>();
        if (id != null && id.indexOf(":") != -1) {
            String[] parts = id.split(":");
            id = parts[0];
            for (int p = 1; p < parts.length; ++p) {
                parameters.add(parts[p]);
            }
        }
        if ((handler = handlers.get(namespace)) != null) {
            return handler.resolve(sessionController, id, parameters);
        }
        return null;
    }

    public static <T> T findObject(SessionController sessionController, String id) {
        return Objects.find(sessionController, id);
    }

    public static <T> T findObject(SessionController sessionController, Long id) {
        return Objects.find(sessionController, id);
    }

    static {
        Objects.registerNamespace("uuid", (sc, id, parameters) -> sc.getSuperObjectByUUID(id));
        Objects.registerNamespace("acl", (sc, id, parameters) -> sc.getAclByName(id));
        Objects.registerNamespace("user", (sc, id, parameters) -> sc.getUserByName(id));
        Objects.registerNamespace("group", (sc, id, parameters) -> sc.getGroupByName(id));
        Objects.registerNamespace("home", (sc, id, parameters) -> {
            FolderObjectClientBean home = sc.getLoginUser().getPrimaryUserProfile().getHomeFolder();
            if (id.isEmpty()) {
                return home;
            }
            if (parameters.contains("create")) {
                return home.createPath(id);
            }
            return sc.findGlobalObjectByPathNoLookup(home, id);
        });
        Objects.registerNamespace("remoteid", (sc, id, parameters) -> {
            String[] idSplit = id.split(";");
            if (idSplit.length != 2) {
                throw new ApiMissingParameterException("please specify a remote-type and a id, seperated by ;");
            }
            return new RemoteRelationUtils(sc).getGlobalObjectFromRemoteId(idSplit[1], idSplit[0]);
        });
        Objects.registerNamespace("languageitem", (sc, id, parameters) -> {
            String[] idSplit = id.split(";");
            String extensionFilter = null;
            if (idSplit.length > 1) {
                extensionFilter = idSplit[1];
            }
            return new RoiFileSystem(sc).findFileObjectInFolderWithLanguage(idSplit[0], sc.getLocale(), extensionFilter);
        });
        Objects.registerNamespace("relative", (sc, id, parameters) -> {
            String root = id;
            String path = "";
            int i = id.indexOf("/");
            if (i >= 0) {
                root = id.substring(0, i);
                path = id.substring(i + 1);
            }
            FolderObjectClientBean folder = (FolderObjectClientBean)Objects.findObject(sc, root);
            if (path.isEmpty()) {
                return folder;
            }
            if (parameters.contains("create")) {
                return folder.createPath(path);
            }
            return sc.findGlobalObjectByPathNoLookup(folder, path);
        });
        Objects.registerNamespace("asf", (sc, id, parameters) -> {
            FolderObjectClientBean entryPoint = (FolderObjectClientBean)sc.getGlobalObjectByUUID(id);
            FolderObjectClientBeanWrapper parent = new FolderObjectClientBeanWrapper(null, entryPoint);
            for (int index = 0; index < parameters.size(); ++index) {
                parent = (FolderObjectClientBeanWrapper)parent.getItem((String)parameters.get(index));
            }
            return parent;
        });
    }

    public static interface NamespaceHandler {
        public Object resolve(SessionController var1, String var2, List<String> var3) throws Exception;
    }
}

