/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.auth.netlogon.object;

import agorum.roi.auth.netlogon.object.NetlogonIdentityInfo;
import jcifs.dcerpc.ndr.NdrBuffer;
import jcifs.dcerpc.ndr.NdrObject;

public class NetlogonNetworkInfo
extends NdrObject {
    private byte[] lmChallenge;
    private byte[] lmChallengeResponse;
    private NetlogonIdentityInfo netlogonIdentityInfo;
    private byte[] ntChallengeResponse;

    public NetlogonNetworkInfo(NetlogonIdentityInfo netlogonIdentityInfo, byte[] lmChallenge, byte[] ntChallengeResponse, byte[] lmChallengeResponse) {
        this.netlogonIdentityInfo = netlogonIdentityInfo;
        this.lmChallenge = lmChallenge;
        this.ntChallengeResponse = ntChallengeResponse;
        this.lmChallengeResponse = lmChallengeResponse;
    }

    public void decode(NdrBuffer ndrBuffer) {
        throw new UnsupportedOperationException();
    }

    public void encode(NdrBuffer ndrBuffer) {
        ndrBuffer.align(4);
        this.netlogonIdentityInfo.encode(ndrBuffer);
        int lmChallengeIndex = ndrBuffer.index;
        ndrBuffer.advance(8);
        ndrBuffer.enc_ndr_short((int)((short)this.ntChallengeResponse.length));
        ndrBuffer.enc_ndr_short((int)((short)this.ntChallengeResponse.length));
        ndrBuffer.enc_ndr_referent((Object)this.ntChallengeResponse, 1);
        ndrBuffer.enc_ndr_short((int)((short)this.lmChallengeResponse.length));
        ndrBuffer.enc_ndr_short((int)((short)this.lmChallengeResponse.length));
        ndrBuffer.enc_ndr_referent((Object)this.lmChallengeResponse, 1);
        this.netlogonIdentityInfo.encodeLogonDomainName(ndrBuffer);
        this.netlogonIdentityInfo.encodeUserName(ndrBuffer);
        this.netlogonIdentityInfo.encodeWorkStationName(ndrBuffer);
        ndrBuffer = ndrBuffer.derive(lmChallengeIndex);
        for (int i = 0; i < 8; ++i) {
            ndrBuffer.enc_ndr_small((int)this.lmChallenge[i]);
        }
        this.encodeChallengeResponse(ndrBuffer, this.ntChallengeResponse);
        this.encodeChallengeResponse(ndrBuffer, this.lmChallengeResponse);
    }

    protected void encodeChallengeResponse(NdrBuffer ndrBuffer, byte[] challenge) {
        ndrBuffer = ndrBuffer.deferred;
        ndrBuffer.enc_ndr_long(challenge.length);
        ndrBuffer.enc_ndr_long(0);
        ndrBuffer.enc_ndr_long(challenge.length);
        int index = ndrBuffer.index;
        ndrBuffer.advance(challenge.length);
        ndrBuffer = ndrBuffer.derive(index);
        for (int i = 0; i < challenge.length; ++i) {
            ndrBuffer.enc_ndr_small((int)challenge[i]);
        }
    }
}

