/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.behavior;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.roi.behavior.BaseBehavior;
import agorum.roi.ejb.client.beans.AttributeLookupObjectClientBean;
import agorum.roi.ejb.client.beans.AttributeLookupRelationObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.ClassObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.FolderRelationObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.RelationObjectClientBean;
import agorum.roi.ejb.client.beans.RelationObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.AttributeValueList;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.sessionfacade.beans.AttributeLookupObjectSessionFacade;
import java.util.HashMap;
import java.util.Map;

public class AttributeLookupBehavior
extends BaseBehavior {
    private SessionController sessionControllerAdmin;
    private SessionController sessionController;
    private GlobalObjectClientBean object;
    private boolean inherit;
    private Map<String, Map<String, String>> config;
    private static final String[] empty = new String[]{null};

    @Override
    public void init(SessionController sessionControllerAdmin, GlobalObjectClientBean object, String basePath) throws Exception {
        this.sessionControllerAdmin = sessionControllerAdmin;
        this.sessionController = object.getSessionController();
        this.object = object;
        MetaDb metaDb = sessionControllerAdmin.getMetaDbInstance();
        String[] inherit = metaDb.getSimplePropertyValue(basePath + "Inherit");
        if (inherit != null && inherit.length > 0) {
            this.inherit = Boolean.parseBoolean(inherit[0]);
        }
        this.config = new HashMap<String, Map<String, String>>();
        String[] bundles = metaDb.listSimplePropertyBundle(basePath);
        if (bundles != null) {
            for (String bundle : bundles) {
                HashMap<String, String> ci = new HashMap<String, String>();
                String ident = this.getString(metaDb, basePath + bundle + "/Ident", null);
                String value1 = this.getString(metaDb, basePath + bundle + "/Value1Attribute", null);
                String value2 = this.getString(metaDb, basePath + bundle + "/Value2Attribute", null);
                if (ident == null) {
                    throw new Exception("No Ident defined");
                }
                if (value1 == null) {
                    throw new Exception("No Value1 defined");
                }
                ci.put("ident", ident);
                ci.put("value1", value1);
                if (value2 != null) {
                    ci.put("value2", value2);
                }
                this.config.put(bundle, ci);
            }
        }
    }

    private String getString(MetaDb metaDb, String path, String def) {
        String v = def;
        try {
            v = metaDb.getSimplePropertyValue(path)[0];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return v;
    }

    @Override
    public void afterCreate(GlobalObjectClientBeanDefinition def) throws Exception {
        for (Map.Entry<String, Map<String, String>> entry : this.config.entrySet()) {
            this.createOrUpdateAttributeLookup(entry.getValue());
        }
    }

    @Override
    public void afterUpdate(GlobalObjectClientBeanDefinition def) throws Exception {
        for (Map.Entry<String, Map<String, String>> entry : this.config.entrySet()) {
            this.createOrUpdateAttributeLookup(entry.getValue());
        }
    }

    @Override
    public void afterAssociateRight(RelationObjectClientBean relation, GlobalObjectClientBean other) throws Exception {
        if (this.inherit && relation instanceof FolderRelationObjectClientBean) {
            this.inherit(other);
        }
    }

    private void createOrUpdateAttributeLookup(Map<String, String> attrs) throws Exception {
        int i;
        String[] value1 = this.getValue(attrs.get("value1"));
        String[] value2 = this.getValue(attrs.get("value2"));
        String ident = attrs.get("ident");
        SuperObjectClientBean[] alo = this.findAttrLookup(ident);
        int used = 0;
        for (i = 0; i < value1.length; ++i) {
            for (int j = 0; j < value2.length; ++j) {
                AttributeLookupObjectClientBean existing = null;
                if (alo != null && alo.length > used) {
                    existing = (AttributeLookupObjectClientBean)alo[used];
                    ++used;
                }
                this.create(existing, ident, value1[i], value2[j]);
            }
        }
        if (alo != null) {
            for (i = used; i < alo.length; ++i) {
                alo[i].delete();
            }
        }
    }

    private void create(AttributeLookupObjectClientBean existing, String ident, String value1, String value2) throws Exception {
        AttributeLookupObjectSessionFacade sf = new AttributeLookupObjectSessionFacade(this.sessionController);
        if (existing != null) {
            sf.setGlobalObject(existing);
        } else {
            sf.setAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE, AttributeLookupObjectClientBean.CLASS_NAME + "_$$ID$$");
            sf.setNameWithId(true);
            sf.setAttribute(AttributeLookupObjectClientBean.IDENT_ATTRIBUTE, ident);
            sf.setAttribute(GlobalObjectClientBean.MAINOBJECT_ATTRIBUTE, this.object);
            sf.setAccessControlList(this.object.getAcl());
        }
        sf.setAttribute(AttributeLookupObjectClientBean.VALUE1_ATTRIBUTE, value1);
        sf.setAttribute(AttributeLookupObjectClientBean.VALUE2_ATTRIBUTE, value2);
        if (existing != null) {
            sf.update();
        } else {
            existing = (AttributeLookupObjectClientBean)sf.create();
            this.object.addRelationship(existing, (RelationObjectClientBeanDefinition)new AttributeLookupRelationObjectClientBeanDefinition(this.sessionController));
        }
    }

    private String[] getValue(String attr) {
        if (attr == null) {
            return empty;
        }
        try {
            if (attr.startsWith("~~")) {
                return AttributeLookupBehavior.getValue(this.object.getExtendedAttributeAll(attr.substring(2))[0]);
            }
            if (attr.startsWith("~")) {
                return AttributeLookupBehavior.getValue(this.object.getExtendedAttribute(attr.substring(1)));
            }
            if (attr.equalsIgnoreCase("id")) {
                return new String[]{this.object.getId().toString()};
            }
            return AttributeLookupBehavior.getValue(this.object.getAttribute(attr.toUpperCase()));
        }
        catch (Exception exception) {
            return empty;
        }
    }

    private static String[] getValue(AttributeValue av) {
        if (av == null) {
            return empty;
        }
        if (av instanceof AttributeValueList) {
            AttributeValueList avl = (AttributeValueList)av;
            int len = avl.size();
            String[] result = new String[len];
            AttributeValue[] items = avl.toArray(new AttributeValue[len]);
            for (int i = 0; i < len; ++i) {
                result[i] = items[i].getObject().toString();
            }
            return result;
        }
        return new String[]{av.getObject().toString()};
    }

    private SuperObjectClientBean[] findAttrLookup(String ident) throws Exception {
        ClassObjectClientBean co = this.sessionControllerAdmin.getClassObject(AttributeLookupObjectClientBean.CLASS_NAME);
        SuperObjectClientBean[] soArr = this.sessionControllerAdmin.getSuperObjectByAttributes(this.sessionControllerAdmin, co, new String[]{AttributeLookupObjectClientBean.IDENT_ATTRIBUTE, GlobalObjectClientBean.MAINOBJECT_ATTRIBUTE}, new Object[]{ident, this.object.getId()}, new int[]{0, 0}, new boolean[]{true, true}, new int[]{1, 1}, null, null);
        return soArr;
    }

    private void inherit(GlobalObjectClientBean other) throws Exception {
        String behaviorName = this.object.getBehaviorName();
        if (!behaviorName.equals(other.getBehaviorName())) {
            this.inherit(behaviorName, this.sessionControllerAdmin.getGlobalObjectById(other.getId()));
        }
    }

    private void inherit(String behaviorName, GlobalObjectClientBean other) throws Exception {
        SuperObjectClientBeanDefinition def = other.getNewDefinition(this.sessionControllerAdmin);
        def.setAttribute(GlobalObjectClientBean.BEHAVIOR_ATTRIBUTE, AttributeValue.newAttributeValueObject(behaviorName));
        other.updateSilent(def);
        if (other.getIsFolder()) {
            FolderObjectClientBean folder = (FolderObjectClientBean)other;
            for (GlobalObjectClientBean item : folder.items()) {
                if (behaviorName.equals(item.getBehaviorName())) continue;
                this.inherit(behaviorName, item);
            }
        }
    }
}

