/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.behavior;

import agorum.roi.behavior.Behavior;
import agorum.roi.behavior.BehaviorManager;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.RelationObjectClientBean;
import agorum.roi.ejb.client.beans.RelationObjectClientBeanDefinition;
import agorum.roi.ejb.common.SessionController;
import java.util.ArrayList;
import java.util.List;

public class ProxyBehavior
implements Behavior {
    private final List<Behavior> proxied = new ArrayList<Behavior>();

    @Override
    public void init(SessionController sessionController, GlobalObjectClientBean object, String basePath) throws Exception {
        for (String behaviorName : sessionController.getMetaDbInstance().getSimplePropertyValue(basePath + "Behaviors")) {
            this.proxied.add(BehaviorManager.getBehavior(object, behaviorName));
        }
    }

    @Override
    public void afterCreate(GlobalObjectClientBeanDefinition def) throws Exception {
        for (Behavior behavior : this.proxied) {
            behavior.afterCreate(def);
        }
    }

    @Override
    public void beforeUpdate(GlobalObjectClientBeanDefinition def) throws Exception {
        for (Behavior behavior : this.proxied) {
            behavior.beforeUpdate(def);
        }
    }

    @Override
    public void afterUpdate(GlobalObjectClientBeanDefinition def) throws Exception {
        for (Behavior behavior : this.proxied) {
            behavior.afterUpdate(def);
        }
    }

    @Override
    public void beforeDelete(GlobalObjectClientBeanDefinition def, boolean trash) throws Exception {
        for (Behavior behavior : this.proxied) {
            behavior.beforeDelete(def, trash);
        }
    }

    @Override
    public void beforeAssociateLeft(RelationObjectClientBeanDefinition relationDef, GlobalObjectClientBean other) throws Exception {
        for (Behavior behavior : this.proxied) {
            behavior.beforeAssociateLeft(relationDef, other);
        }
    }

    @Override
    public void beforeAssociateRight(RelationObjectClientBeanDefinition relationDef, GlobalObjectClientBean other) throws Exception {
        for (Behavior behavior : this.proxied) {
            behavior.beforeAssociateRight(relationDef, other);
        }
    }

    @Override
    public void afterAssociateLeft(RelationObjectClientBean relation, GlobalObjectClientBean other) throws Exception {
        for (Behavior behavior : this.proxied) {
            behavior.afterAssociateLeft(relation, other);
        }
    }

    @Override
    public void afterAssociateRight(RelationObjectClientBean relation, GlobalObjectClientBean other) throws Exception {
        for (Behavior behavior : this.proxied) {
            behavior.afterAssociateRight(relation, other);
        }
    }

    @Override
    public void beforeDissociateLeft(RelationObjectClientBean relation, GlobalObjectClientBean other) throws Exception {
        for (Behavior behavior : this.proxied) {
            behavior.beforeDissociateLeft(relation, other);
        }
    }

    @Override
    public void beforeDissociateRight(RelationObjectClientBean relation, GlobalObjectClientBean other) throws Exception {
        for (Behavior behavior : this.proxied) {
            behavior.beforeDissociateRight(relation, other);
        }
    }

    @Override
    public boolean runInSync() {
        return true;
    }
}

