/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.common;

import agorum.roi.ejb.audit.AuditUtil;
import agorum.roi.ejb.client.beans.FileObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.sessionfacade.beans.FileObjectSessionFacade;

public class Storage {
    private static final String BASE_PATH = "/agorum/roi/Storage";
    private final String baseKey;

    private Storage(String baseKey) {
        this.baseKey = baseKey;
    }

    public static Storage get(Class<?> clazz) {
        return new Storage(clazz.getName() + ".");
    }

    public String get(String key) throws Exception {
        return this.get(key, null);
    }

    public String get(String key, String defaultValue) throws Exception {
        FileObjectClientBean container = Storage.get(this.baseKey + key, false);
        return container == null ? defaultValue : container.getContentString();
    }

    public void put(String key, String value) throws Exception {
        if (value == null) {
            this.remove(key);
        } else {
            Storage.get(this.baseKey + key, true).setContentString(value);
        }
    }

    public void remove(String key) throws Exception {
        FileObjectClientBean container = Storage.get(this.baseKey + key, false);
        if (container != null) {
            container.delete();
        }
    }

    private static SessionController getStealthSession() {
        SessionController sca = SessionControllerAdmin.getService(Storage.class);
        sca.setAuditState(AuditUtil.ACTION_EXT_NOT_ENTRY);
        return sca;
    }

    public void clear() throws Exception {
        SessionController sca = Storage.getStealthSession();
        FolderObjectClientBean baseFolder = sca.getRootFolder().createPath(BASE_PATH);
        GlobalObjectClientBean[] items = baseFolder.getItems(this.baseKey + "%");
        if (items != null) {
            for (GlobalObjectClientBean item : items) {
                item.delete();
            }
        }
    }

    private static FileObjectClientBean get(String key, boolean create) throws Exception {
        SessionController sca = Storage.getStealthSession();
        FolderObjectClientBean baseFolder = sca.getRootFolder().createPath(BASE_PATH);
        FileObjectClientBean container = (FileObjectClientBean)baseFolder.getItem(key);
        if (container == null && create) {
            FileObjectSessionFacade fosf = new FileObjectSessionFacade(sca);
            fosf.setAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE, key);
            fosf.setDestinationFolder(baseFolder);
            container = (FileObjectClientBean)fosf.create();
        }
        return container;
    }
}

