/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.common.utils;

import agorum.roi.ejb.client.beans.FileObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.RoiFileSystem;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.sessionfacade.beans.FileObjectSessionFacade;
import java.io.File;
import java.io.FileInputStream;

public class ImportFileStructure {
    private final SessionController sessionController;

    public ImportFileStructure(SessionController sessionController) {
        this.sessionController = sessionController;
    }

    public void importFileStructure(String pathOnDisk, String pathRoi) throws Exception {
        try {
            FolderObjectClientBean folder;
            File f = new File(pathOnDisk);
            if (f.isDirectory() && (folder = (FolderObjectClientBean)this.sessionController.findGlobalObjectByPath(pathRoi)) != null) {
                String folderPath = folder.getAnyFolderPath();
                this.importRecursiveFileStructure(f, folder, folderPath);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void importFile(String pathOnDisk, String pathRoi) throws Exception {
        try {
            FolderObjectClientBean folder;
            File f = new File(pathOnDisk);
            if (f.isFile() && (folder = (FolderObjectClientBean)this.sessionController.findGlobalObjectByPath(pathRoi)) != null) {
                this.createFileObject(f, folder);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private void importRecursiveFileStructure(File f, FolderObjectClientBean folder, String folderPath) throws Exception {
        File[] fArr = f.listFiles();
        RoiFileSystem rfs = new RoiFileSystem(this.sessionController);
        if (fArr != null) {
            int len = fArr.length;
            for (int i = 0; i < len; ++i) {
                if (fArr[i].getName().equalsIgnoreCase("CVS")) continue;
                System.err.println("create: " + folderPath + "/" + fArr[i].getName());
                if (fArr[i].isDirectory()) {
                    FolderObjectClientBean focb = rfs.createFullpath(folderPath + "/" + fArr[i].getName());
                    this.importRecursiveFileStructure(fArr[i], focb, folderPath + "/" + fArr[i].getName());
                    continue;
                }
                this.createFileObject(fArr[i], folder);
            }
        }
    }

    private FileObjectClientBean createFileObject(File f, FolderObjectClientBean folder) throws Exception {
        FileObjectClientBean focb = null;
        GlobalObjectClientBean updateObject = null;
        try {
            updateObject = this.sessionController.findGlobalObjectByPath(folder, f.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        FileObjectSessionFacade fileSF = new FileObjectSessionFacade(this.sessionController);
        if (updateObject != null) {
            fileSF.setGlobalObject(updateObject);
        }
        fileSF.setWithTransaction(true);
        fileSF.setAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE, f.getName());
        fileSF.setDestinationFolder(folder);
        FileInputStream fis = new FileInputStream(f);
        fileSF.setContentStream(fis);
        focb = updateObject != null ? (FileObjectClientBean)fileSF.update() : (FileObjectClientBean)fileSF.create();
        fis.close();
        return focb;
    }
}

