/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.common.utils;

import agorum.commons.logging.Log;
import agorum.commons.string.StringConverterUtils;
import agorum.roi.common.utils.TemplateUtil;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.ContentInterface;
import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class XmlTemplateUtil {
    private static final String SUB_PREFIX = "sub_";

    private XmlTemplateUtil() {
    }

    public static Document fillTemplate(Map<String, Object> data, Map<String, ContentInterface> templates) throws Exception {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        return XmlTemplateUtil.fillTemplate(data, templates, "root", doc, new Stack<ElementAndContent>());
    }

    public static Map<String, ContentInterface> findTemplates(FolderObjectClientBean folder) throws Exception {
        HashMap<String, ContentInterface> result = new HashMap<String, ContentInterface>();
        for (GlobalObjectClientBean item : folder.items()) {
            if (!(item instanceof ContentInterface)) continue;
            ContentInterface ci = (ContentInterface)((Object)item);
            String name = item.getName();
            String extension = "";
            int i = name.lastIndexOf(".");
            if (i >= 0) {
                extension = name.substring(i);
                name = name.substring(0, i);
            }
            if (!".xml".equalsIgnoreCase(extension)) continue;
            result.put(name, ci);
        }
        return result;
    }

    public static InputStream toStream(Document doc) throws IOException {
        return XmlTemplateUtil.toStream(doc, "UTF-8");
    }

    public static InputStream toStream(Document doc, String encoding) throws IOException {
        return new ByteArrayInputStream(XmlTemplateUtil.toString(doc, encoding).getBytes(encoding));
    }

    public static String toString(Document doc, String encoding) throws IOException {
        OutputFormat format = new OutputFormat(doc);
        format.setEncoding(encoding);
        format.setIndenting(true);
        format.setIndent(2);
        format.setLineWidth(100);
        format.setPreserveSpace(true);
        format.setPreserveEmptyAttributes(true);
        StringWriter stringWriter = new StringWriter();
        new XMLSerializer(stringWriter, format).serialize(doc);
        return stringWriter.toString();
    }

    public static void validate(ContentInterface xmlCi, ContentInterface ... schemaCis) throws Exception {
        int len = schemaCis.length;
        InputStream[] streams = new InputStream[len];
        for (int i = 0; i < len; ++i) {
            streams[i] = schemaCis[i].getContentStream();
        }
        XmlTemplateUtil.validate(xmlCi.getContentStream(), streams);
    }

    public static void validate(InputStream xmlStream, InputStream ... schemaStreams) throws SAXException, IOException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        int len = schemaStreams.length;
        Source[] sources = new Source[len];
        for (int i = 0; i < len; ++i) {
            sources[i] = new StreamSource(schemaStreams[i]);
        }
        String xmlString = StringConverterUtils.toString((InputStream)xmlStream, (String)"UTF-8");
        xmlStream = StringConverterUtils.toStream((String)xmlString, (String)"UTF-8");
        int size = xmlStream.available();
        xmlStream = new BufferedInputStream(xmlStream, size);
        xmlStream.mark(size);
        try {
            factory.newSchema(sources).newValidator().validate(new StreamSource(xmlStream));
        }
        catch (SAXParseException e) {
            Log.warning((Throwable)e);
            Log.warning((String)("Line: " + e.getLineNumber() + ", Column: " + e.getColumnNumber()));
            try {
                Log.warning((String)xmlString);
            }
            catch (Exception e2) {
                Log.warning((Throwable)e2);
            }
            throw e;
        }
        catch (Exception e) {
            Log.warning((Throwable)e);
            try {
                Log.warning((String)xmlString);
            }
            catch (Exception e2) {
                Log.warning((Throwable)e2);
            }
            throw e;
        }
    }

    private static Document fillTemplate(final Map<String, Object> data, final Map<String, ContentInterface> templates, String templateName, final Document doc, final Stack<ElementAndContent> elementStack) throws Exception {
        for (String subKey : templates.keySet()) {
            data.put(SUB_PREFIX + subKey, data.remove(subKey));
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        DefaultHandler handler = new DefaultHandler(){

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                this.buildText();
                Element current = doc.createElement(qName);
                if (null != attributes) {
                    try {
                        XmlTemplateUtil.addAttributesToElement(attributes, current, data);
                    }
                    catch (Exception e) {
                        throw new SAXException("Could not process attributes for element " + qName + ": " + e.getMessage(), e);
                    }
                }
                if (!elementStack.isEmpty()) {
                    ((ElementAndContent)elementStack.peek()).element.appendChild(current);
                } else {
                    doc.appendChild(current);
                }
                elementStack.push(new ElementAndContent(current, new StringBuilder()));
            }

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
                ((ElementAndContent)elementStack.peek()).content.append(new String(ch, start, length));
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                this.buildText();
                ElementAndContent eac = (ElementAndContent)elementStack.pop();
                Element current = eac.element;
                if (!current.hasAttributes() && !current.hasChildNodes()) {
                    ((ElementAndContent)elementStack.peek()).element.removeChild(current);
                }
            }

            private void buildText() throws SAXException {
                if (elementStack.empty()) {
                    return;
                }
                ElementAndContent eac = (ElementAndContent)elementStack.peek();
                Element current = eac.element;
                String content = eac.content.toString().trim();
                try {
                    content = TemplateUtil.fillTemplate(data, content);
                }
                catch (Exception e) {
                    throw new SAXException(e);
                }
                if (content.contains("${")) {
                    String template = content.substring(2, content.length() - 1);
                    Object value = data.get(XmlTemplateUtil.SUB_PREFIX + template);
                    if (value instanceof Map) {
                        try {
                            XmlTemplateUtil.fillTemplate((Map)value, templates, template, doc, elementStack);
                        }
                        catch (Exception e) {
                            throw new SAXException("Could not fill map template: " + e.getMessage(), e);
                        }
                    } else if (value instanceof List) {
                        for (Map subData : (List)value) {
                            try {
                                XmlTemplateUtil.fillTemplate(subData, templates, template, doc, elementStack);
                            }
                            catch (Exception e) {
                                throw new SAXException("Could not fill list template: " + e.getMessage(), e);
                            }
                        }
                    }
                } else if (!content.isEmpty()) {
                    current.appendChild(doc.createTextNode(content));
                }
                eac.content.setLength(0);
            }
        };
        saxParser.parse(templates.get(templateName).getContentStream(), handler);
        return doc;
    }

    private static void addAttributesToElement(Attributes attributes, Element element, Map<String, Object> data) throws SAXException {
        for (int i = 0; i < attributes.getLength(); ++i) {
            String value = XmlTemplateUtil.fillTemplate(data, attributes.getValue(i));
            if (value.contains("${")) continue;
            element.setAttribute(attributes.getQName(i), value);
        }
    }

    private static String fillTemplate(Map<String, Object> data, String template) throws SAXException {
        try {
            return TemplateUtil.fillTemplate(data, template);
        }
        catch (Exception e) {
            throw new SAXException("Could not fill text template", e);
        }
    }

    private static class ElementAndContent {
        public final Element element;
        public final StringBuilder content;

        public ElementAndContent(Element element, StringBuilder content) {
            this.element = element;
            this.content = content;
        }
    }
}

