/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.contenthash.common;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.roi.common.ClassHolder;
import agorum.roi.contenthash.handler.ContentHashHandler;
import agorum.roi.ejb.client.beans.ClassObjectClientBean;
import agorum.roi.ejb.client.beans.ContentHashObjectClientBean;
import agorum.roi.ejb.client.beans.ContentHashObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.ContentInterface;
import agorum.roi.ejb.common.GenericMultiQueueBean;
import agorum.roi.ejb.common.GenericMultiQueueHelper;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.Transaction;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public final class ContentHashUtils {
    public static final String QUEUE_IDENT = "ContentHashQueue";
    public static final String METADB_BASE_KEY = "MAIN_MODULE_MANAGEMENT/roi/control/contenthash";
    public static Boolean contentHashIsInstalled;

    private ContentHashUtils() {
    }

    private static boolean isModuleInstalled(SessionController sessionController) {
        if (contentHashIsInstalled != null) {
            return contentHashIsInstalled;
        }
        ClassObjectClientBean co = null;
        try {
            co = sessionController.getClassObject(ContentHashObjectClientBean.CLASS_NAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
        contentHashIsInstalled = co != null;
        return contentHashIsInstalled;
    }

    public static void addToQueue(SessionController sessionController, ContentInterface contentObject, boolean deletePresent) throws Exception {
        if (!ContentHashUtils.isModuleInstalled(sessionController)) {
            return;
        }
        MetaDb metaDb = sessionController.getMetaDbInstance();
        boolean active = false;
        try {
            active = Boolean.valueOf(metaDb.getSimplePropertyValue("MAIN_MODULE_MANAGEMENT/roi/control/contenthash/Active")[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (active) {
            Collection<ContentHashObjectClientBean> hashes;
            GenericMultiQueueHelper qh = new GenericMultiQueueHelper();
            Long id = contentObject.getId();
            if (qh.getQueueEntries(id, QUEUE_IDENT).size() <= 0) {
                qh.createQueueEntry(id, QUEUE_IDENT);
            }
            if (deletePresent && (hashes = ContentHashUtils.getHashes(sessionController, contentObject, null)) != null) {
                for (ContentHashObjectClientBean hash : hashes) {
                    hash.delete();
                }
            }
        }
    }

    public static Collection<ContentInterface> getQueuedEntries(SessionController sessionController) throws Exception {
        ArrayList<ContentInterface> ret = new ArrayList<ContentInterface>();
        if (!ContentHashUtils.isModuleInstalled(sessionController)) {
            return ret;
        }
        GenericMultiQueueHelper qh = new GenericMultiQueueHelper();
        List<GenericMultiQueueBean> entries = qh.getQueueEntries(null, QUEUE_IDENT);
        if (entries != null) {
            for (GenericMultiQueueBean qb : entries) {
                ContentInterface ci = null;
                try {
                    ci = (ContentInterface)((Object)sessionController.getGlobalObjectById(qb.id));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (ci == null) continue;
                ret.add(ci);
            }
        }
        return ret;
    }

    public static Collection<ContentInterface> getObjectsByHash(SessionController sessionController, String ident, String hash) throws Exception {
        ArrayList<ContentInterface> ret = new ArrayList<ContentInterface>();
        if (!ContentHashUtils.isModuleInstalled(sessionController)) {
            return ret;
        }
        ClassObjectClientBean co = sessionController.getClassObject(ContentHashObjectClientBean.CLASS_NAME);
        SuperObjectClientBean[] result = sessionController.getSuperObjectByAttributes(sessionController, co, new String[]{ContentHashObjectClientBean.HASH_ATTRIBUTE, ContentHashObjectClientBean.IDENT_ATTRIBUTE}, new Object[]{hash, ident}, new int[]{0, 0}, new boolean[]{false, true}, new int[]{1, 1}, null, null);
        if (result != null) {
            for (SuperObjectClientBean obj : result) {
                ContentHashObjectClientBean hashObj = (ContentHashObjectClientBean)obj;
                ret.add((ContentInterface)((Object)hashObj.getContentObject()));
            }
        }
        return ret;
    }

    public static Collection<ContentHashObjectClientBean> createHashes(SessionController sessionController, ContentInterface contentObject) throws Exception {
        ArrayList<ContentHashObjectClientBean> ret = new ArrayList<ContentHashObjectClientBean>();
        if (!ContentHashUtils.isModuleInstalled(sessionController)) {
            return ret;
        }
        try (Transaction t = new Transaction();){
            boolean changed = false;
            HashMap<String, ContentHashObjectClientBean> prev = new HashMap<String, ContentHashObjectClientBean>();
            Collection<ContentHashObjectClientBean> hashes = ContentHashUtils.getHashes(sessionController, contentObject, null);
            if (hashes != null) {
                for (ContentHashObjectClientBean hash : hashes) {
                    prev.put(hash.getIdent(), hash);
                }
            }
            MetaDb metaDb = sessionController.getMetaDbInstance();
            String[] bundles = metaDb.listSimplePropertyBundle(METADB_BASE_KEY);
            ArrayList<ContentHashHandler> handlers = new ArrayList<ContentHashHandler>();
            if (bundles != null) {
                for (String bundle : bundles) {
                    try {
                        ContentHashObjectClientBean prevHash;
                        boolean active = Boolean.valueOf(metaDb.getSimplePropertyValue("MAIN_MODULE_MANAGEMENT/roi/control/contenthash/" + bundle + "/Active")[0]);
                        String handler = metaDb.getSimplePropertyValue("MAIN_MODULE_MANAGEMENT/roi/control/contenthash/" + bundle + "/Class")[0];
                        String ident = metaDb.getSimplePropertyValue("MAIN_MODULE_MANAGEMENT/roi/control/contenthash/" + bundle + "/Ident")[0];
                        String[] parameterNames = metaDb.getSimplePropertyValue("MAIN_MODULE_MANAGEMENT/roi/control/contenthash/" + bundle + "/ParameterNames");
                        String[] parameterValues = metaDb.getSimplePropertyValue("MAIN_MODULE_MANAGEMENT/roi/control/contenthash/" + bundle + "/ParameterValues");
                        if (!active || (prevHash = (ContentHashObjectClientBean)prev.remove(ident)) != null && prevHash.getLastContentModifyDate().getTime() == contentObject.getLastContentModifyDate().getTime()) continue;
                        changed = true;
                        if (prevHash != null) {
                            prevHash.delete();
                        }
                        ContentHashHandler hashHandler = (ContentHashHandler)ClassHolder.getClassInstance(handler).newInstance();
                        HashMap<String, String> parameters = new HashMap<String, String>();
                        if (parameterNames != null && parameterValues != null && parameterNames.length == parameterValues.length) {
                            for (int i = 0; i < parameterNames.length; ++i) {
                                parameters.put(parameterNames[i], parameterValues[i]);
                            }
                        }
                        hashHandler.init(sessionController, parameters, ident);
                        handlers.add(hashHandler);
                    }
                    catch (Exception e) {
                        System.err.println("ContentHash handler: " + bundle + " is not valid");
                        e.printStackTrace();
                    }
                }
                if (handlers.size() > 0) {
                    Date lastContentModifyDate = contentObject.getLastContentModifyDate();
                    try (InputStream cStream = contentObject.getContentStream();){
                        int read;
                        int amount = (int)contentObject.getBlockSize();
                        byte[] buffer = new byte[amount];
                        while ((read = cStream.read(buffer, 0, amount)) > 0) {
                            for (ContentHashHandler handler : handlers) {
                                handler.update(buffer, 0, read);
                            }
                        }
                    }
                    for (ContentHashHandler handler : handlers) {
                        ContentHashObjectClientBeanDefinition def = new ContentHashObjectClientBeanDefinition(sessionController);
                        def.setIdent(handler.getIdent());
                        def.setChunkNumber(-1L);
                        def.setContentObject((GlobalObjectClientBean)((Object)contentObject));
                        def.setLastContentModifyDate(lastContentModifyDate);
                        def.setHash(handler.getHash());
                        ContentHashObjectClientBean contentHash = (ContentHashObjectClientBean)sessionController.createInternalObject(def);
                        ret.add(contentHash);
                        changed = true;
                    }
                }
            }
            for (ContentHashObjectClientBean prevHash : prev.values()) {
                prevHash.delete();
                changed = true;
            }
            if (changed) {
                GlobalObjectClientBean contentGlobalObject = (GlobalObjectClientBean)((Object)contentObject);
                SuperObjectClientBeanDefinition def = contentGlobalObject.getNewDefinition(sessionController);
                def.setSystemOption("doNotEA", "true");
                def.setSystemOption("internal", "true");
                def.setAttribute(GlobalObjectClientBean.LASTMODIFIER_ATTRIBUTE, contentGlobalObject.getAttribute(GlobalObjectClientBean.LASTMODIFIER_ATTRIBUTE));
                def.setAttribute(GlobalObjectClientBean.UPDATEDATE_ATTRIBUTE, AttributeValue.newAttributeValueObject(new Date()));
                contentGlobalObject.update(def);
            }
            t.commit();
        }
        return ret;
    }

    public static boolean hasValidHash(SessionController sessionController, ContentInterface contentObject, String ident) throws Exception {
        if (!ContentHashUtils.isModuleInstalled(sessionController)) {
            return false;
        }
        ClassObjectClientBean co = sessionController.getClassObject(ContentHashObjectClientBean.CLASS_NAME);
        SuperObjectClientBean[] result = sessionController.getSuperObjectByAttributes(sessionController, co, new String[]{ContentHashObjectClientBean.CONTENTOBJECT_ATTRIBUTE, ContentHashObjectClientBean.IDENT_ATTRIBUTE}, new Object[]{contentObject, ident}, new int[]{0, 0}, new boolean[]{false, true}, new int[]{1, 1}, null, null);
        if (result != null) {
            for (SuperObjectClientBean obj : result) {
                ContentHashObjectClientBean hashObj = (ContentHashObjectClientBean)obj;
                ContentInterface ci = (ContentInterface)((Object)hashObj.getContentObject());
                if (hashObj.getLastContentModifyDate().getTime() != ci.getLastContentModifyDate().getTime()) continue;
                return true;
            }
        }
        return false;
    }

    public static Collection<ContentHashObjectClientBean> getHashes(SessionController sessionController, ContentInterface contentObject, String ident) throws Exception {
        ArrayList<ContentHashObjectClientBean> ret = new ArrayList<ContentHashObjectClientBean>();
        if (!ContentHashUtils.isModuleInstalled(sessionController)) {
            return ret;
        }
        ClassObjectClientBean co = sessionController.getClassObject(ContentHashObjectClientBean.CLASS_NAME);
        SuperObjectClientBean[] result = null;
        result = ident != null ? sessionController.getSuperObjectByAttributes(sessionController, co, new String[]{ContentHashObjectClientBean.CONTENTOBJECT_ATTRIBUTE, ContentHashObjectClientBean.IDENT_ATTRIBUTE}, new Object[]{contentObject, ident}, new int[]{0, 0}, new boolean[]{false, true}, new int[]{1, 1}, null, null) : sessionController.getSuperObjectByAttributes(sessionController, co, new String[]{ContentHashObjectClientBean.CONTENTOBJECT_ATTRIBUTE}, new Object[]{contentObject}, new int[]{0}, new boolean[]{false}, new int[]{1}, null, null);
        if (result == null) {
            return ret;
        }
        Date lastContentModifyDate = contentObject.getLastContentModifyDate();
        boolean rehash = false;
        for (SuperObjectClientBean obj : result) {
            ContentHashObjectClientBean hashObj = (ContentHashObjectClientBean)obj;
            if (hashObj.getLastContentModifyDate().equals(lastContentModifyDate)) {
                ret.add(hashObj);
                continue;
            }
            rehash = true;
        }
        if (rehash) {
            ContentHashUtils.addToQueue(sessionController, contentObject, false);
        }
        return ret;
    }

    public static void removeAllHashes(SessionController sessionController, ContentInterface contentObject) throws Exception {
        if (!ContentHashUtils.isModuleInstalled(sessionController)) {
            return;
        }
        Collection<ContentHashObjectClientBean> hashes = ContentHashUtils.getHashes(sessionController, contentObject, null);
        for (ContentHashObjectClientBean hash : hashes) {
            hash.delete();
        }
    }

    public static void removeHash(SessionController sessionController, ContentInterface contentObject, String ident) throws Exception {
        if (!ContentHashUtils.isModuleInstalled(sessionController)) {
            return;
        }
        Collection<ContentHashObjectClientBean> hashes = ContentHashUtils.getHashes(sessionController, contentObject, null);
        for (ContentHashObjectClientBean hash : hashes) {
            if (!hash.getIdent().equalsIgnoreCase(ident)) continue;
            hash.delete();
        }
    }

    public static void setContentHash(SessionController sessionController, ContentInterface contentObject, String ident, String hash) throws Exception {
        if (!ContentHashUtils.isModuleInstalled(sessionController)) {
            return;
        }
        Collection<ContentHashObjectClientBean> hashes = ContentHashUtils.getHashes(sessionController, contentObject, ident);
        for (ContentHashObjectClientBean hashObj : hashes) {
            hashObj.delete();
        }
        ContentHashObjectClientBeanDefinition def = new ContentHashObjectClientBeanDefinition(sessionController);
        def.setIdent(ident);
        def.setChunkNumber(-1L);
        def.setContentObject((GlobalObjectClientBean)((Object)contentObject));
        def.setLastContentModifyDate(contentObject.getLastContentModifyDate());
        def.setHash(hash);
        sessionController.createInternalObject(def);
    }
}

