/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.agents.mail;

import agorum.commons.statistic.CoreStatistic;
import agorum.commons.string.StringConverterUtils;
import agorum.commons.string.StringUtils;
import agorum.commons.system.SystemProperties;
import agorum.commons.utils.TempFile;
import agorum.commons.uuid.UUIDGenerator;
import agorum.roi.ejb.agents.mail.internet.EmlMimeMessage;
import agorum.roi.ejb.client.beans.AttachmentsRelationObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.ClassObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.FileObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.MailBodyRelationObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.MailDocumentObjectClientBean;
import agorum.roi.ejb.client.beans.MailFilterObjectClientBean;
import agorum.roi.ejb.client.beans.MailObjectClientBean;
import agorum.roi.ejb.client.beans.MailObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.RelationObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.CryptKeyController;
import agorum.roi.ejb.common.MailFilterUtils;
import agorum.roi.ejb.common.RoiFileSystem;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.RoiPropertiesMetaDb;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.ejb.common.SendableContentInterface;
import agorum.roi.ejb.common.ServiceAuthInterface;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.ejb.common.Transaction;
import agorum.roi.sessionfacade.beans.MailDocumentObjectSessionFacade;
import agorum.roi.sessionfacade.beans.MailObjectSessionFacade;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

public class SendMail {
    private SessionController sessionController = null;
    private RoiProperties rp = new RoiProperties();
    private Vector delVector = new Vector();
    private boolean noErrorMail;
    private MailObjectClientBean sentMail = null;

    public SendMail(SessionController sessionController) {
        try {
            this.sessionController = sessionController == null ? this.doLogin() : sessionController;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public MailObjectClientBean getSentMail() {
        return this.sentMail;
    }

    public SessionController login() throws Exception {
        return this.doLogin();
    }

    private final SessionController doLogin() throws Exception {
        CredentialObject credential = new CredentialObject();
        credential.setUserName(this.rp.getRoiSystemUser());
        credential.setAuthInterface(new ServiceAuthInterface());
        credential.setModulInfo("SendMail");
        SessionController sessionController = SessionController.connect(credential);
        return sessionController;
    }

    public SuperObjectClientBean[] getAllMailObjects() throws Exception {
        ClassObjectClientBean classObject = this.sessionController.getClassObject(MailObjectClientBean.CLASS_NAME);
        SuperObjectClientBean[] superObjects = this.sessionController.getSuperObjectByAttribute(this.sessionController, "MAILSTATUS", "outbox", false, classObject);
        return superObjects;
    }

    public void sendSingleMail(MailObjectClientBean mailObject) throws Exception {
        Throwable throwable;
        Transaction trans;
        boolean markAsError = false;
        try (Transaction trans2 = new Transaction();){
            mailObject.isContentSet();
            trans2.commit();
        }
        catch (Exception e) {
            CoreStatistic.getInstance().warning((Throwable)e, "Mail with UUID: " + mailObject.getUUID() + " can not be sent! Maybe some kind of content worker is currently accessing the mail. Next try to sent the email in the next email cycle");
            return;
        }
        SessionController scAdmin = SessionControllerAdmin.getSessionControllerAdmin(mailObject.getSessionController(), "SendMail");
        Exception sendException = null;
        EmlMimeMessage message = null;
        try {
            trans = new Transaction();
            throwable = null;
            try {
                Properties props = new Properties();
                RoiPropertiesMetaDb rpmd = new RoiPropertiesMetaDb(this.sessionController);
                props.put("mail.smtp.host", rpmd.getMailserverHostaddress());
                props.put("mail.smtp.port", rpmd.getMailserverPort());
                SMTPAuthenticator auth = null;
                String user = rpmd.getMailserverUser();
                String passwordTmp = rpmd.getMailserverPassword();
                String password = null;
                try {
                    password = new CryptKeyController().decrypt(passwordTmp, "metadb", scAdmin);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (password == null) {
                    password = passwordTmp;
                }
                if (user != null && user.trim().length() > 0 && password != null) {
                    auth = new SMTPAuthenticator(user, password);
                }
                props.put("mail.smtp.auth", auth == null ? "false" : "true");
                Session session = Session.getInstance((Properties)props, auth);
                session.setDebug(false);
                boolean contentIsAlreadySet = false;
                if (mailObject.isContentSet()) {
                    message = new EmlMimeMessage(session, mailObject.getContentStream());
                    contentIsAlreadySet = true;
                } else {
                    message = this.generateMessage(mailObject, session);
                }
                try {
                    if (message != null) {
                        message.saveChanges();
                        if (!contentIsAlreadySet) {
                            File tmpFile = TempFile.createTempFile((long)1000000L);
                            FileOutputStream fos = new FileOutputStream(tmpFile);
                            message.writeTo(fos);
                            fos.close();
                            FileInputStream fis = new FileInputStream(tmpFile);
                            mailObject.setContent(fis);
                            fis.close();
                            tmpFile.delete();
                        }
                        MailObjectClientBeanDefinition mailDef = (MailObjectClientBeanDefinition)mailObject.getNewDefinition(scAdmin);
                        mailDef.setLastModifier(mailObject.getOwner());
                        mailDef.setRFC822Date(message.getSentDate());
                        mailDef.setRFC822MessageId(message.getMessageID());
                        Enumeration headerEnum = message.getAllHeaderLines();
                        ArrayList headerList = new ArrayList();
                        while (headerEnum.hasMoreElements()) {
                            headerList.add(headerEnum.nextElement());
                        }
                        mailDef.setRFC822Header(headerList.toArray(new String[headerList.size()]));
                        mailDef.setContentTransferEncoding(message.getEncoding());
                        mailObject.update(mailDef);
                        trans.restart();
                        Transport.send((Message)message);
                        this.moveSentMail(mailObject, message);
                        this.handleAttachments(mailObject);
                    }
                    trans.commit();
                }
                catch (Exception e) {
                    sendException = e;
                    throw e;
                }
                finally {
                    int len = this.delVector.size();
                    for (int i = 0; i < len; ++i) {
                        try {
                            File f = (File)this.delVector.elementAt(i);
                            f.delete();
                            continue;
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            catch (Throwable props) {
                throwable = props;
                throw props;
            }
            finally {
                if (trans != null) {
                    if (throwable != null) {
                        try {
                            trans.close();
                        }
                        catch (Throwable props) {
                            throwable.addSuppressed(props);
                        }
                    } else {
                        trans.close();
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("Mail could not be sent: " + mailObject.getId());
            e.printStackTrace(System.err);
            markAsError = true;
        }
        if (sendException != null && message != null && !this.noErrorMail) {
            this.sendErrorMail(mailObject, message, sendException);
        }
        if (markAsError) {
            try {
                trans = new Transaction();
                throwable = null;
                try {
                    this.moveErrorMail(mailObject);
                    GlobalObjectClientBeanDefinition def = (GlobalObjectClientBeanDefinition)mailObject.getNewDefinition(this.sessionController);
                    def.setLastModifier(mailObject.getOwner());
                    def.setSystemOption("ShowAlwaysEA", "true");
                    def.setSystemOption("ForceEA", "true");
                    def.setAttribute("MAILSTATUS", AttributeValue.newAttributeValueObject("error"));
                    mailObject.update(def);
                    trans.commit();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (trans != null) {
                        if (throwable != null) {
                            try {
                                trans.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            trans.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateRFC822(MailObjectClientBean mailObject) throws Exception {
        MessagingException exception = null;
        try (Transaction t = new Transaction();){
            Properties props = new Properties();
            RoiPropertiesMetaDb rpmd = new RoiPropertiesMetaDb(this.sessionController);
            props.put("mail.smtp.host", rpmd.getMailserverHostaddress());
            props.put("mail.smtp.port", rpmd.getMailserverPort());
            SMTPAuthenticator auth = null;
            String user = rpmd.getMailserverUser();
            String password = rpmd.getMailserverPassword();
            if (user != null && user.trim().length() > 0 && password != null) {
                props.put("mail.smtp.auth", "true");
                auth = new SMTPAuthenticator(user, password);
            }
            Session session = Session.getInstance((Properties)props, auth);
            session.setDebug(false);
            EmlMimeMessage message = this.generateMessage(mailObject, session);
            try {
                SessionController scAdmin = SessionControllerAdmin.getSessionControllerAdmin(this.sessionController, "GenerateMail");
                mailObject = (MailObjectClientBean)scAdmin.getGlobalObjectById(mailObject.getId());
                if (message != null) {
                    message.saveChanges();
                    File tmpFile = TempFile.createTempFile((long)1000000L);
                    try (FileOutputStream fos = new FileOutputStream(tmpFile);){
                        message.writeTo(fos);
                    }
                    try {
                        var15_25 = null;
                        try (FileInputStream fis = new FileInputStream(tmpFile);){
                            MailObjectClientBeanDefinition mailDef = (MailObjectClientBeanDefinition)mailObject.getNewDefinition(scAdmin);
                            mailDef.setSystemOption("doNotEA", "true");
                            mailDef.setRFC822Date(message.getSentDate());
                            mailDef.setRFC822MessageId(message.getMessageID());
                            Enumeration headerEnum = message.getAllHeaderLines();
                            ArrayList headerList = new ArrayList();
                            while (headerEnum.hasMoreElements()) {
                                headerList.add(headerEnum.nextElement());
                            }
                            mailDef.setRFC822Header(headerList.toArray(new String[headerList.size()]));
                            mailDef.setContentTransferEncoding(message.getEncoding());
                            mailObject.update(mailDef);
                            mailDef = (MailObjectClientBeanDefinition)mailObject.getNewDefinition(scAdmin);
                            mailDef.setSystemOption("doNotEA", "true");
                            mailObject.setContent(fis, mailDef);
                        }
                        catch (Throwable throwable) {
                            var15_25 = throwable;
                            throw throwable;
                        }
                    }
                    finally {
                        tmpFile.delete();
                    }
                }
                t.commit();
            }
            catch (MessagingException e) {
                exception = e;
                e.printStackTrace(System.err);
            }
            finally {
                int len = this.delVector.size();
                for (int i = 0; i < len; ++i) {
                    try {
                        File f = (File)this.delVector.elementAt(i);
                        f.delete();
                        continue;
                    }
                    catch (Exception exception2) {}
                }
            }
            if (exception != null && !this.noErrorMail) {
                this.sendErrorMail(mailObject, message, (Exception)((Object)exception));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendErrorMail(MailObjectClientBean mailObject, MimeMessage message, Exception e) throws Exception {
        try (Transaction t = new Transaction();){
            this.noErrorMail = true;
            this.moveErrorMail(mailObject);
            SuperObjectClientBeanDefinition def = mailObject.getNewDefinition(this.sessionController);
            def.setSystemOption("ShowAlwaysEA", "true");
            def.setSystemOption("ForceEA", "true");
            def.setAttribute("MAILSTATUS", AttributeValue.newAttributeValueObject("error"));
            mailObject.update(def);
            InternetAddress adr = (InternetAddress)message.getFrom()[0];
            String stackTrace = "An error occured sending the mail: \"" + message.getSubject() + "\":\n\n";
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            e.printStackTrace(ps);
            stackTrace = stackTrace + new String(baos.toByteArray());
            baos.close();
            this.sendSimpleMail(new String[]{adr.getAddress()}, null, null, "Error sending Mail: " + message.getSubject(), stackTrace, false);
            t.commit();
        }
        catch (Exception e1) {
            e1.printStackTrace(System.err);
        }
        finally {
            this.noErrorMail = false;
        }
    }

    private InternetAddress formatedInternetAddress(String mailAddressWithName) throws Exception {
        try {
            mailAddressWithName = mailAddressWithName.trim();
            if (mailAddressWithName.length() > 0) {
                int startPos = mailAddressWithName.indexOf("<");
                if (startPos != -1) {
                    StringUtils su = new StringUtils();
                    String mailAddress = su.getStringFrommTrenner(mailAddressWithName, "<", ">", 1);
                    mailAddress = mailAddress.replaceAll("[\\s]*", "");
                    String name = mailAddressWithName.substring(0, startPos);
                    name = name.replaceAll("^[\\s]*", "");
                    name = name.replaceAll("[\\s]*$", "");
                    name = name.replaceAll("^[\"]*", "");
                    name = name.replaceAll("[\"]*$", "");
                    return new InternetAddress(mailAddress, name, SystemProperties.getCharsetName());
                }
                return new InternetAddress(mailAddressWithName);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return null;
    }

    private EmlMimeMessage generateMessage(MailObjectClientBean mailObject, Session session) throws Exception {
        String inReplyTo;
        int i;
        int len;
        EmlMimeMessage message = new EmlMimeMessage(session);
        message.setSentDate(new Date());
        if (mailObject.getFromAddress() != null) {
            len = mailObject.getFromAddress().length;
            for (i = 0; i < len; ++i) {
                InternetAddress iAdr = this.formatedInternetAddress(mailObject.getFromAddress()[i]);
                if (iAdr != null) {
                    message.setFrom((Address)iAdr);
                    System.err.println("Send from: " + mailObject.getFromAddress()[i]);
                    continue;
                }
                System.err.println("Error in mail: FromAdress has Errors!!");
            }
        }
        if (mailObject.getReplayTo() != null) {
            ArrayList<InternetAddress> iAddrs = new ArrayList<InternetAddress>();
            for (String addr : mailObject.getReplayTo()) {
                InternetAddress iAdr = this.formatedInternetAddress(addr);
                if (iAdr != null) {
                    iAddrs.add(iAdr);
                    System.err.println("Reply-To: " + addr);
                    continue;
                }
                System.err.println("Reply-To: " + addr + " is invalid");
            }
            message.setReplyTo(iAddrs.toArray(new Address[iAddrs.size()]));
        }
        if (mailObject.getToAddress() != null) {
            len = mailObject.getToAddress().length;
            for (i = 0; i < len; ++i) {
                InternetAddress iAdr = this.formatedInternetAddress(mailObject.getToAddress()[i]);
                if (iAdr != null) {
                    message.addRecipient(Message.RecipientType.TO, (Address)iAdr);
                    continue;
                }
                System.err.println("Error in mail: ToAdress has Errors!!");
            }
        }
        if (mailObject.getCcAddress() != null) {
            len = mailObject.getCcAddress().length;
            for (i = 0; i < len; ++i) {
                InternetAddress iAdr = this.formatedInternetAddress(mailObject.getCcAddress()[i]);
                if (iAdr != null) {
                    message.addRecipient(Message.RecipientType.CC, (Address)iAdr);
                    continue;
                }
                System.err.println("Error in mail: CCAdress has Errors!!");
            }
        }
        if (mailObject.getBccAddress() != null) {
            len = mailObject.getBccAddress().length;
            for (i = 0; i < len; ++i) {
                InternetAddress iAdr = this.formatedInternetAddress(mailObject.getBccAddress()[i]);
                if (iAdr != null) {
                    message.addRecipient(Message.RecipientType.BCC, (Address)iAdr);
                    continue;
                }
                System.err.println("Error in mail: BCCAdress has Errors!!");
            }
        }
        if (mailObject.getSubject() != null) {
            message.setSubject(mailObject.getSubject(), SystemProperties.getCharsetName());
        }
        if (mailObject.getDispositionNotificationTo() != null && mailObject.getDispositionNotificationTo().trim().length() > 0) {
            message.setHeader("Disposition-Notification-To", mailObject.getDispositionNotificationTo());
        }
        if (mailObject.getPriority() != null) {
            String priority = mailObject.getPriority();
            if (priority.equalsIgnoreCase("high")) {
                message.setHeader("Importance", priority.toLowerCase());
                message.setHeader("X-Priority", "1 (High)");
                message.setHeader("X-MSMail-Priority", priority);
            } else if (priority.equalsIgnoreCase("low")) {
                message.setHeader("Importance", priority.toLowerCase());
                message.setHeader("X-Priority", "5 (Low)");
                message.setHeader("X-MSMail-Priority", priority);
            }
        }
        if (mailObject.getSensitivity() != null && mailObject.getSensitivity().trim().length() > 0) {
            message.setHeader("Sensitivity", mailObject.getSensitivity());
        }
        if ((inReplyTo = mailObject.getInReplayTo()) != null && inReplyTo.trim().length() > 0) {
            MailObjectClientBean inReplyToMail = null;
            if (mailObject.getMailStatus().equals("drafts")) {
                try {
                    inReplyToMail = (MailObjectClientBean)this.sessionController.getGlobalObjectById(new Long(inReplyTo));
                }
                catch (Exception iAdr) {}
            } else {
                try {
                    inReplyToMail = (MailObjectClientBean)this.sessionController.getSuperObjectByAttribute(this.sessionController, "RFC822MESSAGEID", inReplyTo, false, this.sessionController.getClassObject(MailObjectClientBean.CLASS_NAME))[0];
                }
                catch (Exception iAdr) {
                    // empty catch block
                }
            }
            String references = "";
            if (inReplyToMail != null) {
                String inReplyToParent;
                String[] headers = inReplyToMail.getRFC822Header();
                boolean referencesFound = false;
                if (headers != null) {
                    int headerLen = headers.length;
                    for (int i2 = 0; i2 < headerLen; ++i2) {
                        String actOldReference;
                        if (!headers[i2].toLowerCase().startsWith("references:")) continue;
                        references = headers[i2].substring(11).trim() + " ";
                        referencesFound = true;
                        String oldReferences = headers[i2].substring(11).trim();
                        String[] oldReferencesArr = oldReferences.split(" ");
                        if (oldReferencesArr == null) break;
                        String firstOldReference = oldReferencesArr[0].trim();
                        int fieldlen = inReplyTo.length() + firstOldReference.length() + 1;
                        int oldRefLen = oldReferencesArr.length;
                        for (int j = oldRefLen - 1; j > 0 && fieldlen + (actOldReference = oldReferencesArr[j].trim()).length() + 1 <= 986; --j) {
                            references = references + " " + actOldReference;
                        }
                        references = firstOldReference + references;
                        referencesFound = true;
                        break;
                    }
                }
                if (!referencesFound && (inReplyToParent = inReplyToMail.getInReplayTo()) != null && inReplyToParent.length() > 0) {
                    references = inReplyToParent + " ";
                }
            }
            references = references + inReplyTo;
            message.setHeader("References", references);
            message.setHeader("In-Reply-To", inReplyTo);
        }
        MailDocumentObjectClientBean mailBody = (MailDocumentObjectClientBean)mailObject.getBestBodyPart();
        String body = "";
        String mimeType = "text/plain";
        if (mailBody != null) {
            body = StringConverterUtils.toString((InputStream)mailBody.getContentStreamNoRead());
            mimeType = mailBody.getFormat().getMimeType();
        }
        mimeType = mimeType + "; charset=" + SystemProperties.getCharsetName();
        GlobalObjectClientBean[] attachmentObjects = mailObject.getMailAttachments();
        if (attachmentObjects != null && attachmentObjects.length > 0) {
            MimeMultipart multiPart = new MimeMultipart();
            int attaLen = attachmentObjects.length;
            System.err.println(attaLen + " attachments gefunden");
            for (int pass = 0; pass < 2; ++pass) {
                if (pass == 1) {
                    MimeBodyPart textBodyPart = new MimeBodyPart();
                    textBodyPart.setContent((Object)body, mimeType);
                    multiPart.addBodyPart((BodyPart)textBodyPart);
                }
                for (int i3 = 0; i3 < attaLen; ++i3) {
                    if (pass == 1 && attachmentObjects[i3] instanceof MailObjectClientBean) {
                        MailObjectClientBean moc = (MailObjectClientBean)attachmentObjects[i3];
                        moc.setRFCMode(true);
                        MimeMessage myMessage = new MimeMessage(session, moc.getContentStream());
                        MimeBodyPart attaBodyPart = new MimeBodyPart();
                        attaBodyPart.setContent((Object)myMessage, "message/rfc822");
                        moc.setRFCMode(false);
                        multiPart.addBodyPart((BodyPart)attaBodyPart);
                        continue;
                    }
                    if (attachmentObjects[i3] instanceof SendableContentInterface) {
                        String content;
                        SendableContentInterface sci = (SendableContentInterface)((Object)attachmentObjects[i3]);
                        if ((pass != 0 || !sci.isBeforeBodyPart()) && (pass != 1 || sci.isBeforeBodyPart()) || (content = sci.getSendableContentString(mailObject)) == null) continue;
                        MimeBodyPart mimeBodyPart = new MimeBodyPart();
                        mimeBodyPart.setContent((Object)content, sci.getSendableContentType());
                        mimeBodyPart.setHeader("Content-Type", sci.getSendableContentType());
                        mimeBodyPart.setHeader("Content-Class", sci.getSendableContentClass());
                        mimeBodyPart.setHeader("Content-Transfer-Encoding", sci.getSendableContentTransferEncoding());
                        multiPart.addBodyPart((BodyPart)mimeBodyPart);
                        continue;
                    }
                    if (pass != 1) continue;
                    MimeBodyPart attaBodyPart = this.handleDocumentAttachments(message, attachmentObjects[i3]);
                    multiPart.addBodyPart((BodyPart)attaBodyPart);
                }
            }
            message.setContent((Multipart)multiPart);
        } else {
            message.setContent(body, mimeType);
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MimeBodyPart handleDocumentAttachments(MimeMessage parentMsg, GlobalObjectClientBean attachmentObject) {
        MimeBodyPart mRet = null;
        try {
            FileObjectClientBean attDoc = (FileObjectClientBean)attachmentObject;
            String fName = "tmpSendMail_" + UUIDGenerator.get();
            File f = new File(fName);
            if (!f.exists()) {
                FileOutputStream fos = new FileOutputStream(fName);
                InputStream is = attDoc.getContentStream();
                try {
                    StringConverterUtils.pipe((InputStream)is, (OutputStream)fos);
                }
                finally {
                    fos.close();
                    is.close();
                }
            }
            mRet = new MimeBodyPart();
            FileDataSource fds = new FileDataSource(fName);
            mRet.setDataHandler(new DataHandler((DataSource)fds));
            String name = MimeUtility.encodeText((String)attDoc.getName(), (String)"UTF-8", null);
            name = name.replaceAll("\\?= =\\?UTF-8\\?Q\\?", "?=\r\n =?UTF-8?Q?");
            mRet.setHeader("Content-Type", "application/octet-stream;name=\"" + name + "\"");
            mRet.setHeader("Content-Disposition", "attachment;filename=\"" + name + "\"");
            File f1 = new File(fName);
            this.delVector.addElement(f1);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return mRet;
    }

    private void handleAttachments(MailObjectClientBean mailObject) throws Exception {
        GlobalObjectClientBean[] attaObjects = mailObject.getMailAttachments();
        if (attaObjects != null) {
            for (GlobalObjectClientBean attaObject : attaObjects) {
                GlobalObjectClientBean orgAttaObject = null;
                if (attaObject instanceof MailObjectClientBean || attaObject instanceof SendableContentInterface) {
                    orgAttaObject = attaObject;
                } else {
                    GlobalObjectClientBean[] orgAttaObjects = attaObject.getAllAttachments();
                    if (orgAttaObjects != null && orgAttaObjects.length == 1) {
                        orgAttaObject = orgAttaObjects[0];
                        attaObject.removeAttachments(orgAttaObjects);
                    }
                }
                if (orgAttaObject == null) continue;
                mailObject.addRelationship(orgAttaObject, (RelationObjectClientBeanDefinition)new AttachmentsRelationObjectClientBeanDefinition(this.sessionController));
            }
        }
    }

    public void sendAllMails(SuperObjectClientBean[] superObjects) throws Exception {
        if (superObjects != null) {
            int len = superObjects.length;
            for (int i = 0; i < len; ++i) {
                MailObjectClientBean mo = (MailObjectClientBean)superObjects[i];
                FolderObjectClientBean outbox = mo.getParent("outbox");
                if (outbox == null) continue;
                this.sendSingleMail((MailObjectClientBean)superObjects[i]);
            }
        }
    }

    public void moveSentMail(MailObjectClientBean mailObject, MimeMessage mimeMessage) throws Exception {
        MailFilterUtils mailFilterUtils = new MailFilterUtils();
        MailFilterObjectClientBean[] mailFilters = mailFilterUtils.getMailFilters(this.sessionController, mailObject.getOwner());
        boolean move = mailFilterUtils.filterOutboxAction(this.sessionController, mailObject, mailFilters);
        if (move) {
            FolderObjectClientBean userMailFolder = mailObject.getOwner().getPrimrayUserProfile().getMailFolder();
            FolderObjectClientBean sentBox = (FolderObjectClientBean)userMailFolder.getItem("sentbox");
            Hashtable<String, List<GlobalObjectClientBean>> folderPathObjects = mailObject.getAllFolderPathObjects(userMailFolder.getId());
            FolderObjectClientBean fromBox = null;
            if (folderPathObjects != null) {
                List pathObjects;
                String name;
                Iterator iter = folderPathObjects.values().iterator();
                while (iter.hasNext() && !(name = (fromBox = (FolderObjectClientBean)(pathObjects = (List)iter.next()).get(pathObjects.size() - 2)).getName()).equalsIgnoreCase("outbox") && !name.equalsIgnoreCase("drafts")) {
                }
            }
            if (fromBox != null) {
                RoiFileSystem rfs = new RoiFileSystem(this.sessionController);
                rfs.move(fromBox, sentBox, mailObject);
            } else {
                sentBox.addItem(mailObject);
            }
        }
        GlobalObjectClientBeanDefinition def = (GlobalObjectClientBeanDefinition)mailObject.getNewDefinition(this.sessionController);
        def.setSystemOption("ForceEA", "true");
        def.setSystemOption("PerformUpdateCallbacks", "");
        def.setLastModifier(mailObject.getOwner());
        def.setAttribute("MAILSTATUS", AttributeValue.newAttributeValueObject("sentbox"));
        mailObject.update(def);
    }

    public void moveErrorMail(MailObjectClientBean mailObject) throws Exception {
        String userHomeFolderPath = mailObject.getOwner().getPrimrayUserProfile().getHomeFolder().getAnyFolderPath();
        Hashtable<String, List<GlobalObjectClientBean>> allFPaths = mailObject.getAllFolderPathObjects();
        FolderObjectClientBean fromBox = null;
        Enumeration<String> pathEnum = allFPaths.keys();
        while (pathEnum.hasMoreElements()) {
            String path = pathEnum.nextElement();
            Vector allPObjects = (Vector)allFPaths.get(path);
            fromBox = (FolderObjectClientBean)allPObjects.elementAt(allPObjects.size() - 2);
            if (!path.toUpperCase().startsWith(userHomeFolderPath.toUpperCase())) continue;
            break;
        }
        FolderObjectClientBean sentbox = (FolderObjectClientBean)this.sessionController.findGlobalObjectByPath(userHomeFolderPath + "/Mail/Drafts");
        if (fromBox != null && sentbox != null) {
            RoiFileSystem rfs = new RoiFileSystem(this.sessionController);
            rfs.move(fromBox, sentbox, mailObject);
        }
    }

    public void sendSimpleMail(String[] toAddress, String[] ccAddress, String[] bccAddress, String subject, String body) throws Exception {
        this.sendSimpleMail(null, toAddress, ccAddress, bccAddress, subject, body, true, null);
    }

    public void sendSimpleMail(String[] toAddress, String[] ccAddress, String[] bccAddress, String subject, String body, GlobalObjectClientBean[] attachments) throws Exception {
        this.sendSimpleMail(null, toAddress, ccAddress, bccAddress, subject, body, true, attachments);
    }

    public void sendSimpleMail(String[] fromAddress, String[] toAddress, String[] ccAddress, String[] bccAddress, String subject, String body, GlobalObjectClientBean[] attachments) throws Exception {
        this.sendSimpleMail(fromAddress, toAddress, ccAddress, bccAddress, subject, body, true, attachments);
    }

    public void sendSimpleMail(String[] toAddress, String[] ccAddress, String[] bccAddress, String subject, String body, boolean sendIt) throws Exception {
        this.sendSimpleMail(null, toAddress, ccAddress, bccAddress, subject, body, sendIt, null);
    }

    public void sendSimpleMail(String[] fromAddress, String[] toAddress, String[] ccAddress, String[] bccAddress, String subject, String body, boolean sendIt, GlobalObjectClientBean[] attachments) throws Exception {
        this.sendSimpleMail(fromAddress, toAddress, ccAddress, bccAddress, subject, body, sendIt, attachments, false);
    }

    public MailObjectClientBean sendSimpleMail(String[] fromAddress, String[] toAddress, String[] ccAddress, String[] bccAddress, String subject, String body, boolean sendIt, GlobalObjectClientBean[] attachments, boolean html) throws Exception {
        return this.sendSimpleMail(fromAddress, toAddress, ccAddress, bccAddress, subject, body, sendIt, attachments, html, null);
    }

    public MailObjectClientBean sendSimpleMail(String[] fromAddress, String[] toAddress, String[] ccAddress, String[] bccAddress, String subject, String body, boolean sendIt, GlobalObjectClientBean[] attachments, boolean html, String[] replyToAddress) throws Exception {
        return this.sendSimpleMail(fromAddress, toAddress, ccAddress, bccAddress, subject, body, sendIt, attachments, html, replyToAddress, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MailObjectClientBean sendSimpleMail(String[] fromAddress, String[] toAddress, String[] ccAddress, String[] bccAddress, String subject, String body, boolean sendIt, GlobalObjectClientBean[] attachments, boolean html, String[] replyToAddress, String inReplyTo) throws Exception {
        RoiTransactionHandler rth = new RoiTransactionHandler();
        rth.begin();
        try {
            MailObjectClientBean mailObject;
            StringUtils stringUtils = new StringUtils();
            DirectoryUserObjectClientBean mailOwner = null;
            if (!sendIt) {
                mailOwner = this.sessionController.getDirectoryUserFromEmailAddress(toAddress[0]);
            }
            if (mailOwner == null) {
                mailOwner = this.sessionController.getLoginUser();
            }
            MailObjectSessionFacade mosf = new MailObjectSessionFacade(this.sessionController);
            if (fromAddress == null) {
                fromAddress = new String[1];
                DirectoryUserObjectClientBean loginUser = this.sessionController.getLoginUser();
                String mailOwnerAddress = loginUser.getEmailUserProfiles()[0].getEmailAddress();
                String mailOwnerName = loginUser.getInfoUserProfile().getFullName();
                fromAddress[0] = mailOwnerName != null && !mailOwnerName.equals("") ? mailOwnerName + " <" + mailOwnerAddress + ">" : mailOwnerAddress;
            }
            String outbox = mailOwner.getPrimrayUserProfile().getHomeFolder().getAnyFolderPath() + "/Mail/outbox";
            if (!sendIt) {
                outbox = mailOwner.getPrimrayUserProfile().getHomeFolder().getAnyFolderPath() + "/Mail/inbox";
            }
            mosf.setDestinationFolder((FolderObjectClientBean)this.sessionController.findGlobalObjectByPath(outbox));
            mosf.setNameWithId(true);
            mosf.setWithTransaction(true);
            mosf.setAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE, stringUtils.strReplaceToFilename(subject + "_" + "$$ID$$" + ".eml"));
            if (sendIt) {
                mosf.setAttribute("MAILSTATUS", "outbox");
            } else {
                mosf.setAttribute("MAILSTATUS", "inbox");
                mosf.setAttribute(GlobalObjectClientBean.OWNER_ATTRIBUTE, mailOwner);
            }
            mosf.setAttribute("FROMADDRESS", fromAddress);
            mosf.setAttribute("TOADDRESS", toAddress);
            mosf.setAttribute("CCADDRESS", ccAddress);
            mosf.setAttribute("BCCADDRESS", bccAddress);
            mosf.setAttribute("SUBJECT", subject);
            if (inReplyTo != null) {
                mosf.setAttribute("INREPLAYTO", inReplyTo);
            }
            if (replyToAddress != null) {
                mosf.setAttribute("REPLAYTO", replyToAddress);
            }
            this.sentMail = mailObject = (MailObjectClientBean)mosf.create();
            MailDocumentObjectSessionFacade mdosf = new MailDocumentObjectSessionFacade(this.sessionController);
            mdosf.setWithTransaction(true);
            mdosf.setContentStream(StringConverterUtils.toStream((String)body));
            mdosf.setNameWithId(true);
            String fileName = null;
            fileName = html ? "(Html) $$ID$$.html" : "(Text) $$ID$$.txt";
            mdosf.setAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE, fileName);
            if (!sendIt) {
                mdosf.setAttribute(GlobalObjectClientBean.OWNER_ATTRIBUTE, mailOwner);
            }
            mdosf.setAccessControlList(mailObject.getAcl());
            MailDocumentObjectClientBean mdocb = (MailDocumentObjectClientBean)mdosf.create();
            mailObject.addRelationship(mdocb, (RelationObjectClientBeanDefinition)new MailBodyRelationObjectClientBeanDefinition(this.sessionController));
            if (attachments != null) {
                for (GlobalObjectClientBean attachment : attachments) {
                    mailObject.addMailAttachment(attachment);
                }
            }
            if (sendIt) {
                this.sendSingleMail(mailObject);
            }
            rth.end();
            rth = null;
            MailObjectClientBean mailObjectClientBean = mailObject;
            return mailObjectClientBean;
        }
        finally {
            if (rth != null) {
                rth.abort();
                rth = null;
            }
        }
    }

    public static void main(String[] args) {
        try {
            Properties props = new Properties();
            Session session = Session.getInstance((Properties)props);
            String mailAddressWithName = "\"t\u00e4\u00f6\u00fcst\" <test@domain.de>";
            InternetAddress res = null;
            try {
                mailAddressWithName = mailAddressWithName.trim();
                if (mailAddressWithName.length() > 0) {
                    int startPos = mailAddressWithName.indexOf("<");
                    if (startPos != -1) {
                        StringUtils su = new StringUtils();
                        String mailAddress = su.getStringFrommTrenner(mailAddressWithName, "<", ">", 1);
                        mailAddress = mailAddress.replaceAll("[\\s]*", "");
                        String name = mailAddressWithName.substring(0, startPos);
                        name = name.replaceAll("^[\\s]*", "");
                        name = name.replaceAll("[\\s]*$", "");
                        name = name.replaceAll("^[\"]*", "");
                        name = name.replaceAll("[\"]*$", "");
                        res = new InternetAddress(mailAddress, name, "ISO-8859-15");
                    } else {
                        res = new InternetAddress(mailAddressWithName);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            EmlMimeMessage message = new EmlMimeMessage(session);
            message.setSentDate(new Date());
            message.setFrom((Address)res);
            message.addRecipient(Message.RecipientType.TO, (Address)res);
            MimeMultipart multiPart = new MimeMultipart();
            MimeBodyPart textBodyPart = new MimeBodyPart();
            textBodyPart.setContent((Object)"Hallo", "text/plain");
            multiPart.addBodyPart((BodyPart)textBodyPart);
            message.setContent((Multipart)multiPart);
            message.writeTo(new FileOutputStream("c:\\temp\\mails\\out.eml"));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private class SMTPAuthenticator
    extends Authenticator {
        private String username = null;
        private String password = null;

        public SMTPAuthenticator(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.username, this.password);
        }
    }
}

