/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.beans;

import agorum.commons.logging.Log;
import agorum.roi.common.utils.CycleUtils;
import agorum.roi.ejb.beans.GlobalObjectEJB;
import agorum.roi.ejb.callback.SuperObjectCallBack;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.FolderRelationObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.InternalObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.RelationObjectClientBean;
import agorum.roi.ejb.client.beans.RelationObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.CallBackUtils;
import agorum.roi.ejb.common.ConnectionUtils;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.RoiFileSystem;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.ejb.database.common.DatabaseInterface;
import agorum.roi.ejb.database.common.DatabaseUtils;
import agorum.roi.search.SearchClass;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.ejb.SessionBean;

public class FolderObjectEJB
extends GlobalObjectEJB
implements SessionBean {
    public RelationObjectClientBean addItem(SessionController sessionController, GlobalObjectClientBean lo, GlobalObjectClientBean ro, SuperObjectClientBeanDefinition foldDef) throws RemoteException, Exception {
        try {
            FolderObjectClientBean leftFolder = (FolderObjectClientBean)lo;
            RelationObjectClientBeanDefinition def = (RelationObjectClientBeanDefinition)leftFolder.getFolderRelationObjectCreateDefinition(sessionController);
            if (foldDef != null) {
                def.addAllSystemOption(foldDef.getAllSystemOption(), true);
                if (foldDef instanceof InternalObjectClientBeanDefinition) {
                    def.setAttributes(foldDef.getAttributes());
                }
            }
            RelationObjectClientBean rel = lo.addRelationship(ro, def);
            return rel;
        }
        catch (RemoteException e) {
            System.err.println("------------------s-RE-------------");
            e.printStackTrace(System.err);
            System.err.println("-------------------E--RE-----------");
            throw e;
        }
        catch (Exception e) {
            System.err.println("------------------s--------------");
            e.printStackTrace(System.err);
            System.err.println("-------------------E-------------");
            ExceptionUtils.handleException(e);
            return null;
        }
    }

    public void checkCycle(SessionController sessionController, FolderObjectClientBean lo, GlobalObjectClientBean ro) throws RemoteException, Exception {
        RoiFileSystem rfs = new RoiFileSystem(sessionController);
        rfs.doCycleCheck(lo, ro);
    }

    public boolean isFolderInFolder(SessionController sessionController, long startFolderId, long subFolderId) throws RemoteException, Exception {
        try (Connection conn = new ConnectionUtils().getConnection();){
            boolean bl = new CycleUtils(sessionController).isFolderInFolder(conn, startFolderId, subFolderId);
            return bl;
        }
    }

    public int getItemsCount(SessionController sessionController, FolderObjectClientBean lo, String[] className, String[] attributeName, Object[] value, int[] qualification, boolean[] ignorecase, int[] clause) throws RemoteException, Exception {
        SearchClass sc = this.getSearchClassForGetItems(sessionController, lo, true, className, attributeName, value, qualification, ignorecase, clause, null, null, null, null);
        int count = sc.getSelectCounter();
        sc.closeSearch();
        return count;
    }

    public boolean hasItems(SessionController sessionController, FolderObjectClientBean lo, String[] className, String[] attributeName, Object[] value, int[] qualification, boolean[] ignorecase, int[] clause) throws RemoteException, Exception {
        GlobalObjectClientBean[] goRet = null;
        DatabaseUtils du = new DatabaseUtils();
        DatabaseInterface dbi = du.getDatabaseInterfaceImpl();
        if (dbi.supportsLimit()) {
            SearchClass sc = this.getSearchClassForGetItems(sessionController, lo, false, className, attributeName, value, qualification, ignorecase, clause, null, null, null, null, true);
            goRet = sc.getItems();
            sc.closeSearch();
            return goRet != null && goRet.length > 0;
        }
        SearchClass sc = this.getSearchClassForGetItems(sessionController, lo, true, className, attributeName, value, qualification, ignorecase, clause, null, null, null, null);
        goRet = sc.getItems();
        int count = sc.getSelectCounter();
        sc.closeSearch();
        return count > 0;
    }

    public boolean hasItem(SessionController sessionController, FolderObjectClientBean lo, String[] className, String[] attributeName, Object[] value, int[] qualification, boolean[] ignorecase, int[] clause) throws RemoteException, Exception {
        int count = 0;
        SessionController scAdmin = SessionControllerAdmin.getSessionControllerAdmin(sessionController, "UserAdminTmpMode");
        lo = (FolderObjectClientBean)scAdmin.getGlobalObjectById(lo.getId());
        SearchClass sc = this.getSearchClassForGetItems(scAdmin, lo, true, className, attributeName, value, qualification, ignorecase, clause, null, null, null, null);
        sc.getItems();
        count = sc.getSelectCounter();
        sc.closeSearch();
        return count > 0;
    }

    public GlobalObjectClientBean[] getItems(SessionController sessionController, FolderObjectClientBean lo, boolean withDocumentOption, String[] className, String[] attributeName, Object[] value, int[] qualification, boolean[] ignorecase, int[] clause, String[] sortClassnames, String[] sortAttribute, int[] sortOrder, String serachName) throws RemoteException, Exception {
        int len;
        GlobalObjectClientBean[] goRet = null;
        SearchClass sc = this.getSearchClassForGetItems(sessionController, lo, false, className, attributeName, value, qualification, ignorecase, clause, sortClassnames, sortAttribute, sortOrder, serachName);
        goRet = sc.getItems();
        sc.closeSearch();
        if (withDocumentOption && goRet != null && (len = goRet.length) > 0) {
            for (int i = 0; i < len; ++i) {
                if (!withDocumentOption || !sessionController.isDocument(goRet[i])) continue;
                try {
                    Method dynMethodSetS = goRet[i].getClass().getMethod("getContentSize", new Class[0]);
                    dynMethodSetS.invoke((Object)goRet[i], new Object[0]);
                    continue;
                }
                catch (Exception e) {
                    ExceptionUtils.handleException(e);
                }
            }
        }
        return goRet;
    }

    private SearchClass getSearchClassForGetItems(SessionController sessionController, FolderObjectClientBean folder, boolean countOnly, String[] className, String[] attributeName, Object[] value, int[] qualification, boolean[] ignorecase, int[] clause, String[] sortClassnames, String[] sortAttribute, int[] sortOrder, String searchName) throws RemoteException, Exception {
        return this.getSearchClassForGetItems(sessionController, folder, countOnly, className, attributeName, value, qualification, ignorecase, clause, sortClassnames, sortAttribute, sortOrder, searchName, false);
    }

    private SearchClass getSearchClassForGetItems(SessionController sessionController, FolderObjectClientBean folder, boolean countOnly, String[] className, String[] attributeName, Object[] value, int[] qualification, boolean[] ignorecase, int[] clause, String[] sortClassnames, String[] sortAttribute, int[] sortOrder, String searchName, boolean onlyOneElement) throws RemoteException, Exception {
        int i;
        String[] classNameInternal;
        SearchClass sc = new SearchClass(sessionController);
        sc.setBindOn();
        if (countOnly) {
            sc.setCountOnly();
        }
        if (onlyOneElement) {
            sc.setOnlyOneElement();
        }
        String[] allClassName = classNameInternal = new String[]{GlobalObjectClientBean.CLASS_NAME, RelationObjectClientBean.CLASS_NAME, FolderRelationObjectClientBean.CLASS_NAME};
        int off = allClassName.length;
        if (className != null) {
            int i2;
            Vector<String> v = new Vector<String>();
            Hashtable<String, String> h = new Hashtable<String, String>();
            int len = classNameInternal.length;
            for (i2 = 0; i2 < len; ++i2) {
                v.addElement(classNameInternal[i2]);
                h.put(classNameInternal[i2], "");
            }
            len = className.length;
            for (i2 = 0; i2 < len; ++i2) {
                if (h.containsKey(className[i2])) continue;
                v.addElement(className[i2]);
            }
            len = v.size();
            allClassName = new String[len];
            for (i2 = 0; i2 < len; ++i2) {
                allClassName[i2] = v.elementAt(i2).toString();
            }
        }
        sc.setClassname(allClassName);
        sc.setJoin(GlobalObjectClientBean.CLASS_NAME, null, RelationObjectClientBean.CLASS_NAME, RelationObjectClientBean.RIGHTOBJECT_ATTRIBUTE);
        sc.setJoin(RelationObjectClientBean.CLASS_NAME, null, FolderRelationObjectClientBean.CLASS_NAME, null);
        sc.setSearchClauseAND();
        int len = allClassName.length;
        for (i = off; i < len; ++i) {
            sc.setJoin(GlobalObjectClientBean.CLASS_NAME, null, allClassName[i], null);
            sc.setSearchClauseAND();
        }
        sc.setAttributeEQUAL(RelationObjectClientBean.CLASS_NAME, RelationObjectClientBean.LEFTOBJECT_ATTRIBUTE, (Object)folder.getId(), false);
        sc.setSearchClauseAND();
        if (className != null && attributeName != null && clause != null) {
            len = className.length;
            for (i = 0; i < len; ++i) {
                if (attributeName[i] == null) continue;
                sc.setAttributeData(className[i], attributeName[i], value[i], qualification[i], ignorecase[i]);
                sc.setSearchClause(clause[i]);
            }
            int lenC = clause.length;
            for (int i3 = len; i3 < lenC; ++i3) {
                sc.setSearchClause(clause[i3]);
            }
        }
        if (sortClassnames != null && sortAttribute != null && sortOrder != null) {
            sc.setSortSpezification(sortClassnames, sortAttribute, sortOrder);
            searchName = null;
        }
        sc.openSearch(GlobalObjectClientBean.CLASS_NAME, searchName);
        return sc;
    }

    public void removeItem(SessionController sessionController, FolderObjectClientBean focb, GlobalObjectClientBean gocb) throws RemoteException, Exception {
        try {
            SuperObjectClientBeanDefinition defLo = focb.getNewDefinition(sessionController);
            CallBackUtils cbu = new CallBackUtils();
            try {
                SuperObjectCallBack callBack = cbu.getCallBackFromClassId(sessionController, defLo.getClassId());
                callBack.executeBeforeRemoveItem(sessionController, defLo, focb, gocb);
                String name = gocb.getName();
                focb.removeRelationship(focb.getRelations(FolderRelationObjectClientBean.CLASS_NAME, RelationObjectClientBean.LEFTOBJECT_ATTRIBUTE, RelationObjectClientBean.RIGHTOBJECT_ATTRIBUTE, gocb));
                callBack.executeAfterRemoveItem(sessionController, defLo, focb, name);
                cbu.finishCallBack(sessionController);
                cbu = null;
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                try {
                    if (cbu != null) {
                        cbu.finishCallBack(sessionController);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (RemoteException e) {
            System.err.println("------------------s-RE-------------");
            e.printStackTrace(System.err);
            System.err.println("-------------------E--RE-----------");
            throw e;
        }
        catch (Exception e) {
            System.err.println("------------------s--------------");
            e.printStackTrace(System.err);
            System.err.println("-------------------E-------------");
            ExceptionUtils.handleException(e);
        }
    }

    public void removeItems(SessionController sessionController, FolderObjectClientBean focb, GlobalObjectClientBean[] gocb) throws RemoteException, Exception {
        if (gocb != null) {
            int len = gocb.length;
            for (int i = 0; i < len; ++i) {
                this.removeItem(sessionController, focb, gocb[i]);
            }
        }
    }

    public void removeAllItems(SessionController sessionController, FolderObjectClientBean focb) throws RemoteException, Exception {
        this.removeItems(sessionController, focb, focb.getItems());
    }

    @Override
    protected boolean deleteOnlyItems(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        boolean delItems = false;
        if (def.getSystemOption("deleteOnlyItemsFromFolder") != null) {
            FolderObjectClientBean folder = (FolderObjectClientBean)clientBean;
            Hashtable systemOptions = def.getAllSystemOption();
            if (systemOptions.containsKey("parentFolderOfDeleteObject")) {
                systemOptions.remove("parentFolderOfDeleteObject");
                systemOptions.put("parentFolderOfDeleteObject", folder);
            }
            systemOptions.remove("deleteOnlyItemsFromFolder");
            RelationObjectClientBean[] allRel = folder.getRightwardRelations(FolderRelationObjectClientBean.CLASS_NAME);
            if (allRel != null) {
                int len = allRel.length;
                for (int i = 0; i < len; ++i) {
                    GlobalObjectClientBean gocb;
                    try {
                        gocb = allRel[i].getRightObject();
                    }
                    catch (Exception e) {
                        try {
                            if (sessionController.getInternalObjectById(allRel[i].getId()) == null) continue;
                            throw e;
                        }
                        catch (Exception e2) {
                            Log.debug((Throwable)e2);
                        }
                        continue;
                    }
                    if (gocb == null) continue;
                    SuperObjectClientBeanDefinition myDef = gocb.getNewDefinition(sessionController);
                    if (systemOptions != null) {
                        Enumeration enumO = systemOptions.keys();
                        while (enumO.hasMoreElements()) {
                            Object key = enumO.nextElement();
                            Object value = systemOptions.get(key);
                            myDef.setSystemOption((String)key, value);
                        }
                    }
                    gocb.delete(myDef);
                }
            }
            delItems = true;
        }
        return delItems;
    }
}

