/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.callback;

import agorum.roi.ejb.callback.AccessControlListObjectCallBack;
import agorum.roi.ejb.client.beans.AccessControlListObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.search.SearchClass;

public class CustomAccessControlListObjectCallBack
extends AccessControlListObjectCallBack {
    @Override
    public void executeBeforeDelete(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        AccessControlListObjectClientBean acl = (AccessControlListObjectClientBean)clientBean;
        if (def.getSystemOption("DeleteACL_And_AllObjectsWithThisACL") != null) {
            if (sessionController.isAdminEnabled()) {
                SearchClass sc = new SearchClass(sessionController);
                sc.setBindOn();
                sc.setClassname(new String[]{GlobalObjectClientBean.CLASS_NAME});
                sc.setAttributeEQUAL(GlobalObjectClientBean.CLASS_NAME, GlobalObjectClientBean.ACL_ATTRIBUTE, (Object)acl, false);
                sc.openSearch(GlobalObjectClientBean.CLASS_NAME);
                GlobalObjectClientBean[] objects = sc.getItems();
                sc.closeSearch();
                if (objects != null) {
                    long aclid = clientBean.getId();
                    int len = objects.length;
                    for (int i = 0; i < len; ++i) {
                        try {
                            if (objects[i].getId() == aclid) continue;
                            objects[i].delete();
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            } else {
                ExceptionUtils.handleException("You can't delete all objects with this ACL (" + acl.getName() + ", admin access needed.", "agorum.roi.remote.exception.AdminAccessNeeded", 23);
            }
        }
        super.executeBeforeDelete(sessionController, def, clientBean);
    }
}

