/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.callback;

import agorum.roi.ejb.callback.CustomRelationObjectCallBack;
import agorum.roi.ejb.callback.SuperObjectCallBack;
import agorum.roi.ejb.client.beans.AllocationRelationObjectClientBean;
import agorum.roi.ejb.client.beans.FolderRelationObjectClientBean;
import agorum.roi.ejb.client.beans.FolderRelationObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.NoteObjectClientBean;
import agorum.roi.ejb.client.beans.RelationObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.AttributeXMLObjectUtils;
import agorum.roi.ejb.common.BackendHelper;
import agorum.roi.ejb.common.CallBackUtils;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.ejb.mbeans.PathDateService;
import agorum.roi.ejb.messaging.common.MessageUtils;
import agorum.roi.exception.RoiException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class FolderRelationObjectCallBack
extends CustomRelationObjectCallBack {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeBeforeCreate(SessionController sessionController, SuperObjectClientBeanDefinition def) throws Exception {
        ((FolderRelationObjectClientBeanDefinition)def).setSubChangeDate(new Date());
        GlobalObjectClientBean lo = def.getAttribute(RelationObjectClientBean.LEFTOBJECT_ATTRIBUTE).getGlobalObjectClientBean(sessionController);
        GlobalObjectClientBean ro = def.getAttribute(RelationObjectClientBean.RIGHTOBJECT_ATTRIBUTE).getGlobalObjectClientBean(sessionController);
        if (ro instanceof NoteObjectClientBean) {
            throw new RoiException("Folder relations are not supported for " + ro.getClassName(), "agorum.roi.remote.exception.NotAllowed", 20, null);
        }
        CallBackUtils cbu = new CallBackUtils();
        try {
            SuperObjectClientBeanDefinition defLo = lo.getNewDefinition(sessionController);
            cbu.getCallBackFromClassId(sessionController, defLo.getClassId()).executeBeforeAddItem(sessionController, defLo, def, lo, ro);
        }
        finally {
            try {
                cbu.finishCallBack(sessionController);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.executeBeforeCreate(sessionController, def);
    }

    @Override
    public void executeAfterCreate(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        GlobalObjectClientBean obj;
        GlobalObjectClientBean mainObj;
        GlobalObjectClientBean lo = ((RelationObjectClientBean)clientBean).getLeftObject();
        SuperObjectClientBeanDefinition defLo = lo.getNewDefinition(sessionController);
        GlobalObjectClientBean ro = null;
        CallBackUtils cbu = new CallBackUtils();
        try {
            SuperObjectCallBack callBack = cbu.getCallBackFromClassId(sessionController, defLo.getClassId());
            ro = ((RelationObjectClientBean)clientBean).getRightObject();
            callBack.executeAfterAddItem(sessionController, defLo, lo, ro);
            cbu.finishCallBack(sessionController);
            cbu = null;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (cbu != null) {
                    cbu.finishCallBack(sessionController);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Object sysOp = def.getSystemOption("addToFolderFromCreate");
        MessageUtils mu = new MessageUtils();
        if (sysOp == null || ((String)sysOp).equalsIgnoreCase("false")) {
            mu.sendUpdateToPathEvent(ro, def);
        }
        PathDateService.addToPathDateQueue(ro);
        AttributeXMLObjectUtils.itemAdded(lo, ro);
        if (BackendHelper.backendInterface != null) {
            BackendHelper.backendInterface.folderItemAdded(lo, ro);
        }
        if (def.getSystemOption("doNotChangeMainObject") == null && !(mainObj = (obj = this.asAdmin(ro)).getMainObj()).equals(obj)) {
            this.setMainObjRecursive(obj, mainObj, obj, new HashSet<Long>());
        }
        super.executeAfterCreate(sessionController, def, clientBean);
    }

    @Override
    public void executeBeforeDelete(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        GlobalObjectClientBean newMainObj;
        GlobalObjectClientBean lo = ((FolderRelationObjectClientBean)clientBean).getLeftObject();
        GlobalObjectClientBean ro = ((FolderRelationObjectClientBean)clientBean).getRightObject();
        SuperObjectClientBeanDefinition defLo = lo.getNewDefinition(sessionController);
        defLo.setAllSystemOption(def.getAllSystemOption());
        CallBackUtils cbu = new CallBackUtils();
        try {
            SuperObjectCallBack callBack = cbu.getCallBackFromClassId(sessionController, defLo.getClassId());
            callBack.executeBeforeDeleteRelation(sessionController, defLo, lo, ro);
            cbu.finishCallBack(sessionController);
            cbu = null;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (cbu != null) {
                    cbu.finishCallBack(sessionController);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        MessageUtils mu = new MessageUtils();
        mu.sendUpdateToPathEvent(ro, def);
        PathDateService.addToPathDateQueue(lo);
        AttributeXMLObjectUtils.itemRemoved(lo, ro);
        GlobalObjectClientBean obj = this.asAdmin(ro);
        GlobalObjectClientBean mainObj = null;
        try {
            mainObj = obj.getMainObj();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (mainObj != null && mainObj.equals(obj) && obj.getLeftwardRelationCount(FolderRelationObjectClientBean.CLASS_NAME) <= 1 && (newMainObj = this.findMainObj(obj)) != null) {
            this.setMainObjRecursive(obj, obj, this.findMainObj(obj), new HashSet<Long>());
        }
        super.executeBeforeDelete(sessionController, def, clientBean);
    }

    private GlobalObjectClientBean asAdmin(GlobalObjectClientBean obj) throws Exception {
        return SessionControllerAdmin.getSessionControllerAdmin("FolderRelationObjectCallBack").getGlobalObjectById(obj.getId());
    }

    private GlobalObjectClientBean findMainObj(GlobalObjectClientBean obj) throws Exception {
        GlobalObjectClientBean[] sup = obj.getLeftwardRelationObjects(AllocationRelationObjectClientBean.CLASS_NAME);
        if (sup == null) {
            return null;
        }
        for (GlobalObjectClientBean supItem : sup) {
            if (supItem.getMainObj().equals(supItem)) {
                return supItem;
            }
            GlobalObjectClientBean result = this.findMainObj(supItem);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private void setMainObjRecursive(GlobalObjectClientBean obj, GlobalObjectClientBean oldMainObj, GlobalObjectClientBean newMainObj, Set<Long> done) throws Exception {
        done.add(obj.getId());
        if (!oldMainObj.equals(obj.getMainObj())) {
            return;
        }
        SuperObjectClientBeanDefinition def = obj.getNewDefinition(obj.getSessionController());
        def.setSystemOption("doNotEA", "");
        def.setAttribute(GlobalObjectClientBean.CREATEDATE_ATTRIBUTE, AttributeValue.newAttributeValueObject(obj.getCreateDate()));
        def.setAttribute(GlobalObjectClientBean.LASTMODIFYDATE_ATTRIBUTE, AttributeValue.newAttributeValueObject(obj.getLastModifyDate()));
        def.setAttribute(GlobalObjectClientBean.MAINOBJECT_ATTRIBUTE, AttributeValue.newAttributeValueObject(newMainObj));
        obj.update(def);
        GlobalObjectClientBean[] sub = obj.getRightwardRelationObjects(AllocationRelationObjectClientBean.CLASS_NAME);
        if (sub == null) {
            return;
        }
        for (GlobalObjectClientBean subItem : sub) {
            if (done.contains(subItem.getId())) continue;
            this.setMainObjRecursive(subItem, oldMainObj, newMainObj, done);
        }
    }
}

