/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.callback;

import agorum.roi.ejb.callback.CustomInternalObjectCallBack;
import agorum.roi.ejb.client.beans.FormatObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.FormatObjectUtils;
import agorum.roi.ejb.common.SessionController;

public class FormatObjectCallBack
extends CustomInternalObjectCallBack {
    @Override
    public void executeAfterCreate(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        FormatObjectClientBean formatObject = (FormatObjectClientBean)clientBean;
        FormatObjectUtils utils = new FormatObjectUtils(sessionController);
        utils.setFormatObjectToObjectsWithThisExtensions(formatObject);
        super.executeAfterCreate(sessionController, def, clientBean);
    }

    @Override
    public void executeBeforeDelete(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        FormatObjectUtils utils = new FormatObjectUtils(sessionController);
        FormatObjectClientBean formatObject = (FormatObjectClientBean)clientBean;
        if (utils.hasObjectWithThisFormatObject(formatObject)) {
            ExceptionUtils.handleException("FormatObject couldn't be delete, it has a reference to an object.", "agorum.roi.remote.exception.FormatObjectHasReference", 55);
        }
        super.executeBeforeDelete(sessionController, def, clientBean);
    }

    @Override
    public void executeBeforeUpdate(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        if (def.getAttribute(FormatObjectClientBean.EXTENSION_ATTRIBUTE) != null) {
            ExceptionUtils.handleException("Update not allowed for attribute: FormatObject." + FormatObjectClientBean.EXTENSION_ATTRIBUTE, "agorum.roi.remote.exception.AttributeUpdateNotAllowed", 73);
        }
        if (def.getAttribute(FormatObjectClientBean.TABLENAME_ATTRIBUTE) != null) {
            ExceptionUtils.handleException("Update not allowed for attribute: FormatObject." + FormatObjectClientBean.TABLENAME_ATTRIBUTE, "agorum.roi.remote.exception.AttributeUpdateNotAllowed", 73);
        }
        super.executeBeforeUpdate(sessionController, def, clientBean);
    }
}

