/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.callback;

import agorum.commons.uuid.UUIDGenerator;
import agorum.roi.behavior.BehaviorManager;
import agorum.roi.common.FolderItemsChangedDeleted;
import agorum.roi.common.ObjectUpdateCollector;
import agorum.roi.common.utils.PermissionUtil;
import agorum.roi.contenthash.common.ContentHashUtils;
import agorum.roi.ejb.audit.AuditUtil;
import agorum.roi.ejb.beans.GlobalObjectEntity;
import agorum.roi.ejb.callback.SuperObjectCallBack;
import agorum.roi.ejb.client.beans.AccessControlListObjectClientBean;
import agorum.roi.ejb.client.beans.AttributeObjectClientBean;
import agorum.roi.ejb.client.beans.ChangeHistoryRelationObjectClientBean;
import agorum.roi.ejb.client.beans.ClassObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.FileObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.FolderPathRelationObjectClientBean;
import agorum.roi.ejb.client.beans.FolderRelationObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.InternalObjectClientBean;
import agorum.roi.ejb.client.beans.RelationObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.AttributeValueGlobalObjectClientBean;
import agorum.roi.ejb.common.ChangeHistoryUtils;
import agorum.roi.ejb.common.ContentInterface;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.LockUtils;
import agorum.roi.ejb.common.RemoteRelationUtils;
import agorum.roi.ejb.common.RoiFileSystem;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.Transaction;
import agorum.roi.ejb.mbeans.ExpirationDateService;
import agorum.roi.ejb.messaging.common.MessageUtils;
import agorum.roi.statistic.DatabaseAccessStatistic;
import agorum.roi.timephasedaction.common.TimePhasedActionUtils;
import agorum.roi.workers.AclInheritor;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class GlobalObjectCallBack
extends SuperObjectCallBack {
    @Override
    public void executeBeforeCreate(SessionController sessionController, SuperObjectClientBeanDefinition def) throws Exception {
        Object foldObj;
        GlobalObjectClientBean mainObject;
        GlobalObjectClientBeanDefinition gDef = (GlobalObjectClientBeanDefinition)def;
        if (gDef.getAttribute(GlobalObjectClientBean.UUID_ATTRIBUTE) == null) {
            gDef.setAttribute(GlobalObjectClientBean.UUID_ATTRIBUTE, AttributeValue.newAttributeValueObject(new UUIDGenerator().getUUID().toLowerCase()));
        }
        AttributeValue avName = gDef.getAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE);
        RoiFileSystem rfs = new RoiFileSystem(sessionController);
        if (avName != null && gDef.checkForNotAllowedChars()) {
            rfs.checkNameChars(avName.getString());
        } else {
            rfs.checkNameCharsCustom(avName.getString(), "/\\");
        }
        Date currentDate = new Date();
        if (gDef.getAttribute(GlobalObjectClientBean.LASTMODIFYDATE_ATTRIBUTE) == null) {
            gDef.setLastModifyDate(currentDate);
        }
        boolean ownerSet = true;
        if (gDef.getAttribute(GlobalObjectClientBean.OWNER_ATTRIBUTE) == null) {
            gDef.setOwner(sessionController.getLoginUser());
            ownerSet = false;
        }
        if (gDef.getAttribute(GlobalObjectClientBean.CREATOR_ATTRIBUTE) == null) {
            gDef.setCreator(sessionController.getLoginUser());
        }
        if (gDef.getAttribute(GlobalObjectClientBean.CREATEDATE_ATTRIBUTE) == null) {
            gDef.setCreateDate(currentDate);
        }
        if (gDef.getAttribute(GlobalObjectClientBean.MAINOBJECT_ATTRIBUTE) == null) {
            gDef.setAttribute(GlobalObjectClientBean.MAINOBJECT_ATTRIBUTE, new AttributeValueGlobalObjectClientBean(gDef.getId()));
        } else {
            gDef.setMainObject(null);
        }
        if (gDef.getAttribute(GlobalObjectClientBean.LASTMODIFIER_ATTRIBUTE) == null) {
            gDef.setLastModifier(sessionController.getLoginUser());
        }
        if ((mainObject = (GlobalObjectClientBean)gDef.getSystemOption("setExplicitMainObject")) != null) {
            gDef.setMainObject(mainObject);
        }
        long usedAcl = -1L;
        FolderObjectClientBean folder = null;
        if (gDef.getAttribute(GlobalObjectClientBean.ACL_ATTRIBUTE) == null) {
            foldObj = def.getSystemOption("addToFolder");
            if (foldObj != null) {
                folder = (FolderObjectClientBean)foldObj;
                usedAcl = folder.getAcl().getId();
                gDef.setAcl(folder.getAcl());
                gDef.setScopeAcls(folder.getScopeAclsById());
            } else {
                AccessControlListObjectClientBean userAcl = sessionController.getLoginUserDefaultAcl();
                usedAcl = userAcl.getId();
                gDef.setAcl(userAcl);
            }
        } else {
            usedAcl = gDef.getAttribute(GlobalObjectClientBean.ACL_ATTRIBUTE).getLong();
        }
        if (folder == null && (foldObj = def.getSystemOption("addToFolder")) != null) {
            folder = (FolderObjectClientBean)foldObj;
        }
        if (!ownerSet && usedAcl != -1L && 12000L == usedAcl && folder != null && folder.getAcl().getId() == 12000L) {
            gDef.setOwner(folder.getOwner());
        }
        if (gDef.getIsFolderAV() == null) {
            gDef.setIsFolder(false);
        }
        if (def.getSystemOption(GlobalObjectClientBean.UPDATEDATE_ATTRIBUTE) != null) {
            def.setAttribute(GlobalObjectClientBean.UPDATEDATE_ATTRIBUTE, (AttributeValue)def.getSystemOption(GlobalObjectClientBean.UPDATEDATE_ATTRIBUTE));
        } else {
            def.setAttribute(GlobalObjectClientBean.UPDATEDATE_ATTRIBUTE, AttributeValue.newAttributeValueObject(new Date()));
        }
        super.executeBeforeCreate(sessionController, def);
    }

    private void checkSystemFlags(SessionController sessionController, GlobalObjectClientBean gocb, SuperObjectClientBeanDefinition def, boolean nameOrDescChanged) throws Exception {
        AttributeValue systemFlagsAv;
        boolean isHistoryObject;
        if (sessionController.isInSychronization()) {
            return;
        }
        long systemflags = gocb.getSystemFlags();
        if ((systemflags & GlobalObjectClientBean.SYSTEMFLAG_NOTCHANGENAME) > 0L) {
            AttributeValue av = def.getAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE);
            if (av != null && !av.getString().equals(gocb.getName())) {
                ExceptionUtils.handleException("No Access", "agorum.roi.remote.exception.SystemFlagsNotChangeName", 2005);
            }
        } else if ((systemflags & GlobalObjectClientBean.SYSTEMFLAG_ONLYOWNERCHANGENAME) > 0L) {
            AttributeValue av;
            DirectoryUserObjectClientBean loginUser = sessionController.getLoginUser();
            if (!(gocb.getOwner().equals(sessionController.getLoginUser()) || loginUser.getAdminenabled() || (av = def.getAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE)) == null || av.getString().equals(gocb.getName()))) {
                ExceptionUtils.handleException("No Access", "agorum.roi.remote.exception.SystemFlagsOnlyOwnerChangeName", 2012);
            }
        }
        boolean bl = isHistoryObject = (systemflags & GlobalObjectClientBean.SYSTEMFLAG_HISTORYOBJECT) > 0L;
        if (isHistoryObject && nameOrDescChanged) {
            ExceptionUtils.handleException("History objects cannot be changed", "agorum.roi.remote.exception.SystemFlagsHistoryObject", 2010);
        }
        if ((systemFlagsAv = def.getAttribute(GlobalObjectClientBean.SYSTEMFLAGS_ATTRIBUTE)) != null) {
            boolean expired;
            long newFlags = systemFlagsAv.getLong();
            Date expirationDate = gocb.getExpirationDate();
            boolean bl2 = expired = expirationDate != null && expirationDate.after(ExpirationDateService.MIN_EXPIRATION) && expirationDate.before(new Date());
            if (!expired) {
                if ((systemflags & (GlobalObjectClientBean.SYSTEMFLAG_NOTDELETELOCK | GlobalObjectClientBean.SYSTEMFLAG_NOTCHANGE)) != 0L) {
                    if ((systemflags & GlobalObjectClientBean.SYSTEMFLAG_NOTDELETE) != 0L && (newFlags & GlobalObjectClientBean.SYSTEMFLAG_NOTDELETE) == 0L) {
                        ExceptionUtils.handleException("No access to this system flag", "agorum.roi.remote.exception.SystemFlagsNotDeleteLock", 2009);
                    }
                    if ((newFlags & GlobalObjectClientBean.SYSTEMFLAG_NOTDELETELOCK) == 0L) {
                        ExceptionUtils.handleException("No access to this system flag", "agorum.roi.remote.exception.SystemFlagsNotDeleteLock", 2009);
                    }
                }
                if ((systemflags & GlobalObjectClientBean.SYSTEMFLAG_CONTENTREADONLY) != 0L && (newFlags & GlobalObjectClientBean.SYSTEMFLAG_CONTENTREADONLY) == 0L) {
                    ExceptionUtils.handleException("No access to this system flag", "agorum.roi.remote.exception.SystemFlagsNotDeleteLock", 2009);
                }
                if ((systemflags & GlobalObjectClientBean.SYSTEMFLAG_NOTCHANGE) != 0L && (newFlags & GlobalObjectClientBean.SYSTEMFLAG_NOTCHANGE) == 0L) {
                    ExceptionUtils.handleException("No access to this system flag", "agorum.roi.remote.exception.SystemFlagsNotDeleteLock", 2009);
                }
            }
            if (isHistoryObject) {
                if ((newFlags & GlobalObjectClientBean.SYSTEMFLAG_HISTORYOBJECT) == 0L) {
                    ExceptionUtils.handleException("History objects cannot be changed", "agorum.roi.remote.exception.SystemFlagsHistoryObject", 2010);
                }
                if ((newFlags & GlobalObjectClientBean.SYSTEMFLAG_PROTOHISTORYOBJECT) > 0L) {
                    ExceptionUtils.handleException("This flag cannot be set on history objects", "agorum.roi.remote.exception.SystemFlagsProtoHistoryObject", 2011);
                }
                if ((systemflags & GlobalObjectClientBean.SYSTEMFLAG_SPECIALBEHAVIOUR) > 0L && (newFlags & GlobalObjectClientBean.SYSTEMFLAG_SPECIALBEHAVIOUR) <= 0L && !sessionController.isAdminEnabled()) {
                    ExceptionUtils.handleException("No Access", "agorum.roi.remote.exception.NoAccess", 21);
                }
            }
        }
    }

    @Override
    public void executeBeforeUpdate(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        RelationObjectClientBean[] relations;
        AttributeValue avName;
        AttributeValue acl;
        AttributeValue lockstateAv;
        BehaviorManager.beforeUpdate((GlobalObjectClientBean)clientBean, (GlobalObjectClientBeanDefinition)def);
        boolean stealthUpdate = false;
        if (def != null && def.getSystemOption("stealthUpdate") != null) {
            stealthUpdate = true;
        }
        if ((lockstateAv = def.getAttribute(GlobalObjectClientBean.LOCKSTATE_ATTRIBUTE)) != null) {
            int newLockstate = lockstateAv.getInteger();
            int oldLockstate = ((GlobalObjectClientBean)clientBean).getLockState();
            if (oldLockstate == 1 && (newLockstate == 4 || newLockstate == 8)) {
                def.setAttribute(GlobalObjectClientBean.LOCKSTATE_ATTRIBUTE, null);
            }
        }
        boolean nameChanged = false;
        if (def.getAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE) != null) {
            String oldName = ((GlobalObjectClientBean)clientBean).getName();
            String newName = def.getAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE).getString();
            if (newName != null && !newName.equals(oldName)) {
                nameChanged = true;
                def.setSystemOption("NameChanged", true);
            }
        }
        boolean descrChanged = false;
        if (def.getAttribute(GlobalObjectClientBean.DESCRIPTION_ATTRIBUTE) != null) {
            String oldDescr = ((GlobalObjectClientBean)clientBean).getDescription();
            String newDescr = def.getAttribute(GlobalObjectClientBean.DESCRIPTION_ATTRIBUTE).getString();
            if (oldDescr == null) {
                oldDescr = "";
            }
            if (newDescr != null && !newDescr.equals(oldDescr)) {
                descrChanged = true;
            }
        }
        if ((acl = def.getAttribute(GlobalObjectClientBean.ACL_ATTRIBUTE)) != null && acl.getLong() <= 0L) {
            ExceptionUtils.handleException("Invalid ACL ID: " + acl.getLong(), "agorum.roi.remote.exception.ValueIsNull", 76);
        }
        if (!stealthUpdate && def.getSystemOption("makeNoHistory") == null && (nameChanged || descrChanged || def.getSystemOption("forceMakeHistory") != null || def.getSystemOption("suggestMakeHistory") != null || def.getSystemOption("extendedAttributesXML") != null || def.getSystemOption("extendedAttributesXMLInherited") != null || def.getSystemOption("updatedExtendedAttributesInherited") != null || def.getSystemOption("removedExtendedAttributesInherited") != null || def.getSystemOption("updatedExtendedAttributes") != null || def.getSystemOption("removedExtendedAttributes") != null)) {
            ChangeHistoryUtils chu = new ChangeHistoryUtils(sessionController);
            chu.makeHistoryWithUpdate((GlobalObjectClientBean)clientBean, null, (GlobalObjectClientBeanDefinition)def);
        }
        def.setSystemOption("makeNoHistory", null);
        def.setSystemOption("forceMakeHistory", null);
        def.setSystemOption("suggestMakeHistory", null);
        Date updateDate = new Date();
        GlobalObjectClientBean go = (GlobalObjectClientBean)clientBean;
        this.checkLock(sessionController, clientBean, def);
        this.checkSystemFlags(sessionController, go, def, nameChanged || descrChanged);
        for (Object attributes : def.getAttributes().values()) {
            for (Object key : ((Hashtable)attributes).keySet()) {
                if (SuperObjectClientBean.CLASSID_ATTRIBUTE.equals(key)) continue;
                if (GlobalObjectClientBean.EXPIRATIONDATE_ATTRIBUTE.equals(key)) {
                    long oldExpTS = clientBean.getAttribute(GlobalObjectClientBean.EXPIRATIONDATE_ATTRIBUTE).getDate().getTime();
                    long newExpTS = def.getAttribute(GlobalObjectClientBean.EXPIRATIONDATE_ATTRIBUTE).getDate().getTime();
                    if (newExpTS >= oldExpTS && oldExpTS != 0L || go.checkEffectiveAccess(16L)) continue;
                    ExceptionUtils.handleException("No Access" + go.getPossibleNoAccessCause(), "agorum.roi.remote.exception.NoAccess", 21);
                    continue;
                }
                if (GlobalObjectClientBean.LOCKSTATE_ATTRIBUTE.equals(key) || GlobalObjectClientBean.LOCKEDFOR_ATTRIBUTE.equals(key)) {
                    if (go.checkEffectiveAccess(32L)) continue;
                    ExceptionUtils.handleException("No Access" + go.getPossibleNoAccessCause(), "agorum.roi.remote.exception.NoAccess", 21);
                    continue;
                }
                if (FileObjectClientBean.CONTENTSIZE_ATTRIBUTE.equals(key)) {
                    if (go.checkEffectiveAccess(8L)) continue;
                    ExceptionUtils.handleException("No Access" + go.getPossibleNoAccessCause(), "agorum.roi.remote.exception.NoAccess", 21);
                    continue;
                }
                if (go.checkEffectiveAccess(2L)) continue;
                ExceptionUtils.handleException("No Access" + go.getPossibleNoAccessCause(), "agorum.roi.remote.exception.NoAccess", 21);
            }
        }
        GlobalObjectClientBeanDefinition gDef = (GlobalObjectClientBeanDefinition)def;
        Date lastUpdateDate = go.getLastModifyDate();
        AttributeValue avLastUU = go.getAttribute(GlobalObjectClientBean.LASTMODIFIER_ATTRIBUTE);
        long lastUpdateUserId = avLastUU.getLong();
        if (!(stealthUpdate || avLastUU.getDateToDB(lastUpdateDate) == avLastUU.getDateToDB(updateDate) && lastUpdateUserId == sessionController.getLoginUser().getId())) {
            int flags;
            boolean setUpdateDate = true;
            Long classIdTmp = GlobalObjectEntity.CLASS_ID;
            if (gDef.getAttributes().size() == 1 && gDef.getAttributes().containsKey(classIdTmp)) {
                if (gDef.getAttribute(GlobalObjectClientBean.DESCRIPTION_ATTRIBUTE) == null) {
                    setUpdateDate = false;
                }
                stealthUpdate = true;
                for (Object attributes : gDef.getAttributes().values()) {
                    for (Object key : ((Hashtable)attributes).keySet()) {
                        int lockState;
                        if (SuperObjectClientBean.CLASSID_ATTRIBUTE.equals(key)) continue;
                        if (!(GlobalObjectClientBean.FLAGS_ATTRIBUTE.equals(key) || GlobalObjectClientBean.LOCKSTATE_ATTRIBUTE.equals(key) || GlobalObjectClientBean.LOCKEDFOR_ATTRIBUTE.equals(key))) {
                            stealthUpdate = false;
                        }
                        if (!stealthUpdate || !GlobalObjectClientBean.LOCKSTATE_ATTRIBUTE.equals(key) || (lockState = gDef.getAttribute(FileObjectClientBean.LOCKSTATE_ATTRIBUTE).getInteger()) == 4 || lockState == 8 || lockState == 0) continue;
                        stealthUpdate = false;
                    }
                }
            } else if (gDef.getAttribute(FileObjectClientBean.CONTENTSIZE_ATTRIBUTE) != null && (((flags = go.getFlags()) & 0x400) != 0 || (flags & 0x800) != 0)) {
                if ((flags & 0x800) != 0) {
                    setUpdateDate = false;
                }
                flags &= 0xFFFFFBFF;
                gDef.setAttribute(GlobalObjectClientBean.FLAGS_ATTRIBUTE, AttributeValue.newAttributeValueObject(flags &= 0xFFFFF7FF));
            }
            if (!stealthUpdate) {
                if (setUpdateDate && !sessionController.isService() && def.getSystemOption("SetNoLASTMODIFYDATE") == null && gDef.getAttribute(GlobalObjectClientBean.LASTMODIFYDATE_ATTRIBUTE) == null) {
                    gDef.setLastModifyDate(updateDate);
                } else {
                    gDef.setSystemOption("FireUpdateEvent", "true");
                }
            }
            if (!stealthUpdate && !sessionController.isService() && gDef.getAttribute(GlobalObjectClientBean.LASTMODIFIER_ATTRIBUTE) == null && gDef.getSystemOption("doNotChangeLastModifier") == null && def.getSystemOption("silentUpdate") == null) {
                gDef.setLastModifier(sessionController.getLoginUser());
            }
        }
        if ((avName = def.getAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE)) != null && avName.getString() != null && !go.getName().equals(avName.getString())) {
            String name = avName.getString();
            RoiFileSystem rfs = new RoiFileSystem(sessionController);
            if (((GlobalObjectClientBean)clientBean).checkForNotAllowedChars()) {
                rfs.checkNameChars(name);
            } else {
                rfs.checkNameCharsCustom(name, "/\\");
            }
            RelationObjectClientBean[] fpro = ((GlobalObjectClientBean)clientBean).getLeftwardRelations(FolderPathRelationObjectClientBean.CLASS_NAME);
            if (fpro != null) {
                int len = fpro.length;
                for (int i = 0; i < len; ++i) {
                    fpro[i].setAttribute(FolderPathRelationObjectClientBean.RIGHTOBJECTNAME_ATTRIBUTE, AttributeValue.newAttributeValueObject(name.toLowerCase()));
                }
            }
        }
        this.setExtendedAttributesXML(sessionController, clientBean, def, true);
        GlobalObjectCallBack.scopeAcls(sessionController, clientBean, def);
        this.checkTimePhasedAction(sessionController, go, def);
        try {
            ClassObjectClientBean co = sessionController.getClassObject(GlobalObjectClientBean.CLASS_NAME);
            Hashtable goAttributes = co.getEffectiveAttributes();
            Enumeration enumH = goAttributes.elements();
            while (enumH.hasMoreElements()) {
                AttributeObjectClientBean ao = (AttributeObjectClientBean)enumH.nextElement();
                String attName = ao.getName();
                AttributeValue avDef = def.getAttribute(attName);
                if (avDef == null || !avDef.equals(sessionController, go.getAttribute(attName)) || attName.equals(GlobalObjectClientBean.ACL_ATTRIBUTE) && AclInheritor.mayInherit()) continue;
                def.setAttribute(attName, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        if (def.hasAttributes() && !stealthUpdate && def.getSystemOption("silentUpdate") == null) {
            def.setAttribute(GlobalObjectClientBean.UPDATEDATE_ATTRIBUTE, AttributeValue.newAttributeValueObject(new Date()));
        }
        if (def.getSystemOption(GlobalObjectClientBean.UPDATEDATE_ATTRIBUTE) != null) {
            def.setAttribute(GlobalObjectClientBean.UPDATEDATE_ATTRIBUTE, (AttributeValue)def.getSystemOption(GlobalObjectClientBean.UPDATEDATE_ATTRIBUTE));
        }
        AccessControlListObjectClientBean gAcl = gDef.getAcl();
        if (!PermissionUtil.isAclInheritanceDeactivated()) {
            this.leaveACLToSubObjects(sessionController, gDef, go);
        }
        if (gAcl != null && gAcl.getId() == 12000L) {
            System.out.println("----> Set ACL to \"Private\" and change owner (goId = " + go.getId() + ")");
            DirectoryUserObjectClientBean newOwner = (DirectoryUserObjectClientBean)gDef.getSystemOption("NewOwnerForPrivateACL");
            if (newOwner != null) {
                System.out.println("New Owner: " + newOwner.getName());
                gDef.setAttribute(GlobalObjectClientBean.OWNER_ATTRIBUTE, AttributeValue.newAttributeValueObject(newOwner));
            } else {
                System.out.println("New Owner is Null!!!");
            }
        }
        AttributeValue avNewOwner = def.getAttribute(GlobalObjectClientBean.OWNER_ATTRIBUTE);
        DirectoryUserObjectClientBean owner = ((GlobalObjectClientBean)clientBean).getOwner();
        if (avNewOwner != null) {
            RelationObjectClientBean[] rightRels;
            DirectoryUserObjectClientBean newOwner = (DirectoryUserObjectClientBean)avNewOwner.getGlobalObjectClientBean(sessionController);
            if (owner != null && !newOwner.getId().equals(owner.getId()) && (rightRels = ((GlobalObjectClientBean)clientBean).getRightwardRelations()) != null) {
                RelationObjectClientBean[] relationObjectClientBeanArray = rightRels;
                int n = relationObjectClientBeanArray.length;
                for (int i = 0; i < n; ++i) {
                    RelationObjectClientBean rel = relationObjectClientBeanArray[i];
                    rel.leaveOwner(newOwner, def);
                }
            }
        }
        this.checkInHistoryFlag(def, clientBean);
        if (clientBean instanceof ContentInterface && def.getAttribute(GlobalObjectClientBean.FLAGS_ATTRIBUTE) == null) {
            int flags = go.getFlags() | GlobalObjectClientBean.FLAG_ARCHIVE;
            def.setAttribute(GlobalObjectClientBean.FLAGS_ATTRIBUTE, AttributeValue.newAttributeValueObject(flags));
        }
        if (!stealthUpdate && clientBean.supportsFolderItemsChangeDelete() && (relations = ((GlobalObjectClientBean)clientBean).getLeftwardRelations(FolderRelationObjectClientBean.CLASS_NAME)) != null && (def == null || def.getSystemOption("disableFolderItemsChangedDeleted") == null)) {
            for (RelationObjectClientBean relation : relations) {
                FolderItemsChangedDeleted.invalidateOnCommit(relation.getLeftObjectId(), clientBean.getId(), false);
            }
        }
        super.executeBeforeUpdate(sessionController, def, clientBean);
    }

    private void leaveACLToSubObjects(SessionController sessionController, GlobalObjectClientBeanDefinition gDef, GlobalObjectClientBean gocb) throws Exception {
        AccessControlListObjectClientBean gAcl = gDef.getAcl();
        if (gAcl != null) {
            AclInheritor.queue(gocb);
            RelationObjectClientBean[] rel = gocb.getRightwardRelations();
            if (rel != null) {
                int len = rel.length;
                for (int i = 0; i < len; ++i) {
                    rel[i].leaveAclToSubObjects(gAcl, gDef);
                }
            }
        }
    }

    private static void leaveScopeAclsToSubObjects(GlobalObjectClientBean gocb, SessionController sessionController, GlobalObjectClientBeanDefinition gDef) throws Exception {
        AclInheritor.queue(gocb);
        RelationObjectClientBean[] rel = gocb.getRightwardRelations();
        if (rel != null) {
            int len = rel.length;
            for (int i = 0; i < len; ++i) {
                rel[i].leaveScopeAclsToSubObjects(gDef);
            }
        }
    }

    private void checkInHistoryFlag(SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        AttributeValue acLockState;
        GlobalObjectClientBean gocb = (GlobalObjectClientBean)clientBean;
        if ((gocb.getSystemFlags() & GlobalObjectClientBean.SYSTEMFLAG_INHISTORYOBJECT) > 0L && gocb.getLockState() != 0 && (acLockState = def.getAttribute(GlobalObjectClientBean.LOCKSTATE_ATTRIBUTE)) != null && acLockState.getInteger() == 0) {
            AttributeValue avSysFlags = def.getAttribute(GlobalObjectClientBean.SYSTEMFLAGS_ATTRIBUTE);
            long sysFlags = -1L;
            sysFlags = avSysFlags != null ? avSysFlags.getLong() : gocb.getSystemFlags();
            def.setAttribute(GlobalObjectClientBean.SYSTEMFLAGS_ATTRIBUTE, AttributeValue.newAttributeValueObject(sysFlags &= GlobalObjectClientBean.SYSTEMFLAG_INHISTORYOBJECT ^ 0xFFFFFFFFFFFFFFFFL));
        }
    }

    @Override
    public void executeAfterUpdate(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        DatabaseAccessStatistic.getInstance().count("Object updates", "Objects", 1L);
        BehaviorManager.afterUpdate((GlobalObjectClientBean)clientBean, (GlobalObjectClientBeanDefinition)def);
        try {
            if ((def.getAttribute(GlobalObjectClientBean.LASTMODIFYDATE_ATTRIBUTE) != null || def.getSystemOption("FireUpdateEvent") != null || def.getSystemOption("ForceEA") != null) && def.getSystemOption(GlobalObjectClientBean.SYSTEMOPTION_NOEVENT) == null) {
                this.sendUpdateEvent(clientBean, def);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((GlobalObjectClientBean)clientBean).addToPathDateQueue();
        if (def.getSystemOption("doNotCheckLeaveAclOption") == null && def.getAttribute(GlobalObjectClientBean.ACL_ATTRIBUTE) != null && (def.getSystemOption("leaveAclToObjectsWithThisAcl") != null || def.getSystemOption("leaveAclToAllObjects") != null)) {
            SuperObjectClientBeanDefinition defLeaveAcl = clientBean.getNewDefinition(sessionController);
            defLeaveAcl.setSystemOption("deleteAllScopeAcls", def.getSystemOption("deleteAllScopeAcls"));
            defLeaveAcl.setSystemOption("deleteScopeAcls", def.getSystemOption("deleteScopeAcls"));
            defLeaveAcl.setSystemOption("setScopeAcls", def.getSystemOption("setScopeAcls"));
            if (def.getSystemOption("leaveAclToObjectsWithThisAcl") != null) {
                defLeaveAcl.setSystemOption("leaveAclToObjectsWithThisAcl", def.getAttributeBeforUpdate(GlobalObjectClientBean.ACL_ATTRIBUTE).getGlobalObjectClientBean(sessionController));
            }
            if (def.getSystemOption("leaveAclToAllObjects") != null) {
                defLeaveAcl.setSystemOption("leaveAclToAllObjects", def.getSystemOption("leaveAclToAllObjects"));
            }
            defLeaveAcl.setSystemOption("doNotCheckLeaveAclOption", "");
            defLeaveAcl.setSystemOption("NotLeaveAclToThisObject", clientBean);
            defLeaveAcl.setSystemOption("leaveAclFromUpdateMyOldAcl", def.getAttributeBeforUpdate(GlobalObjectClientBean.ACL_ATTRIBUTE).getGlobalObjectClientBean(sessionController));
            ((GlobalObjectClientBean)clientBean).leaveAcl((AccessControlListObjectClientBean)def.getAttribute(GlobalObjectClientBean.ACL_ATTRIBUTE).getGlobalObjectClientBean(sessionController), defLeaveAcl);
        }
        super.executeAfterUpdate(sessionController, def, clientBean);
        ObjectUpdateCollector.changed(clientBean.getUUID(), def);
    }

    protected void sendUpdateEvent(SuperObjectClientBean clientBean, SuperObjectClientBeanDefinition def) throws Exception {
        MessageUtils mu = new MessageUtils();
        mu.sendUpdateEvent(clientBean, def);
    }

    @Override
    public void executeAfterCreate(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        DatabaseAccessStatistic.getInstance().count("Object creations", "Objects", 1L);
        def.setAttribute(InternalObjectClientBean.UUID_ATTRIBUTE, null);
        GlobalObjectClientBean gocb = (GlobalObjectClientBean)clientBean;
        this.setExtendedAttributesXML(sessionController, clientBean, def, false);
        GlobalObjectCallBack.scopeAcls(sessionController, clientBean, def);
        GlobalObjectClientBeanDefinition defMO = (GlobalObjectClientBeanDefinition)gocb.getNewDefinition(sessionController);
        defMO.setAllSystemOption(def.getAllSystemOption());
        defMO.setAttribute(GlobalObjectClientBean.MAINOBJECT_ATTRIBUTE, AttributeValue.newAttributeValueObject(gocb));
        try {
            if (gocb.getMainObjectId() == 0L) {
                gocb.update(defMO);
            }
        }
        catch (Exception e) {
            gocb.update(defMO);
        }
        Object foldObj = def.getSystemOption("addToFolder");
        if (foldObj != null) {
            FolderObjectClientBean folder = (FolderObjectClientBean)foldObj;
            GlobalObjectClientBeanDefinition foldDef = (GlobalObjectClientBeanDefinition)clientBean.getNewDefinition(sessionController);
            foldDef.setSystemOption("addToFolderFromCreate", "true");
            folder.addItem((GlobalObjectClientBean)clientBean, foldDef);
        }
        this.checkTimePhasedAction(sessionController, gocb, def);
        BehaviorManager.afterCreate((GlobalObjectClientBean)clientBean, (GlobalObjectClientBeanDefinition)def);
        if (clientBean.supportsFolderItemsChangeDelete()) {
            FolderItemsChangedDeleted.invalidateOnCommit(null, clientBean.getId(), true);
        }
        super.executeAfterCreate(sessionController, def, clientBean);
    }

    @Override
    public void executeBeforeAddItem(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBeanDefinition relDef, SuperObjectClientBean lo, SuperObjectClientBean ro) throws Exception {
        if (((GlobalObjectClientBean)lo).checkEffectiveAccess(16384L)) {
            super.executeBeforeAddItem(sessionController, def, relDef, lo, ro);
        } else {
            ExceptionUtils.handleException("No Access", "agorum.roi.remote.exception.NoAccess", 21);
        }
    }

    @Override
    public void executeBeforeRemoveItem(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean lo, SuperObjectClientBean ro) throws Exception {
        FolderObjectClientBean parentFolder;
        if (lo instanceof FolderObjectClientBean && !(parentFolder = (FolderObjectClientBean)lo).canRemoveItem(sessionController, ro)) {
            ExceptionUtils.handleException("No Access", "agorum.roi.remote.exception.NoAccess", 21);
        }
        super.executeBeforeRemoveItem(sessionController, def, lo, ro);
    }

    @Override
    public void executeBeforeLeaveAcl(SessionController sessionController, SuperObjectClientBean clientBean, SuperObjectClientBeanDefinition definition, AccessControlListObjectClientBean acl) throws Exception {
        RelationObjectClientBean[] relArr = ((GlobalObjectClientBean)clientBean).getRightwardRelations();
        if (relArr != null) {
            int len = relArr.length;
            for (int i = 0; i < len; ++i) {
                if (relArr[i] == null) continue;
                relArr[i].leaveAcl(acl, definition);
            }
        }
        super.executeBeforeLeaveAcl(sessionController, clientBean, definition, acl);
    }

    private void checkLock(SessionController sessionController, SuperObjectClientBean clientBean, SuperObjectClientBeanDefinition definition) throws Exception {
        LockUtils lockUtils = new LockUtils();
        LockUtils.checkLock(sessionController, clientBean, definition);
    }

    private void setExtendedAttributesXML(SessionController sessionController, SuperObjectClientBean clientBean, SuperObjectClientBeanDefinition definition, boolean inUpdate) throws Exception {
        String key;
        Enumeration keyEnum;
        GlobalObjectClientBean gocb = (GlobalObjectClientBean)clientBean;
        String attributeXML = (String)definition.getSystemOption("extendedAttributesXML");
        String attributeXMLInherited = (String)definition.getSystemOption("extendedAttributesXMLInherited");
        if (attributeXML != null) {
            gocb.setExtendedAttributesXml(attributeXML, definition, false, null, inUpdate);
        }
        if (attributeXMLInherited != null) {
            gocb.setExtendedAttributesXml(attributeXMLInherited, definition, true, null, inUpdate);
        }
        boolean updated = false;
        boolean updatedInheritable = false;
        Hashtable updatedAttributes = (Hashtable)definition.getSystemOption("updatedExtendedAttributes");
        Hashtable updatedAttributesInherited = (Hashtable)definition.getSystemOption("updatedExtendedAttributesInherited");
        if (updatedAttributes != null) {
            gocb.setExtendedAttributes(updatedAttributes, true);
            updated = true;
        }
        if (updatedAttributesInherited != null) {
            gocb.setExtendedAttributesInheritable(updatedAttributesInherited, true);
            updatedInheritable = true;
        }
        Hashtable removedAttributes = (Hashtable)definition.getSystemOption("removedExtendedAttributes");
        Hashtable removedAttributesInherited = (Hashtable)definition.getSystemOption("removedExtendedAttributesInherited");
        if (removedAttributes != null) {
            keyEnum = removedAttributes.keys();
            while (keyEnum.hasMoreElements()) {
                key = (String)keyEnum.nextElement();
                gocb.setExtendedAttribute(key, null, true);
            }
            updated = true;
        }
        if (removedAttributesInherited != null) {
            keyEnum = removedAttributesInherited.keys();
            while (keyEnum.hasMoreElements()) {
                key = (String)keyEnum.nextElement();
                gocb.setExtendedAttributeInheritable(key, null, true);
            }
            updatedInheritable = true;
        }
        if (updated) {
            gocb.saveExtendedAttributes((GlobalObjectClientBeanDefinition)definition);
        }
        if (updatedInheritable) {
            gocb.saveExtendedAttributesInheritable((GlobalObjectClientBeanDefinition)definition);
        }
    }

    public static void scopeAcls(SessionController sessionController, SuperObjectClientBean clientBean, SuperObjectClientBeanDefinition definition) throws Exception {
        SuperObjectClientBeanDefinition aclDef;
        GlobalObjectClientBean gocb = (GlobalObjectClientBean)clientBean;
        boolean setAcls = !gocb.getId().equals(definition.getSystemOption("skipAcls"));
        HashMap<Long, Map<String, Object>> attributes = new HashMap<Long, Map<String, Object>>();
        HashMap<String, AttributeValue> attrSub = new HashMap<String, AttributeValue>();
        attributes.put(1L, attrSub);
        if (definition.getSystemOption("deleteAllScopeAcls") != null && setAcls) {
            gocb.deleteAllScopeAclsInternal();
            attrSub.put("deleteAllScopeAcls", AttributeValue.newAttributeValueObject(new Long[0]));
        }
        boolean performLeave = false;
        GlobalObjectClientBean[] scopeAcls = GlobalObjectCallBack.getScopeAclArray(sessionController, definition, "deleteScopeAcls");
        if (scopeAcls != null) {
            if (setAcls) {
                aclDef = clientBean.getNewDefinition(sessionController);
                if (definition.getSystemOption("doNotEA") != null) {
                    aclDef.setSystemOption("doNotEA", "");
                }
                gocb.deleteScopeAclInternal((AccessControlListObjectClientBean[])scopeAcls, aclDef);
                attrSub.put("deleteScopeAcls", AttributeValue.newAttributeValueObject(scopeAcls));
            }
            if (!PermissionUtil.isAclInheritanceDeactivated()) {
                performLeave = true;
            }
        }
        if ((scopeAcls = GlobalObjectCallBack.getScopeAclArray(sessionController, definition, "setScopeAcls")) != null) {
            if (setAcls) {
                aclDef = clientBean.getNewDefinition(sessionController);
                if (definition.getSystemOption("doNotEA") != null) {
                    aclDef.setSystemOption("doNotEA", "");
                }
                gocb.setScopeAclInternal((AccessControlListObjectClientBean[])scopeAcls, aclDef);
                attrSub.put("setScopeAcls", AttributeValue.newAttributeValueObject(scopeAcls));
            }
            if (!PermissionUtil.isAclInheritanceDeactivated()) {
                performLeave = true;
            }
        }
        if (performLeave) {
            GlobalObjectCallBack.leaveScopeAclsToSubObjects(gocb, sessionController, (GlobalObjectClientBeanDefinition)definition);
        }
        if (attrSub.size() > 0) {
            AuditUtil.createAuditEntry(clientBean, sessionController.getLoginUser(), AuditUtil.ACTION_UPDATE, attributes);
        }
    }

    private static AccessControlListObjectClientBean[] getScopeAclArray(SessionController sessionController, SuperObjectClientBeanDefinition definition, String keyword) throws Exception {
        AccessControlListObjectClientBean[] scopeAcls = null;
        Object o = definition.getSystemOption(keyword);
        if (o != null) {
            AccessControlListObjectClientBean acl;
            int i;
            int len;
            Object[] l;
            Vector<AccessControlListObjectClientBean> v = new Vector<AccessControlListObjectClientBean>();
            if (o instanceof AccessControlListObjectClientBean[]) {
                scopeAcls = (AccessControlListObjectClientBean[])o;
            } else if (o instanceof Long[]) {
                l = (Long[])o;
                len = l.length;
                for (i = 0; i < len; ++i) {
                    if (l[i] == null) continue;
                    acl = (AccessControlListObjectClientBean)sessionController.getGlobalObjectById(l[i]);
                    v.addElement(acl);
                }
            } else if (o instanceof long[]) {
                l = (long[])o;
                len = l.length;
                for (i = 0; i < len; ++i) {
                    acl = (AccessControlListObjectClientBean)sessionController.getGlobalObjectById(new Long(l[i]));
                    v.addElement(acl);
                }
            } else if (o instanceof String[]) {
                String[] s = (String[])o;
                len = s.length;
                for (i = 0; i < len; ++i) {
                    if (s[i] == null) continue;
                    acl = sessionController.getAclByName(s[i]);
                    v.addElement(acl);
                }
            }
            int len2 = v.size();
            if (len2 > 0) {
                scopeAcls = new AccessControlListObjectClientBean[len2];
                for (int i2 = 0; i2 < len2; ++i2) {
                    scopeAcls[i2] = (AccessControlListObjectClientBean)v.elementAt(i2);
                }
            }
        }
        return scopeAcls;
    }

    @Override
    public void executeBeforeDeleteToRecycling(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        BehaviorManager.beforeDelete((GlobalObjectClientBean)clientBean, (GlobalObjectClientBeanDefinition)def, true);
        RelationObjectClientBean[] relArr = ((GlobalObjectClientBean)clientBean).getRightwardRelations();
        if (relArr != null) {
            int len = relArr.length;
            for (int i = 0; i < len; ++i) {
                if (relArr[i] == null) continue;
                relArr[i].deleteToRecycle((GlobalObjectClientBeanDefinition)def);
            }
        }
        super.executeBeforeDeleteToRecycling(sessionController, def, clientBean);
    }

    @Override
    public void executeBeforeUndelete(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        RelationObjectClientBean[] relArr = ((GlobalObjectClientBean)clientBean).getRightwardRelations();
        if (relArr != null) {
            int len = relArr.length;
            for (int i = 0; i < len; ++i) {
                if (relArr[i] == null) continue;
                relArr[i].undelete((GlobalObjectClientBeanDefinition)def);
            }
        }
        super.executeBeforeUndelete(sessionController, def, clientBean);
    }

    public static Set<Long> deleting() {
        HashSet ids = (HashSet)Transaction.get("Deleting");
        if (ids == null) {
            ids = new HashSet();
            Transaction.put("Deleting", ids);
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeBeforeDelete(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        Set<Long> deleting = GlobalObjectCallBack.deleting();
        Long id = clientBean.getId();
        deleting.add(id);
        try {
            int count;
            DatabaseAccessStatistic.getInstance().count("Object deletions", "Objects", 1L);
            BehaviorManager.beforeDelete((GlobalObjectClientBean)clientBean, (GlobalObjectClientBeanDefinition)def, false);
            GlobalObjectClientBean gocb = (GlobalObjectClientBean)clientBean;
            if (!sessionController.isInSychronization() && def.getSystemOption("MayDeleteHistory") == null && gocb.isHistoryObject() && (count = gocb.getLeftwardRelationCount(ChangeHistoryRelationObjectClientBean.CLASS_NAME)) > 0) {
                ExceptionUtils.handleException("Cannot delete history objects", "agorum.roi.remote.exception.SystemFlagsNotDeleteLock", 2009);
            }
            RemoteRelationUtils rru = new RemoteRelationUtils(sessionController);
            rru.deleteRemoteRelationObject((GlobalObjectClientBean)clientBean, null, null);
            new MessageUtils().sendDeleteEvent(clientBean);
            RelationObjectClientBean[] rRelArr = gocb.getRightwardRelations();
            if (rRelArr != null) {
                int len = rRelArr.length;
                for (int i = 0; i < len; ++i) {
                    if (!rRelArr[i].isExisting()) continue;
                    rRelArr[i].deleteRightObject(def);
                }
            }
            RelationObjectClientBean[] lRelArr = gocb.getLeftwardRelations();
            gocb.removeRelationship(lRelArr);
            if (clientBean instanceof ContentInterface) {
                ContentHashUtils.removeAllHashes(sessionController, (ContentInterface)((Object)clientBean));
            }
            super.executeBeforeDelete(sessionController, def, clientBean);
        }
        finally {
            deleting.remove(id);
        }
    }

    @Override
    public void executeBeforeCopy(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        long sysFlags;
        def.setAttribute(GlobalObjectClientBean.EXPIRATIONDATE_ATTRIBUTE, null);
        try {
            if (def.getSystemOption("ChangeHistoryCopy") == null) {
                long systemflags = def.getAttribute(GlobalObjectClientBean.SYSTEMFLAGS_ATTRIBUTE).getLong();
                if ((systemflags & GlobalObjectClientBean.SYSTEMFLAG_HISTORYOBJECT) > 0L) {
                    systemflags -= GlobalObjectClientBean.SYSTEMFLAG_HISTORYOBJECT;
                }
                if ((systemflags & GlobalObjectClientBean.SYSTEMFLAG_HISTORYOBJECTRESTORE) > 0L) {
                    systemflags -= GlobalObjectClientBean.SYSTEMFLAG_HISTORYOBJECTRESTORE;
                }
                def.setAttribute(GlobalObjectClientBean.SYSTEMFLAGS_ATTRIBUTE, AttributeValue.newAttributeValueObject(systemflags));
            }
        }
        catch (Exception systemflags) {
            // empty catch block
        }
        AttributeValue avSysFlags = def.getAttribute(GlobalObjectClientBean.SYSTEMFLAGS_ATTRIBUTE);
        if (avSysFlags != null && ((sysFlags = avSysFlags.getLong()) & GlobalObjectClientBean.SYSTEMFLAG_INHISTORYOBJECT) > 0L) {
            def.setAttribute(GlobalObjectClientBean.SYSTEMFLAGS_ATTRIBUTE, AttributeValue.newAttributeValueObject(sysFlags &= GlobalObjectClientBean.SYSTEMFLAG_INHISTORYOBJECT ^ 0xFFFFFFFFFFFFFFFFL));
        }
        super.executeBeforeCopy(sessionController, def, clientBean);
    }

    protected void leaveAclToThisObject(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        AttributeValue avAcl;
        if (def.getSystemOption("setACLFromLeaveACL") == null && !PermissionUtil.isAclInheritanceDeactivated() && (avAcl = def.getAttribute(GlobalObjectClientBean.ACL_ATTRIBUTE)) != null) {
            long mainObjectId;
            GlobalObjectClientBean gocb = (GlobalObjectClientBean)clientBean;
            long id = ((GlobalObjectClientBean)clientBean).getId();
            if (id == (mainObjectId = ((GlobalObjectClientBean)clientBean).getAttribute(GlobalObjectClientBean.MAINOBJECT_ATTRIBUTE).getLong())) {
                AccessControlListObjectClientBean oldAcl = gocb.getAcl();
                AccessControlListObjectClientBean newAcl = (AccessControlListObjectClientBean)avAcl.getGlobalObjectClientBean(sessionController);
                System.err.println("New Acl : " + newAcl.getName());
                System.err.println("Old Acl : " + oldAcl.getName());
                SuperObjectClientBeanDefinition aclDef = gocb.getNewDefinition(sessionController);
                aclDef.setSystemOption("leaveAclToObjectsWithThisAcl", oldAcl);
                aclDef.setSystemOption("FirstObjectOK", "");
                aclDef.setSystemOption("deleteAllScopeAcls", def.getSystemOption("deleteAllScopeAcls"));
                aclDef.setSystemOption("deleteScopeAcls", def.getSystemOption("deleteScopeAcls"));
                aclDef.setSystemOption("setScopeAcls", def.getSystemOption("setScopeAcls"));
                this.executeBeforeLeaveAcl(sessionController, clientBean, aclDef, newAcl);
            }
        }
    }

    private void checkTimePhasedAction(SessionController sessionController, GlobalObjectClientBean gocb, SuperObjectClientBeanDefinition def) throws Exception {
        TimePhasedActionUtils timePhasedActionUtils;
        String action;
        AttributeValue av = def.getAttribute(GlobalObjectClientBean.TIMEPHASEDACTION_ATTRIBUTE);
        if (av != null && (action = av.getString()) != null && action.length() > 0 && !(timePhasedActionUtils = new TimePhasedActionUtils()).hasAccess(sessionController, gocb, action)) {
            ExceptionUtils.handleException("No access to set this TimePhasedAction: '" + action + "'", "agorum.roi.remote.exception.NoAccessToSetThisTimePhasedAction", 41);
        }
    }
}

