/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.callback;

import agorum.roi.ejb.callback.CustomFolderDocumentObjectCallBack;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.MailDocumentObjectClientBean;
import agorum.roi.ejb.client.beans.MailObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AccessCounterUtils;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.AttributeValueBoolean;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.Transaction;

public class MailObjectCallBack
extends CustomFolderDocumentObjectCallBack {
    @Override
    public void executeBeforeCreate(SessionController sessionController, SuperObjectClientBeanDefinition def) throws Exception {
        def.setAttribute("RECENT", new AttributeValueBoolean(true));
        super.executeBeforeCreate(sessionController, def);
    }

    @Override
    public void executeBeforeCopy(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        def.setAttribute("INREPLAYTO", null);
        Transaction.put(MailObjectClientBean.COPY_CONTEXT, def);
        super.executeBeforeCopy(sessionController, def, clientBean);
    }

    @Override
    public void executeAfterCopy(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBeanSource, SuperObjectClientBean clientBeanDestination) throws Exception {
        super.executeAfterCopy(sessionController, def, clientBeanSource, clientBeanDestination);
        Transaction.remove(MailObjectClientBean.COPY_CONTEXT);
    }

    @Override
    public void executeBeforeUpdate(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        MailObjectClientBean mail;
        GlobalObjectClientBean[] attachments;
        this.leaveAclToThisObject(sessionController, def, clientBean);
        if ((def.getAttribute(GlobalObjectClientBean.CREATEDATE_ATTRIBUTE) != null || def.getAttribute(GlobalObjectClientBean.LASTMODIFYDATE_ATTRIBUTE) != null) && (attachments = (mail = (MailObjectClientBean)clientBean).getMailAttachments()) != null) {
            for (GlobalObjectClientBean attachment : attachments) {
                AttributeValue avLD;
                if (!(attachment instanceof MailDocumentObjectClientBean)) continue;
                SuperObjectClientBeanDefinition subDef = attachment.getNewDefinition(sessionController);
                AttributeValue avCD = def.getAttribute(GlobalObjectClientBean.CREATEDATE_ATTRIBUTE);
                if (avCD != null) {
                    subDef.setAttribute(GlobalObjectClientBean.CREATEDATE_ATTRIBUTE, avCD);
                }
                if ((avLD = def.getAttribute(GlobalObjectClientBean.LASTMODIFYDATE_ATTRIBUTE)) != null) {
                    subDef.setAttribute(GlobalObjectClientBean.LASTMODIFYDATE_ATTRIBUTE, avLD);
                }
                attachment.update(subDef);
            }
        }
        super.executeBeforeUpdate(sessionController, def, clientBean);
    }

    @Override
    public void executeAfterUpdate(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        super.executeAfterUpdate(sessionController, def, clientBean);
        MailObjectClientBean mail = (MailObjectClientBean)clientBean;
        String status = mail.getMailStatus();
        if ("drafts".equals(status) || "outbox".equals(status) || "sentbox".equals(status)) {
            AccessCounterUtils acu = new AccessCounterUtils(sessionController);
            acu.sendReadEvent(mail, false, mail.getCreator().getId());
        }
    }
}

