/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.callback;

import agorum.commons.statistic.CoreStatistic;
import agorum.roi.behavior.BehaviorManager;
import agorum.roi.common.ObjectUpdateCollector;
import agorum.roi.ejb.callback.CustomInternalObjectCallBack;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.RelationObjectClientBean;
import agorum.roi.ejb.client.beans.RelationObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.messaging.common.MessageBean;
import agorum.roi.ejb.messaging.common.MessageUtils;
import agorum.roi.exception.RoiException;

public class RelationObjectCallBack
extends CustomInternalObjectCallBack {
    private static final CoreStatistic stat = CoreStatistic.getInstance();

    @Override
    public void executeBeforeCreate(SessionController sessionController, SuperObjectClientBeanDefinition def) throws Exception {
        RelationObjectClientBeanDefinition relDef = (RelationObjectClientBeanDefinition)def;
        GlobalObjectClientBean leftObject = relDef.getLeftObject();
        GlobalObjectClientBean rightObject = relDef.getRightObject();
        BehaviorManager.beforeCreateRelation(relDef, leftObject, rightObject);
        if (!sessionController.isInSychronization() && (rightObject.getSystemFlags() & GlobalObjectClientBean.SYSTEMFLAG_COMPRESSED) > 0L) {
            ExceptionUtils.noAccess("Not allowed");
        }
        relDef.setName(leftObject.getClassName() + "," + rightObject.getClassName());
        if (relDef.getAttribute(RelationObjectClientBean.FILTERFLAG_ATTRIBUTE) == null) {
            relDef.setFilterFlag(rightObject.getIsFolder());
        }
        if (relDef.getAttribute(RelationObjectClientBean.FILTERDATE_ATTRIBUTE) == null) {
            relDef.setFilterDate(rightObject.getCreateDate());
        }
        if (relDef.getAttribute(RelationObjectClientBean.SORTSEQUENCE_ATTRIBUTE) == null) {
            relDef.setSortSequence(def.getId());
        }
        super.executeBeforeCreate(sessionController, def);
    }

    @Override
    public void executeAfterCreate(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        RelationObjectClientBean relation = (RelationObjectClientBean)clientBean;
        GlobalObjectClientBean leftObject = relation.getLeftObject();
        GlobalObjectClientBean rightObject = relation.getRightObject();
        BehaviorManager.afterCreateRelation(relation, leftObject, rightObject);
        try {
            Long leftId = leftObject.getId();
            Long rightId = rightObject.getId();
            MessageBean mb = new MessageBean();
            mb.setObjectProperty("eventType", "addRelationListener");
            mb.setObjectProperty("value", leftId);
            mb.setObjectProperty("valueRelationObject", relation.getId());
            mb.setObjectProperty("valueRightObject", rightId);
            mb.setObjectProperty("className", relation.getClassName());
            mb.setObjectProperty("classNameLeftObject", leftObject.getClassName());
            mb.setObjectProperty("classNameRightObject", rightObject.getClassName());
            mb.setObjectProperty("initialSessionId", sessionController.getInitialSessionId());
            MessageUtils mu = new MessageUtils();
            mu.publishToTopic(sessionController, "addRelationListener", mb, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ObjectUpdateCollector.changed(leftObject.getUUID(), "right-added-" + relation.getClassName());
        ObjectUpdateCollector.changed(rightObject.getUUID(), "left-added-" + relation.getClassName());
        super.executeAfterCreate(sessionController, def, clientBean);
    }

    @Override
    public void executeBeforeDelete(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        GlobalObjectClientBean rightObject;
        GlobalObjectClientBean leftObject;
        RelationObjectClientBean relation = (RelationObjectClientBean)clientBean;
        try {
            leftObject = relation.getLeftObject();
            rightObject = relation.getRightObject();
        }
        catch (RoiException e) {
            if (e.getErrorCode() == 101) {
                stat.warning().exception((Throwable)e).send("Deleting dangling " + relation.getClassName() + " " + relation + " (" + relation.getLeftObjectId() + " -> " + relation.getRightObjectId() + ")");
                super.executeBeforeDelete(sessionController, def, clientBean);
                return;
            }
            throw e;
        }
        BehaviorManager.beforeDeleteRelation(relation, leftObject, rightObject);
        try {
            Long leftId = leftObject.getId();
            Long rightId = rightObject.getId();
            MessageBean mb = new MessageBean();
            mb.setObjectProperty("eventType", "removeRelationListener");
            mb.setObjectProperty("value", leftId);
            mb.setObjectProperty("valueRelationObject", relation.getId());
            mb.setObjectProperty("valueRightObject", rightId);
            mb.setObjectProperty("className", relation.getClassName());
            mb.setObjectProperty("classNameLeftObject", leftObject.getClassName());
            mb.setObjectProperty("classNameRightObject", rightObject.getClassName());
            mb.setObjectProperty("initialSessionId", sessionController.getInitialSessionId());
            MessageUtils mu = new MessageUtils();
            mu.publishToTopic(sessionController, "removeRelationListener", mb, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ObjectUpdateCollector.changed(leftObject.getUUID(), "right-removed-" + relation.getClassName());
        ObjectUpdateCollector.changed(rightObject.getUUID(), "left-removed-" + relation.getClassName());
        super.executeBeforeDelete(sessionController, def, clientBean);
    }
}

