/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.client.beans;

import agorum.roi.ejb.client.beans.AccessControlListObjectClientBean;
import agorum.roi.ejb.client.beans.AllocationRelationObjectClientBean;
import agorum.roi.ejb.client.beans.FolderDeleteRelationObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.FolderRelationObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.RelationObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.util.annotations.ObjDoc;
import agorum.roi.util.annotations.ObjDocAttribute;
import java.io.Serializable;

@ObjDoc(groups={ObjDoc.Group.FOLDER, ObjDoc.Group.RELATION}, description="Client Bean for the FolderDeleteRelationObject Class")
public class FolderDeleteRelationObjectClientBean
extends RelationObjectClientBean
implements Serializable {
    public static String CLASS_NAME = "FOLDERDELETERELATIONOBJECT";
    public static final String DELETEID_ATTRIBUTE = "DELETEID";
    public static final String DIRECT_ATTRIBUTE = "DIRECT";

    @Override
    public SuperObjectClientBeanDefinition getNewDefinition(SessionController sessionController) throws Exception {
        return new FolderDeleteRelationObjectClientBeanDefinition(sessionController);
    }

    public void setDeleteId(long value) throws Exception {
        this.setAttribute(DELETEID_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    @ObjDocAttribute(value="the delete id")
    public long getDeleteId() throws Exception {
        return this.getAttribute(DELETEID_ATTRIBUTE).getLong();
    }

    public void setDirect(boolean value) throws Exception {
        this.setAttribute(DIRECT_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    @ObjDocAttribute(value="the associated folder relation was deleted directly")
    public boolean getDirect() throws Exception {
        return this.getAttribute(DIRECT_ATTRIBUTE).getBoolean();
    }

    @Override
    public void deleteToRecycle(GlobalObjectClientBeanDefinition def, int relationOffset) throws Exception {
    }

    @Override
    public void deleteToRecycle(GlobalObjectClientBeanDefinition def) throws Exception {
    }

    @Override
    public void undelete(GlobalObjectClientBeanDefinition def) throws Exception {
    }

    @Override
    public void leaveAcl(AccessControlListObjectClientBean acl, SuperObjectClientBeanDefinition def) throws Exception {
    }

    @Override
    public void deleteRightObject(SuperObjectClientBeanDefinition def) throws Exception {
        GlobalObjectClientBean gocb = null;
        try {
            gocb = this.getRightObject();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (gocb == null) {
            return;
        }
        if (this.deleteRightObject(gocb, def)) {
            gocb.delete(def);
        } else {
            this.deleteMe(def);
        }
    }

    private boolean deleteRightObject(GlobalObjectClientBean obj, SuperObjectClientBeanDefinition def) throws Exception {
        if (def.getSystemOption("deleteAllReferences") != null) {
            return true;
        }
        return obj.getLeftwardRelationCount(FolderRelationObjectClientBean.CLASS_NAME) + obj.getLeftwardRelationCount(CLASS_NAME) + obj.getLeftwardRelationCount(AllocationRelationObjectClientBean.CLASS_NAME) <= 1;
    }

    private void deleteMe(SuperObjectClientBeanDefinition def) throws Exception {
        if (def.getSystemOption("SetExpirationDateInsteadOfDelete") != null) {
            return;
        }
        this.delete(def);
    }

    @Override
    public void copyRightObject(SuperObjectClientBeanDefinition def, SuperObjectClientBean newLeftObject) throws Exception {
    }
}

