/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.client.beans;

import agorum.commons.string.StringConverterUtils;
import agorum.roi.ejb.client.beans.AccessCounterObjectClientBean;
import agorum.roi.ejb.client.beans.AccessCounterUserObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.FileObjectClientBean;
import agorum.roi.ejb.client.beans.FolderDocumentObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.FormatObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AccessCounterUtils;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.ContentInterface;
import agorum.roi.ejb.common.ContentTransferBean;
import agorum.roi.ejb.common.ContentUtils;
import agorum.roi.ejb.common.DbRandomAccessFile;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.util.annotations.ObjDoc;
import agorum.roi.util.annotations.ObjDocAttribute;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;

@ObjDoc(groups={ObjDoc.Group.FOLDER}, description="Client Bean for the FolderDocumentObject Class")
public class FolderDocumentObjectClientBean
extends FolderObjectClientBean
implements ContentInterface,
Serializable {
    public static String CLASS_NAME = "FOLDERDOCUMENTOBJECT";
    public static String CONTENT_ATTRIBUTE = "CONTENT";
    public static String CONTENTSIZE_ATTRIBUTE = "CONTENTSIZE";
    public static String FORMATOBJECT_ATTRIBUTE = "FORMATOBJECT";
    public static String BLOCKSIZE_ATTRIBUTE = "BLOCKSIZE";
    public static String LASTCONTENTMODIFYDATE_ATTRIBUTE = "LASTCONTENTMODIFYDATE";
    ContentUtils contentUtils = null;
    private Hashtable systemOptions = null;

    @Override
    public SuperObjectClientBeanDefinition getNewDefinition(SessionController sessionController) throws Exception {
        return new FolderDocumentObjectClientBeanDefinition(sessionController);
    }

    @Override
    public void closeForRead() throws Exception {
        this.initContentUtils();
        this.contentUtils.closeForRead();
    }

    @Override
    public void closeTransfer() throws Exception {
        this.initContentUtils();
        this.contentUtils.closeTransfer();
    }

    @Override
    public ContentTransferBean getBuffer(long blockNumber, long contentSize) throws Exception {
        return this.getBuffer(blockNumber, contentSize, false);
    }

    @Override
    public ContentTransferBean getBuffer(long blockNumber, long contentSize, boolean bufferd) throws Exception {
        this.initContentUtils();
        return this.contentUtils.getBuffer(blockNumber, contentSize, bufferd);
    }

    @Override
    public boolean validateContent(long contentSize) throws Exception {
        this.initContentUtils();
        return this.contentUtils.validateContent(contentSize);
    }

    @Override
    public void openForRead() throws Exception {
        this.initContentUtils();
        this.contentUtils.openForRead();
    }

    @Override
    public void openTransfer() throws Exception {
        this.initContentUtils();
        this.contentUtils.openTransfer();
    }

    @Override
    public void openTransfer(boolean makeHistory) throws Exception {
        this.initContentUtils();
        this.contentUtils.openTransfer(null, makeHistory);
    }

    @Override
    public void transferContent(ContentTransferBean ctb, long blockNumber) throws Exception {
        this.initContentUtils();
        this.contentUtils.transferContent(ctb, blockNumber);
    }

    @Override
    public void transferContent(ContentTransferBean ctb, long blockNumber, boolean makeHistory) throws Exception {
        this.initContentUtils();
        this.contentUtils.transferContent(ctb, blockNumber, null, makeHistory);
    }

    @Override
    public void transferContentUpdate(ContentTransferBean ctb, long blockNumber, boolean makeHistory) throws Exception {
        this.initContentUtils();
        this.contentUtils.transferContentUpdate(ctb, blockNumber, makeHistory);
    }

    public void initContentUtils() throws Exception {
        if (this.contentUtils == null) {
            this.contentUtils = new ContentUtils(this.sessionController, this);
        }
    }

    @Override
    @ObjDocAttribute(value="get the content id")
    public Long getContent() throws Exception {
        return new Long(this.getAttribute(FileObjectClientBean.CONTENT_ATTRIBUTE).getLong());
    }

    @Override
    public void setContentSize(long value) throws Exception {
        GlobalObjectClientBeanDefinition def = (GlobalObjectClientBeanDefinition)this.getNewDefinition(this.sessionController);
        if (this.systemOptions != null) {
            def.setAllSystemOption(this.systemOptions);
        }
        def.setAttribute(CONTENTSIZE_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
        this.update(def);
    }

    @Override
    @ObjDocAttribute(value="get the ContentSize of the Object")
    public long getContentSize() throws Exception {
        return this.getContentSize(false);
    }

    @Override
    public long getContentSize(boolean doNotGenerateContent) throws Exception {
        return this.getAttribute(CONTENTSIZE_ATTRIBUTE).getLong();
    }

    @Override
    public void setFormatObject(FormatObjectClientBean value) throws Exception {
        this.setAttribute(FORMATOBJECT_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    @Override
    @ObjDocAttribute(value="get the FormatObject")
    public FormatObjectClientBean getFormatObject() throws Exception {
        return (FormatObjectClientBean)this.getAttribute(FORMATOBJECT_ATTRIBUTE).getInternalObjectClientBean(this.sessionController);
    }

    @Override
    @ObjDocAttribute(value="get the LastContentModifyDate of the Object")
    public Date getLastContentModifyDate() throws Exception {
        return this.getAttribute(LASTCONTENTMODIFYDATE_ATTRIBUTE).getDate();
    }

    @Override
    public void setLastContentModifyDate(Date date) throws Exception {
        this.setAttribute(LASTCONTENTMODIFYDATE_ATTRIBUTE, AttributeValue.newAttributeValueObject(date));
    }

    @Override
    public void setContent(InputStream is, GlobalObjectClientBeanDefinition def) throws Exception {
        this.initContentUtils();
        this.contentUtils.setContent(is, def);
    }

    @Override
    @ObjDocAttribute(value="Get the Content of the Object")
    public InputStream getContentStream() throws Exception {
        return new ContentUtils(this.sessionController, this).getContentStream();
    }

    @Override
    public void setContent(InputStream is) throws Exception {
        this.initContentUtils();
        this.contentUtils.setContent(is);
    }

    @Override
    @ObjDocAttribute(value="Getting the format of this content-Object")
    public FormatObjectClientBean getFormat() throws Exception {
        return (FormatObjectClientBean)this.getAttribute(FORMATOBJECT_ATTRIBUTE).getInternalObjectClientBean(this.sessionController);
    }

    public void setFormat(FormatObjectClientBean formatObject) throws Exception {
        this.setAttribute(FORMATOBJECT_ATTRIBUTE, AttributeValue.newAttributeValueObject(formatObject));
    }

    @Override
    @ObjDocAttribute(value="Get a random Access to the content")
    public DbRandomAccessFile getRandomAccessFile() throws Exception {
        this.initContentUtils();
        return this.contentUtils.getRandomAccessFile();
    }

    @Override
    public OutputStream getContentOutputStream() throws Exception {
        this.initContentUtils();
        return this.contentUtils.getContentOutputStream();
    }

    @Override
    public OutputStream getContentOutputStream(boolean makeHistory) throws Exception {
        this.initContentUtils();
        return this.contentUtils.getContentOutputStream(makeHistory);
    }

    @Override
    public void setBlockSize(long blockSize) throws Exception {
        this.setAttribute(BLOCKSIZE_ATTRIBUTE, AttributeValue.newAttributeValueObject(blockSize));
    }

    @Override
    @ObjDocAttribute(value="Getting the BlockSize of this content-Object")
    public long getBlockSize() throws Exception {
        return this.getAttribute(BLOCKSIZE_ATTRIBUTE).getLong();
    }

    @Override
    @ObjDocAttribute(value="Getting the AccessCounterObject from this Object")
    public AccessCounterObjectClientBean getAccessCounterObject() throws Exception {
        AccessCounterUtils acu = new AccessCounterUtils(this.sessionController);
        return acu.getAccessCounterObject(this);
    }

    @Override
    public AccessCounterUserObjectClientBean getAccessCounterUserObject(DirectoryUserObjectClientBean user) throws Exception {
        AccessCounterUtils acu = new AccessCounterUtils(this.sessionController);
        return acu.getAccessCounterUserObject(this, user);
    }

    @Override
    public AccessCounterUserObjectClientBean[] getAllAccessCounterUserObjects() throws Exception {
        AccessCounterUtils acu = new AccessCounterUtils(this.sessionController);
        return acu.getAllAccessCounterUserObject(this);
    }

    @Override
    public boolean hasUserRead() throws Exception {
        AccessCounterUtils acu = new AccessCounterUtils(this.sessionController);
        return acu.hasUserContentRead(this, this.sessionController.getLoginUser());
    }

    @Override
    @ObjDocAttribute(value="Check if the actual user is the last modifier in the hasUserRead method")
    public boolean getUserReadWatchLastModifier() throws Exception {
        return true;
    }

    @Override
    @ObjDocAttribute(value="get this class")
    public ContentInterface getAccessCounterContentObject() throws Exception {
        return this;
    }

    @Override
    public void truncate(long newFileLength, boolean setContentSize, boolean makeHistory) throws Exception {
        this.initContentUtils();
        this.contentUtils.truncate(newFileLength, setContentSize, makeHistory);
    }

    @Override
    public void open() throws Exception {
    }

    @Override
    public ContentTransferBean read(int len1, long filePos) throws Exception {
        ExceptionUtils.handleException("'read' not implemented in FolderDocumentObject", "agorum.roi.remote.exception.NotImplemented", 3);
        return null;
    }

    @Override
    public void write(ContentTransferBean ctb, int bufferPos, int len, long filePos) throws Exception {
        ExceptionUtils.handleException("'write' not implemented in FolderDocumentObject", "agorum.roi.remote.exception.NotImplemented", 3);
    }

    @Override
    public boolean supportsServerSideStreaming(GlobalObjectClientBean destObject) throws Exception {
        return this.getClassId().longValue() == destObject.getClassId().longValue();
    }

    @Override
    public void streamContent(ContentInterface contentInterface) throws Exception {
        this.initContentUtils();
        this.contentUtils.copyContent(this, contentInterface, this.getFormat().getTableName(), contentInterface.getFormat().getTableName(), this.systemOptions);
        contentInterface.setContentSize(this.getContentSize());
    }

    @Override
    public void setSystemOptions(Hashtable sysOptions) {
        this.systemOptions = sysOptions;
    }

    @Override
    public boolean supportsAccessCounter() {
        return true;
    }

    @Override
    @ObjDocAttribute(value="the table name")
    public String getTableName() throws Exception {
        this.initContentUtils();
        return this.contentUtils.getTableName();
    }

    @Override
    @ObjDocAttribute(value="the format id")
    public Long getFormatId() throws Exception {
        return this.getAttribute(FORMATOBJECT_ATTRIBUTE).getLong();
    }

    @Override
    public String getMd5() throws Exception {
        this.initContentUtils();
        return this.contentUtils.getMD5(this.getContentStream());
    }

    @Override
    public boolean supportsBackend() {
        return true;
    }

    @Override
    @ObjDocAttribute(value="get generated content hashes from the object, listed by ident")
    public Map<String, String> getContentHashes() throws Exception {
        return super.getContentHashesInternal();
    }

    @Override
    @ObjDocAttribute(value="set a content hash code with the given ident to the given object, format: ident;hashcode")
    public void setContentHash(String identAndHash) throws Exception {
        super.setContentHashInternal(identAndHash);
    }

    @Override
    public String getContentString() throws Exception {
        InputStream contentStream = this.getContentStream();
        String text = "";
        if (contentStream != null) {
            text = StringConverterUtils.toString((InputStream)contentStream);
        }
        return text;
    }

    @Override
    public void setContentString(String text) throws Exception {
        this.setContent(StringConverterUtils.toStream((String)text));
    }

    @Override
    public boolean createAccessCounterObject() {
        return true;
    }

    @Override
    public boolean shouldMakeHistory() {
        return false;
    }

    @Override
    public boolean isBinary() throws Exception {
        return true;
    }
}

