/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.client.beans;

import agorum.commons.string.StringConverterUtils;
import agorum.commons.string.StringUtils;
import agorum.roi.common.utils.JavaUtil;
import agorum.roi.ejb.agents.mail.SendMail;
import agorum.roi.ejb.client.beans.AttachmentsRelationObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.DirectoryObjectClientBean;
import agorum.roi.ejb.client.beans.FileObjectClientBean;
import agorum.roi.ejb.client.beans.FolderDocumentObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.FolderPathRelationObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.MailAttachmentsRelationObjectClientBean;
import agorum.roi.ejb.client.beans.MailAttachmentsRelationObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.MailBodyRelationObjectClientBean;
import agorum.roi.ejb.client.beans.MailDocumentObjectClientBean;
import agorum.roi.ejb.client.beans.MailMsgRelationObjectClientBean;
import agorum.roi.ejb.client.beans.MailObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.RelationObjectClientBean;
import agorum.roi.ejb.client.beans.RelationObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AccessCounterUtils;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.AttributeValueBoolean;
import agorum.roi.ejb.common.ContentInterface;
import agorum.roi.ejb.common.ContentUtils;
import agorum.roi.ejb.common.MetaDbSuperCache;
import agorum.roi.ejb.common.SendableContentInterface;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.Transaction;
import agorum.roi.lucene.common.RoiHtml2Text;
import agorum.roi.preview.PreviewHelperGateway;
import agorum.roi.sessionfacade.beans.MailDocumentObjectSessionFacade;
import agorum.roi.util.annotations.ObjDoc;
import agorum.roi.util.annotations.ObjDocAttribute;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@ObjDoc(groups={ObjDoc.Group.MAIL}, description="Client Bean for the MailObject Class")
public class MailObjectClientBean
extends FolderDocumentObjectClientBean
implements Serializable {
    private boolean rfcMode = false;
    public static String CLASS_NAME = "MAILOBJECT";
    public static final String FROMADDRESS_ATTRIBUTE = "FROMADDRESS";
    public static final String TOADDRESS_ATTRIBUTE = "TOADDRESS";
    public static final String CCADDRESS_ATTRIBUTE = "CCADDRESS";
    public static final String BCCADDRESS_ATTRIBUTE = "BCCADDRESS";
    public static final String SENDER_ATTRIBUTE = "SENDER";
    public static final String SUBJECT_ATTRIBUTE = "SUBJECT";
    public static final String RFC822DATE_ATTRIBUTE = "RFC822DATE";
    public static final String REPLAYTO_ATTRIBUTE = "REPLAYTO";
    public static final String INREPLAYTO_ATTRIBUTE = "INREPLAYTO";
    public static final String MESSAGEID_ATTRIBUTE = "MESSAGEID";
    public static final String RFC822MESSAGEID_ATTRIBUTE = "RFC822MESSAGEID";
    public static final String RFC822SIZE_ATTRIBUTE = "RFC822SIZE";
    public static final String RFC822HEADER_ATTRIBUTE = "RFC822HEADER";
    public static final String PRIORITY_ATTRIBUTE = "PRIORITY";
    public static final String SENSITIVITY_ATTRIBUTE = "SENSITIVITY";
    public static final String DISPOSITIONNOTIFICATIONTO_ATTRIBUTE = "DISPOSITIONNOTIFICATIONTO";
    public static final String CONTENTTYPE_ATTRIBUTE = "CONTENTTYPE";
    public static final String CONTENTTYPEPARAMETERS_ATTRIBUTE = "CONTENTTYPEPARAMETERS";
    public static final String MESSAGEUID_ATTRIBUTE = "MESSAGEUID";
    public static final String RECENT_ATTRIBUTE = "RECENT";
    public static final String SEEN_ATTRIBUTE = "SEEN";
    public static final String FLAGGED_ATTRIBUTE = "FLAGGED";
    public static final String ANSWERED_ATTRIBUTE = "ANSWERED";
    public static final String DRAFT_ATTRIBUTE = "DRAFT";
    public static final String DELETED_ATTRIBUTE = "DELETED";
    public static final String MESSAGELOCK_ATTRIBUTE = "MESSAGELOCK";
    public static final String BYTECOUNT_ATTRIBUTE = "BYTECOUNT";
    public static final String LINECOUNT_ATTRIBUTE = "LINECOUNT";
    public static final String CONTENTTRANSFERENCODING_ATTRIBUTE = "CONTENTTRANSFERENCODING";
    public static final String MESSAGEOBJECT_ATTRIBUTE = "MESSAGEOBJECT";
    public static final String MAILSTATUS_ATTRIBUTE = "MAILSTATUS";
    public static final String READBYOWNER_ATTRIBUTE = "READBYOWNER";
    public static final String ORGCREATEDATE_ATTRIBUTE = "ORGCREATEDATE";
    public static final String ORGLASTMODIFYDATE_ATTRIBUTE = "ORGLASTMODIFYDATE";
    public static final String MAILSTATUS_INBOX = "inbox";
    public static final String MAILSTATUS_OUTBOX = "outbox";
    public static final String MAILSTATUS_SENTBOX = "sentbox";
    public static final String MAILSTATUS_DRAFTS = "drafts";
    public static final String MAILSTATUS_UNKNOWN = "unknown";
    public static final String MAILSTATUS_ERROR = "error";
    private boolean seenHasBeenLoaded = false;
    private boolean seen = false;
    public static final String COPY_CONTEXT = MailObjectClientBean.class.getName() + "_CopyContext";

    @Override
    public void setAttribute(String attribute, AttributeValue av) throws Exception {
        if (attribute.equalsIgnoreCase(SEEN_ATTRIBUTE)) {
            GlobalObjectClientBean[] mbd = this.getMailBodies();
            boolean setSeen = ((AttributeValueBoolean)av).getBoolean();
            if (mbd != null) {
                int len = mbd.length;
                for (int i = 0; i < len; ++i) {
                    AccessCounterUtils acu;
                    if (setSeen) {
                        acu = new AccessCounterUtils(this.sessionController);
                        acu.sendReadEvent((ContentInterface)((Object)mbd[i]));
                        continue;
                    }
                    acu = new AccessCounterUtils(this.sessionController);
                    acu.sendUnreadEvent((ContentInterface)((Object)mbd[i]));
                }
            }
        } else {
            super.setAttribute(attribute, av);
        }
    }

    public void addMailAttachment(GlobalObjectClientBean attachmentObject) throws Exception {
        MailAttachmentsRelationObjectClientBeanDefinition marDef = new MailAttachmentsRelationObjectClientBeanDefinition(this.sessionController);
        if (attachmentObject instanceof MailObjectClientBean) {
            marDef.setSystemOption("doNotLeaveMainObject", "");
            this.addRelationship(attachmentObject, (RelationObjectClientBeanDefinition)marDef);
        } else if (attachmentObject instanceof SendableContentInterface) {
            marDef.setSystemOption("doNotLeaveMainObject", "");
            this.addRelationship(attachmentObject, (RelationObjectClientBeanDefinition)marDef);
        } else if (attachmentObject instanceof ContentInterface) {
            boolean isAttached;
            MailDocumentObjectSessionFacade mdosfAtta = new MailDocumentObjectSessionFacade(this.sessionController);
            mdosfAtta.setWithTransaction(true);
            mdosfAtta.setAccessControlList(this.getAcl());
            mdosfAtta.setAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE, attachmentObject.getName());
            mdosfAtta.setContentStream(((ContentInterface)((Object)attachmentObject)).getContentStream());
            MailDocumentObjectClientBean mdocbAtta = (MailDocumentObjectClientBean)mdosfAtta.create();
            this.addRelationship(mdocbAtta, (RelationObjectClientBeanDefinition)marDef);
            boolean bl = isAttached = attachmentObject.getLeftwardRelationCount(RelationObjectClientBean.CLASS_NAME) > 0;
            if (!isAttached) {
                if (attachmentObject.mayBeDeleted()) {
                    attachmentObject.delete();
                }
            } else {
                if (attachmentObject instanceof MailDocumentObjectClientBean) {
                    try {
                        attachmentObject = attachmentObject.getAllAttachments()[0];
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                mdocbAtta.addRelationship(attachmentObject, (RelationObjectClientBeanDefinition)new AttachmentsRelationObjectClientBeanDefinition(this.sessionController));
            }
        }
    }

    @Override
    public SuperObjectClientBeanDefinition getNewDefinition(SessionController sessionController) throws Exception {
        return new MailObjectClientBeanDefinition(sessionController);
    }

    public void setFromAddress(String[] value) throws Exception {
        this.setAttribute(FROMADDRESS_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setToAddress(String[] value) throws Exception {
        this.setAttribute(TOADDRESS_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setCcAddress(String[] value) throws Exception {
        this.setAttribute(CCADDRESS_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setBccAddress(String[] value) throws Exception {
        this.setAttribute(BCCADDRESS_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setSender(String[] value) throws Exception {
        this.setAttribute(SENDER_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setSubject(String value) throws Exception {
        this.setAttribute(SUBJECT_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setRFC822Date(Date value) throws Exception {
        this.setAttribute(RFC822DATE_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setReplyTo(String[] value) throws Exception {
        this.setAttribute(REPLAYTO_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setInReplyTo(String value) throws Exception {
        this.setAttribute(INREPLAYTO_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    @Deprecated
    public void setReplayTo(String[] value) throws Exception {
        this.setReplyTo(value);
    }

    @Deprecated
    public void setInReplayTo(String value) throws Exception {
        this.setInReplyTo(value);
    }

    public void setMessageId(String value) throws Exception {
        this.setAttribute(MESSAGEID_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setRFC822MessageId(String value) throws Exception {
        this.setAttribute(RFC822MESSAGEID_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setRFC822Size(int value) throws Exception {
        this.setAttribute(RFC822SIZE_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setRFC822Header(String[] value) throws Exception {
        this.setAttribute(RFC822HEADER_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setContentType(String value) throws Exception {
        this.setAttribute(CONTENTTYPE_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setContentTypeParameters(GlobalObjectClientBean value) throws Exception {
        this.setAttribute(CONTENTTYPEPARAMETERS_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setMessageuId(int value) throws Exception {
        this.setAttribute(MESSAGEUID_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setRecent(boolean value) throws Exception {
        this.setAttribute(RECENT_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setSeen(boolean value) throws Exception {
        this.setAttribute(SEEN_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setFlagged(boolean value) throws Exception {
        this.setAttribute(FLAGGED_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setAnswered(boolean value) throws Exception {
        this.setAttribute(ANSWERED_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setDraft(boolean value) throws Exception {
        this.setAttribute(DRAFT_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setDeleted(boolean value) throws Exception {
        this.setAttribute(DELETED_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setMessageLock(boolean value) throws Exception {
        this.setAttribute(MESSAGELOCK_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setByteCount(int value) throws Exception {
        this.setAttribute(BYTECOUNT_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setLineCount(int value) throws Exception {
        this.setAttribute(LINECOUNT_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setContentTransferEncoding(String value) throws Exception {
        this.setAttribute(CONTENTTRANSFERENCODING_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setMessageObject(GlobalObjectClientBean value) throws Exception {
        this.setAttribute(MESSAGEOBJECT_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setMailStatus(String value) throws Exception {
        this.setAttribute(MAILSTATUS_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setReadByOwner(boolean value) throws Exception {
        this.setAttribute(READBYOWNER_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setOrgCreateDate(Date value) throws Exception {
        this.setAttribute(ORGCREATEDATE_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setOrgLastmodifyDate(Date value) throws Exception {
        this.setAttribute(ORGLASTMODIFYDATE_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setPriority(String value) throws Exception {
        this.setAttribute(PRIORITY_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setSensitivity(String value) throws Exception {
        this.setAttribute(SENSITIVITY_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setDispositionNotificationTo(String value) throws Exception {
        this.setAttribute(DISPOSITIONNOTIFICATIONTO_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    @ObjDocAttribute(value="the from address of the mail")
    public String[] getFromAddress() throws Exception {
        return this.getAttribute(FROMADDRESS_ATTRIBUTE).getStringArrayObject(this.sessionController);
    }

    @ObjDocAttribute(value="the to addresses of the mail")
    public String[] getToAddress() throws Exception {
        return this.getAttribute(TOADDRESS_ATTRIBUTE).getStringArrayObject(this.sessionController);
    }

    @ObjDocAttribute(value="the cc addresses of the mail")
    public String[] getCcAddress() throws Exception {
        return this.getAttribute(CCADDRESS_ATTRIBUTE).getStringArrayObject(this.sessionController);
    }

    @ObjDocAttribute(value="the bcc address of the mail")
    public String[] getBccAddress() throws Exception {
        return this.getAttribute(BCCADDRESS_ATTRIBUTE).getStringArrayObject(this.sessionController);
    }

    public String[] getSender() throws Exception {
        return this.getAttribute(SENDER_ATTRIBUTE).getStringArrayObject(this.sessionController);
    }

    @ObjDocAttribute(value="the subject")
    public String getSubject() throws Exception {
        return this.getAttribute(SUBJECT_ATTRIBUTE).getString();
    }

    @ObjDocAttribute(value="the date in rfc822 format")
    public Date getRFC822Date() throws Exception {
        return this.getAttribute(RFC822DATE_ATTRIBUTE).getDate();
    }

    @ObjDocAttribute(value="the mail address that should be used for a reply")
    public String[] getReplyTo() throws Exception {
        return this.getAttribute(REPLAYTO_ATTRIBUTE).getStringArrayObject(this.sessionController);
    }

    @ObjDocAttribute(value="the in reply to")
    public String getInReplyTo() throws Exception {
        return this.getAttribute(INREPLAYTO_ATTRIBUTE).getString();
    }

    @Deprecated
    public String[] getReplayTo() throws Exception {
        return this.getReplyTo();
    }

    @Deprecated
    public String getInReplayTo() throws Exception {
        return this.getInReplyTo();
    }

    @ObjDocAttribute(value="the message id")
    public String getMessageId() throws Exception {
        return this.getAttribute(MESSAGEID_ATTRIBUTE).getString();
    }

    @ObjDocAttribute(value="the rfc822 conform message id")
    public String getRFC822MessageId() throws Exception {
        return this.getAttribute(RFC822MESSAGEID_ATTRIBUTE).getString();
    }

    @ObjDocAttribute(value="the rfc822 conform size")
    public int getRFC822Size() throws Exception {
        return this.getAttribute(RFC822SIZE_ATTRIBUTE).getInteger();
    }

    @ObjDocAttribute(value="the rfc 822 header of the mail")
    public String[] getRFC822Header() throws Exception {
        return this.getAttribute(RFC822HEADER_ATTRIBUTE).getStringArrayObject(this.sessionController);
    }

    @ObjDocAttribute(value="the content type")
    public String getContentType() throws Exception {
        return this.getAttribute(CONTENTTYPE_ATTRIBUTE).getString();
    }

    @ObjDocAttribute(value="the content type parameters")
    public GlobalObjectClientBean getContentTypeParameters() throws Exception {
        return this.getAttribute(CONTENTTYPEPARAMETERS_ATTRIBUTE).getGlobalObjectClientBean(this.sessionController);
    }

    @ObjDocAttribute(value="the message uid")
    public int getMessageuId() throws Exception {
        return this.getAttribute(MESSAGEUID_ATTRIBUTE).getInteger();
    }

    @ObjDocAttribute(value="returns if recent")
    public boolean getRecent() throws Exception {
        return this.getAttribute(RECENT_ATTRIBUTE).getBoolean();
    }

    @ObjDocAttribute(value="returns if seen")
    public boolean getSeen() throws Exception {
        if (!this.seenHasBeenLoaded) {
            this.seenHasBeenLoaded = true;
            this.seen = this.hasUserRead();
        }
        return this.seen;
    }

    @ObjDocAttribute(value="returns if flagged")
    public boolean getFlagged() throws Exception {
        return this.getAttribute(FLAGGED_ATTRIBUTE).getBoolean();
    }

    @ObjDocAttribute(value="returns if answered")
    public boolean getAnswered() throws Exception {
        return this.getAttribute(ANSWERED_ATTRIBUTE).getBoolean();
    }

    @ObjDocAttribute(value="returns if drafted")
    public boolean getDraft() throws Exception {
        return this.getAttribute(DRAFT_ATTRIBUTE).getBoolean();
    }

    @ObjDocAttribute(value="returns if deleted")
    public boolean getDeleted() throws Exception {
        return this.getAttribute(DELETED_ATTRIBUTE).getBoolean();
    }

    @ObjDocAttribute(value="returns if message locked")
    public boolean getMessageLock() throws Exception {
        return this.getAttribute(MESSAGELOCK_ATTRIBUTE).getBoolean();
    }

    @ObjDocAttribute(value="returns if byte counted")
    public int getByteCount() throws Exception {
        return this.getAttribute(BYTECOUNT_ATTRIBUTE).getInteger();
    }

    @ObjDocAttribute(value="the counted lines")
    public int getLineCount() throws Exception {
        return this.getAttribute(LINECOUNT_ATTRIBUTE).getInteger();
    }

    @ObjDocAttribute(value="the content transfer encoding")
    public String getContentTransferEncoding() throws Exception {
        return this.getAttribute(CONTENTTRANSFERENCODING_ATTRIBUTE).getString();
    }

    @ObjDocAttribute(value="the message object")
    public GlobalObjectClientBean getMessageObject() throws Exception {
        return this.getAttribute(MESSAGEOBJECT_ATTRIBUTE).getGlobalObjectClientBean(this.sessionController);
    }

    @ObjDocAttribute(value="the mail status")
    public String getMailStatus() throws Exception {
        return this.getAttribute(MAILSTATUS_ATTRIBUTE).getString();
    }

    @ObjDocAttribute(value="the mail direction (in or out)")
    public String getMailDirection() throws Exception {
        String mailStatus = this.getMailStatus();
        if (mailStatus != null && mailStatus.equalsIgnoreCase(MAILSTATUS_INBOX)) {
            return "in";
        }
        return "out";
    }

    @ObjDocAttribute(value="the first sender or receiver, depending on direction")
    public String getSenderOrReceiver() throws Exception {
        String mailStatus = this.getMailStatus();
        if (mailStatus != null && mailStatus.equalsIgnoreCase(MAILSTATUS_INBOX)) {
            String[] fromAdr = this.getFromAddress();
            if (fromAdr != null && fromAdr.length > 0) {
                return fromAdr[0];
            }
        } else {
            String[] toAdr = this.getToAddress();
            if (toAdr != null && toAdr.length > 0) {
                return toAdr[0];
            }
        }
        return null;
    }

    @ObjDocAttribute(value="returns if read by owner")
    public boolean getReadByOwner() throws Exception {
        return this.getAttribute(READBYOWNER_ATTRIBUTE).getBoolean();
    }

    @ObjDocAttribute(value="the org create date")
    public Date getOrgCreateDate() throws Exception {
        return this.getAttribute(ORGCREATEDATE_ATTRIBUTE).getDate();
    }

    @ObjDocAttribute(value="the org lst modify date")
    public Date getOrgLastmodifyDate() throws Exception {
        return this.getAttribute(ORGLASTMODIFYDATE_ATTRIBUTE).getDate();
    }

    public GlobalObjectClientBean[] getMailBodies() throws Exception {
        return this.getMailObjects(MailBodyRelationObjectClientBean.CLASS_NAME);
    }

    public String getBodyMime() throws Exception {
        MailDocumentObjectClientBean body = (MailDocumentObjectClientBean)this.getBestBodyPart();
        if (body == null) {
            return null;
        }
        return body.getFormat().getMimeType();
    }

    public String getBodyString() throws Exception {
        return this.getBodyString(true);
    }

    private String getBodyString(boolean retry) throws Exception {
        try {
            StringBuilder sb = new StringBuilder();
            for (GlobalObjectClientBean body : this.getBestBodyParts()) {
                if (!(body instanceof ContentInterface)) continue;
                sb.append(((ContentInterface)((Object)body)).getContentString());
            }
            return sb.toString();
        }
        catch (Exception e) {
            if (retry) {
                return this.getBodyString(false);
            }
            throw e;
        }
    }

    @ObjDocAttribute(value="the priority")
    public String getPriority() throws Exception {
        return this.getAttribute(PRIORITY_ATTRIBUTE).getString();
    }

    @ObjDocAttribute(value="the sensivity")
    public String getSensitivity() throws Exception {
        return this.getAttribute(SENSITIVITY_ATTRIBUTE).getString();
    }

    @ObjDocAttribute(value="the disposition notification to")
    public String getDispositionNotificationTo() throws Exception {
        return this.getAttribute(DISPOSITIONNOTIFICATIONTO_ATTRIBUTE).getString();
    }

    @ObjDocAttribute(value="indicates, if a disposition notification should be sent")
    public boolean getShouldSendDispositionNotification() throws Exception {
        return Boolean.parseBoolean(MetaDbSuperCache.getSimplePropertyValue(this.sessionController, "MAIN_MODULE_MANAGEMENT/roi/control/mail/AllowDispositionNotification", "true"));
    }

    @ObjDocAttribute(value="the body part of the mail that should be used for display purposes (html preferred)")
    public GlobalObjectClientBean getBestBodyPart() throws Exception {
        GlobalObjectClientBean[] bodies = this.getMailBodies();
        MailDocumentObjectClientBean body = null;
        if (bodies != null) {
            int len = bodies.length;
            for (int i = 0; i < len; ++i) {
                MailDocumentObjectClientBean mailBody;
                body = mailBody = (MailDocumentObjectClientBean)bodies[i];
                if (mailBody.getFormat().getMimeType().equalsIgnoreCase("text/html")) break;
            }
        }
        return body;
    }

    @ObjDocAttribute(value="update a body of a mail (has to be in drafts mode)")
    public void setBody(String body) throws Exception {
        try (Transaction t = new Transaction();){
            if (!this.getMailStatus().equals(MAILSTATUS_DRAFTS) && !this.getMailStatus().equals(MAILSTATUS_ERROR)) {
                throw new Exception("Body may not be changed, when not in drafts mode");
            }
            MailDocumentObjectClientBean mailBody = (MailDocumentObjectClientBean)this.getBestBodyPart();
            if (mailBody == null) {
                throw new Exception("Mail has no body");
            }
            mailBody.setContent(StringConverterUtils.toStream((String)body));
            t.commit();
        }
    }

    @ObjDocAttribute(value="update attachments of a mail (has to be in drafts mode)")
    public void setMailAttachmentsUpdate(String[] attachmentIds) throws Exception {
        try (Transaction t = new Transaction();){
            if (!this.getMailStatus().equals(MAILSTATUS_DRAFTS) && !this.getMailStatus().equals(MAILSTATUS_ERROR)) {
                throw new Exception("Attachments may not be changed, when not in drafts mode");
            }
            GlobalObjectClientBean[] alreadyAttachedObjects = this.getMailAttachments();
            HashSet<String> alreadyAttached = new HashSet<String>();
            if (alreadyAttachedObjects != null) {
                for (GlobalObjectClientBean alreadyAttachedObject : alreadyAttachedObjects) {
                    alreadyAttached.add(alreadyAttachedObject.getId() + "");
                }
            }
            for (String newAttaId : attachmentIds) {
                if (!alreadyAttached.contains(newAttaId)) {
                    GlobalObjectClientBean attachmentObject = this.sessionController.getGlobalObjectById(new Long(newAttaId));
                    this.addMailAttachment(attachmentObject);
                    continue;
                }
                alreadyAttached.remove(newAttaId);
            }
            for (String attaId : alreadyAttached) {
                GlobalObjectClientBean gocb = this.sessionController.getGlobalObjectById(new Long(attaId));
                if (gocb instanceof MailObjectClientBean) {
                    this.removeRelationship(gocb, MailAttachmentsRelationObjectClientBean.CLASS_NAME);
                    continue;
                }
                if (gocb instanceof SendableContentInterface) {
                    this.removeRelationship(gocb, MailAttachmentsRelationObjectClientBean.CLASS_NAME);
                    continue;
                }
                SuperObjectClientBeanDefinition def = gocb.getDefinition(this.sessionController);
                def.setSystemOption("parentFolderOfDeleteObject", this);
                gocb.delete(def);
            }
            t.commit();
        }
    }

    @ObjDocAttribute(value="generates the RFC822 part of the mail, from the mail object")
    public void setGenerateRFC822(boolean generate) throws Exception {
        if (generate) {
            try (Transaction t = new Transaction();){
                if (!this.getMailStatus().equals(MAILSTATUS_DRAFTS) && !this.getMailStatus().equals(MAILSTATUS_ERROR)) {
                    throw new Exception("mail has to be in draft mode");
                }
                SendMail sm = new SendMail(this.sessionController);
                sm.generateRFC822(this);
                RelationObjectClientBean[] parentRelations = this.getLeftwardRelations(FolderPathRelationObjectClientBean.CLASS_NAME);
                if (parentRelations != null) {
                    for (RelationObjectClientBean parentRel : parentRelations) {
                        if (parentRel.getId().equals(parentRel.getSortSequence())) continue;
                        FolderObjectClientBean parent = (FolderObjectClientBean)parentRel.getLeftObject();
                        parentRel.delete();
                        parent.add(this);
                    }
                }
                t.commit();
            }
        }
    }

    @ObjDocAttribute(value="forces to send this mail, and sets the state to outbox")
    public void setSendMail(boolean keepDraft) throws Exception {
        try (Transaction t = new Transaction();){
            if (!this.getMailStatus().equals(MAILSTATUS_DRAFTS) && !this.getMailStatus().equals(MAILSTATUS_ERROR)) {
                throw new Exception("mail has to be in draft mode");
            }
            MailObjectClientBean mail = this;
            FolderObjectClientBean draftFolder = (FolderObjectClientBean)this.sessionController.findGlobalObjectByPath(this.getSessionController().getHomeFolder(), "/mail/drafts");
            FolderObjectClientBean outboxFolder = (FolderObjectClientBean)this.sessionController.findGlobalObjectByPath(this.getSessionController().getHomeFolder(), "/mail/outbox");
            if (keepDraft) {
                SuperObjectClientBeanDefinition def = this.getDefinition(this.sessionController);
                StringUtils su = new StringUtils();
                mail = (MailObjectClientBean)this.copy(def);
                mail.setName(su.strReplaceToFilename(this.getSubject() + "_" + mail.getID() + ".eml"));
            } else {
                draftFolder.removeItem(mail);
            }
            outboxFolder.add(mail);
            mail.setMailStatus(MAILSTATUS_OUTBOX);
            mail.setDraft(false);
            mail.handleInReplyToMail();
            t.commit();
        }
    }

    public void handleInReplyToMail() throws Exception {
        try (Transaction t = new Transaction();){
            SuperObjectClientBean[] inReplyToMails = null;
            String inReplyTo = this.getInReplyTo();
            if (inReplyTo != null && inReplyTo.length() > 0) {
                try {
                    inReplyToMails = this.sessionController.getSuperObjectByAttribute(this.sessionController, RFC822MESSAGEID_ATTRIBUTE, inReplyTo, false, this.sessionController.getClassObject(CLASS_NAME));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (inReplyToMails != null) {
                    for (SuperObjectClientBean replyMail : inReplyToMails) {
                        MailObjectClientBean inReplyToMail = (MailObjectClientBean)replyMail;
                        inReplyToMail.addRelationship(this, (RelationObjectClientBeanDefinition)new AttachmentsRelationObjectClientBeanDefinition(this.sessionController));
                        if (!inReplyToMail.checkEffectiveAccess(2L)) continue;
                        try {
                            SuperObjectClientBeanDefinition irtmDef = inReplyToMail.getNewDefinition(this.sessionController);
                            irtmDef.setSystemOption("doNotEA", "true");
                            irtmDef.setAttribute(ANSWERED_ATTRIBUTE, AttributeValue.newAttributeValueObject(true));
                            irtmDef.setAttribute(GlobalObjectClientBean.LASTMODIFIER_ATTRIBUTE, AttributeValue.newAttributeValueObject(inReplyToMail.getLastModifier()));
                            irtmDef.setSystemOption("SetNoLASTMODIFYDATE", "true");
                            irtmDef.setSystemOption("silentUpdate", "true");
                            inReplyToMail.update(irtmDef);
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.err);
                        }
                    }
                }
            }
            t.commit();
        }
    }

    @ObjDocAttribute(value="set the name of the mail, with the subject")
    public void setNameAndSubject(String subject) throws Exception {
        try (Transaction t = new Transaction();){
            StringUtils su = new StringUtils();
            this.setSubject(subject);
            this.setName(su.strReplaceToFilename(subject + "_" + this.getID() + ".eml"));
            t.commit();
        }
    }

    @ObjDocAttribute(value="the body parts of the mail that should be used for display purposes (html preferred)")
    public List<GlobalObjectClientBean> getBestBodyParts() throws Exception {
        GlobalObjectClientBean[] all = this.getMailBodies();
        if (all == null) {
            return new ArrayList<GlobalObjectClientBean>(0);
        }
        boolean isHtml = false;
        for (GlobalObjectClientBean part : all) {
            if (!"text/html".equalsIgnoreCase(((ContentInterface)((Object)part)).getFormat().getMimeType())) continue;
            isHtml = true;
            break;
        }
        ArrayList<GlobalObjectClientBean> result = new ArrayList<GlobalObjectClientBean>(all.length);
        for (GlobalObjectClientBean part : all) {
            if (isHtml) {
                if (!"text/html".equalsIgnoreCase(((ContentInterface)((Object)part)).getFormat().getMimeType())) continue;
                result.add(part);
                continue;
            }
            result.add(part);
        }
        return result;
    }

    public GlobalObjectClientBean[] getMailAttachments() throws Exception {
        return this.getMailObjects(MailAttachmentsRelationObjectClientBean.CLASS_NAME);
    }

    public boolean hasMailAttachments() throws Exception {
        return this.getRightwardRelations(MailAttachmentsRelationObjectClientBean.CLASS_NAME) != null;
    }

    @ObjDocAttribute(value="returns, if the mail has attachments or not (API usage)")
    public boolean getHasMailAttachments() throws Exception {
        return this.hasMailAttachments();
    }

    @Override
    @ObjDocAttribute(value="returns, if the mail has attachments or not (legacy usage)")
    public boolean hasOwnAttachments() throws Exception {
        return this.hasMailAttachments();
    }

    private GlobalObjectClientBean[] getMailObjects(String allocationType) throws Exception {
        GlobalObjectClientBean[] mdoArr = null;
        JavaUtil ju = new JavaUtil();
        try {
            mdoArr = (GlobalObjectClientBean[])ju.convertArray(this.getAllocationFromType(allocationType), GlobalObjectClientBean.class.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mdoArr;
    }

    @Override
    @ObjDocAttribute(value="returns the class as xml")
    public String getXml() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(super.getXml(false));
        if (!this.globalObjectOnly || this.xmlForIndex) {
            int i;
            int len;
            GlobalObjectClientBean[] mbd = this.getMailBodies();
            sb.append("<MAILBODIES>\n");
            if (mbd != null) {
                len = mbd.length;
                for (i = 0; i < len; ++i) {
                    sb.append(mbd[i].getXml());
                }
            }
            sb.append("</MAILBODIES>\n");
            mbd = this.getMailAttachments();
            sb.append("<MAILATTACHMENTS>\n");
            if (mbd != null) {
                len = mbd.length;
                for (i = 0; i < len; ++i) {
                    sb.append(mbd[i].getXml());
                }
            }
            sb.append("</MAILATTACHMENTS>\n");
        }
        sb.append(this.getXMLEndTag(this.sessionController));
        return sb.toString();
    }

    @ObjDocAttribute(value="Returns the sent date of the mail. Returns the create date for old mails")
    public Date getSentDate() throws Exception {
        Date sentDate = this.getRFC822Date();
        if (sentDate == null || sentDate.getTime() == 0L) {
            sentDate = this.getCreateDate();
        }
        return sentDate;
    }

    @Override
    @ObjDocAttribute(value="No NOT check if the actual user is the last modifier in the hasUserRead method")
    public boolean getUserReadWatchLastModifier() throws Exception {
        return false;
    }

    @Override
    public void initContentUtils() throws Exception {
        if (this.contentUtils == null) {
            ContentInterface msgObject;
            if (this.getName().toUpperCase().endsWith(".MSG") && !this.rfcMode && (msgObject = this.getMsgObject()) != null) {
                this.contentUtils = new ContentUtils(this.sessionController, msgObject);
            }
            if (this.contentUtils == null) {
                this.contentUtils = new ContentUtils(this.sessionController, this);
            }
        }
    }

    public void setRFCMode(boolean mode) {
        this.contentUtils = null;
        this.rfcMode = mode;
    }

    @ObjDocAttribute(value="get the original eml-stream of this mail (even if it is a msg mail)")
    public InputStream getRFC822Stream() throws Exception {
        this.getContentSize();
        ContentUtils myContentUtils = new ContentUtils(this.sessionController, this);
        return myContentUtils.getContentStreamNoRead();
    }

    @ObjDocAttribute(value="the best body part of the mail as html")
    public String getHtmlBody() throws Exception {
        MailDocumentObjectClientBean mailBody = (MailDocumentObjectClientBean)this.getBestBodyPart();
        String text = "";
        if (mailBody != null) {
            text = mailBody.getContentString();
        }
        if (mailBody != null && !mailBody.getFormat().getMimeType().equalsIgnoreCase("text/html")) {
            StringUtils su = new StringUtils();
            text = su.strReplace(text, "<", "&lt;");
            text = su.strReplace(text, ">", "&gt;");
            text = su.strReplace(text, "\n", "<br>");
        }
        return text;
    }

    @Override
    public long getContentSize(boolean doNotGenerateContent) throws Exception {
        ContentInterface msgObject;
        long myContentSize = -1L;
        if (this.getName().toUpperCase().endsWith(".MSG") && !this.rfcMode && (msgObject = this.getMsgObject()) != null) {
            myContentSize = msgObject.getContentSize();
        }
        if (myContentSize == -1L) {
            myContentSize = super.getContentSize(true);
            if (myContentSize == 0L && !doNotGenerateContent) {
                SendMail sendMail = new SendMail(this.sessionController);
                sendMail.generateRFC822(this);
            }
            myContentSize = super.getContentSize(true);
        }
        return myContentSize;
    }

    public boolean isContentSet() throws Exception {
        return this.getContentSize() > 0L;
    }

    @ObjDocAttribute(value="the appended msg object")
    public ContentInterface getMsgObject() throws Exception {
        GlobalObjectClientBean[] msgObjects = this.getRightwardRelationObjects(MailMsgRelationObjectClientBean.CLASS_NAME);
        if (msgObjects != null && msgObjects.length == 1) {
            return (ContentInterface)((Object)msgObjects[0]);
        }
        return null;
    }

    @ObjDocAttribute(value="get the address to reply to")
    public String getReplyToAddress() throws Exception {
        String replyToAddress = "";
        String[] replyToAddresses = this.getReplyTo();
        if (replyToAddresses != null && replyToAddresses.length > 0) {
            replyToAddress = replyToAddresses[0];
        } else {
            String[] fromAddresses = this.getFromAddress();
            if (fromAddresses != null && fromAddresses.length > 0) {
                replyToAddress = fromAddresses[0];
            }
        }
        return replyToAddress;
    }

    @ObjDocAttribute(value="the address in reply to")
    public String getInReplyToAddress() throws Exception {
        return this.getRFC822MessageId();
    }

    @ObjDocAttribute(value="the reply body of an email")
    public String getReplyBody() throws Exception {
        String mailAddress = "";
        try {
            mailAddress = this.getSessionController().getLoginUser().getEmailUserProfiles()[0].getEmailAddress();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getFooterText(mailAddress) + this.generateNewBody(true);
    }

    @ObjDocAttribute(value="the body for forwarding a mail")
    public String getForwardBody() throws Exception {
        String mailAddress = "";
        try {
            mailAddress = this.getSessionController().getLoginUser().getEmailUserProfiles()[0].getEmailAddress();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getFooterText(mailAddress) + this.generateNewBody(true);
    }

    public String getFooterText(String fromAddress) throws Exception {
        String footerName = "MailFooter_" + fromAddress + ".txt";
        String footerText = "";
        FileObjectClientBean footerObject = null;
        try {
            String userName = this.sessionController.getLoginUser().getName();
            footerObject = (FileObjectClientBean)this.sessionController.findGlobalObjectByPath("/Home/" + userName + "/MyAdmin/Mail/" + footerName);
            if (footerObject != null) {
                StringUtils su = new StringUtils();
                footerText = "\n" + su.streamToString(footerObject.getContentStream()) + "\n\n\n";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return footerText;
    }

    private String generateNewBody(boolean replyOrForward) throws Exception {
        String contentLine;
        MailDocumentObjectClientBean mailBody = (MailDocumentObjectClientBean)this.getBestBodyPart();
        String text = "";
        if (mailBody != null) {
            text = mailBody.getContentString();
        }
        if (mailBody != null && !mailBody.getFormat().getMimeType().equalsIgnoreCase("text/plain")) {
            int beginIndex = text.toLowerCase().indexOf("<body");
            int endIndex = text.toLowerCase().indexOf("</body>");
            if (beginIndex != -1 && endIndex != -1) {
                text = text.substring(beginIndex, endIndex);
            }
            StringUtils su = new StringUtils();
            text = su.strReplace(text, "\n", "");
            Pattern p = Pattern.compile("<br\\s*/?>", 2);
            Matcher m = p.matcher(text);
            text = m.replaceAll("%%return%%");
            p = Pattern.compile("<p[^>]*>", 2);
            m = p.matcher(text);
            text = m.replaceAll("%%return%%");
            text = su.str(text, "</div>", "%%return%%");
            text = su.str(text, "</tr>", "%%return%%");
            text = RoiHtml2Text.convert(text);
            text = su.strReplace(text, "%%return%%", "\n");
        }
        if (!replyOrForward) {
            return text;
        }
        StringBuffer buffer = new StringBuffer();
        StringReader contentReader = new StringReader(text);
        BufferedReader br = new BufferedReader(contentReader);
        buffer.append("\n\n");
        buffer.append("${Translate_OriginalMessage_Translate}: ");
        String[] fromAddresses = this.getFromAddress();
        String fromAddress = "";
        if (fromAddresses != null && fromAddresses.length > 0) {
            fromAddress = fromAddresses[0];
        }
        buffer.append("${Translate_From_Translate}:  " + fromAddress + "\n");
        if (this.getToAddress() != null && this.getToAddress().length > 0) {
            buffer.append("To: " + this.generateStringFromArray(this.getToAddress(), ", ") + "\n");
        }
        if (this.getCcAddress() != null && this.getCcAddress().length > 0) {
            buffer.append("CC: " + this.generateStringFromArray(this.getCcAddress(), ", ") + "\n");
        }
        buffer.append("${Translate_Date_Translate}: " + this.getCreateDate().toString() + "\n");
        buffer.append("${Translate_Subject_Translate}: " + this.getDisplayName() + "\n");
        buffer.append("---------------------------------------\n");
        while ((contentLine = br.readLine()) != null) {
            buffer.append("> ");
            buffer.append(contentLine);
            buffer.append("\n");
        }
        return buffer.toString();
    }

    private String generateStringFromArray(String[] arr, String seperator) {
        String str = "";
        String sep = "";
        if (arr != null) {
            int len = arr.length;
            for (int i = 0; i < len; ++i) {
                str = str + sep + arr[i];
                sep = seperator;
            }
        }
        return str;
    }

    @Override
    public void executeBeforeItemAdded(SessionController sessionController, GlobalObjectClientBean lo, GlobalObjectClientBean ro, SuperObjectClientBeanDefinition relDef) throws Exception {
        if (this.getId().longValue() == ro.getId().longValue() && relDef.getAttribute(RelationObjectClientBean.FILTERDATE_ATTRIBUTE) == null) {
            relDef.setAttribute(RelationObjectClientBean.FILTERDATE_ATTRIBUTE, AttributeValue.newAttributeValueObject(((MailObjectClientBean)ro).getRFC822Date()));
        }
        super.executeBeforeItemAdded(sessionController, lo, ro, relDef);
    }

    @Override
    @ObjDocAttribute(value="return BestBodyPart for displaying, cause mail has no display")
    public GlobalObjectClientBean getObjectForHighlighting() throws Exception {
        GlobalObjectClientBean retG = this.getBestBodyPart();
        if (retG == null) {
            retG = this;
        }
        return retG;
    }

    @Override
    public boolean supportsPreview() throws Exception {
        PreviewHelperGateway ph = new PreviewHelperGateway();
        return ph.getPreviewInterface().hasPreview(this);
    }

    @Override
    public boolean shouldMakeHistory() {
        return false;
    }

    @ObjDocAttribute(value="get the default sender address of the user")
    public String getDefaultSenderAddress() throws Exception {
        return this.sessionController.getLoginUser().getEmailUserProfiles()[0].getEmailAddress();
    }

    @Override
    public boolean belongsToUser() throws Exception {
        return this.getOwnerId().equals(this.sessionController.getLoginUserId());
    }

    @Override
    public boolean hasSubContent() {
        return true;
    }

    @Override
    public boolean checkEffectiveAccess(DirectoryObjectClientBean directoryObject, long accessLevel, boolean ignoreSharedLock) throws Exception {
        if (this.sessionController.isInSychronization()) {
            return super.checkEffectiveAccess(directoryObject, accessLevel, ignoreSharedLock);
        }
        if (!((accessLevel & 8L) == 0L || this.getDraft() || MAILSTATUS_DRAFTS.equals(this.getMailStatus()) || super.getContentSize(false) <= 0L || Transaction.has(COPY_CONTEXT))) {
            return false;
        }
        if ((accessLevel & 0x100000L) != 0L) {
            return false;
        }
        return super.checkEffectiveAccess(directoryObject, accessLevel, ignoreSharedLock);
    }

    @Override
    public boolean supportsFolderItemsChangeDelete() {
        return true;
    }

    @Override
    public DirectoryObjectClientBean getAssociatedUser() throws Exception {
        return this.getCreator();
    }

    @Override
    public List<GlobalObjectClientBean> getIndexMainObjects() throws Exception {
        HashSet<String> done = new HashSet<String>();
        ArrayList<GlobalObjectClientBean> objects = new ArrayList<GlobalObjectClientBean>();
        return this.getIndexMainObjects(this, objects, done);
    }

    private List<GlobalObjectClientBean> getIndexMainObjects(GlobalObjectClientBean obj, List<GlobalObjectClientBean> objects, Set<String> done) throws Exception {
        GlobalObjectClientBean[] mails = this.getLeftwardRelationObjects(MailAttachmentsRelationObjectClientBean.CLASS_NAME);
        if (mails == null || mails.length == 0) {
            objects.add(this.getIndexMainObject());
        } else {
            for (GlobalObjectClientBean mail : mails) {
                objects.add(mail);
                if (done.contains(obj.getID())) continue;
                done.add(mail.getID());
                this.getIndexMainObjects(mail, objects, done);
            }
        }
        return objects;
    }
}

