/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.client.beans;

import agorum.commons.html.HtmlUtils;
import agorum.commons.string.StringConverterUtils;
import agorum.roi.common.utils.JavaUtil;
import agorum.roi.ejb.client.beans.DirectoryObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.FileObjectClientBean;
import agorum.roi.ejb.client.beans.FileRelationObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.LinkRelationObjectClientBean;
import agorum.roi.ejb.client.beans.MediaRelationObjectClientBean;
import agorum.roi.ejb.client.beans.NoteFileObjectClientBean;
import agorum.roi.ejb.client.beans.NoteLinkObjectClientBean;
import agorum.roi.ejb.client.beans.NoteMediaObjectClientBean;
import agorum.roi.ejb.client.beans.NoteObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.NoteRecipientRelationObjectClientBean;
import agorum.roi.ejb.client.beans.NoteRelationObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AttributeInfo;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.sessionfacade.beans.NoteObjectSessionFacade;
import agorum.roi.util.annotations.ObjDoc;
import agorum.roi.util.annotations.ObjDocAttribute;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;

@ObjDoc(groups={ObjDoc.Group.NOTE}, description="Client Bean for the NoteObject Class")
public class NoteObjectClientBean
extends FileObjectClientBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static String CLASS_NAME = "NOTEOBJECT";
    public static final String USERNAME_ATTRIBUTE = "USERNAME";
    public static final String SUBJECT_ATTRIBUTE = "SUBJECT";
    public static final String TEXT_ATTRIBUTE = "TEXT";
    public static final String DATEFROM_ATTRIBUTE = "DATEFROM";
    public static final String DATETO_ATTRIBUTE = "DATETO";
    public static final String PRIORITAET_ATTRIBUTE = "PRIORITAET";

    @Override
    public SuperObjectClientBeanDefinition getNewDefinition(SessionController sessionController) throws Exception {
        return new NoteObjectClientBeanDefinition(sessionController);
    }

    public void setUserName(String value) throws Exception {
        this.setAttribute(USERNAME_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setSubject(String value) throws Exception {
        this.setAttribute(SUBJECT_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setText(String value) throws Exception {
        this.setAttribute(TEXT_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setDatefrom(Date value) throws Exception {
        this.setAttribute(DATEFROM_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setDateto(Date value) throws Exception {
        this.setAttribute(DATETO_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setPrioritaet(String value) throws Exception {
        this.setAttribute(PRIORITAET_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    @ObjDocAttribute(value=" the user name")
    public String getUserName() throws Exception {
        return this.getAttribute(USERNAME_ATTRIBUTE).getString();
    }

    @ObjDocAttribute(value="the subject")
    public String getSubject() throws Exception {
        return this.getAttribute(SUBJECT_ATTRIBUTE).getString();
    }

    @Override
    @ObjDocAttribute(value="the text")
    public String getText() throws Exception {
        return this.getAttribute(TEXT_ATTRIBUTE).getString();
    }

    @ObjDocAttribute(value="the date from")
    public Date getDatefrom() throws Exception {
        return this.getAttribute(DATEFROM_ATTRIBUTE).getDate();
    }

    @ObjDocAttribute(value="the date to")
    public Date getDateto() throws Exception {
        return this.getAttribute(DATETO_ATTRIBUTE).getDate();
    }

    @ObjDocAttribute(value="the priority")
    public String getPrioritaet() throws Exception {
        return this.getAttribute(PRIORITAET_ATTRIBUTE).getString();
    }

    public NoteFileObjectClientBean[] getFiles() throws Exception {
        try {
            JavaUtil ju = new JavaUtil();
            return (NoteFileObjectClientBean[])ju.convertArray(this.getRightwardRelationObjects(FileRelationObjectClientBean.CLASS_NAME), NoteFileObjectClientBean.class.getName());
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
            return null;
        }
    }

    public NoteMediaObjectClientBean[] getMedias() throws Exception {
        try {
            JavaUtil ju = new JavaUtil();
            return (NoteMediaObjectClientBean[])ju.convertArray(this.getRightwardRelationObjects(MediaRelationObjectClientBean.CLASS_NAME), NoteMediaObjectClientBean.class.getName());
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
            return null;
        }
    }

    public GlobalObjectClientBean[] getReceivers() throws Exception {
        return this.getRightwardRelationObjects(NoteRecipientRelationObjectClientBean.CLASS_NAME);
    }

    public NoteLinkObjectClientBean[] getLinks() throws Exception {
        try {
            JavaUtil ju = new JavaUtil();
            return (NoteLinkObjectClientBean[])ju.convertArray(this.getRightwardRelationObjects(LinkRelationObjectClientBean.CLASS_NAME), NoteLinkObjectClientBean.class.getName());
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
            return null;
        }
    }

    @Override
    public String getDisplayName() throws Exception {
        String customName = this.getCustomName();
        if (customName != null) {
            return customName;
        }
        String content = HtmlUtils.htmlToText((InputStream)this.getContentStreamNoRead());
        content = content.trim();
        if ((content = content.replaceAll("\r", "").replaceAll("\n", " ")).length() > 50) {
            content = content.substring(0, 47) + "...";
        }
        return content;
    }

    @Override
    @ObjDocAttribute(value="the Object that should be dispalyed (e.g. in the EventAssistant)")
    public GlobalObjectClientBean getDisplayableObject() throws Exception {
        return this;
    }

    @Override
    @ObjDocAttribute(value="the Object that should be dispalyed as the \"main\" object(e.g. in the EventAssistant)")
    public GlobalObjectClientBean getMainObjectForList() throws Exception {
        return this.getMainObject();
    }

    @Override
    @ObjDocAttribute(value="return the class as xml file")
    public String getXml() throws Exception {
        GlobalObjectClientBean[] recArray;
        StringBuffer sb = new StringBuffer();
        sb.append(super.getXml(false));
        if (!this.globalObjectOnly) {
            NoteFileObjectClientBean[] nfocb = this.getFiles();
            sb.append("<FILES>\n");
            if (nfocb != null) {
                int len = nfocb.length;
                for (int i = 0; i < len; ++i) {
                    sb.append(nfocb[i].getXml());
                }
            }
            sb.append("</FILES>\n");
            NoteMediaObjectClientBean[] nmocb = this.getMedias();
            sb.append("<MEDIAS>\n");
            if (nmocb != null) {
                int len = nmocb.length;
                for (int i = 0; i < len; ++i) {
                    sb.append(nmocb[i].getXml());
                }
            }
            sb.append("</MEDIAS>\n");
            NoteLinkObjectClientBean[] nlocb = this.getLinks();
            sb.append("<LINKS>\n");
            if (nlocb != null) {
                int len = nlocb.length;
                for (int i = 0; i < len; ++i) {
                    sb.append(nlocb[i].getXml());
                }
            }
            sb.append("</LINKS>\n");
        }
        if ((recArray = this.getRecipients()) != null) {
            sb.append("<RECIPIENTS>");
            for (GlobalObjectClientBean rec : recArray) {
                sb.append(rec.getID());
                sb.append(" ");
            }
            sb.append("</RECIPIENTS>");
            sb.append("<RECIPIENTS_UUID>");
            for (GlobalObjectClientBean rec : recArray) {
                sb.append(rec.getUUID());
                sb.append(" ");
            }
            sb.append("</RECIPIENTS_UUID>");
        }
        sb.append(this.getXMLEndTag(this.sessionController));
        return sb.toString();
    }

    @Override
    public boolean findWithoutPath() {
        return true;
    }

    @Override
    public boolean supportsPreview() {
        return false;
    }

    @ObjDocAttribute(value="return sub xml of class for index")
    public StringBuffer getSubXmlForIndex() throws Exception {
        String noteContent = this.getContentString();
        noteContent = noteContent.replaceAll("\\<", "");
        noteContent = noteContent.replaceAll("\\>", "");
        StringBuffer sb = new StringBuffer();
        sb.append("<NOTE ID=\"" + this.getId() + "\">\n");
        sb.append("<NOTECONTENT><![CDATA[" + noteContent + "]]></NOTECONTENT>\n");
        sb.append(this.getMyAttributesAsXML());
        sb.append("</NOTE>\n");
        return sb;
    }

    public static NoteObjectClientBean createNote(String content, GlobalObjectClientBean toObject) throws Exception {
        NoteObjectSessionFacade noteSessionFacade = new NoteObjectSessionFacade(toObject.getSessionController());
        noteSessionFacade.setWithTransaction(true);
        noteSessionFacade.setNameWithId(true);
        noteSessionFacade.setParentObject(toObject);
        noteSessionFacade.setAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE, CLASS_NAME + "_$$ID$$.txt");
        noteSessionFacade.setContentStream(StringConverterUtils.toStream((String)content));
        NoteObjectClientBean note = (NoteObjectClientBean)noteSessionFacade.create();
        return note;
    }

    public GlobalObjectClientBean[] getRecipients() throws Exception {
        return this.getRightwardRelationObjects(NoteRecipientRelationObjectClientBean.CLASS_NAME);
    }

    public String[] getRecipientNames() throws Exception {
        GlobalObjectClientBean[] recipients = this.getRecipients();
        if (recipients == null) {
            return null;
        }
        int len = recipients.length;
        String[] result = new String[len];
        for (int i = 0; i < len; ++i) {
            result[i] = ((DirectoryUserObjectClientBean)recipients[i]).getFullName();
        }
        return result;
    }

    @Override
    public boolean shouldMakeHistory() {
        return false;
    }

    @Override
    public boolean countDownloadQuota() {
        return false;
    }

    @Override
    public boolean belongsToUser() throws Exception {
        GlobalObjectClientBean[] rec = this.getRecipients();
        if (rec != null) {
            for (GlobalObjectClientBean r : rec) {
                if (!r.getId().equals(this.sessionController.getLoginUserId())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public GlobalObjectClientBean getBelongingObject() throws Exception {
        GlobalObjectClientBean[] objects = this.getLeftwardRelationObjects(NoteRelationObjectClientBean.CLASS_NAME);
        if (objects != null && objects.length > 0) {
            return objects[0];
        }
        return super.getBelongingObject();
    }

    @Override
    public void fillIndexAttributes(Map<String, AttributeInfo> attributes, GlobalObjectClientBean mainObject) throws Exception {
        super.fillIndexAttributes(attributes, mainObject);
        ArrayList<Long> recipients = new ArrayList<Long>();
        ArrayList<String> recipientsUuid = new ArrayList<String>();
        GlobalObjectClientBean[] recArray = this.getRecipients();
        if (recArray != null) {
            for (GlobalObjectClientBean rec : recArray) {
                recipients.add(rec.getId());
                recipientsUuid.add(rec.getUUID());
            }
        }
        AttributeInfo.put(attributes, "recipients", recipients);
        AttributeInfo.put(attributes, "recipients_uuid", recipientsUuid);
    }

    @Override
    public DirectoryObjectClientBean getAssociatedUser() throws Exception {
        return this.getCreator();
    }

    @Override
    public String useLastAddedRelationClass() {
        return NoteRelationObjectClientBean.CLASS_NAME;
    }

    @Override
    public boolean supportsTrash() {
        return true;
    }
}

