/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.client.beans;

import agorum.roi.common.utils.JavaUtil;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.PropertyBundleObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.PropertyObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SortSpecification;
import agorum.roi.util.annotations.ObjDoc;
import agorum.roi.util.annotations.ObjDocAttribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;

@ObjDoc(groups={ObjDoc.Group.METADB}, description="Client Bean for the PropertyBundleObject Class")
public class PropertyBundleObjectClientBean
extends FolderObjectClientBean
implements Serializable {
    public static String CLASS_NAME = "PROPERTYBUNDLEOBJECT";
    public static final String DEFAULTPROPERTYNAME_ATTRIBUTE = "DEFAULTPROPERTYNAME";
    private Hashtable cache = null;
    private PropertyObjectClientBean[] allProperties = null;

    @Override
    public SuperObjectClientBeanDefinition getNewDefinition(SessionController sessionController) throws Exception {
        return new PropertyBundleObjectClientBeanDefinition(sessionController);
    }

    public void setDefaultPropertyName(String value) throws Exception {
        this.setAttribute(DEFAULTPROPERTYNAME_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    @ObjDocAttribute(value="the default property name")
    public String getDefaultPropertyName() throws Exception {
        return this.getAttribute(DEFAULTPROPERTYNAME_ATTRIBUTE).getString();
    }

    public PropertyObjectClientBean getProperty(String propertyName) throws Exception {
        if (this.cache != null && this.cache.containsKey(propertyName)) {
            return (PropertyObjectClientBean)this.cache.get(propertyName);
        }
        PropertyObjectClientBean property = null;
        try {
            property = (PropertyObjectClientBean)this.getItem(propertyName);
            if (this.cache == null) {
                this.cache = new Hashtable();
                this.cache.put(propertyName, property);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return property;
    }

    public PropertyObjectClientBean[] getAllProperties() throws Exception {
        if (this.allProperties != null) {
            return this.allProperties;
        }
        PropertyObjectClientBean[] allProperties = null;
        try {
            SortSpecification sortSpec = new SortSpecification(new String[]{PropertyObjectClientBean.CLASS_NAME}, new String[]{"PROPERTYSORTSEQUENCE"}, new int[]{2});
            this.setSortSpecification(sortSpec);
            JavaUtil ju = new JavaUtil();
            allProperties = (PropertyObjectClientBean[])ju.convertArray(this.getItems(), PropertyObjectClientBean.class.getName());
            this.allProperties = allProperties;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.allProperties;
    }

    public ArrayList getAllPropertyNames() throws Exception {
        PropertyObjectClientBean[] allProps = this.getAllProperties();
        ArrayList<String> allNames = new ArrayList<String>();
        int len = allProps.length;
        for (int i = 0; i < len; ++i) {
            allNames.add(allProps[i].getName());
        }
        return allNames;
    }

    @ObjDocAttribute(value="the default property")
    public PropertyObjectClientBean getDefaultProperty() throws Exception {
        return this.getProperty(this.getDefaultPropertyName());
    }
}

