/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.client.beans;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.commons.cache.GenericCache;
import agorum.commons.utils.CaseInsensitiveHashMap;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.InternalObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.ObjectUpdateHandler;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.ejb.common.StartupInitializer;
import agorum.roi.ejb.interfaces.remote.SuperObjectEntityRemote;
import agorum.roi.ejb.interfaces.remote.SuperObjectRemote;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

public class SuperObjectClientCachedBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Hashtable<?, ?> attributes = new Hashtable();
    private String className = null;
    private Long classId = null;
    private String uuid = null;
    private String ejbName = null;
    private Class<?> classObject = null;
    private Class<?> classObjectEJBHome = null;
    private Long id = null;
    private transient SuperObjectRemote remoteReference;
    private transient SuperObjectEntityRemote entityRemoteReference;
    private long updateCounter;
    private boolean getNoUpdateCounter;
    private boolean globalObjectOnly;
    private boolean withAttributeXMLContent;
    private Vector<?> vXMLClassNames;
    private String xmlOffset;
    private boolean transacted = false;
    private boolean deleted = false;
    public static int cacheSize;
    public static long cacheCheckTime;
    private long updateCounterExtendedAttributes = -2L;
    private CaseInsensitiveHashMap<Object> extendedAttributes = new CaseInsensitiveHashMap();
    private long updateCounterExtendedAttributesAll = -2L;
    private CaseInsensitiveHashMap<Object> extendedAttributesAll = new CaseInsensitiveHashMap();
    private long updateCounterExtendedAttributesInheritable = -2L;
    private CaseInsensitiveHashMap<Object> extendedAttributesInheritable = new CaseInsensitiveHashMap();
    private static final SuperObjectClientCachedBean WHITE_OUT;
    private static ThreadLocal<Map<Long, SuperObjectClientCachedBean>> transactionCache;
    public static long cacheHitRateGlobalObjectsCached;
    public static long cacheHitRateGlobalObjectsNotCached;
    public static long cacheHitRateInternalObjectsCached;
    public static long cacheHitRateInternalObjectsNotCached;

    public static SuperObjectClientCachedBean getFromGlobalObject(GlobalObjectClientBean gocb) {
        SuperObjectClientCachedBean cBean = new SuperObjectClientCachedBean();
        try {
            cBean.setClassName(gocb.getClassName());
            cBean.setId(gocb.getId());
            cBean.setEjbName(gocb.getJndiNameEJB());
            cBean.setUuid(gocb.getUUID());
            cBean.setClassId(gocb.getClassId());
            cBean.setUpdateCounter(gocb.getMyUpdateCounter());
            cBean.setUpdateCounterExtendedAttributes(gocb.getUpdateCounterExtendedAttributes());
            cBean.setUpdateCounterExtendedAttributesAll(gocb.getUpdateCounterExtendedAttributesAll());
            cBean.setUpdateCounterExtendedAttributesInheritable(gocb.getUpdateCounterExtendedAttributesInheritable());
            cBean.setGetNoUpdateCounter(gocb.getGetNoUpdateCounter());
            cBean.setGlobalObjectOnly(gocb.isGlobalObjectOnly());
            cBean.setWithAttributeXMLContent(gocb.isWithAttributeXMLContent());
            cBean.setvXMLClassNames(gocb.getvXMLClassNames());
            cBean.setXmlOffset(gocb.getXmlOffset());
            cBean.setClassObject(gocb.getClassObjectEJB());
            cBean.setAttributes(SuperObjectClientCachedBean.getClonedAttributes(gocb.getAttributes()));
            cBean.setExtendedAttributes(SuperObjectClientCachedBean.getClonedEAAttributes(gocb.getExtendedAttributesForCache()));
            cBean.setExtendedAttributesAll(SuperObjectClientCachedBean.getClonedEAAttributes(gocb.getExtendedAttributesAllForCache()));
            cBean.setExtendedAttributesInheritable(SuperObjectClientCachedBean.getClonedEAAttributes(gocb.getExtendedAttributesInheritableForCache()));
            if (gocb.getRemoteReference() == null) {
                throw new Exception("Missing Remote Ref");
            }
            cBean.setRemoteReference(gocb.getRemoteReference());
            cBean.setEntityRemoteReference(gocb.getEntityRemoteReference());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cBean;
    }

    public static SuperObjectClientCachedBean getFromInternalObject(InternalObjectClientBean iocb) {
        SuperObjectClientCachedBean cBean = new SuperObjectClientCachedBean();
        try {
            cBean.setClassName(iocb.getClassName());
            cBean.setId(iocb.getId());
            cBean.setEjbName(iocb.getJndiNameEJB());
            cBean.setUuid(iocb.getUUID());
            cBean.setClassId(iocb.getClassId());
            cBean.setUpdateCounter(iocb.getMyUpdateCounter());
            cBean.setGetNoUpdateCounter(iocb.getGetNoUpdateCounter());
            cBean.setGlobalObjectOnly(iocb.isGlobalObjectOnly());
            cBean.setvXMLClassNames(iocb.getvXMLClassNames());
            cBean.setXmlOffset(iocb.getXmlOffset());
            cBean.setClassObject(iocb.getClassObjectEJB());
            cBean.setAttributes(SuperObjectClientCachedBean.getClonedAttributes(iocb.getAttributes()));
            if (iocb.getRemoteReference() == null) {
                throw new Exception("Missing Remote Ref");
            }
            cBean.setRemoteReference(iocb.getRemoteReference());
            cBean.setEntityRemoteReference(iocb.getEntityRemoteReference());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cBean;
    }

    public static SuperObjectClientCachedBean get(SuperObjectClientBean cb) {
        if (cb instanceof GlobalObjectClientBean) {
            return SuperObjectClientCachedBean.getFromGlobalObject((GlobalObjectClientBean)cb);
        }
        if (cb instanceof InternalObjectClientBean) {
            return SuperObjectClientCachedBean.getFromInternalObject((InternalObjectClientBean)cb);
        }
        return null;
    }

    public void invalidateAllAttributes() {
    }

    private static Hashtable getClonedAttributes(Hashtable attrs) {
        if (attrs == null) {
            return null;
        }
        return (Hashtable)attrs.clone();
    }

    private static CaseInsensitiveHashMap<Object> getClonedEAAttributes(CaseInsensitiveHashMap<Object> attrs) {
        if (attrs == null) {
            return null;
        }
        return attrs.clone();
    }

    public GlobalObjectClientBean getGlobalObjectClientBean(SessionController sessionController) throws Exception {
        GlobalObjectClientBean clientBean = (GlobalObjectClientBean)this.getClassObject().newInstance();
        if (this.remoteReference == null) {
            throw new Exception("Missing Remote Ref 2");
        }
        clientBean.init(this.remoteReference, this.entityRemoteReference, sessionController, this.id);
        clientBean.setClassName(this.className);
        clientBean.setJndiNameEJB(this.ejbName);
        clientBean.setClassObjectEJB(this.classObject);
        clientBean.setClassObjectEJBHome(this.classObjectEJBHome);
        clientBean.setMyUpdateCounter(this.updateCounter);
        clientBean.setUpdateCounterExtendedAttributes(this.updateCounterExtendedAttributes);
        clientBean.setUpdateCounterExtendedAttributesAll(this.updateCounterExtendedAttributesAll);
        clientBean.setUpdateCounterExtendedAttributesInheritable(this.updateCounterExtendedAttributesInheritable);
        clientBean.setGetNoUpdateCounter(this.getNoUpdateCounter);
        clientBean.setGlobalObjectOnly(this.globalObjectOnly);
        clientBean.setWithAttributeXMLContent(this.withAttributeXMLContent);
        clientBean.setvXMLClassNames(this.vXMLClassNames);
        clientBean.setXmlOffset(this.xmlOffset);
        clientBean.setInitialized(true);
        clientBean.setAttributes(SuperObjectClientCachedBean.getClonedAttributes(this.attributes));
        if (this.updateCounter == this.updateCounterExtendedAttributes) {
            clientBean.setExtendedAttributesForCache(SuperObjectClientCachedBean.getClonedEAAttributes(this.extendedAttributes));
        }
        if (this.updateCounter == this.updateCounterExtendedAttributesAll) {
            clientBean.setExtendedAttributesAllForCache(SuperObjectClientCachedBean.getClonedEAAttributes(this.extendedAttributesAll));
        }
        if (this.updateCounter == this.updateCounterExtendedAttributesInheritable) {
            clientBean.setExtendedAttributesInheritableForCache(SuperObjectClientCachedBean.getClonedEAAttributes(this.extendedAttributesInheritable));
        }
        return clientBean;
    }

    public InternalObjectClientBean getInternalObjectClientBean(SessionController sessionController) throws Exception {
        InternalObjectClientBean clientBean = (InternalObjectClientBean)this.getClassObject().newInstance();
        if (this.remoteReference == null) {
            throw new Exception("Missing Remote Ref 2");
        }
        clientBean.init(this.remoteReference, this.entityRemoteReference, sessionController, this.id);
        clientBean.setClassName(this.className);
        clientBean.setJndiNameEJB(this.ejbName);
        clientBean.setClassObjectEJB(this.classObject);
        clientBean.setClassObjectEJBHome(this.classObjectEJBHome);
        clientBean.setMyUpdateCounter(this.updateCounter);
        clientBean.setGetNoUpdateCounter(this.getNoUpdateCounter);
        clientBean.setGlobalObjectOnly(this.globalObjectOnly);
        clientBean.setWithAttributeXMLContent(this.withAttributeXMLContent);
        clientBean.setvXMLClassNames(this.vXMLClassNames);
        clientBean.setXmlOffset(this.xmlOffset);
        clientBean.setInitialized(true);
        clientBean.setAttributes(SuperObjectClientCachedBean.getClonedAttributes(this.attributes));
        return clientBean;
    }

    private static Map<Long, SuperObjectClientCachedBean> getTransactionCache() {
        Map<Long, SuperObjectClientCachedBean> tCache = transactionCache.get();
        if (tCache == null && RoiTransactionHandler.isTransactionActive()) {
            tCache = new HashMap<Long, SuperObjectClientCachedBean>();
            transactionCache.set(tCache);
        }
        return tCache;
    }

    public static SuperObjectClientCachedBean getCachedBean(Long id) {
        if (!StartupInitializer.isInitialized()) {
            return null;
        }
        GenericCache gc = SuperObjectClientCachedBean.getClientBeanCache();
        if (gc != null) {
            SuperObjectClientCachedBean cachedBean = null;
            Map<Long, SuperObjectClientCachedBean> tCache = SuperObjectClientCachedBean.getTransactionCache();
            if (tCache != null && (cachedBean = tCache.get(id)) == WHITE_OUT) {
                return null;
            }
            if (cachedBean == null) {
                cachedBean = (SuperObjectClientCachedBean)gc.get((Object)id);
            }
            return cachedBean;
        }
        return null;
    }

    public static Long getId(String uuid) {
        GenericCache gc = SuperObjectClientCachedBean.getUuidCache();
        return gc == null ? null : (Long)gc.get((Object)uuid);
    }

    public static void setId(String uuid, Long id) {
        GenericCache gc = SuperObjectClientCachedBean.getUuidCache();
        if (gc != null) {
            gc.put((Object)uuid, (Object)id);
        }
    }

    public static void setCachedBean(SuperObjectClientBean cb) {
        Map<Long, SuperObjectClientCachedBean> tCache;
        GenericCache gc = SuperObjectClientCachedBean.getClientBeanCache();
        if (gc == null) {
            return;
        }
        Long id = cb.getId();
        if (cb instanceof GlobalObjectClientBean) {
            SuperObjectClientCachedBean.setId(((GlobalObjectClientBean)cb).getUUID(), id);
        }
        if ((tCache = SuperObjectClientCachedBean.getTransactionCache()) != null && tCache.containsKey(id)) {
            SuperObjectClientCachedBean.setCachedBeanTransacted(cb);
            return;
        }
        SuperObjectClientCachedBean cBean = SuperObjectClientCachedBean.get(cb);
        if (cBean != null) {
            gc.put((Object)id, (Object)cBean);
        }
    }

    public static SuperObjectClientCachedBean setCachedBeanTransacted(SuperObjectClientBean cb) {
        GenericCache gc = SuperObjectClientCachedBean.getClientBeanCache();
        if (gc == null) {
            return null;
        }
        Map<Long, SuperObjectClientCachedBean> tCache = SuperObjectClientCachedBean.getTransactionCache();
        SuperObjectClientCachedBean cBean = SuperObjectClientCachedBean.get(cb);
        if (cBean != null && tCache != null) {
            cBean.setTransacted(true);
            tCache.put(cb.getId(), cBean);
        }
        return cBean;
    }

    public static void invalidateTransactionCache(boolean invalidateMainCache) {
        GenericCache gc = SuperObjectClientCachedBean.getClientBeanCache();
        if (gc != null) {
            Map<Long, SuperObjectClientCachedBean> tCache;
            if (invalidateMainCache && (tCache = SuperObjectClientCachedBean.getTransactionCache()) != null) {
                for (Long id : tCache.keySet()) {
                    gc.remove((Object)id);
                }
            }
            transactionCache.remove();
        }
    }

    public static void invalidateCachedObject(Long id) {
        GenericCache gc = SuperObjectClientCachedBean.getClientBeanCache();
        if (gc != null) {
            Map<Long, SuperObjectClientCachedBean> tCache = SuperObjectClientCachedBean.getTransactionCache();
            if (tCache == null) {
                gc.remove((Object)id);
            } else {
                tCache.put(id, WHITE_OUT);
            }
        }
    }

    public static GenericCache getClientBeanCache() {
        SuperObjectClientCachedBean.loadCachedSize();
        GenericCache gc = GenericCache.getInstance((Object)"ClientBeanCache", (int)cacheSize, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE);
        if (cacheSize <= 0 && gc != null) {
            gc.invalidateCache();
            gc = null;
        }
        return gc;
    }

    private static GenericCache getUuidCache() {
        SuperObjectClientCachedBean.loadCachedSize();
        GenericCache gc = GenericCache.getInstance((Object)"UuidCache", (int)cacheSize, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE);
        if (cacheSize <= 0 && gc != null) {
            gc.invalidateCache();
            gc = null;
        }
        return gc;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Class<?> getClassObjectEJBHome() {
        return this.classObjectEJBHome;
    }

    public void setClassObjectEJBHome(Class<?> classObjectEJBHome) {
        this.classObjectEJBHome = classObjectEJBHome;
    }

    public Class<?> getClassObject() {
        return this.classObject;
    }

    public void setClassObject(Class<?> classObject) {
        this.classObject = classObject;
    }

    public void addExtendedAttribute(String name, AttributeValue value) {
        if (this.extendedAttributes == null) {
            this.extendedAttributes = new CaseInsensitiveHashMap();
        }
        this.extendedAttributes.put(name, (Object)value);
    }

    public void addExtendedAttributesAll(String name, AttributeValue value) {
        if (this.extendedAttributesAll == null) {
            this.extendedAttributesAll = new CaseInsensitiveHashMap();
        }
        this.extendedAttributesAll.put(name, (Object)value);
    }

    public void addExtendedAttributeInheritable(String name, AttributeValue value) {
        if (this.extendedAttributesInheritable == null) {
            this.extendedAttributesInheritable = new CaseInsensitiveHashMap();
        }
        this.extendedAttributesInheritable.put(name, (Object)value);
    }

    public Hashtable<?, ?> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Hashtable<?, ?> attributes) {
        this.attributes = attributes;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public Long getClassId() {
        return this.classId;
    }

    public void setClassId(Long classId) {
        this.classId = classId;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getEjbName() {
        return this.ejbName;
    }

    public void setEjbName(String ejbName) {
        this.ejbName = ejbName;
    }

    public CaseInsensitiveHashMap<Object> getExtendedAttributes() {
        return this.extendedAttributes;
    }

    public void setExtendedAttributes(CaseInsensitiveHashMap<Object> extendedAttributes) {
        this.extendedAttributes = extendedAttributes;
    }

    public CaseInsensitiveHashMap<Object> getExtendedAttributesAll() {
        return this.extendedAttributesAll;
    }

    public void setExtendedAttributesAll(CaseInsensitiveHashMap<Object> extendedAttributesAll) {
        this.extendedAttributesAll = extendedAttributesAll;
    }

    public CaseInsensitiveHashMap<Object> getExtendedAttributesInheritable() {
        return this.extendedAttributesInheritable;
    }

    public void setExtendedAttributesInheritable(CaseInsensitiveHashMap<Object> extendedAttributesInheritable) {
        this.extendedAttributesInheritable = extendedAttributesInheritable;
    }

    public SuperObjectRemote getRemoteReference() {
        return this.remoteReference;
    }

    public void setRemoteReference(SuperObjectRemote remoteReference) {
        this.remoteReference = remoteReference;
    }

    public SuperObjectEntityRemote getEntityRemoteReference() {
        return this.entityRemoteReference;
    }

    public void setEntityRemoteReference(SuperObjectEntityRemote entityRemoteReference) {
        this.entityRemoteReference = entityRemoteReference;
    }

    public long getUpdateCounter() {
        return this.updateCounter;
    }

    public void setUpdateCounter(long updateCounter) {
        this.updateCounter = updateCounter;
    }

    public void setUpdateCounterExtendedAttributes(long updateCounter) {
        this.updateCounterExtendedAttributes = updateCounter;
    }

    public void setUpdateCounterExtendedAttributesAll(long updateCounter) {
        this.updateCounterExtendedAttributesAll = updateCounter;
    }

    public void setUpdateCounterExtendedAttributesInheritable(long updateCounter) {
        this.updateCounterExtendedAttributesInheritable = updateCounter;
    }

    public boolean isGetNoUpdateCounter() {
        return this.getNoUpdateCounter;
    }

    public void setGetNoUpdateCounter(boolean getNoUpdateCounter) {
        this.getNoUpdateCounter = getNoUpdateCounter;
    }

    public boolean isGlobalObjectOnly() {
        return this.globalObjectOnly;
    }

    public void setGlobalObjectOnly(boolean globalObjectOnly) {
        this.globalObjectOnly = globalObjectOnly;
    }

    public boolean isWithAttributeXMLContent() {
        return this.withAttributeXMLContent;
    }

    public void setWithAttributeXMLContent(boolean withAttributeXMLContent) {
        this.withAttributeXMLContent = withAttributeXMLContent;
    }

    public Vector<?> getvXMLClassNames() {
        return this.vXMLClassNames;
    }

    public void setvXMLClassNames(Vector<?> vXMLClassNames) {
        this.vXMLClassNames = vXMLClassNames;
    }

    public String getXmlOffset() {
        return this.xmlOffset;
    }

    public void setXmlOffset(String xmlOffset) {
        this.xmlOffset = xmlOffset;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public static void loadCachedSize() {
        try {
            if (System.currentTimeMillis() - cacheCheckTime > 60000L) {
                cacheCheckTime = System.currentTimeMillis();
                SessionController sc = SessionControllerAdmin.getSessionControllerAdmin("SuperObjectCache");
                MetaDb mdb = sc.getMetaDbInstance();
                try {
                    int tmpCacheSize = Integer.parseInt(mdb.getSimplePropertyValue("MAIN_MODULE_MANAGEMENT/roi/control/superobjectcache/CacheSize")[0]);
                    if (tmpCacheSize != cacheSize) {
                        cacheSize = tmpCacheSize;
                        System.out.println("Set superobjectcache size: " + cacheSize);
                    }
                    ObjectUpdateHandler.getInstance().setCacheSize((int)((double)cacheSize * 1.2));
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        WHITE_OUT = new SuperObjectClientCachedBean();
        transactionCache = new ThreadLocal();
        cacheHitRateGlobalObjectsCached = 0L;
        cacheHitRateGlobalObjectsNotCached = 0L;
        cacheHitRateInternalObjectsCached = 0L;
        cacheHitRateInternalObjectsNotCached = 0L;
    }
}

