/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.clients;

import agorum.roi.ejb.client.beans.AttributeObjectClientBean;
import agorum.roi.ejb.client.beans.ClassObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.SessionController;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class CreateObjectWiki {
    private SessionController sessionController = null;
    private StringBuffer chapters = new StringBuffer();

    public CreateObjectWiki(SessionController sessionController) {
        this.sessionController = sessionController;
    }

    public void create() throws Exception {
        this.createWikiFromObject("GLOBALOBJECT", null, new ArrayList());
        FileOutputStream fos = new FileOutputStream(new File("c:\\objectwiki.txt"));
        fos.write(this.chapters.toString().getBytes());
        fos.close();
    }

    private void createWikiFromObject(String startObjectName, ArrayList attributes, ArrayList parentObjects) throws Exception {
        SuperObjectClientBean[] scocb;
        this.chapters.append("<NoWiki><a name=\"" + startObjectName + "\"></NoWiki>\n");
        this.chapters.append("===== " + startObjectName + " =====\n\n");
        parentObjects.add(startObjectName);
        this.chapters.append("==== Vererbungen ====\n\n");
        String off = "";
        int parentLen = parentObjects.size();
        for (int i = 0; i < parentLen; ++i) {
            String parentName = parentObjects.get(i).toString();
            this.chapters.append(off + "  * <NoWiki><a href=\"#" + parentName + "\">");
            this.chapters.append(parentName + "</a></NoWiki>\n");
            off = off + "  ";
        }
        this.chapters.append("\n\n");
        this.chapters.append("==== Attribute ====\n\n");
        ClassObjectClientBean cocb = this.sessionController.getClassObject(startObjectName);
        this.chapters.append("^ Name ^ Typ ^ Vererbt von ^\n");
        if (attributes != null) {
            int len = attributes.size();
            for (int i = 0; i < len; ++i) {
                AttributeBean attr = (AttributeBean)attributes.get(i);
                this.chapters.append("| ");
                this.chapters.append(attr.getName());
                this.chapters.append(" | ");
                this.chapters.append(attr.getType());
                this.chapters.append(" | ");
                if (attr.getParentObject() != null) {
                    this.chapters.append("<NoWiki><a href=\"#" + attr.getParentObject() + "\">");
                    this.chapters.append(attr.getParentObject());
                    this.chapters.append("</NoWiki></a>");
                }
                this.chapters.append(" |\n");
            }
        } else {
            attributes = new ArrayList<AttributeBean>();
        }
        Hashtable effectiveAttributes = cocb.getEffectiveAttributes();
        Enumeration attrEnum = effectiveAttributes.keys();
        while (attrEnum.hasMoreElements()) {
            Object key = attrEnum.nextElement();
            AttributeObjectClientBean attribute = (AttributeObjectClientBean)effectiveAttributes.get(key);
            this.chapters.append("| **");
            this.chapters.append(attribute.getName());
            this.chapters.append("** | ");
            this.chapters.append(attribute.getDataType());
            this.chapters.append(" | |\n");
            AttributeBean attr = new AttributeBean();
            attr.setName(attribute.getName());
            attr.setType(attribute.getDataType());
            attr.setParentObject(startObjectName);
            attributes.add(attr);
        }
        this.chapters.append("\n\n");
        if (cocb != null && (scocb = this.sessionController.getSuperObjectByAttribute(this.sessionController, ClassObjectClientBean.SUPERCLASS_ATTRIBUTE, cocb, false, this.sessionController.getClassObject(ClassObjectClientBean.CLASS_NAME))) != null) {
            int len = scocb.length;
            for (int i = 0; i < len; ++i) {
                if (((ClassObjectClientBean)scocb[i]).getName().equals(startObjectName)) continue;
                this.createWikiFromObject(((ClassObjectClientBean)scocb[i]).getName(), (ArrayList)attributes.clone(), (ArrayList)parentObjects.clone());
            }
        }
    }

    public static void main(String[] args) {
        System.err.println("Start");
        try {
            CredentialObject credential = new CredentialObject();
            credential.setUserName("roi");
            credential.setPassWord("agorum");
            credential.setModulInfo("CreateObjectWiki");
            SessionController sessionController = SessionController.connect(credential);
            CreateObjectWiki cow = new CreateObjectWiki(sessionController);
            cow.create();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        System.err.println("Ende Programm");
    }

    private class AttributeBean {
        private String name = null;
        private String type = null;
        private String parentObject = null;

        private AttributeBean() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getParentObject() {
            return this.parentObject;
        }

        public void setParentObject(String parentObject) {
            this.parentObject = parentObject;
        }
    }
}

