/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.AttributeValueArray;
import agorum.roi.ejb.common.AttributeValueBlob;
import agorum.roi.ejb.common.AttributeValueBoolean;
import agorum.roi.ejb.common.AttributeValueBooleanArray;
import agorum.roi.ejb.common.AttributeValueCIString;
import agorum.roi.ejb.common.AttributeValueDataBaseObjectClientBean;
import agorum.roi.ejb.common.AttributeValueDataBaseObjectClientBeanArray;
import agorum.roi.ejb.common.AttributeValueDate;
import agorum.roi.ejb.common.AttributeValueDateArray;
import agorum.roi.ejb.common.AttributeValueDirectoryObjectClientBean;
import agorum.roi.ejb.common.AttributeValueDirectoryObjectClientBeanArray;
import agorum.roi.ejb.common.AttributeValueDouble;
import agorum.roi.ejb.common.AttributeValueDoubleArray;
import agorum.roi.ejb.common.AttributeValueFloat;
import agorum.roi.ejb.common.AttributeValueFloatArray;
import agorum.roi.ejb.common.AttributeValueGlobalObjectClientBean;
import agorum.roi.ejb.common.AttributeValueGlobalObjectClientBeanArray;
import agorum.roi.ejb.common.AttributeValueInteger;
import agorum.roi.ejb.common.AttributeValueIntegerArray;
import agorum.roi.ejb.common.AttributeValueInternalObjectClientBean;
import agorum.roi.ejb.common.AttributeValueInternalObjectClientBeanArray;
import agorum.roi.ejb.common.AttributeValueLong;
import agorum.roi.ejb.common.AttributeValueLongArray;
import agorum.roi.ejb.common.AttributeValueNull;
import agorum.roi.ejb.common.AttributeValueString;
import agorum.roi.ejb.common.AttributeValueStringArray;
import agorum.roi.ejb.common.AttributeValueText;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AttributeInfo {
    public Object value;
    public DataType dataType;
    public boolean array;

    public static AttributeInfo getFromObject(Object o, DataType dataType) {
        AttributeInfo ai = new AttributeInfo();
        ai.value = o;
        ai.dataType = dataType;
        ai.array = o instanceof List;
        return ai;
    }

    public static AttributeInfo getFromObject(Object o) {
        return AttributeInfo.getFromObject(o, (AttributeValue)null);
    }

    public static AttributeInfo getFromObject(Object o, AttributeValue valueHint) {
        AttributeInfo ai = new AttributeInfo();
        ai.value = o;
        ai.array = o instanceof List || o instanceof Iterable || o instanceof Object[];
        ai.dataType = valueHint != null ? AttributeInfo.guessDataType(valueHint) : AttributeInfo.guessDataType(o);
        if (ai.dataType == null) {
            return null;
        }
        return ai;
    }

    private static DataType guessDataType(Object o) {
        if (o instanceof Iterable) {
            Iterator iter = ((Iterable)o).iterator();
            if (iter.hasNext()) {
                return AttributeInfo.guessDataType(iter.next());
            }
            return null;
        }
        if (o instanceof String) {
            return DataType.STRING;
        }
        if (o instanceof Long) {
            return DataType.LONG;
        }
        if (o instanceof Integer) {
            return DataType.INT;
        }
        if (o instanceof Date) {
            return DataType.DATE;
        }
        if (o instanceof Double) {
            return DataType.DOUBLE;
        }
        if (o instanceof Float) {
            return DataType.FLOAT;
        }
        if (o instanceof Boolean) {
            return DataType.BOOL;
        }
        return null;
    }

    private static DataType guessDataType(AttributeValue av) {
        if (av instanceof AttributeValueArray) {
            if (av instanceof AttributeValueBooleanArray) {
                return DataType.BOOL;
            }
            if (av instanceof AttributeValueGlobalObjectClientBeanArray) {
                return DataType.LONG;
            }
            if (av instanceof AttributeValueDataBaseObjectClientBeanArray) {
                return DataType.LONG;
            }
            if (av instanceof AttributeValueDateArray) {
                return DataType.DATE;
            }
            if (av instanceof AttributeValueFloatArray) {
                return DataType.FLOAT;
            }
            if (av instanceof AttributeValueDoubleArray) {
                return DataType.DOUBLE;
            }
            if (av instanceof AttributeValueInternalObjectClientBeanArray) {
                return DataType.LONG;
            }
            if (av instanceof AttributeValueDirectoryObjectClientBeanArray) {
                return DataType.LONG;
            }
            if (av instanceof AttributeValueIntegerArray) {
                return DataType.INT;
            }
            if (av instanceof AttributeValueLongArray) {
                return DataType.LONG;
            }
            if (av instanceof AttributeValueStringArray) {
                return DataType.STRING;
            }
        } else {
            if (av instanceof AttributeValueBoolean) {
                return DataType.BOOL;
            }
            if (av instanceof AttributeValueGlobalObjectClientBean) {
                return DataType.LONG;
            }
            if (av instanceof AttributeValueDataBaseObjectClientBean) {
                return DataType.LONG;
            }
            if (av instanceof AttributeValueDate) {
                return DataType.DATE;
            }
            if (av instanceof AttributeValueFloat) {
                return DataType.FLOAT;
            }
            if (av instanceof AttributeValueDouble) {
                return DataType.DOUBLE;
            }
            if (av instanceof AttributeValueLong) {
                return DataType.LONG;
            }
            if (av instanceof AttributeValueInternalObjectClientBean) {
                return DataType.LONG;
            }
            if (av instanceof AttributeValueDirectoryObjectClientBean) {
                return DataType.LONG;
            }
            if (av instanceof AttributeValueInteger) {
                return DataType.INT;
            }
            if (av instanceof AttributeValueText) {
                return DataType.TEXT;
            }
            if (av instanceof AttributeValueString) {
                return DataType.STRING;
            }
            if (av instanceof AttributeValueCIString) {
                return DataType.STRING;
            }
            if (av instanceof AttributeValueBlob) {
                return null;
            }
            if (av instanceof AttributeValueNull) {
                return null;
            }
        }
        throw new IllegalArgumentException("The given datatype is not supported: " + av.getClass().getName());
    }

    public static void put(Map<String, AttributeInfo> attributes, String name, AttributeInfo value) {
        if (!attributes.containsKey(name) && value != null) {
            attributes.put(name, value);
        }
    }

    public static void put(Map<String, AttributeInfo> attributes, String name, Object value) {
        AttributeInfo ai;
        if (value != null && (ai = AttributeInfo.getFromObject(value)) != null) {
            AttributeInfo.put(attributes, name, ai);
        }
    }

    public static void put(Map<String, AttributeInfo> attributes, String name, Object value, AttributeValue valueHint) {
        AttributeInfo ai;
        if (!attributes.containsKey(name) && value != null && (ai = AttributeInfo.getFromObject(value, valueHint)) != null) {
            attributes.put(name, ai);
        }
    }

    public static void putAsArray(Map<String, AttributeInfo> attributes, String name, Object value, AttributeValue valueHint) {
        if (value != null) {
            if (attributes.containsKey(name)) {
                AttributeInfo ai = attributes.get(name);
                DataType type = valueHint == null ? AttributeInfo.guessDataType(value) : AttributeInfo.guessDataType(valueHint);
                if (type != ai.dataType) {
                    throw new IllegalArgumentException("Data types may not be mixed within a list: " + (Object)((Object)type) + " != " + (Object)((Object)ai.dataType) + " for key " + name);
                }
                List values = (List)ai.value;
                values.add(value);
            } else {
                AttributeInfo ai = new AttributeInfo();
                ArrayList<Object> arr = new ArrayList<Object>();
                arr.add(value);
                ai.array = true;
                ai.value = arr;
                ai.dataType = valueHint != null ? AttributeInfo.guessDataType(valueHint) : AttributeInfo.guessDataType(value);
                if (ai.dataType != null) {
                    attributes.put(name, ai);
                }
            }
        }
    }

    public static void put(Map<String, AttributeInfo> attributes, String name, AttributeValue attributeValue) {
        AttributeInfo.put(attributes, name, attributeValue.getObject(), attributeValue);
    }

    public String toString() {
        return this.value.toString();
    }

    public static enum DataType {
        STRING,
        INT,
        LONG,
        DATE,
        DOUBLE,
        FLOAT,
        TEXT,
        BOOL;

    }
}

