/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.AttributeValueArray;
import agorum.roi.ejb.common.AttributeValueDBUtils;
import agorum.roi.ejb.common.ConnectionUtils;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.database.common.DatabaseInterface;
import agorum.roi.ejb.database.common.DatabaseUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class AttributeValueArrayDBUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addElement(SessionController sessionController, Connection conn, DatabaseInterface dbi, AttributeValueDBUtils attributeValueDBUtils, String tablename, String valueType, Long objectId, Long attributeId, AttributeValue av) throws Exception {
        Statement pstmt = null;
        try {
            pstmt = conn.prepareStatement("insert into " + tablename + "(" + dbi.getAVObjectIdDatabaseName() + "," + dbi.getAVAttributeIdDatabaseName() + "," + dbi.getAVSequenceDatabaseName() + "," + dbi.getAVValueDatabaseName() + ") values (?,?,?,?)");
            pstmt.setLong(1, objectId);
            pstmt.setLong(2, attributeId);
            pstmt.setLong(3, sessionController.getSequenceId());
            if (attributeValueDBUtils.setAttributeValueToStatment(sessionController, (PreparedStatement)pstmt, 4, av)) {
                ExceptionUtils.handleException("ARRAY not alowed", "agorum.roi.remote.exception.ArrayNotAllowed", 56);
            }
            pstmt.execute();
        }
        finally {
            try {
                pstmt.close();
                pstmt = null;
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertElementAt(SessionController sessionController, Connection conn, DatabaseInterface dbi, AttributeValueDBUtils attributeValueDBUtils, String tablename, String valueType, Long objectId, Long attributeId, AttributeValue av, int sequence) throws Exception {
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = conn.prepareStatement("select max(" + dbi.getAVSequenceDatabaseName() + ") from " + tablename + " where " + dbi.getAVObjectIdDatabaseName() + "=? and " + dbi.getAVAttributeIdDatabaseName() + "=?");
            pstmt.setLong(1, objectId);
            pstmt.setLong(2, attributeId);
            rs = pstmt.executeQuery();
            if (rs != null && rs.next()) {
                int max = rs.getInt(1);
                if (max + 1 >= sequence) {
                    pstmt.close();
                    pstmt = null;
                    pstmt = conn.prepareStatement("update " + tablename + " set " + dbi.getAVSequenceDatabaseName() + "=" + dbi.getAVSequenceDatabaseName() + "+1 where " + dbi.getAVObjectIdDatabaseName() + "=? and " + dbi.getAVAttributeIdDatabaseName() + "=? and " + dbi.getAVSequenceDatabaseName() + ">=?");
                    pstmt.setLong(1, objectId);
                    pstmt.setLong(2, attributeId);
                    pstmt.setInt(2, sequence);
                    pstmt.execute();
                    pstmt.close();
                    pstmt = null;
                    pstmt = conn.prepareStatement("insert into " + tablename + "(" + dbi.getAVObjectIdDatabaseName() + "," + dbi.getAVAttributeIdDatabaseName() + "," + dbi.getAVSequenceDatabaseName() + "," + dbi.getAVValueDatabaseName() + ") values (?,?,?,?)");
                    pstmt.setLong(1, objectId);
                    pstmt.setLong(2, attributeId);
                    pstmt.setLong(3, sessionController.getSequenceId());
                    if (attributeValueDBUtils.setAttributeValueToStatment(sessionController, (PreparedStatement)pstmt, 4, av)) {
                        ExceptionUtils.handleException("ARRAY not alowed", "agorum.roi.remote.exception.ArrayNotAllowed", 56);
                    }
                    pstmt.execute();
                } else {
                    ExceptionUtils.handleException("ARRAY out of bound", "agorum.roi.remote.exception.ArrayOutOfBound", 57);
                }
            }
        }
        finally {
            try {
                rs.close();
                rs = null;
            }
            catch (Exception exception) {}
            try {
                pstmt.close();
                pstmt = null;
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElement(SessionController sessionController, Connection conn, DatabaseInterface dbi, AttributeValueDBUtils attributeValueDBUtils, String tablename, String valueType, Long objectId, Long attributeId, AttributeValue av) throws Exception {
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = conn.prepareStatement("select count(*) from " + tablename + " where " + dbi.getAVObjectIdDatabaseName() + "=? and " + dbi.getAVAttributeIdDatabaseName() + "=? and " + dbi.getAVValueDatabaseName() + "=?");
            pstmt.setLong(1, objectId);
            pstmt.setLong(2, attributeId);
            if (attributeValueDBUtils.setAttributeValueToStatment(sessionController, (PreparedStatement)pstmt, 3, av)) {
                // empty if block
            }
            if ((rs = pstmt.executeQuery()) != null && rs.next() && rs.getInt(1) > 0) {
                pstmt.close();
                pstmt = null;
                pstmt = conn.prepareStatement("delete from " + tablename + " where " + dbi.getAVObjectIdDatabaseName() + "=? and " + dbi.getAVAttributeIdDatabaseName() + "=? and " + dbi.getAVValueDatabaseName() + "=?");
                pstmt.setLong(1, objectId);
                pstmt.setLong(2, attributeId);
                if (attributeValueDBUtils.setAttributeValueToStatment(sessionController, (PreparedStatement)pstmt, 3, av)) {
                    ExceptionUtils.handleException("ARRAY not alowed", "agorum.roi.remote.exception.ArrayNotAllowed", 56);
                }
                pstmt.execute();
            }
        }
        finally {
            try {
                rs.close();
                rs = null;
            }
            catch (Exception exception) {}
            try {
                pstmt.close();
                pstmt = null;
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElementAt(SessionController sessionController, Connection conn, DatabaseInterface dbi, AttributeValueDBUtils attributeValueDBUtils, String tablename, String valueType, Long objectId, Long attributeId, int sequence) throws Exception {
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = conn.prepareStatement("select count(*) from " + tablename + " where " + dbi.getAVObjectIdDatabaseName() + "=? and " + dbi.getAVAttributeIdDatabaseName() + "=? and " + dbi.getAVSequenceDatabaseName() + "=?");
            pstmt.setLong(1, objectId);
            pstmt.setLong(2, attributeId);
            pstmt.setInt(3, sequence);
            rs = pstmt.executeQuery();
            if (rs != null && rs.next() && rs.getInt(1) > 0) {
                pstmt.close();
                pstmt = null;
                pstmt = conn.prepareStatement("delete from " + tablename + " where " + dbi.getAVObjectIdDatabaseName() + "=? and " + dbi.getAVAttributeIdDatabaseName() + "=? and " + dbi.getAVSequenceDatabaseName() + "=?");
                pstmt.setLong(1, objectId);
                pstmt.setLong(2, attributeId);
                pstmt.setInt(3, sequence);
                pstmt.execute();
            }
        }
        finally {
            try {
                rs.close();
                rs = null;
            }
            catch (Exception exception) {}
            try {
                pstmt.close();
                pstmt = null;
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttributeArrayFromDB(SessionController sessionController, String tablename, String dataType, String valueType, Long objectId, Long attributeId) {
        Object[] o = null;
        ConnectionUtils cu = null;
        Connection conn = null;
        ResultSet rs = null;
        Statement pstmt = null;
        try {
            cu = new ConnectionUtils(sessionController);
            conn = cu.getConnection();
            AttributeValueDBUtils attributeValueDBUtils = new AttributeValueDBUtils();
            DatabaseInterface dbi = new DatabaseUtils().getDatabaseInterfaceImpl();
            String select = "select " + dbi.getAVValueDatabaseName() + " from " + tablename + " where  " + dbi.getAVObjectIdDatabaseName() + " = ? and " + dbi.getAVAttributeIdDatabaseName() + " = ? order by " + dbi.getAVSequenceDatabaseName() + " asc";
            pstmt = conn.prepareStatement(select);
            pstmt.setLong(1, objectId);
            pstmt.setLong(2, attributeId);
            rs = pstmt.executeQuery();
            Vector<AttributeValue> v = new Vector<AttributeValue>();
            while (rs.next()) {
                v.addElement(attributeValueDBUtils.getAttributeValueFromResultSet(sessionController, rs, dbi.getAVValueDatabaseName(), valueType));
            }
            int len = v.size();
            if (valueType.equalsIgnoreCase("BOOLEAN")) {
                Boolean[] b = new Boolean[len];
                for (int i = 0; i < len; ++i) {
                    b[i] = ((AttributeValue)v.elementAt(i)).getBoolean();
                }
                o = b;
            } else if (valueType.equalsIgnoreCase("INTEGER")) {
                Integer[] iArr = new Integer[len];
                for (int i = 0; i < len; ++i) {
                    iArr[i] = ((AttributeValue)v.elementAt(i)).getInteger();
                }
                o = iArr;
            } else if (valueType.equalsIgnoreCase("DATE")) {
                Date[] dArr = new Date[len];
                for (int i = 0; i < len; ++i) {
                    dArr[i] = ((AttributeValue)v.elementAt(i)).getDate();
                }
                o = dArr;
            } else if (valueType.equalsIgnoreCase("LONG")) {
                Long[] lArr = new Long[len];
                for (int i = 0; i < len; ++i) {
                    lArr[i] = ((AttributeValue)v.elementAt(i)).getLong();
                }
                o = lArr;
            } else if (valueType.equalsIgnoreCase("STRING")) {
                String[] sArr = new String[len];
                for (int i = 0; i < len; ++i) {
                    sArr[i] = dbi.unescapeWildCards(((AttributeValue)v.elementAt(i)).getString());
                }
                o = sArr;
            } else if (valueType.equalsIgnoreCase("CISTRING")) {
                String[] sArr = new String[len];
                for (int i = 0; i < len; ++i) {
                    sArr[i] = dbi.unescapeWildCards(((AttributeValue)v.elementAt(i)).getString());
                }
                o = sArr;
            } else if (valueType.equalsIgnoreCase("DOUBLE")) {
                Double[] dArr = new Double[len];
                for (int i = 0; i < len; ++i) {
                    dArr[i] = ((AttributeValue)v.elementAt(i)).getDouble();
                }
                o = dArr;
            } else if (valueType.equalsIgnoreCase("DATABASEOBJECT")) {
                Long[] lArr = new Long[len];
                for (int i = 0; i < len; ++i) {
                    lArr[i] = ((AttributeValue)v.elementAt(i)).getLong();
                }
                o = lArr;
            } else if (valueType.equalsIgnoreCase("INTERNALOBJECT")) {
                Long[] lArr = new Long[len];
                for (int i = 0; i < len; ++i) {
                    lArr[i] = ((AttributeValue)v.elementAt(i)).getLong();
                }
                o = lArr;
            } else if (valueType.equalsIgnoreCase("GLOBALOBJECT")) {
                Long[] lArr = new Long[len];
                for (int i = 0; i < len; ++i) {
                    lArr[i] = ((AttributeValue)v.elementAt(i)).getLong();
                }
                o = lArr;
            } else if (valueType.equalsIgnoreCase("DIRECTORYOBJECT")) {
                Long[] lArr = new Long[len];
                for (int i = 0; i < len; ++i) {
                    lArr[i] = ((AttributeValue)v.elementAt(i)).getLong();
                }
                o = lArr;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        finally {
            try {
                rs.close();
                rs = null;
            }
            catch (Exception exception) {}
            try {
                pstmt.close();
                pstmt = null;
            }
            catch (Exception exception) {}
            try {
                cu.closeConnection();
            }
            catch (Exception exception) {}
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAttributeValueArray(Connection conn, String tableName, Long objectId) throws Exception {
        Statement pstmt = null;
        try {
            DatabaseInterface dbi = new DatabaseUtils().getDatabaseInterfaceImpl();
            String delete = "delete from " + tableName + " where " + dbi.getAVObjectIdDatabaseName() + " = ?";
            pstmt = conn.prepareStatement(delete);
            pstmt.setLong(1, objectId);
            pstmt.execute();
        }
        finally {
            try {
                pstmt.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAttributeValueArrays(SessionController sessionController, SuperObjectClientBean clientBean) throws Exception {
        ConnectionUtils cu = null;
        Connection conn = null;
        try {
            cu = new ConnectionUtils(sessionController);
            conn = cu.getConnection();
            Hashtable hAllAttributes = clientBean.getAttributes();
            Hashtable<String, String> hDeleted = new Hashtable<String, String>();
            Enumeration attrEnum = hAllAttributes.elements();
            while (attrEnum.hasMoreElements()) {
                AttributeValueArray ava;
                AttributeValue av = (AttributeValue)attrEnum.nextElement();
                if (!(av instanceof AttributeValueArray) || (ava = (AttributeValueArray)av).getArrayLength() <= 0 || hDeleted.containsKey(ava.getDataType())) continue;
                this.deleteAttributeValueArray(conn, ava.getTableName(), clientBean.getId());
                hDeleted.put(ava.getDataType(), "");
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                cu.closeConnection();
            }
            catch (Exception exception) {}
        }
    }
}

