/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.commons.utils.LockHandle;
import agorum.commons.utils.LockMaster;
import agorum.roi.ejb.common.Transaction;
import java.util.ArrayList;
import java.util.List;

public class BackendLock {
    private static LockMaster<String> pool = new LockMaster();
    private static final String KEY = "BackendLock";
    public static boolean enabled = true;

    public static void acquireLock(String id, boolean exclusive) throws Exception {
        if (!enabled) {
            return;
        }
        ArrayList<LockHandle> locks = (ArrayList<LockHandle>)Transaction.get(KEY);
        if (locks == null) {
            locks = new ArrayList<LockHandle>();
            Transaction.put(KEY, locks);
        }
        locks.add(pool.lock((Object)id, exclusive));
        ArrayList<LockHandle> transactionLocks = locks;
        Transaction.afterCommit(KEY, () -> BackendLock.unlock(transactionLocks));
        Transaction.afterRollback(KEY, () -> BackendLock.unlock(transactionLocks));
    }

    public static LockHandle tryLock(String id, boolean exclusive) {
        return pool.tryLock((Object)id, exclusive);
    }

    private static void unlock(List<LockHandle> locks) {
        for (LockHandle lock : locks) {
            lock.close();
        }
    }
}

