/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.roi.ejb.client.beans.FolderRelationObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.RelationObjectClientBean;
import agorum.roi.ejb.common.RoiFileSystem;
import agorum.roi.ejb.common.SessionController;
import java.io.Serializable;
import java.util.Hashtable;

public class CheckUtils
implements Serializable {
    public boolean checkFolderRelation(SessionController sessionController, GlobalObjectClientBeanDefinition def, GlobalObjectClientBean clientBean, int relationOffset) throws Exception {
        boolean bRet = true;
        if (def != null && clientBean != null) {
            RelationObjectClientBean[] folderRel = clientBean.getLeftwardRelations(FolderRelationObjectClientBean.CLASS_NAME);
            if (folderRel != null) {
                if (folderRel.length - relationOffset <= 0) {
                    bRet = false;
                    this.setSystemOptionCounter(def, clientBean.getId(), 0L);
                } else {
                    long counter = this.getSystemOptionCounter(def, clientBean.getId());
                    if (counter == -1L) {
                        this.setSystemOptionCounter(def, clientBean.getId(), folderRel.length - relationOffset);
                    } else {
                        this.setSystemOptionCounter(def, clientBean.getId(), counter -= (long)relationOffset);
                        if (counter <= 0L) {
                            bRet = false;
                        }
                    }
                }
            } else {
                bRet = false;
            }
        }
        return bRet;
    }

    private void setSystemOptionCounter(GlobalObjectClientBeanDefinition def, Long id, long counter) throws Exception {
        Hashtable<Long, Long> objectHash = (Hashtable<Long, Long>)def.getSystemOption("ObjectDeleteToRecycling");
        if (objectHash == null) {
            objectHash = new Hashtable<Long, Long>();
            def.setSystemOption("ObjectDeleteToRecycling", objectHash);
        } else if (objectHash.containsKey(id)) {
            objectHash.remove(id);
        }
        objectHash.put(id, new Long(counter));
    }

    private long getSystemOptionCounter(GlobalObjectClientBeanDefinition def, Long id) throws Exception {
        long bRet = -1L;
        Hashtable objectHash = (Hashtable)def.getSystemOption("ObjectDeleteToRecycling");
        if (objectHash != null && objectHash.containsKey(id)) {
            bRet = (Long)objectHash.get(id);
        }
        return bRet;
    }

    public boolean checkMainObject(SessionController sessionController, GlobalObjectClientBeanDefinition def, GlobalObjectClientBean clientBean) throws Exception {
        boolean bRet = true;
        if (this.isThisTheMainObject(sessionController, def, clientBean)) {
            bRet = false;
        } else {
            long mainObjectId = clientBean.getAttribute(GlobalObjectClientBean.MAINOBJECT_ATTRIBUTE).getLong();
            long counter = this.getSystemOptionCounter(def, new Long(mainObjectId));
            if (counter == 0L) {
                bRet = false;
            }
        }
        return bRet;
    }

    public boolean isThisTheMainObject(SessionController sessionController, GlobalObjectClientBeanDefinition def, GlobalObjectClientBean clientBean) throws Exception {
        long id = clientBean.getId();
        if (clientBean.handleAsMainObject()) {
            return true;
        }
        long mainObjectId = clientBean.getAttribute(GlobalObjectClientBean.MAINOBJECT_ATTRIBUTE).getLong();
        return id == mainObjectId;
    }

    public GlobalObjectClientBean getParentFolderFromSystemOption(SessionController sessionController, Object o) throws Exception {
        RoiFileSystem rfs = new RoiFileSystem(sessionController);
        return rfs.getGlobalObject(o);
    }

    public boolean checkDeletor(SessionController sessionController, GlobalObjectClientBean clientBean) throws Exception {
        boolean doUndeleteThisObject = false;
        long deletorId = clientBean.getAttribute(GlobalObjectClientBean.DELETOR_ATTRIBUTE).getLong();
        if (sessionController.isAdminEnabled()) {
            if (deletorId > 0L) {
                doUndeleteThisObject = true;
            }
        } else if (deletorId == sessionController.getLoginUser().getId()) {
            doUndeleteThisObject = true;
        }
        return doUndeleteThisObject;
    }
}

