/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.commons.statistic.CoreStatistic;
import agorum.roi.ejb.common.ConnectionWrapper;
import agorum.roi.ejb.common.EJBHomeHolder;
import agorum.roi.ejb.common.SessionController;
import java.net.ConnectException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class ConnectionUtils {
    private Connection conn = null;
    public static long connCounter = 0L;
    public static long connGet = 0L;
    public static long connNumber = 0L;

    public ConnectionUtils(SessionController sessionController) {
    }

    public ConnectionUtils() {
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(false);
    }

    public Connection getConnection(boolean raw) throws SQLException {
        if (this.conn == null) {
            this.conn = raw ? ConnectionUtils.getConnection(this.getDataSource()) : new ConnectionWrapper(this.getDataSource());
        }
        return this.conn;
    }

    public static synchronized void incConnCounter() {
        ++connCounter;
        ++connGet;
    }

    public static synchronized void decConnCounter() {
        --connCounter;
    }

    public void closeConnection() throws Exception {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            finally {
                this.conn = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Connection getConnection(DataSource dataSource) throws SQLException {
        CoreStatistic coreStatistic = CoreStatistic.getInstance();
        String sticky = "[FATAL] Could not establish database connection";
        for (int retry = 0; retry < 10; ++retry) {
            try {
                Connection conn = dataSource.getConnection();
                if (retry > 0) {
                    coreStatistic.info().send("Connection recovered after " + retry + " retries");
                    coreStatistic.clearStickyLogEntry(sticky);
                }
                return conn;
            }
            catch (Exception sqe) {
                Exception baseExc = sqe;
                Throwable t = sqe;
                while (true) {
                    if (t.getCause() == null || t instanceof ConnectException) break;
                    t = t.getCause();
                }
                baseExc = t;
                if (baseExc instanceof ConnectException) {
                    try {
                        coreStatistic.error().sticky(sticky).exception((Throwable)sqe).detail((Object)("[FATAL] Could not establish database connection, retrying count: " + retry)).send("[FATAL] Could not establish database connection");
                        System.err.println("[FATAL] Could not establish database connection, retry: " + retry);
                        sqe.printStackTrace();
                        continue;
                    }
                    finally {
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (Exception exception) {}
                    }
                }
                throw sqe;
            }
        }
        coreStatistic.error().sticky("[FATAL] Could not establish database connection, shutting down").send("[FATAL] Could not establish database connection, shutting down");
        System.err.println("[FATAL] Could not establish database connection, shut down system, to prevent errors");
        Runtime.getRuntime().halt(1);
        return null;
    }

    private DataSource getDataSource() throws SQLException {
        DataSource ds;
        try {
            ds = (DataSource)EJBHomeHolder.getHome("java:comp/env/jdbc/RoiMySql");
        }
        catch (NamingException e) {
            throw new SQLException("DBRef does not exists");
        }
        return ds;
    }

    static {
        try {
            ((DataSource)EJBHomeHolder.getHome("java:comp/env/jdbc/RoiMySql")).setLoginTimeout(60000);
        }
        catch (Exception e) {
            System.err.println("[FATAL] Could not set DataSource login timeout");
            e.printStackTrace();
        }
    }
}

