/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.roi.ejb.common.AccessCounterUtils;
import agorum.roi.ejb.common.ContentInterface;
import agorum.roi.ejb.common.ContentTransferBean;
import agorum.roi.ejb.common.SessionController;
import java.io.IOException;
import java.io.InputStream;

public class ContentInputStreamWrapper
extends InputStream {
    private byte[] internalBuffer = null;
    private int internalBufferLen = 0;
    private int internalBufferPos = 0;
    private long blockNumber = 0L;
    private boolean bufferFilled = false;
    private ContentInterface contentInterface = null;
    private long fileSize = 0L;
    private long totalyRead = 0L;
    private long blockSize = 0L;
    private boolean isClosed = false;

    public ContentInputStreamWrapper(SessionController sessionController, ContentInterface contentInterface, long contentSize) {
        this.construct(sessionController, contentInterface, contentSize, true);
    }

    public ContentInputStreamWrapper(SessionController sessionController, ContentInterface contentInterface, long contentSize, boolean markAsRead) {
        this.construct(sessionController, contentInterface, contentSize, markAsRead);
    }

    private void construct(SessionController sessionController, ContentInterface contentInterface, long contentSize, boolean markAsRead) {
        this.fileSize = contentSize;
        this.contentInterface = contentInterface;
        try {
            contentInterface.openForRead();
            this.blockSize = contentInterface.getBlockSize();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        try {
            if (markAsRead && contentInterface.supportsAccessCounter()) {
                AccessCounterUtils acu = new AccessCounterUtils(sessionController);
                acu.sendReadEvent(contentInterface);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int i) {
        System.err.println("ContentInputStreamWrapper: Mark not supported");
    }

    @Override
    public long skip(long i) throws IOException {
        if (i <= Integer.MAX_VALUE) {
            this.skip((int)i);
            return i;
        }
        return 0L;
    }

    public Object clone() {
        System.err.println("Clone not supported");
        return null;
    }

    @Override
    public int read() throws IOException {
        byte[] tmpBuf = new byte[1];
        int read = this.read(tmpBuf, 0, 1);
        if (read == -1) {
            return -1;
        }
        return tmpBuf[0] & 0xFF;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int pos, int len) throws IOException {
        try {
            int read = 0;
            for (int i = pos; i < pos + len; ++i) {
                if (!this.bufferFilled || this.internalBufferPos >= this.internalBufferLen) {
                    ContentTransferBean ctb = this.contentInterface.getBuffer(this.blockNumber, this.fileSize);
                    if (ctb == null) {
                        return -1;
                    }
                    if (ctb.isFilled()) {
                        this.internalBuffer = ctb.getBuffer();
                        this.internalBufferPos = 0;
                        this.internalBufferLen = ctb.getBufferLength();
                        ++this.blockNumber;
                        this.bufferFilled = true;
                    } else {
                        this.bufferFilled = false;
                    }
                }
                if (!this.bufferFilled) break;
                if (buffer != null) {
                    buffer[i] = this.internalBuffer[this.internalBufferPos];
                }
                ++this.internalBufferPos;
                ++this.totalyRead;
                ++read;
            }
            return read == 0 ? -1 : read;
        }
        catch (Exception e) {
            IOException ioException = new IOException(e.getMessage());
            ioException.initCause(e);
            throw ioException;
        }
    }

    @Override
    public void reset() throws IOException {
        this.blockNumber = 0L;
        this.internalBufferPos = 0;
        this.bufferFilled = false;
        this.isClosed = false;
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed) {
            this.isClosed = true;
            try {
                this.contentInterface.closeForRead();
                this.internalBuffer = null;
            }
            catch (Exception e) {
                IOException ioException = new IOException(e.getMessage());
                ioException.initCause(e);
                throw ioException;
            }
        }
    }

    @Override
    public int available() throws IOException {
        return (int)(this.fileSize - this.totalyRead);
    }

    public void skip(int len) throws IOException {
        this.totalyRead += (long)len;
        int newInternalBufferPos = this.internalBufferPos + len;
        if (newInternalBufferPos > this.internalBufferLen) {
            this.bufferFilled = false;
            this.blockNumber += (long)(len -= this.internalBufferLen - this.internalBufferPos) / this.blockSize;
            try {
                ContentTransferBean ctb = this.contentInterface.getBuffer(this.blockNumber, this.fileSize);
                if (ctb.isFilled()) {
                    this.internalBuffer = ctb.getBuffer();
                    this.internalBufferPos = len % (int)this.blockSize;
                    this.internalBufferLen = ctb.getBufferLength();
                    ++this.blockNumber;
                } else {
                    throw new Exception("Read past EOF");
                }
                this.bufferFilled = true;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        } else {
            this.internalBufferPos = newInternalBufferPos;
        }
    }

    public long getBlockSize() {
        return this.blockSize;
    }
}

