/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.roi.ejb.common.ContentInterface;
import agorum.roi.ejb.common.ContentTransferBean;
import agorum.roi.ejb.common.SessionController;
import java.io.IOException;
import java.io.OutputStream;

public class ContentOutputStreamWrapper
extends OutputStream {
    private byte[] internalBuffer = null;
    private int internalBufferLen = 0;
    private int internalBufferPos = 0;
    private long blockNumber = 0L;
    private boolean bufferFilled = false;
    private SessionController sessionController = null;
    private ContentInterface contentInterface = null;
    private long lastWriteTime = System.currentTimeMillis();

    public ContentOutputStreamWrapper(SessionController sessionController, ContentInterface contentInterface) throws Exception {
        this.internalBuffer = new byte[(int)contentInterface.getBlockSize()];
        this.internalBufferLen = this.internalBuffer.length;
        this.sessionController = sessionController;
        this.contentInterface = contentInterface;
        contentInterface.openTransfer();
    }

    public ContentOutputStreamWrapper(SessionController sessionController, ContentInterface contentInterface, boolean makeHistory) throws Exception {
        this.internalBuffer = new byte[(int)contentInterface.getBlockSize()];
        this.internalBufferLen = this.internalBuffer.length;
        this.sessionController = sessionController;
        this.contentInterface = contentInterface;
        contentInterface.openTransfer(makeHistory);
    }

    @Override
    public void flush() throws IOException {
        try {
            if (this.internalBufferPos > 0) {
                byte[] tmpBuf = null;
                if (this.internalBufferPos >= this.internalBufferLen) {
                    tmpBuf = this.internalBuffer;
                } else {
                    tmpBuf = new byte[this.internalBufferPos];
                    System.arraycopy(this.internalBuffer, 0, tmpBuf, 0, this.internalBufferPos);
                }
                ContentTransferBean ctb = new ContentTransferBean(tmpBuf, this.internalBufferPos);
                ctb.setModifiedLength(this.internalBufferPos);
                ctb.setFirstBytePos(0L);
                this.contentInterface.transferContent(ctb, this.blockNumber, false);
                tmpBuf = null;
                this.internalBufferPos = 0;
                ++this.blockNumber;
            }
        }
        catch (Exception e) {
            IOException ioException = new IOException(e.getMessage());
            ioException.initCause(e);
            throw ioException;
        }
    }

    @Override
    public void write(int oneByte) throws IOException {
        byte[] tmpBuf = new byte[]{(byte)oneByte};
        this.write(tmpBuf, 0, 1);
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void write(byte[] buffer, int pos, int len) throws IOException {
        int length;
        int amntToWrite = len;
        int tmpPos = pos;
        do {
            if (this.internalBufferPos >= this.internalBufferLen) {
                this.flush();
            }
            if ((length = this.internalBufferLen - this.internalBufferPos) > amntToWrite) {
                length = amntToWrite;
            }
            System.arraycopy(buffer, tmpPos, this.internalBuffer, this.internalBufferPos, length);
            this.internalBufferPos += length;
            tmpPos += length;
        } while ((amntToWrite -= length) > 0);
    }

    @Override
    public void close() throws IOException {
        this.flush();
        try {
            this.contentInterface.closeTransfer();
            this.internalBuffer = null;
        }
        catch (Exception e) {
            IOException ioException = new IOException(e.getMessage());
            ioException.initCause(e);
            throw ioException;
        }
    }
}

