/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.commons.string.StringUtils;
import agorum.roi.ejb.client.beans.FileObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.MailObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.common.ContentInterface;
import agorum.roi.ejb.common.ContentTaskInterface;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.parser.mail.EmlParser;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ContentTaskEmlConverter
implements ContentTaskInterface {
    @Override
    public void runTask(SessionController sessionController, ContentInterface contentInterface, boolean doDelete) throws Exception {
        if (((GlobalObjectClientBean)((Object)contentInterface)).isPrivateWorkingCopy()) {
            return;
        }
        if (((GlobalObjectClientBean)((Object)contentInterface)).getClassName().equalsIgnoreCase(FileObjectClientBean.CLASS_NAME)) {
            Object tmpFile = null;
            try {
                FolderObjectClientBean folder = null;
                try {
                    folder = ((GlobalObjectClientBean)((Object)contentInterface)).getParents()[0];
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (folder != null) {
                    String orgName = ((GlobalObjectClientBean)((Object)contentInterface)).getName();
                    String mailStatus = "inbox";
                    EmlParser emlParser = new EmlParser(sessionController);
                    emlParser.setDestinationFolder(folder);
                    emlParser.setInputStream(contentInterface.getContentStream());
                    emlParser.setMailStatus(mailStatus);
                    MailObjectClientBean mailObject = emlParser.doParse();
                    emlParser.cleanUp();
                    ContentTaskEmlConverter.rename(sessionController, mailObject, orgName, folder, contentInterface);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public static void rename(SessionController sessionController, MailObjectClientBean mailObject, String orgName, FolderObjectClientBean folder, ContentInterface contentInterface) throws Exception {
        block20: {
            String inReplyTo;
            String oldName = ((GlobalObjectClientBean)((Object)contentInterface)).getName();
            ((GlobalObjectClientBean)((Object)contentInterface)).setName(oldName + "_" + contentInterface.getId());
            String newName = ContentTaskEmlConverter.setNewName(sessionController, mailObject, orgName, folder);
            ((GlobalObjectClientBean)((Object)contentInterface)).setMainObject(mailObject);
            if (oldName.equals(newName)) {
                ((GlobalObjectClientBean)((Object)contentInterface)).deleteDeferred();
            } else {
                ((GlobalObjectClientBean)((Object)contentInterface)).setName(oldName);
                ((GlobalObjectClientBean)((Object)contentInterface)).deleteDeferred(false);
            }
            boolean moveReplyMail = false;
            boolean linkAttachments = false;
            try {
                if (orgName.startsWith("ac_auto_attachments_")) {
                    moveReplyMail = true;
                    linkAttachments = true;
                } else if (orgName.startsWith("ac_auto_")) {
                    moveReplyMail = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (moveReplyMail && (inReplyTo = mailObject.getInReplayTo()) != null && inReplyTo.trim().length() > 0) {
                try {
                    SuperObjectClientBean[] mails = sessionController.getSuperObjectByAttribute(sessionController, "RFC822MESSAGEID", inReplyTo, false, sessionController.getClassObject(MailObjectClientBean.CLASS_NAME));
                    if (mails == null) break block20;
                    boolean done = false;
                    for (SuperObjectClientBean mail : mails) {
                        if (!mail.getId().equals(mailObject.getId())) {
                            GlobalObjectClientBean mailObj = (GlobalObjectClientBean)mail;
                            FolderObjectClientBean[] parentsNew = ((GlobalObjectClientBean)mail).getParents();
                            FolderObjectClientBean[] parentsOld = mailObject.getParents();
                            if (parentsNew != null) {
                                if (parentsOld != null) {
                                    for (FolderObjectClientBean parent : parentsOld) {
                                        parent.removeItem(mailObject);
                                    }
                                }
                                if (parentsNew != null) {
                                    for (FolderObjectClientBean parent : parentsNew) {
                                        GlobalObjectClientBean[] mailAtta;
                                        parent.addItem(mailObject);
                                        mailObject.setAcl(parent.getAcl());
                                        if (!linkAttachments || (mailAtta = mailObject.getMailAttachments()) == null) continue;
                                        for (GlobalObjectClientBean atta : mailAtta) {
                                            String newAttaName = atta.findUniqueNameInFolder(parentsNew);
                                            if (newAttaName != null) {
                                                atta.setName(newAttaName);
                                            }
                                            parent.addItem(atta);
                                        }
                                    }
                                }
                                done = true;
                            }
                        }
                        if (!done) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static String setNewName(SessionController sessionController, MailObjectClientBean mailObject, String orgName, FolderObjectClientBean parent) throws Exception {
        String newNameTemplate = null;
        try {
            MetaDb metaDb = sessionController.getMetaDbInstance();
            newNameTemplate = metaDb.getSimplePropertyValue("MAIN_MODULE_MANAGEMENT/roi/control/contenttask/EML/NewName")[0];
        }
        catch (Throwable metaDb) {
            // empty catch block
        }
        if (newNameTemplate != null) {
            String extension = orgName.substring(orgName.lastIndexOf(".") + 1);
            String nameWOExt = orgName.substring(0, orgName.lastIndexOf("."));
            String subject = mailObject.getSubject();
            Date createDate = mailObject.getCreateDate();
            Date sentDate = mailObject.getSentDate();
            newNameTemplate = ContentTaskEmlConverter.getNewName(newNameTemplate, extension, nameWOExt, subject, createDate, sentDate, mailObject.getId());
            StringUtils su = new StringUtils();
            newNameTemplate = su.strReplaceToFilename(newNameTemplate);
            String ext = newNameTemplate.substring(newNameTemplate.lastIndexOf(".") + 1);
            String name = newNameTemplate.substring(0, newNameTemplate.lastIndexOf("."));
            int counter = 1;
            while (parent.hasItem(newNameTemplate)) {
                newNameTemplate = name + " (" + counter + ")." + ext;
                ++counter;
            }
            mailObject.setName(newNameTemplate);
            return newNameTemplate;
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            ContentTaskEmlConverter ctec = new ContentTaskEmlConverter();
            String nameTmpl = "${CreateDate:yyyy.MM.dd_HHmm}_${SentDate:yyyy.MM.dd_HHmm}_${Subject}_${Id} [${OriginalName}].${Extension}";
            String name = ContentTaskEmlConverter.getNewName(nameTmpl, "eml", "Testmail123", "Dies ist eine Testmail", new Date(), new Date(1000000000000L), new Long(123456L));
            System.out.println("Name: " + name);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private static String getNewName(String newNameTemplate, String extension, String nameWOExt, String subject, Date createDate, Date sentDate, Long id) throws Exception {
        int ind;
        String frmt;
        String srchCreateDate = null;
        String fmtCreateDate = null;
        String srchSentDate = null;
        String fmtSentDate = null;
        if (newNameTemplate.indexOf("${CreateDate:") != -1) {
            frmt = newNameTemplate;
            ind = frmt.indexOf("${CreateDate:");
            srchCreateDate = frmt.substring(ind, ind + 13);
            frmt = frmt.substring(ind + 13);
            frmt = frmt.substring(0, frmt.indexOf("}"));
            srchCreateDate = srchCreateDate + frmt + "}";
            fmtCreateDate = frmt;
        }
        if (newNameTemplate.indexOf("${SentDate:") != -1) {
            frmt = newNameTemplate;
            ind = frmt.indexOf("${SentDate:");
            srchSentDate = frmt.substring(ind, ind + 11);
            frmt = frmt.substring(ind + 11);
            frmt = frmt.substring(0, frmt.indexOf("}"));
            srchSentDate = srchSentDate + frmt + "}";
            fmtSentDate = frmt;
        }
        SimpleDateFormat sdfSD = null;
        if (fmtSentDate != null) {
            sdfSD = new SimpleDateFormat(fmtSentDate);
        }
        SimpleDateFormat sdfCD = null;
        if (fmtCreateDate != null) {
            sdfCD = new SimpleDateFormat(fmtCreateDate);
        }
        StringUtils su = new StringUtils();
        newNameTemplate = su.strReplace(newNameTemplate, "${Subject}", subject);
        newNameTemplate = su.strReplace(newNameTemplate, "${Extension}", extension);
        if (sdfCD != null) {
            newNameTemplate = su.strReplace(newNameTemplate, srchCreateDate, sdfCD.format(createDate));
        }
        if (sdfSD != null) {
            newNameTemplate = su.strReplace(newNameTemplate, srchSentDate, sdfSD.format(sentDate));
        }
        newNameTemplate = su.strReplace(newNameTemplate, "${OriginalName}", nameWOExt);
        newNameTemplate = su.strReplace(newNameTemplate, "${Id}", "" + id);
        return newNameTemplate;
    }
}

