/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.roi.ejb.common.EventAssistanceBean;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.ejb.database.common.DatabaseInterface;
import agorum.roi.ejb.database.common.DatabaseUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Hashtable;

public class EventAssistanceUtils {
    private Connection connection = null;
    private int BITINROW = 63;
    private Hashtable bitHash = null;
    private DatabaseInterface dbi = null;

    public EventAssistanceUtils(Connection connection) throws Exception {
        this.connection = connection;
        this.dbi = new DatabaseUtils().getDatabaseInterfaceImpl();
    }

    public int getRowNumber(int userId) {
        return (userId - this.getBitNumber(userId)) / this.BITINROW;
    }

    public int getBitNumber(int userId) {
        return userId % this.BITINROW;
    }

    public void initBitHash() {
        this.bitHash = new Hashtable();
    }

    public void deleteExpirationObjects() throws Exception {
        try (PreparedStatement pstmt = this.connection.prepareStatement(this.dbi.getEAStatement1());){
            int holdTimeInDays = new RoiProperties().getEventAssistanceLifeTime();
            long expirationdate = this.getDateToDB(holdTimeInDays);
            System.err.println("expirationdate = " + expirationdate);
            pstmt.setLong(1, expirationdate);
            pstmt.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ArrayList getUserIds(int userId, int amount) throws Exception {
        return this.getUserIds(userId, amount, null, 0L);
    }

    public ArrayList getUserIds(int userId, int amount, String[] classNames, long after) throws Exception {
        ArrayList<EventAssistanceBean> al = new ArrayList<EventAssistanceBean>();
        String stmt = this.dbi.getEAStatement2(classNames, after);
        int v1 = 0;
        long v2 = 0L;
        try (PreparedStatement pstmt = this.connection.prepareStatement(stmt);){
            v1 = this.getRowNumber(userId);
            v2 = this.getBitNumber(userId);
            pstmt.setInt(1, v1);
            v2 = 1L << (int)v2;
            pstmt.setLong(2, v2);
            try (ResultSet rs = pstmt.executeQuery();){
                for (int counter = 0; rs.next() && counter < amount; ++counter) {
                    EventAssistanceBean eab = new EventAssistanceBean();
                    eab.setId(new Long(rs.getLong(1)));
                    eab.setType(rs.getString(2));
                    eab.setClassName(rs.getString(3));
                    al.add(eab);
                }
            }
        }
        catch (Exception e) {
            System.err.println("STMT: " + stmt + ", " + v1 + ", " + v2);
            e.printStackTrace(System.err);
        }
        return al;
    }

    public void deleteUserFromId(int userId, long Id) throws Exception {
        try (PreparedStatement pstmt1 = this.connection.prepareStatement(this.dbi.getEAStatement3());){
            pstmt1.setLong(1, Id);
            pstmt1.setInt(2, this.getRowNumber(userId));
            pstmt1.execute();
            try (PreparedStatement pstmt = this.connection.prepareStatement(this.dbi.getEAStatement4());){
                long v1 = this.getBitNumber(userId);
                v1 = 1L << (int)v1;
                pstmt.setLong(1, v1);
                pstmt.setLong(2, v1);
                pstmt.setInt(3, this.getRowNumber(userId));
                pstmt.setLong(4, Id);
                pstmt.execute();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addUserToId(int userId, long id) throws Exception {
        this.initBitHash();
        this.setBitHash(userId);
        EventAssistanceBean eab = new EventAssistanceBean();
        eab.setId(new Long(id));
        eab.setType("updateObjectListener");
        String className = SessionControllerAdmin.getSessionControllerAdmin("EventAssistanceUtils").getGlobalObjectById(new Long(id)).getClassName();
        eab.setClassName(className);
        this.insertBitHashToDB(eab, false);
    }

    public void deleteUserFromAllIds(int userId) throws Exception {
        try (PreparedStatement pstmt1 = this.connection.prepareStatement(this.dbi.getEAStatement5());){
            pstmt1.setInt(1, this.getRowNumber(userId));
            pstmt1.execute();
            try (PreparedStatement pstmt = this.connection.prepareStatement(this.dbi.getEAStatement6());){
                long v1 = this.getBitNumber(userId);
                v1 = 1L << (int)v1;
                pstmt.setLong(1, v1);
                pstmt.setLong(2, v1);
                pstmt.setInt(3, this.getRowNumber(userId));
                pstmt.execute();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setBitHash(int userId) {
        Long row = new Long(this.getRowNumber(userId));
        BitValue bv = null;
        if (this.bitHash.containsKey(row)) {
            bv = (BitValue)this.bitHash.get(row);
        } else {
            bv = new BitValue();
            this.bitHash.put(row, bv);
        }
        bv.addBit(this.getBitNumber(userId));
    }

    public void deleteId(long id) throws Exception {
        try (PreparedStatement pstmt = this.connection.prepareStatement(this.dbi.getEAStatement7());){
            pstmt.setLong(1, id);
            pstmt.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertBitHashToDB(EventAssistanceBean eab, boolean isCustomValue) throws Exception {
        Statement pstmtSelect = null;
        Statement pstmtInsert = null;
        Statement pstmtUpdate = null;
        try {
            pstmtSelect = this.connection.prepareStatement(this.dbi.getEAStatement9());
            pstmtInsert = this.connection.prepareStatement(this.dbi.getEAStatement8());
            pstmtUpdate = isCustomValue ? this.connection.prepareStatement(this.dbi.getEAStatement11()) : this.connection.prepareStatement(this.dbi.getEAStatement10());
            pstmtSelect.setLong(1, eab.getId());
            ResultSet existingSubIdsResult = pstmtSelect.executeQuery();
            HashSet<Long> existingSubIds = new HashSet<Long>();
            BitValue empty = new BitValue();
            while (existingSubIdsResult.next()) {
                Long subId = new Long(existingSubIdsResult.getLong(1));
                existingSubIds.add(subId);
                if (this.bitHash.containsKey(subId)) continue;
                this.bitHash.put(subId, empty);
            }
            long expirationdate = this.getDateToDB(0);
            Enumeration keyEnum = this.bitHash.keys();
            while (keyEnum.hasMoreElements()) {
                Long key = (Long)keyEnum.nextElement();
                BitValue bv = (BitValue)this.bitHash.get(key);
                if (existingSubIds.contains(key)) {
                    if (isCustomValue) {
                        pstmtUpdate.setLong(1, bv.getBitValue());
                        pstmtUpdate.setLong(2, bv.getBitValue());
                        pstmtUpdate.setLong(3, expirationdate);
                        pstmtUpdate.setString(4, eab.getType());
                        pstmtUpdate.setLong(5, eab.getId());
                        pstmtUpdate.setLong(6, key);
                        pstmtUpdate.addBatch();
                        continue;
                    }
                    pstmtUpdate.setLong(1, bv.getBitValue());
                    pstmtUpdate.setLong(2, expirationdate);
                    pstmtUpdate.setString(3, eab.getType());
                    pstmtUpdate.setLong(4, eab.getId());
                    pstmtUpdate.setLong(5, key);
                    pstmtUpdate.addBatch();
                    continue;
                }
                pstmtInsert.setLong(1, eab.getId());
                pstmtInsert.setLong(2, key);
                pstmtInsert.setLong(3, bv.getBitValue());
                pstmtInsert.setLong(4, isCustomValue ? bv.getBitValue() : 0L);
                pstmtInsert.setLong(5, expirationdate);
                pstmtInsert.setString(6, eab.getType());
                pstmtInsert.setString(7, eab.getClassName());
                pstmtInsert.addBatch();
            }
            pstmtUpdate.executeBatch();
            pstmtUpdate.clearBatch();
            pstmtInsert.executeBatch();
            pstmtInsert.clearBatch();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        finally {
            try {
                pstmtSelect.close();
                pstmtSelect = null;
                pstmtInsert.close();
                pstmtInsert = null;
                pstmtUpdate.close();
                pstmtUpdate = null;
            }
            catch (Exception exception) {}
        }
    }

    public int getHashCount() {
        return this.bitHash.size();
    }

    public long getDateToDB(int day) {
        Date d = new Date();
        return this.getDateToDB(d, day);
    }

    private long getDateToDB(Date d, int day) {
        GregorianCalendar gc = new GregorianCalendar(d.getYear() + 1900, d.getMonth(), d.getDate() - day, d.getHours(), d.getMinutes(), d.getSeconds());
        long dbdate = gc.getTime().getTime();
        return dbdate;
    }

    public void printBitHash() {
        Enumeration keyEnum = this.bitHash.keys();
        while (keyEnum.hasMoreElements()) {
            Long key = (Long)keyEnum.nextElement();
            BitValue bitValue = (BitValue)this.bitHash.get(key);
        }
    }

    private class BitValue {
        private long bitValue = 0L;

        public long getBitValue() {
            return this.bitValue;
        }

        public void setBitValue(long bitValue) {
            this.bitValue = bitValue;
        }

        public void addBit(int bit) {
            this.bitValue |= 1L << bit;
        }
    }
}

