/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.commons.cron.SystemTimer;
import agorum.roi.ejb.common.JMSEventListenerBean;
import agorum.roi.ejb.messaging.common.MessageBean;
import agorum.roi.ejb.messaging.common.MessageUtils;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.Message;

public class JMSEventController
implements Runnable {
    public static JMSEventController jmsEventController = null;
    public static final int CHECK_INTERVAL_TIME = 60000;
    public static final int RECEIVE_TIME = 60000;
    private Hashtable eventListeners = new Hashtable();

    public static synchronized JMSEventController getInstance() {
        if (jmsEventController == null) {
            jmsEventController = new JMSEventController();
            SystemTimer.ofPeriod((long)15000L).name("JMSEventControllerTimer").call((Runnable)jmsEventController);
        }
        return jmsEventController;
    }

    public synchronized void registerListener(JMSEventListenerBean jmsEventListenerBean) throws Exception {
        System.err.println("Registering listener: " + jmsEventListenerBean.getId());
    }

    private synchronized void deRegisterListener(JMSEventListenerBean jmsEventListenerBean) {
        this.eventListeners.remove(jmsEventListenerBean.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Hashtable hashtable = this.eventListeners;
        synchronized (hashtable) {
            Hashtable el = (Hashtable)this.eventListeners.clone();
            Enumeration keys = el.keys();
            while (keys.hasMoreElements()) {
                JMSEventListenerBean eventBean = (JMSEventListenerBean)el.get(keys.nextElement());
                long actTime = System.currentTimeMillis();
                if (eventBean.getRemoveEvent()) {
                    System.err.println("Removeing Event bean: " + eventBean.getId());
                    this.deRegisterListener(eventBean);
                    continue;
                }
                if (eventBean.getLastCheckTime() != -1L && actTime - eventBean.getLastCheckTime() > 60000L) {
                    System.err.println("Checking Event bean: " + eventBean.getId());
                    eventBean.setLastCheckTime(-1L);
                    eventBean.setEventReceived(false);
                    eventBean.setLastAnswerTime(actTime);
                    eventBean.getJmsEventListener().sendCheckEvent();
                }
                if (eventBean.getLastCheckTime() != -1L) continue;
                if (eventBean.getEventReceived()) {
                    System.err.println("Received Event: " + eventBean.getId());
                    eventBean.setLastCheckTime(actTime);
                    continue;
                }
                if (actTime - eventBean.getLastAnswerTime() <= 60000L) continue;
                System.err.println("Timedout: " + eventBean.getId());
                eventBean.getJmsEventListener().reconnectEvent();
                eventBean.setLastCheckTime(actTime);
            }
        }
    }

    public boolean checkMyEvent(JMSEventListenerBean jmsBean, Message msg) {
        try {
            if (msg.getObjectProperty("eventType").equals("checkEvent")) {
                if (msg.getObjectProperty("value").equals(jmsBean.getId())) {
                    jmsBean.setEventReceived(true);
                }
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void sendMyEvent(JMSEventListenerBean jmsBean, String eventType) {
        try {
            MessageUtils messageUtils = new MessageUtils();
            MessageBean mb = this.buildMyEvent(jmsBean, eventType);
            messageUtils.publishToTopic(eventType, mb, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MessageBean buildMyEvent(JMSEventListenerBean jmsBean, String eventType) {
        try {
            MessageBean mb = new MessageBean();
            mb.setObjectProperty("value", jmsBean.getId());
            mb.setObjectProperty("eventType", "checkEvent");
            return mb;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

