/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.commons.encrypt.ntlm.DesEncryption;
import agorum.commons.encrypt.ntlm.NTLMEncryption;
import agorum.commons.string.StringUtils;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.EmailUserProfileObjectClientBean;
import agorum.roi.ejb.common.BaseCredentialManager;
import agorum.roi.ejb.common.CredentialCallerBean;
import agorum.roi.ejb.common.CredentialConfig;
import agorum.roi.ejb.common.CredentialInfoBean;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.CredentialPasswordBean;
import agorum.roi.ejb.common.LDapCreateUserInfo;
import agorum.roi.ejb.common.SessionController;
import java.security.MessageDigest;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import sun.misc.BASE64Encoder;

public class LDapCredentialManager
extends BaseCredentialManager {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkCredentialInternal(Connection conn, CredentialObject credential) throws Exception {
        boolean b = false;
        Context context = null;
        try {
            CredentialConfig config = LDapCredentialManager.getCredentialConfig(credential.getCredentialManager());
            context = this.getConnection(config);
            CredentialInfoBean infoBean = this.getCredentialInfo(config, credential.getUserName(), (DirContext)context);
            if (infoBean != null && (infoBean.getPassWord().equals(credential.getPassWord()) || infoBean.getLmPassWord().equals(credential.getPassWord()))) {
                b = true;
            }
        }
        finally {
            try {
                context.close();
            }
            catch (Exception exception) {}
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createCredentialInternal(SessionController sessionController, CredentialObject credential, String ntlmPassWord, Connection conn, CredentialCallerBean credentialCaller) throws Exception {
        Context context = null;
        try {
            CredentialConfig config = LDapCredentialManager.getCredentialConfig(credential.getCredentialManager());
            context = this.getConnection(config);
            LDapCreateUserInfo userInfo = new LDapCreateUserInfo();
            userInfo.setUserName(credential.getUserName().toUpperCase());
            userInfo.setPassWord(ntlmPassWord);
            userInfo.setLmPassWord(credential.getPassWord());
            userInfo.setNtPassWord(null);
            userInfo.setPath("");
            this.createOrUpdateUser(sessionController, config, (DirContext)context, userInfo);
        }
        finally {
            try {
                context.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteCredentialInternal(SessionController sessionController, String distinguisheName, Connection conn) throws Exception {
        Context context = null;
        try {
            CredentialConfig config = LDapCredentialManager.getCredentialConfig(this.credentialManagerName);
            String baseDN = config.getParameters().get("baseDN");
            context = this.getConnection(config);
            SearchControls sc = new SearchControls();
            sc.setSearchScope(2);
            NamingEnumeration<SearchResult> n1 = context.search(baseDN, "(cn=" + distinguisheName.toUpperCase() + ")", sc);
            if (n1 != null && n1.hasMore()) {
                SearchResult item = n1.next();
                String p = item.getName();
                String oldPath = null;
                if (p.indexOf(",") != -1) {
                    oldPath = p.substring(p.indexOf(",") + 1);
                    oldPath = oldPath + ",";
                } else {
                    oldPath = "";
                }
                DirContext orgPath = (DirContext)context.lookup(oldPath + baseDN);
                orgPath.destroySubcontext("cn=" + distinguisheName.toUpperCase());
            }
        }
        finally {
            try {
                context.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changePasswordInternal(SessionController sessionController, String distinguisheName, String password, String lmPassword, String ntPassword, Connection conn, CredentialCallerBean credentialCaller) throws Exception {
        Context context = null;
        try {
            CredentialConfig config = LDapCredentialManager.getCredentialConfig(this.credentialManagerName);
            context = this.getConnection(config);
            LDapCreateUserInfo userInfo = new LDapCreateUserInfo();
            userInfo.setUserName(distinguisheName.toUpperCase());
            userInfo.setNewUserName(distinguisheName.toUpperCase());
            userInfo.setPassWord(password);
            userInfo.setLmPassWord(lmPassword);
            userInfo.setNtPassWord(ntPassword);
            this.createOrUpdateUser(sessionController, config, (DirContext)context, userInfo);
        }
        finally {
            try {
                context.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeDistinguisheNameInternal(SessionController sessionController, String distinguisheNameNew, String distinguisheNameOld, Connection conn, CredentialCallerBean credentialCaller) throws Exception {
        Context context = null;
        try {
            CredentialConfig config = LDapCredentialManager.getCredentialConfig(this.credentialManagerName);
            context = this.getConnection(config);
            LDapCreateUserInfo userInfo = new LDapCreateUserInfo();
            userInfo.setUserName(distinguisheNameOld.toUpperCase());
            userInfo.setNewUserName(distinguisheNameNew.toUpperCase());
            this.createOrUpdateUser(sessionController, config, (DirContext)context, userInfo);
        }
        finally {
            try {
                context.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNtPassword(SessionController sessionController, String distinguisheName) throws Exception {
        long time = System.currentTimeMillis();
        this.checkAccess(sessionController, distinguisheName);
        System.err.println("getNtPassword 1: " + (System.currentTimeMillis() - time));
        time = System.currentTimeMillis();
        Context context = null;
        String ntPassword = null;
        try {
            CredentialConfig config = LDapCredentialManager.getCredentialConfig(this.credentialManagerName);
            context = this.getConnection(config);
            CredentialInfoBean infoBean = this.getCredentialInfo(config, distinguisheName.toUpperCase(), (DirContext)context);
            ntPassword = infoBean.getNtPassWord();
        }
        finally {
            try {
                context.close();
            }
            catch (Exception exception) {}
        }
        System.err.println("getNtPassword 2: " + (System.currentTimeMillis() - time));
        return ntPassword;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String setNtPassword(SessionController sessionController, String distinguisheName, String encodedNtPassword) throws Exception {
        this.checkAccess(sessionController, distinguisheName);
        Context context = null;
        try {
            CredentialConfig config = LDapCredentialManager.getCredentialConfig(this.credentialManagerName);
            context = this.getConnection(config);
            LDapCreateUserInfo userInfo = new LDapCreateUserInfo();
            userInfo.setUserName(distinguisheName.toUpperCase());
            userInfo.setNtPassWord(encodedNtPassword);
            this.createOrUpdateUser(sessionController, config, (DirContext)context, userInfo);
        }
        finally {
            try {
                context.close();
            }
            catch (Exception exception) {}
        }
        return encodedNtPassword;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changePasswordToDes(SessionController sessionController, String distinguisheName) throws Exception {
        this.checkAccess(sessionController, distinguisheName);
        Context context = null;
        try {
            String ntlmHash;
            StringUtils stringUtils = new StringUtils();
            CredentialConfig config = LDapCredentialManager.getCredentialConfig(this.credentialManagerName);
            context = this.getConnection(config);
            CredentialInfoBean infoBean = this.getCredentialInfo(config, distinguisheName.toUpperCase(), (DirContext)context);
            String lmHash = infoBean.getLmPassWord();
            String password = ntlmHash = infoBean.getPassWord();
            if (lmHash == null || lmHash.length() == 0) {
                String ngosPassword = this.getEncodedNTPassword(sessionController, password, distinguisheName);
                DesEncryption des = new DesEncryption();
                lmHash = des.getBaseDESPassword(password);
                NTLMEncryption ntlm = new NTLMEncryption();
                ntlmHash = stringUtils.toHexString(ntlm.getNTLMHash(password));
                LDapCreateUserInfo userInfo = new LDapCreateUserInfo();
                userInfo.setUserName(distinguisheName.toUpperCase());
                userInfo.setPassWord(ntlmHash);
                userInfo.setLmPassWord(lmHash);
                userInfo.setNtPassWord(ngosPassword);
                this.createOrUpdateUser(sessionController, config, (DirContext)context, userInfo);
            }
        }
        finally {
            try {
                context.close();
            }
            catch (Exception exception) {}
        }
    }

    public DirContext getConnection(CredentialConfig config) throws Exception {
        String adminDn = config.getParameters().get("adminDN");
        String adminPw = config.getParameters().get("adminPassWord");
        String authMethod = config.getParameters().get("authMethod");
        String url = config.getParameters().get("url");
        String contextFactory = config.getParameters().get("initialContextFactory");
        Hashtable<String, String> authEnv = new Hashtable<String, String>(11);
        authEnv.put("java.naming.factory.initial", contextFactory);
        authEnv.put("java.naming.provider.url", url);
        authEnv.put("java.naming.security.authentication", authMethod);
        authEnv.put("java.naming.security.principal", adminDn);
        authEnv.put("java.naming.security.credentials", adminPw);
        InitialDirContext authContext = new InitialDirContext(authEnv);
        return authContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CredentialPasswordBean getPasswordHashes(Connection conn, CredentialObject credential) throws Exception {
        CredentialPasswordBean bean = new CredentialPasswordBean();
        Context context = null;
        try {
            CredentialConfig config = LDapCredentialManager.getCredentialConfig(this.credentialManagerName);
            context = this.getConnection(config);
            CredentialInfoBean infoBean = this.getCredentialInfo(config, credential.getUserName().toUpperCase(), (DirContext)context);
            bean.setNtlmHash(infoBean.getPassWord());
            bean.setLmHash(infoBean.getLmPassWord());
            bean.setNgosPassword(infoBean.getNtPassWord());
        }
        finally {
            try {
                context.close();
            }
            catch (Exception exception) {}
        }
        return bean;
    }

    private CredentialInfoBean getCredentialInfo(CredentialConfig config, String userName, DirContext authContext) throws Exception {
        CredentialInfoBean credInfo = null;
        String baseDn = config.getParameters().get("baseDN");
        SearchControls sc = new SearchControls();
        sc.setSearchScope(2);
        NamingEnumeration<SearchResult> n1 = authContext.search(baseDn, "(cn=" + userName + ")", sc);
        System.err.println("CN : " + n1.toString());
        if (n1 == null) {
            System.err.println("No item in the name list");
        } else {
            while (n1.hasMore()) {
                SearchResult item = n1.next();
                Attributes attrs = item.getAttributes();
                credInfo = new CredentialInfoBean();
                String path = this.convertToNgfsPath(config, item.getName(), true);
                credInfo.setPath(path);
                Attribute pwAttr = attrs.get("ngfsPassword");
                credInfo.setPassWord((String)pwAttr.get());
                pwAttr = attrs.get("lmPassword");
                credInfo.setLmPassWord((String)pwAttr.get());
                pwAttr = attrs.get("ntPassword");
                credInfo.setNtPassWord((String)pwAttr.get());
                credInfo.setUserName(userName);
            }
        }
        return credInfo;
    }

    private String correctPath(String path) {
        if (path != null && path.length() > 0 && !path.endsWith(",")) {
            path = path + ",";
        }
        return path;
    }

    private void createOrganizationalUnit(CredentialConfig config, DirContext authContext, String path, String groupName) throws Exception {
        try {
            String baseDN = config.getParameters().get("baseDN");
            path = this.correctPath(path);
            BasicAttributes attrs = new BasicAttributes();
            BasicAttribute ouAttr = new BasicAttribute("ou", groupName);
            attrs.put(ouAttr);
            BasicAttribute ocAttr = new BasicAttribute("objectClass");
            ocAttr.add("top");
            ocAttr.add("organizationalUnit");
            attrs.put(ocAttr);
            DirContext dirContext = authContext.createSubcontext("ou=" + groupName + "," + path + baseDN, (Attributes)attrs);
        }
        catch (NameAlreadyBoundException nameAlreadyBoundException) {
            // empty catch block
        }
    }

    private String convertToLdapPath(CredentialConfig config, String ngfsPath) {
        String cnUsers;
        String sep = "";
        String result = "";
        if (config.getParameters().containsKey("cnUsers") && (cnUsers = config.getParameters().get("cnUsers")) != null && cnUsers.length() > 0) {
            result = cnUsers;
            sep = ",";
        }
        StringTokenizer stt = new StringTokenizer(ngfsPath, "/");
        while (stt.hasMoreElements()) {
            String piece = (String)stt.nextElement();
            result = "ou=" + piece + sep + result;
            sep = ",";
        }
        result = this.correctPath(result);
        return result;
    }

    private String convertToNgfsPath(CredentialConfig config, String ldapPath, boolean removeLeadingCN) {
        if (removeLeadingCN && ldapPath.indexOf(",") != -1) {
            ldapPath = ldapPath.substring(ldapPath.indexOf(",") + 1);
        } else if (removeLeadingCN) {
            ldapPath = "";
        }
        if (config.getParameters().containsKey("cnUsers")) {
            String cnUsers = config.getParameters().get("cnUsers");
            if (ldapPath.toUpperCase().endsWith(cnUsers.toUpperCase())) {
                ldapPath = ldapPath.substring(0, ldapPath.lastIndexOf(cnUsers));
            }
        }
        String sep = "";
        String result = "";
        StringTokenizer st = new StringTokenizer(ldapPath, ",");
        while (st.hasMoreElements()) {
            String piece = st.nextToken();
            if (piece.length() <= 0) continue;
            piece = piece.substring(piece.indexOf(61) + 1);
            result = piece + sep + result;
            sep = "/";
        }
        return result;
    }

    private String createAllPaths(CredentialConfig config, DirContext authContext, String path) throws Exception {
        String cnUsers;
        String sep = "";
        String result = "";
        if (config.getParameters().containsKey("cnUsers") && (cnUsers = config.getParameters().get("cnUsers")) != null && cnUsers.length() > 0) {
            this.createOrganizationalUnit(config, authContext, result, cnUsers.substring(cnUsers.indexOf(61) + 1));
            result = cnUsers;
            sep = ",";
        }
        StringTokenizer stt = new StringTokenizer(path, "/");
        while (stt.hasMoreElements()) {
            String piece = (String)stt.nextElement();
            this.createOrganizationalUnit(config, authContext, result, piece);
            result = "ou=" + piece + sep + result;
            sep = ",";
        }
        result = this.correctPath(result);
        return result;
    }

    public void createOrUpdateUser(SessionController sessionController, CredentialConfig config, DirContext authContext, LDapCreateUserInfo userInfo) throws Exception {
        BasicAttributes attrs;
        String baseDN = config.getParameters().get("baseDN");
        String path = null;
        if (userInfo.getPath() != null) {
            path = this.createAllPaths(config, authContext, userInfo.getPath());
        }
        boolean create = true;
        String oldPath = null;
        DirContext orgUser = null;
        Context orgPath = null;
        SearchControls sc = new SearchControls();
        sc.setSearchScope(2);
        NamingEnumeration<SearchResult> n1 = authContext.search(baseDN, "(cn=" + userInfo.getUserName() + ")", sc);
        if (n1 != null && n1.hasMore()) {
            SearchResult item = n1.next();
            System.err.println(item.getClass().getName());
            System.err.println("Path: " + item.getName());
            String p = item.getName();
            if (p.indexOf(",") != -1) {
                oldPath = p.substring(p.indexOf(",") + 1);
                oldPath = oldPath + ",";
            } else {
                oldPath = "";
            }
            orgUser = (DirContext)authContext.lookup(p + "," + baseDN);
            orgPath = (DirContext)authContext.lookup(oldPath + baseDN);
            create = false;
        }
        if (create) {
            Object al;
            BasicAttribute pwAttr;
            if (path == null) {
                path = this.createAllPaths(config, authContext, "");
            }
            attrs = new BasicAttributes();
            BasicAttribute ocAttr = new BasicAttribute("objectClass");
            ocAttr.add("top");
            ocAttr.add("organizationalRole");
            ocAttr.add("simpleSecurityObject");
            ocAttr.add("ngfsSamAccount");
            attrs.put(ocAttr);
            BasicAttribute cnAttr = new BasicAttribute("cn", userInfo.getUserName());
            attrs.put(cnAttr);
            if (userInfo.getPassWord() != null) {
                pwAttr = new BasicAttribute("userPassword", this.getMd5Pw(sessionController, userInfo.getNtPassWord(), userInfo.getUserName(), userInfo.getPassWord()).getBytes());
                attrs.put(pwAttr);
                BasicAttribute ngfsPwAttr = new BasicAttribute("ngfsPassword", userInfo.getPassWord());
                attrs.put(ngfsPwAttr);
            } else {
                pwAttr = new BasicAttribute("userPassword", "");
                attrs.put(pwAttr);
            }
            if (userInfo.getLmPassWord() != null) {
                BasicAttribute lmAttr = new BasicAttribute("lmPassword", userInfo.getLmPassWord());
                attrs.put(lmAttr);
            }
            if (userInfo.getNtPassWord() != null) {
                BasicAttribute ntAttr = new BasicAttribute("ntPassword", userInfo.getNtPassWord());
                attrs.put(ntAttr);
            }
            if (userInfo.getMailAdresses() != null) {
                al = userInfo.getMailAdresses();
                int len = ((ArrayList)al).size();
                BasicAttribute ntAttr = new BasicAttribute("mail");
                for (int i = 0; i < len; ++i) {
                    ntAttr.add((String)((ArrayList)al).get(i));
                }
                attrs.put(ntAttr);
            }
            al = authContext.createSubcontext("cn=" + userInfo.getUserName() + "," + path + baseDN, (Attributes)attrs);
        } else {
            BasicAttribute pwAttr;
            attrs = new BasicAttributes();
            if (path != null && !path.equals(oldPath)) {
                DirContext newPath = (DirContext)authContext.lookup(path + baseDN);
                newPath.bind("cn=" + userInfo.getUserName(), orgUser);
                orgPath.unbind("cn=" + userInfo.getUserName());
                oldPath = path;
            }
            String userName = userInfo.getUserName();
            if (userInfo.getNewUserName() != null && !userInfo.getNewUserName().equals(userName)) {
                authContext.rename("cn=" + userName + "," + oldPath + baseDN, "cn=" + userInfo.getNewUserName() + "," + oldPath + baseDN);
                userName = userInfo.getNewUserName();
            }
            if (userInfo.getPassWord() != null) {
                pwAttr = new BasicAttribute("userPassword", this.getMd5Pw(sessionController, userInfo.getNtPassWord(), userInfo.getUserName(), null).getBytes());
                attrs.put(pwAttr);
            }
            if (userInfo.getPassWord() != null) {
                pwAttr = new BasicAttribute("ngfsPassword", userInfo.getPassWord());
                attrs.put(pwAttr);
            }
            if (userInfo.getLmPassWord() != null) {
                BasicAttribute lmAttr = new BasicAttribute("lmPassword", userInfo.getLmPassWord());
                attrs.put(lmAttr);
            }
            if (userInfo.getNtPassWord() != null) {
                BasicAttribute ntAttr = new BasicAttribute("ntPassword", userInfo.getNtPassWord());
                attrs.put(ntAttr);
            }
            if (userInfo.getMailAdresses() != null) {
                ArrayList al = userInfo.getMailAdresses();
                int len = al.size();
                BasicAttribute ntAttr = new BasicAttribute("mail");
                for (int i = 0; i < len; ++i) {
                    ntAttr.add((String)al.get(i));
                }
                attrs.put(ntAttr);
            }
            authContext.modifyAttributes("cn=" + userName + "," + oldPath + baseDN, 2, (Attributes)attrs);
        }
    }

    public String getMd5Pw(SessionController sessionController, String pw, String userName, String clearPw) throws Exception {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        pw = clearPw == null ? sessionController.getDecodedSystemPassword(userName) : clearPw;
        byte[] salt = new byte[]{};
        Object label = null;
        md5.reset();
        md5.update(pw.getBytes());
        md5.update(salt);
        byte[] pwhash = md5.digest();
        String s = "{MD5}" + new String(new BASE64Encoder().encode(pwhash));
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CredentialInfoBean getCredentialInfo(SessionController sessionController, String distinguisheName) throws Exception {
        this.checkAccess(sessionController, distinguisheName);
        Context context = null;
        CredentialInfoBean credInfo = new CredentialInfoBean();
        try {
            CredentialConfig config = LDapCredentialManager.getCredentialConfig(this.credentialManagerName);
            context = this.getConnection(config);
            CredentialInfoBean infoBean = this.getCredentialInfo(config, distinguisheName.toUpperCase(), (DirContext)context);
            if (infoBean != null) {
                credInfo.setPassWord(infoBean.getPassWord());
                credInfo.setLmPassWord(infoBean.getLmPassWord());
                credInfo.setNtPassWord(infoBean.getNtPassWord());
                credInfo.setUserName(infoBean.getUserName());
                credInfo.setPath(infoBean.getPath());
            } else {
                System.err.println("ERROR: LDAP User not found: " + distinguisheName);
                credInfo = null;
            }
        }
        finally {
            try {
                context.close();
            }
            catch (Exception exception) {}
        }
        return credInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCredentialInfo(SessionController sessionController, CredentialInfoBean credentialInfo) throws Exception {
        this.checkAccess(sessionController, credentialInfo.getUserName().toUpperCase());
        Context context = null;
        try {
            CredentialConfig config = LDapCredentialManager.getCredentialConfig(this.credentialManagerName);
            context = this.getConnection(config);
            LDapCreateUserInfo userInfo = new LDapCreateUserInfo();
            userInfo.setUserName(credentialInfo.getUserName().toUpperCase());
            userInfo.setNtPassWord(credentialInfo.getNtPassWord());
            userInfo.setLmPassWord(credentialInfo.getLmPassWord());
            userInfo.setPassWord(credentialInfo.getPassWord());
            userInfo.setPath(credentialInfo.getPath());
            DirectoryUserObjectClientBean user = sessionController.getUserByName(credentialInfo.getUserName());
            ArrayList<String> al = new ArrayList<String>();
            EmailUserProfileObjectClientBean[] profiles = user.getEmailUserProfiles();
            if (profiles != null) {
                int len = profiles.length;
                for (int i = 0; i < len; ++i) {
                    al.add(profiles[i].getEmailAddress());
                }
            }
            userInfo.setMailAdresses(al);
            this.createOrUpdateUser(sessionController, config, (DirContext)context, userInfo);
        }
        finally {
            try {
                context.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePaths(SessionController sessionController, String userName) throws Exception {
        Context context = null;
        try {
            CredentialConfig config = LDapCredentialManager.getCredentialConfig(this.credentialManagerName);
            context = this.getConnection(config);
            LDapCreateUserInfo userInfo = new LDapCreateUserInfo();
            String path = LDapCredentialManager.getPathOfUser(sessionController, userName.toUpperCase());
            if (path != null) {
                userInfo.setUserName(userName.toUpperCase());
                userInfo.setPath(path);
                this.createOrUpdateUser(sessionController, config, (DirContext)context, userInfo);
            }
        }
        finally {
            try {
                context.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateUser(DirectoryUserObjectClientBean user) throws Exception {
        Context context = null;
        try {
            CredentialConfig config = LDapCredentialManager.getCredentialConfig(this.credentialManagerName);
            context = this.getConnection(config);
            LDapCreateUserInfo userInfo = new LDapCreateUserInfo();
            ArrayList<String> al = new ArrayList<String>();
            EmailUserProfileObjectClientBean[] profiles = user.getEmailUserProfiles();
            if (profiles != null) {
                int len = profiles.length;
                for (int i = 0; i < len; ++i) {
                    al.add(profiles[i].getEmailAddress());
                }
            }
            userInfo.setUserName(user.getName().toUpperCase());
            userInfo.setMailAdresses(al);
            this.createOrUpdateUser(user.getSessionController(), config, (DirContext)context, userInfo);
        }
        finally {
            try {
                context.close();
            }
            catch (Exception exception) {}
        }
    }
}

