/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.commons.logging.Log;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.SessionController;

public class LockUtils {
    private static void checkLockNoAdmin(SessionController sessionController, GlobalObjectClientBean go) throws Exception {
        if (!sessionController.isAdminEnabled()) {
            LockUtils.checkLock(sessionController, go);
        }
    }

    private static void checkLock(SessionController sessionController, GlobalObjectClientBean go) throws Exception {
        if (LockUtils.checkIsLocked(sessionController, go)) {
            ExceptionUtils.handleException("Object is locked", "agorum.roi.remote.exception.LockException", 106);
        }
    }

    public static void checkLock(SessionController sessionController, SuperObjectClientBean clientBean, SuperObjectClientBeanDefinition definition) throws Exception {
        int newLockState;
        GlobalObjectClientBean gocb = (GlobalObjectClientBean)clientBean;
        AttributeValue av = null;
        if (definition != null) {
            av = definition.getAttribute(GlobalObjectClientBean.LOCKSTATE_ATTRIBUTE);
        }
        if (av != null && (newLockState = av.getInteger()) == 0) {
            definition.setAttribute(GlobalObjectClientBean.LOCKEDFOR_ATTRIBUTE, AttributeValue.newAttributeValueObject(new Long(0L)));
        }
        LockUtils.checkLockNoAdmin(sessionController, gocb);
        if (av != null) {
            newLockState = av.getInteger();
            if (newLockState == 4) {
                definition.setAttribute(GlobalObjectClientBean.LOCKEDFOR_ATTRIBUTE, AttributeValue.newAttributeValueObject(sessionController.getSessionId()));
            } else if (newLockState == 1) {
                definition.setAttribute(GlobalObjectClientBean.LOCKEDFOR_ATTRIBUTE, AttributeValue.newAttributeValueObject(sessionController.getLoginUserId()));
            } else if (newLockState == 8) {
                if (!sessionController.isAdminEnabled()) {
                    ExceptionUtils.handleException("Shared lock can only be set by an admin", "agorum.roi.remote.exception.LockException", 106);
                }
                definition.setAttribute(GlobalObjectClientBean.LOCKEDFOR_ATTRIBUTE, AttributeValue.newAttributeValueObject(sessionController.getLoginUserId()));
            }
        }
    }

    public static boolean checkIsLocked(GlobalObjectClientBean go, boolean ignoreSharedLock) {
        return LockUtils.checkIsLocked(go.getSessionController(), go, ignoreSharedLock);
    }

    public static boolean checkIsLocked(GlobalObjectClientBean go) {
        return LockUtils.checkIsLocked(go.getSessionController(), go, false);
    }

    public static boolean checkIsLocked(SessionController sessionController, GlobalObjectClientBean go) {
        return LockUtils.checkIsLocked(sessionController, go, false);
    }

    public static boolean checkIsLocked(SessionController sessionController, GlobalObjectClientBean go, boolean ignoreSharedLock) {
        try {
            int lockState = go.getLockState();
            if (ignoreSharedLock && lockState == 8) {
                return false;
            }
            if (lockState == 1) {
                Long lockUserId = go.getAttribute(GlobalObjectClientBean.LOCKEDFOR_ATTRIBUTE).getLong();
                if (lockUserId <= 0L) {
                    lockUserId = go.getLastModifier().getId();
                }
                return !lockUserId.equals(sessionController.getLoginUserId());
            }
            if (lockState == 4) {
                return !go.isLockedForSession();
            }
            return lockState == 8;
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return true;
        }
    }
}

