/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.commons.logging.Log;
import agorum.commons.utils.ReloadablePropertyResourceBundle;
import agorum.roi.ejb.common.MetaDbSuperCache;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.searchengine.IndexHelper;

public class LuceneProperties {
    private static ReloadablePropertyResourceBundle property = null;
    private static long lastLoadTime = 0L;
    private static long timerOffset = 20000L;
    private SessionController sessionController;

    public LuceneProperties() {
        LuceneProperties.init();
    }

    public LuceneProperties(SessionController sc) {
        try {
            if (sc != null) {
                this.sessionController = sc;
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        LuceneProperties.init();
    }

    private static synchronized void init() {
        long currentTime = System.currentTimeMillis();
        if (lastLoadTime < currentTime) {
            lastLoadTime = currentTime + timerOffset;
            property = (ReloadablePropertyResourceBundle)ReloadablePropertyResourceBundle.getResourceBundle((String)"agorum.roi.properties.Roi");
        }
    }

    public boolean indexEnabled() {
        return this.getBoolean("MAIN_MODULE_MANAGEMENT/textindexservice/control/textindexenabled", true);
    }

    public boolean realtimeIndexEnabled() {
        return this.getBoolean("MAIN_MODULE_MANAGEMENT/textindexservice/control/realtimeindexenabled", true);
    }

    public boolean contentIndexEnabled() {
        return this.getBoolean("MAIN_MODULE_MANAGEMENT/textindexservice/control/contentindexenabled", true);
    }

    private boolean getBoolean(String path, boolean defaultValue) {
        try {
            String[] values = MetaDbSuperCache.getSimplePropertyValues(this.sessionController, path);
            if (values != null && values.length > 0) {
                return Boolean.parseBoolean(values[0]);
            }
        }
        catch (Exception e) {
            Log.warning((Throwable)e);
        }
        return defaultValue;
    }

    public String getSearchDelims() {
        return MetaDbSuperCache.getSimplePropertyValue(this.sessionController, "MAIN_MODULE_MANAGEMENT/textindexservice/control/syncdata/search/SearchDelims", "( )+-~\"^{}");
    }

    public String getLeftTruncateChars() {
        return MetaDbSuperCache.getSimplePropertyValue(this.sessionController, "MAIN_MODULE_MANAGEMENT/textindexservice/control/syncdata/search/LeftTruncateChars", "a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z,0,1,2,3,4,5,6,7,8,9");
    }

    public int getOptimizedFactor() {
        return Integer.parseInt(MetaDbSuperCache.getSimplePropertyValue(this.sessionController, "MAIN_MODULE_MANAGEMENT/textindexservice/control/syncdata/indexer/OptimizedFactor", "50000"));
    }

    public int getContentTransferBufferSize() {
        int iRet = 6;
        try {
            iRet = Integer.parseInt(property.getString("agorum.roi.lucene.buildindex.content.transfer.buffer.Size"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return iRet * 1024 <= 0 ? 1024 : iRet * 1024;
    }

    public long getBuildIndexMinWaitTime() {
        return Integer.parseInt(MetaDbSuperCache.getSimplePropertyValue(this.sessionController, "MAIN_MODULE_MANAGEMENT/textindexservice/control/totextindex/BuildIndexMinWaitTime", "300"));
    }

    public long getBuildIndexMaxWaitTime() {
        return Integer.parseInt(MetaDbSuperCache.getSimplePropertyValue(this.sessionController, "MAIN_MODULE_MANAGEMENT/textindexservice/control/totextindex/BuildIndexMaxWaitTime", "300"));
    }

    public int getBuildIndexBufferdDocuments() {
        return Integer.parseInt(MetaDbSuperCache.getSimplePropertyValue(this.sessionController, "MAIN_MODULE_MANAGEMENT/textindexservice/control/totextindex/BuildIndexBufferdDocuments", "1000"));
    }

    public int getMergeFactor() {
        return Integer.parseInt(MetaDbSuperCache.getSimplePropertyValue(this.sessionController, "MAIN_MODULE_MANAGEMENT/textindexservice/control/syncdata/indexer/MergeFactor", "10000"));
    }

    public int getMaxMergeDocs() {
        return Integer.parseInt(MetaDbSuperCache.getSimplePropertyValue(this.sessionController, "MAIN_MODULE_MANAGEMENT/textindexservice/control/syncdata/indexer/MaxMergeDocs", "2147483647"));
    }

    public int getMaxFieldLength() {
        return Integer.parseInt(MetaDbSuperCache.getSimplePropertyValue(this.sessionController, "MAIN_MODULE_MANAGEMENT/textindexservice/control/syncdata/indexer/MaxFieldLength", "1000000"));
    }

    public int getMaxDocumentsByTransaction() {
        return Integer.parseInt(IndexHelper.getIndexHandler().getIndexSettings(this.sessionController, "MaxDocumentsByTransaction", "500"));
    }

    public boolean getExportIndexFSOnly() {
        return Boolean.parseBoolean(MetaDbSuperCache.getSimplePropertyValue(this.sessionController, "MAIN_MODULE_MANAGEMENT/textindexservice/control/syncdata/indexer/ExportIndexFSOnly", "false"));
    }

    public boolean getTextIndexStoreContent() {
        return Boolean.parseBoolean(MetaDbSuperCache.getSimplePropertyValue(this.sessionController, "MAIN_MODULE_MANAGEMENT/textindexservice/control/syncdata/indexer/StoreContent", "false"));
    }

    public int getTextIndexMaxHits() {
        return Integer.parseInt(MetaDbSuperCache.getSimplePropertyValue(this.sessionController, "MAIN_MODULE_MANAGEMENT/textindexservice/control/syncdata/search/MaxHits", "-1"));
    }
}

