/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.commons.string.StringUtils;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.MailSearchBean;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.interfaces.mailsearch.MailSearchInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;

public class MailSearchUtils {
    private SessionController sessionController = null;

    public MailSearchUtils(SessionController sessionController) {
        this.sessionController = sessionController;
    }

    public ArrayList getMailAddresse(String query) throws Exception {
        int len;
        ArrayList alResult = null;
        StringUtils su = new StringUtils();
        String asteriskClasses = "";
        if (query.indexOf("*") >= 0) {
            query = su.strReplace(query, "*", "");
            asteriskClasses = "Asterisk";
        }
        String[] allClasses = null;
        MetaDb mdb = null;
        try {
            mdb = this.sessionController.getMetaDbInstance();
            allClasses = mdb.getSimplePropertyValue("MAIN_MODULE_MANAGEMENT/roi/control/mailsearch/" + asteriskClasses + "Classes");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (allClasses != null && (len = allClasses.length) > 0) {
            Hashtable h = new Hashtable();
            for (int i = 0; i < len; ++i) {
                String className = allClasses[i];
                try {
                    Class<?> c = Class.forName(className);
                    MailSearchInterface mailSearchInterface = (MailSearchInterface)c.newInstance();
                    long time = System.currentTimeMillis();
                    ArrayList al = mailSearchInterface.getMailAddresses(this.sessionController, query);
                    System.err.println("Time for: " + className + ": " + (System.currentTimeMillis() - time));
                    this.fillHashFromList(al, h);
                    continue;
                }
                catch (Exception c) {
                    // empty catch block
                }
            }
            long time = System.currentTimeMillis();
            ArrayList alTmp = this.fillHashToArrayList(h);
            alResult = this.filterOutArrayLists(alTmp, query);
            ResultSortComparator comp = new ResultSortComparator();
            Collections.sort(alResult, comp);
            System.err.println("Time for rest: " + (System.currentTimeMillis() - time));
        }
        return alResult;
    }

    public void fillHashFromList(ArrayList al, Hashtable h) throws Exception {
        int count = al.size();
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                ArrayList alRow = (ArrayList)al.get(i);
                MailSearchBean mailSearchBean = new MailSearchBean();
                AttributeValue av = (AttributeValue)alRow.get(0);
                String s = av.getString();
                if (s != null && !s.equalsIgnoreCase("null")) {
                    mailSearchBean.setFirstName(s);
                }
                if ((s = (av = (AttributeValue)alRow.get(1)).getString()) != null && !s.equalsIgnoreCase("null")) {
                    mailSearchBean.setName(s);
                }
                if ((s = (av = (AttributeValue)alRow.get(2)).getString()) == null || s.equalsIgnoreCase("null") || s.length() <= 0) continue;
                mailSearchBean.setMailAddress(s);
                h.put(mailSearchBean.getCompleteAddress(), mailSearchBean);
            }
        }
    }

    private ArrayList filterOutArrayLists(ArrayList al, String search) {
        ArrayList<MailSearchBean> resultList = new ArrayList<MailSearchBean>();
        String[] patterns = search.split(" ");
        int len = al.size();
        int lenPatterns = patterns.length;
        for (int i = 0; i < len; ++i) {
            MailSearchBean mailSearchBean = (MailSearchBean)al.get(i);
            String s = mailSearchBean.getCompleteAddress();
            boolean matches = true;
            for (int p = 0; p < lenPatterns; ++p) {
                String pattern = patterns[p].toLowerCase();
                if (s.toLowerCase().indexOf(pattern) != -1) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            resultList.add(mailSearchBean);
        }
        return resultList;
    }

    public ArrayList fillHashToArrayList(Hashtable h) throws Exception {
        ArrayList alRet = new ArrayList();
        int len = h.size();
        if (len > 0) {
            Enumeration enumH = h.elements();
            while (enumH.hasMoreElements()) {
                alRet.add(enumH.nextElement());
            }
        }
        return alRet;
    }

    private class ResultSortComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            int iRet = 0;
            try {
                MailSearchBean msb1 = (MailSearchBean)o1;
                MailSearchBean msb2 = (MailSearchBean)o2;
                String s1 = msb1.getName();
                String s2 = msb2.getName();
                s1 = s1 == null ? msb1.getMailAddress() : s1;
                s2 = s2 == null ? msb2.getMailAddress() : s2;
                iRet = s1.toUpperCase().compareTo(s2.toUpperCase());
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            return iRet;
        }
    }
}

