/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.QuotaHandlerInterface;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.exception.QuotaReachedException;

public class QuotaHelper {
    public static QuotaHandlerInterface quotaHandler = null;
    public static boolean loaded = false;

    public static synchronized QuotaHandlerInterface getInstance() {
        if (!loaded) {
            loaded = true;
            try {
                quotaHandler = (QuotaHandlerInterface)Class.forName("agorum.quota.common.QuotaHandlerImpl").newInstance();
            }
            catch (Exception e) {
                System.out.println("Quota module is not installed");
            }
        }
        return quotaHandler;
    }

    public static boolean isQuotaReached(SessionController sessionController, GlobalObjectClientBean object) throws Exception {
        if (!sessionController.isInSychronization()) {
            QuotaHelper.getInstance();
            if (quotaHandler != null && !object.getId().equals(11000L)) {
                boolean reached = quotaHandler.isQuotaReached(sessionController, object);
                if (reached && sessionController.getLoginUser().getId().equals(object.getId()) && !sessionController.isQuotaCheckDisabled()) {
                    throw new QuotaReachedException("Quota is reached, write is aborted");
                }
                return reached;
            }
            return false;
        }
        return false;
    }

    public static void addConsumedSpace(String ident, SessionController sessionController, GlobalObjectClientBean object, long size) throws Exception {
        QuotaHelper.getInstance();
        if (quotaHandler != null) {
            quotaHandler.addConsumedSpace(sessionController, object, size);
        }
    }

    public static long getConsumedSpace(SessionController sessionController, GlobalObjectClientBean object) throws Exception {
        QuotaHelper.getInstance();
        if (quotaHandler != null) {
            return quotaHandler.getConsumedSpace(sessionController, object);
        }
        return -1L;
    }

    public static long getAllocatedSpace(SessionController sessionController, GlobalObjectClientBean object) throws Exception {
        QuotaHelper.getInstance();
        if (quotaHandler != null) {
            return quotaHandler.getAllocatedSpace(sessionController, object);
        }
        return -1L;
    }

    public static void reloadQuota(GlobalObjectClientBean quota) throws Exception {
        QuotaHelper.getInstance();
        if (quotaHandler != null) {
            quotaHandler.reloadQuota(quota);
        }
    }

    public static boolean quotaIsInstalled() throws Exception {
        QuotaHelper.getInstance();
        return quotaHandler != null;
    }
}

