/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.commons.statistic.SystemStatistic;
import agorum.commons.utils.AttributeContext;
import agorum.commons.utils.Holder;
import agorum.roi.ejb.client.beans.SuperObjectClientCachedBean;
import agorum.roi.ejb.common.BackendHelper;
import agorum.roi.ejb.common.EJBHomeHolder;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.TransactionProperties;
import agorum.roi.ejb.common.TransactionTracker;
import agorum.roi.ejb.messaging.common.TransactionController;
import agorum.roi.statistic.TransactionStatistic;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.rmi.PortableRemoteObject;
import javax.transaction.UserTransaction;

public class RoiTransactionHandler
implements AutoCloseable,
AttributeContext {
    private static final SystemStatistic stat = TransactionStatistic.getInstance();
    private static long counter;
    private static long transId;
    private static final Object syncObj;
    private static final Map<String, Map<String, Object>> transactionCache;
    private static final Map<String, Long> transactionIds;
    private static final Set<String> transactionEndingCache;
    private static final Set<String> transactionActiveThread;
    private static final ThreadLocal<Holder<RoiTransactionHandler>> threadTransactions;
    private final int transactionTimeOut;
    private final Map<Object, Object> attributes = new HashMap<Object, Object>();
    private boolean open;
    private boolean myTransaction;
    private boolean ignoreBackend;
    private Stage stage;
    private final Map<String, Handler> beforeCommit = new LinkedHashMap<String, Handler>();
    private final List<Handler> beforeCommitList = new ArrayList<Handler>();
    private final Map<String, SafeHandler> whileCommit = new LinkedHashMap<String, SafeHandler>();
    private final List<SafeHandler> whileCommitList = new ArrayList<SafeHandler>();
    private final Map<String, Handler> afterCommit = new LinkedHashMap<String, Handler>();
    private final Map<String, Handler> finishedCommit = new LinkedHashMap<String, Handler>();
    private final List<Handler> afterCommitList = new ArrayList<Handler>();
    private final List<Handler> finishedCommitList = new ArrayList<Handler>();
    private final Map<String, SafeHandler> beforeRollback = new LinkedHashMap<String, SafeHandler>();
    private final List<SafeHandler> beforeRollbackList = new ArrayList<SafeHandler>();
    private final Map<String, SafeHandler> whileRollback = new LinkedHashMap<String, SafeHandler>();
    private final List<SafeHandler> whileRollbackList = new ArrayList<SafeHandler>();
    private final Map<String, Handler> afterRollback = new LinkedHashMap<String, Handler>();
    private final List<Handler> afterRollbackList = new ArrayList<Handler>();
    private final List<SafeHandler> cleanUpList = new ArrayList<SafeHandler>();

    public RoiTransactionHandler(int transactionTimeOut) {
        this.transactionTimeOut = transactionTimeOut < 0 ? TransactionProperties.getDefaultTransactionTimeout() : transactionTimeOut;
    }

    public RoiTransactionHandler() {
        this(-1);
    }

    public Stage getStage() {
        return this.stage;
    }

    @Override
    public void close() {
        if (!this.open) {
            return;
        }
        try {
            this.abort();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getTimeout() {
        return this.transactionTimeOut;
    }

    private UserTransaction getUserTransaction() throws Exception {
        try {
            RoiProperties rp = new RoiProperties();
            String jndiName = rp.getUserTransactionJndiName();
            UserTransaction userTa = (UserTransaction)PortableRemoteObject.narrow((Object)EJBHomeHolder.getHome(jndiName), UserTransaction.class);
            userTa.setTransactionTimeout(this.transactionTimeOut);
            return userTa;
        }
        catch (Exception e) {
            stat.warning((Throwable)e);
            throw ExceptionUtils.get("No UserConnection", "agorum.roi.remote.exception.UserNotConnected", 33);
        }
    }

    public void begin() throws Exception {
        this.begin(null);
    }

    public void begin(boolean ignoreBackend) throws Exception {
        this.begin(null, ignoreBackend);
    }

    public void begin(String ident) throws Exception {
        this.begin(ident, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin(String ident, boolean ignoreBackend) throws Exception {
        block14: {
            this.stage = Stage.ACTIVE;
            this.open = true;
            this.ignoreBackend = ignoreBackend;
            try {
                UserTransaction userTa = this.getUserTransaction();
                if (ident != null && userTa.getStatus() != 6) {
                    stat.warning("Attention: Transaction is active, but should not be: " + ident);
                }
                if (userTa.getStatus() != 6 || RoiTransactionHandler.isTransactionActive()) break block14;
                Object object = syncObj;
                synchronized (object) {
                    ++counter;
                }
                object = transactionActiveThread;
                synchronized (object) {
                    if (transactionActiveThread.contains(RoiTransactionHandler.getTransactionId())) {
                        stat.warning((Throwable)new Exception("Transaction is already active!!! " + RoiTransactionHandler.getTransactionId()));
                    } else {
                        transactionActiveThread.add(RoiTransactionHandler.getTransactionId());
                    }
                }
                userTa.begin();
                this.myTransaction = true;
                object = syncObj;
                synchronized (object) {
                    transactionIds.put(RoiTransactionHandler.getTransactionId(), ++transId);
                    HashMap transCache = new HashMap();
                    transactionCache.put(RoiTransactionHandler.getTransactionId(), transCache);
                }
                TransactionTracker.beginTransaction(ident, "Transaction start: " + new Date() + ", used timeout: " + this.transactionTimeOut + ", threadName: " + Thread.currentThread().getName() + ", transCounter: " + counter);
                this.handleBegin();
            }
            catch (Exception e) {
                stat.warning((Throwable)e);
                throw ExceptionUtils.get(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abortInternal(UserTransaction userTa) throws Exception {
        try {
            try {
                Set<String> set = syncObj;
                synchronized (set) {
                    --counter;
                }
                set = transactionActiveThread;
                synchronized (set) {
                    if (transactionActiveThread.contains(RoiTransactionHandler.getTransactionId())) {
                        transactionActiveThread.remove(RoiTransactionHandler.getTransactionId());
                    } else {
                        stat.warning((Throwable)new Exception("Transaction is no more active (abort)!!! " + RoiTransactionHandler.getTransactionId()));
                    }
                }
                if (counter < 0L) {
                    stat.warning((Throwable)new Exception("abortTransaction: counter is below 0: " + counter));
                }
                userTa.rollback();
                this.cleanUpTransactionHandler();
            }
            finally {
                try {
                    if (!this.ignoreBackend && BackendHelper.backendInterface != null) {
                        BackendHelper.backendInterface.rollback();
                    }
                }
                catch (Exception e) {
                    stat.error().exception((Throwable)e).send("Backend rollback problem");
                }
                try {
                    TransactionTracker.endTransaction();
                }
                catch (Exception e) {
                    stat.warning((Throwable)e);
                }
                try {
                    SuperObjectClientCachedBean.invalidateTransactionCache(false);
                }
                catch (Exception e) {
                    stat.warning((Throwable)e);
                }
                transactionIds.remove(RoiTransactionHandler.getTransactionId());
                transactionCache.remove(RoiTransactionHandler.getTransactionId());
            }
        }
        catch (Exception e) {
            stat.warning((Throwable)e);
            throw ExceptionUtils.get(e);
        }
    }

    public static String getTransactionId() {
        return "" + Thread.currentThread().getId();
    }

    public static boolean isTransactionActive() {
        return transactionCache.containsKey(RoiTransactionHandler.getTransactionId());
    }

    public static boolean isTransactionActive(String transactionId) {
        return transactionCache.containsKey(transactionId);
    }

    public static Map<String, Object> getTransactionCache() {
        return transactionCache.get(RoiTransactionHandler.getTransactionId());
    }

    private void clear() {
        this.open = false;
        this.attributes.clear();
        this.beforeCommit.clear();
        this.beforeCommitList.clear();
        this.whileCommit.clear();
        this.whileCommitList.clear();
        this.afterCommit.clear();
        this.afterCommitList.clear();
        this.finishedCommit.clear();
        this.finishedCommitList.clear();
        this.beforeRollback.clear();
        this.beforeRollbackList.clear();
        this.whileRollback.clear();
        this.whileRollbackList.clear();
        this.afterRollback.clear();
        this.afterRollbackList.clear();
        this.cleanUpList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserTransaction getMyEndingTransaction() throws Exception {
        UserTransaction userTa;
        if (this.myTransaction && (userTa = this.getUserTransaction()).getStatus() != 6) {
            Set<String> set = transactionEndingCache;
            synchronized (set) {
                if (!transactionEndingCache.contains(RoiTransactionHandler.getTransactionId())) {
                    transactionEndingCache.add(RoiTransactionHandler.getTransactionId());
                    return userTa;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseMyEndingTransaction() {
        Set<String> set = transactionEndingCache;
        synchronized (set) {
            transactionEndingCache.remove(RoiTransactionHandler.getTransactionId());
        }
    }

    public void end() throws Exception {
        UserTransaction userTa = this.getMyEndingTransaction();
        if (userTa == null) {
            return;
        }
        try {
            try {
                this.beforeEnd();
                this.endInternal(userTa);
            }
            finally {
                this.releaseMyEndingTransaction();
            }
            this.afterEnd();
        }
        catch (Throwable t) {
            try {
                this.abort();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw t;
        }
        finally {
            this.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() throws Exception {
        UserTransaction userTa = this.getMyEndingTransaction();
        if (userTa == null) {
            return;
        }
        try {
            try {
                try {
                    this.beforeAbort();
                }
                catch (Exception e) {
                    stat.warning().exception((Throwable)e).send("beforeRollback handler violated its contract by throwing an exception");
                }
                this.abortInternal(userTa);
            }
            finally {
                this.releaseMyEndingTransaction();
            }
            this.afterAbort();
        }
        finally {
            this.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endInternal(UserTransaction userTa) throws Exception {
        try {
            try {
                TransactionController.beginCommit();
            }
            catch (Exception e) {
                stat.warning((Throwable)e);
            }
            try {
                if (!this.ignoreBackend && BackendHelper.backendInterface != null) {
                    BackendHelper.backendInterface.preCommit();
                }
                Set<String> e = syncObj;
                synchronized (e) {
                    --counter;
                }
                e = transactionActiveThread;
                synchronized (e) {
                    if (transactionActiveThread.contains(RoiTransactionHandler.getTransactionId())) {
                        transactionActiveThread.remove(RoiTransactionHandler.getTransactionId());
                    } else {
                        stat.warning((Throwable)new Exception("Transaction is no more active (end)!!! " + RoiTransactionHandler.getTransactionId()));
                    }
                }
                if (counter < 0L) {
                    stat.warning((Throwable)new Exception("endTransaction: counter is below 0: " + counter));
                }
                userTa.commit();
                this.cleanUpTransactionHandler();
            }
            finally {
                try {
                    if (!this.ignoreBackend && BackendHelper.backendInterface != null) {
                        BackendHelper.backendInterface.commit();
                    }
                }
                catch (Exception e) {
                    stat.error((Throwable)e, "Backend commit problem");
                }
                try {
                    TransactionController.endCommit();
                }
                catch (Exception e) {
                    stat.warning((Throwable)e);
                }
                try {
                    SuperObjectClientCachedBean.invalidateTransactionCache(true);
                }
                catch (Exception e) {
                    stat.warning((Throwable)e);
                }
                try {
                    TransactionTracker.endTransaction();
                }
                catch (Exception e) {
                    stat.warning((Throwable)e);
                }
                transactionIds.remove(RoiTransactionHandler.getTransactionId());
                transactionCache.remove(RoiTransactionHandler.getTransactionId());
            }
        }
        catch (Exception e) {
            stat.warning((Throwable)e);
            throw ExceptionUtils.get(e);
        }
    }

    private void cleanUpTransactionHandler() {
        this.myTransaction = false;
        this.ignoreBackend = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getTransactionInternalId() {
        Long id = transactionIds.get(RoiTransactionHandler.getTransactionId());
        if (id == null) {
            Object object = syncObj;
            synchronized (object) {
                return transId++;
            }
        }
        return id;
    }

    public String getStatusString() throws Exception {
        return this.getStatusString(this.getUserTransaction());
    }

    public String getStatusString(UserTransaction userTa) throws Exception {
        try {
            switch (userTa.getStatus()) {
                case 0: {
                    return "STATUS_ACTIVE";
                }
                case 3: {
                    return "STATUS_COMMITTED";
                }
                case 8: {
                    return "STATUS_COMMITTING";
                }
                case 1: {
                    return "STATUS_MARKED_ROLLBACK";
                }
                case 6: {
                    return "STATUS_NO_TRANSACTION";
                }
                case 2: {
                    return "STATUS_PREPARED";
                }
                case 7: {
                    return "STATUS_PREPARING";
                }
                case 4: {
                    return "STATUS_ROLLEDBACK";
                }
                case 9: {
                    return "STATUS_ROLLING_BACK";
                }
                case 5: {
                    return "STATUS_UNKNOWN";
                }
            }
            return "STATUS_UNKNOWN : " + userTa.getStatus();
        }
        catch (Exception e) {
            stat.warning((Throwable)e);
            throw ExceptionUtils.get(e);
        }
    }

    public static RoiTransactionHandler getThreadTransaction() {
        return (RoiTransactionHandler)RoiTransactionHandler.threadTransactions.get().value;
    }

    public void beforeCommit(String ident, Handler handler) {
        if (ident == null) {
            this.beforeCommitList.add(handler);
        } else {
            this.beforeCommit.put(ident, handler);
        }
    }

    public void whileCommit(String ident, SafeHandler handler) {
        if (ident == null) {
            this.whileCommitList.add(handler);
        } else {
            this.whileCommit.put(ident, handler);
        }
    }

    public void afterCommit(String ident, Handler handler) {
        if (ident == null) {
            this.afterCommitList.add(handler);
        } else {
            this.afterCommit.put(ident, handler);
        }
    }

    public void finishedCommit(String ident, Handler handler) {
        if (ident == null) {
            this.finishedCommitList.add(handler);
        } else {
            this.finishedCommit.put(ident, handler);
        }
    }

    public void beforeRollback(String ident, SafeHandler handler) {
        if (ident == null) {
            this.beforeRollbackList.add(handler);
        } else {
            this.beforeRollback.put(ident, handler);
        }
    }

    public void whileRollback(String ident, SafeHandler handler) {
        if (ident == null) {
            this.whileRollbackList.add(handler);
        } else {
            this.whileRollback.put(ident, handler);
        }
    }

    public void afterRollback(String ident, Handler handler) {
        if (ident == null) {
            this.afterRollbackList.add(handler);
        } else {
            this.afterRollback.put(ident, handler);
        }
    }

    public void onCleanUp(SafeHandler handler) {
        this.cleanUpList.add(handler);
    }

    private void handleBegin() {
        RoiTransactionHandler.threadTransactions.get().value = this;
    }

    private void beforeEnd() throws Exception {
        this.stage = Stage.BEFORE_COMMIT;
        for (Handler handler : this.beforeCommit.values()) {
            handler.run();
        }
        for (Handler handler : this.beforeCommitList) {
            handler.run();
        }
        this.stage = Stage.WHILE_COMMIT;
        for (SafeHandler safeHandler : this.whileCommit.values()) {
            safeHandler.run();
        }
        for (SafeHandler safeHandler : this.whileCommitList) {
            safeHandler.run();
        }
    }

    private void afterEnd() throws Exception {
        try {
            RoiTransactionHandler.threadTransactions.get().value = null;
            for (Handler handler : this.afterCommit.values()) {
                handler.run();
            }
            for (Handler handler : this.afterCommitList) {
                handler.run();
            }
            for (Handler handler : this.finishedCommit.values()) {
                handler.run();
            }
            for (Handler handler : this.finishedCommitList) {
                handler.run();
            }
            this.stage = null;
        }
        catch (Throwable throwable) {
            for (SafeHandler handler : this.cleanUpList) {
                handler.run();
            }
            throw throwable;
        }
        for (SafeHandler safeHandler : this.cleanUpList) {
            safeHandler.run();
        }
    }

    private void beforeAbort() {
        this.stage = Stage.BEFORE_ROLLBACK;
        for (SafeHandler handler : this.beforeRollback.values()) {
            handler.run();
        }
        for (SafeHandler handler : this.beforeRollbackList) {
            handler.run();
        }
        this.stage = Stage.WHILE_ROLLBACK;
        for (SafeHandler handler : this.whileRollback.values()) {
            handler.run();
        }
        for (SafeHandler handler : this.whileRollbackList) {
            handler.run();
        }
    }

    private void afterAbort() throws Exception {
        try {
            RoiTransactionHandler.threadTransactions.get().value = null;
            for (Handler handler : this.afterRollback.values()) {
                handler.run();
            }
            for (Handler handler : this.afterRollbackList) {
                handler.run();
            }
            this.stage = null;
        }
        catch (Throwable throwable) {
            for (SafeHandler handler : this.cleanUpList) {
                handler.run();
            }
            throw throwable;
        }
        for (SafeHandler safeHandler : this.cleanUpList) {
            safeHandler.run();
        }
    }

    public Object get(Object key) {
        return this.attributes.get(key);
    }

    public Object put(String key, Object value) {
        return this.attributes.put(key, value);
    }

    public Object remove(Object key) {
        return this.attributes.remove(key);
    }

    static {
        transId = System.currentTimeMillis();
        syncObj = new Object();
        transactionCache = new ConcurrentHashMap<String, Map<String, Object>>();
        transactionIds = new ConcurrentHashMap<String, Long>();
        transactionEndingCache = new HashSet<String>();
        transactionActiveThread = new HashSet<String>();
        threadTransactions = ThreadLocal.withInitial(Holder::new);
    }

    public static interface SafeHandler
    extends Handler {
        @Override
        public void run();
    }

    public static interface Handler {
        public void run() throws Exception;
    }

    public static enum Stage {
        ACTIVE,
        BEFORE_COMMIT,
        WHILE_COMMIT,
        BEFORE_ROLLBACK,
        WHILE_ROLLBACK;

    }
}

