/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.agceptit.metadb.client.common.MetaDbEnvironment;
import agorum.agceptit.metadb.client.common.MetaDbException;
import agorum.commons.cron.SystemTimer;
import agorum.commons.encrypt.ntlm.NTLMEncryption;
import agorum.commons.logging.Log;
import agorum.commons.logging.MessageTranslator;
import agorum.commons.statistic.PerformanceValueHolder;
import agorum.commons.statistic.SystemCheck;
import agorum.commons.statistic.SystemObjectReference;
import agorum.commons.statistic.SystemStatistic;
import agorum.commons.string.StringBase64Utils;
import agorum.commons.string.StringConverterUtils;
import agorum.commons.utils.AttributeContext;
import agorum.commons.utils.RandomIdGenerator;
import agorum.roi.common.ClassHolder;
import agorum.roi.common.MultiFactorAuthentication;
import agorum.roi.ejb.audit.AuditUtil;
import agorum.roi.ejb.beans.FolderObjectEJB;
import agorum.roi.ejb.beans.SystemSessionEJB;
import agorum.roi.ejb.client.beans.AccessControlEntryObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.AccessControlListObjectClientBean;
import agorum.roi.ejb.client.beans.AccessControlListObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.AttributeObjectClientBean;
import agorum.roi.ejb.client.beans.ClassObjectClientBean;
import agorum.roi.ejb.client.beans.CustomAclObjectClientBean;
import agorum.roi.ejb.client.beans.DataBaseObjectClientBean;
import agorum.roi.ejb.client.beans.DataBaseObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.DirectoryGroupObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.EmailUserProfileObjectClientBean;
import agorum.roi.ejb.client.beans.FileObjectClientBean;
import agorum.roi.ejb.client.beans.FolderDocumentObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.FormatObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.InternalObjectClientBean;
import agorum.roi.ejb.client.beans.InternalObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.MailObjectClientBean;
import agorum.roi.ejb.client.beans.PermissionBundleObjectClientBean;
import agorum.roi.ejb.client.beans.PropertyBundleObjectClientBean;
import agorum.roi.ejb.client.beans.SessionInfoObjectClientBean;
import agorum.roi.ejb.client.beans.SessionInfoObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.SuperObjectClientCachedBean;
import agorum.roi.ejb.client.beans.SystemAclObjectClientBean;
import agorum.roi.ejb.client.beans.UnknownDirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.VersionObjectClientBean;
import agorum.roi.ejb.common.AclUserResolver;
import agorum.roi.ejb.common.ApplicationHashtable;
import agorum.roi.ejb.common.AssociatedGroupOfDirectoryObject;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.BaseCredentialManager;
import agorum.roi.ejb.common.ContentInterface;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.DbPrimaryKey;
import agorum.roi.ejb.common.DbRoiSequencePrimaryKey;
import agorum.roi.ejb.common.EJBHomeHolder;
import agorum.roi.ejb.common.EventAssistanceBean;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.InitSessionReturnBean;
import agorum.roi.ejb.common.LoginLogoutHandler;
import agorum.roi.ejb.common.MetaDbSuperCache;
import agorum.roi.ejb.common.NetworkAccessControllerUtils;
import agorum.roi.ejb.common.PropertyBundleCache;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.SequenceIdController;
import agorum.roi.ejb.common.ServiceAuthInterface;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.ejb.common.SessionInfoCheckInterface;
import agorum.roi.ejb.common.Transaction;
import agorum.roi.ejb.common.UserManagerBean;
import agorum.roi.ejb.interfaces.home.RoiSequenceIdEntityHome;
import agorum.roi.ejb.interfaces.home.SystemSessionHome;
import agorum.roi.ejb.interfaces.remote.RoiSequenceIdEntityRemote;
import agorum.roi.ejb.interfaces.remote.SystemSessionRemote;
import agorum.roi.ejb.mbeans.SessionUnLockService;
import agorum.roi.ejb.messaging.common.MessageUtils;
import agorum.roi.exception.RoiException;
import agorum.roi.lucene.ejb.interfaces.home.RoiIndexHome;
import agorum.roi.lucene.ejb.interfaces.remote.RoiIndexRemote;
import agorum.roi.search.SearchClass;
import agorum.roi.searchengine.AdvancedSearchQuery;
import agorum.roi.statistic.SessionControllerStatistic;
import agorum.webcomponents.common.WebResourcesHelper;
import agorum.webcomponents.webservices.beans.WebServiceSessionBean;
import agorum.webcomponents.webservices.common.WebServiceSessionCache;
import com.opensymphony.module.sequence.SequenceGenerator;
import com.opensymphony.module.sequence.SequenceGeneratorHome;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.nio.charset.StandardCharsets;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.ejb.CreateException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

public class SessionController
implements Serializable,
AttributeContext,
MessageTranslator {
    public static final long serialVersionUID = 1L;
    private static final SystemStatistic stat = SessionControllerStatistic.getInstance();
    private DirectoryObjectClientBean checkAccessUser;
    private SessionController mainSessionController;
    private SystemSessionRemote systemSessionRemote;
    private Locale locale;
    private boolean isInLogin;
    private boolean isInInit;
    private boolean userIsInitialized;
    private boolean roleIsInitialized;
    private static long WORLD_GROUP = 999L;
    private boolean adminEnabled;
    private boolean userIsAdminSet;
    private boolean readOnlyMode;
    private Hashtable<String, String> networkAccessSettings;
    private final Map<String, Object> sessionObjectCache;
    private boolean doNotEA;
    private boolean isMainSessionController;
    private Long sessionId = 1L;
    private Long initialSessionId;
    private String secureSessionId;
    private boolean isSessionInfoCreated;
    private RoiSequenceIdEntityRemote sequenceRemote;
    private Long myRootFolderId;
    private Long roleId;
    private Long loginUserId;
    private String loginUserUuid;
    public static String ACTUAL_VERSION = "5.2.0";
    public transient FolderObjectClientBean globalRootFolder;
    private CredentialObject credential;
    public transient MetaDb metaDb;
    public String metaDbSessionKey;
    private boolean disconnected;
    private boolean disabled;
    public static String DELETEOBJECTSEXPIRATIONTIMEMETADBPATH = "MAIN_MODULE_MANAGEMENT/roi/control/trashcan/DeleteObjectsExpirationTime";
    private static SessionInfoCheckInterface sessionInfoCheck;
    private final Map<String, Object> context = new HashMap<String, Object>();
    private int auditState = AuditUtil.ACTION_EXT_NORMAL;
    private String modulInfo;
    private boolean makeContentTask = true;
    private boolean inSynchronization;
    private boolean forceAudit;
    private boolean service;
    public static final String PERMISSION_READ = "AG_PB_READ";
    public static final String PERMISSION_CHECK_OUT = "AG_PB_CHECK_OUT";
    public static final String PERMISSION_WRITE = "AG_PB_WRITE";
    public static final String PERMISSION_ALL = "AG_PB_ALL";
    public static final String PERMISSION_PROTECTED = "AG_PB_PROTECTED";
    public static Map<Long, String> classNameIdMap;
    private static Map<String, String> classNameMap;
    private boolean quotaCheckDisabled;
    private final ReadWriteLock reconnectLock = new ReentrantReadWriteLock();
    private boolean initialized;
    private DirectoryUserObjectClientBean loginUser;
    private DirectoryUserObjectClientBean role;
    private Hashtable<Long, Hashtable<String, Object>> tableSelectStatementCache = new Hashtable();
    private ApplicationHashtable effectiveAttributes = new ApplicationHashtable(this, 6);
    private ApplicationHashtable allAttributes = new ApplicationHashtable(this, 3);
    private ApplicationHashtable allClassObjects = new ApplicationHashtable(this, 1);
    private ApplicationHashtable allFormatObjects = new ApplicationHashtable(this, 2);
    private ApplicationHashtable allClassObjectsByName = new ApplicationHashtable(this, 4);
    private static Map<String, Long> formatCache;
    private Map<String, FormatObjectClientBean> localFormatCache = new ConcurrentHashMap<String, FormatObjectClientBean>();
    private AccessControlListObjectClientBean loginUserDefaultAcl = null;
    private static boolean importMode;
    private static final String METADB_CORE_UUID = "MAIN_MODULE_MANAGEMENT/roi/control/CoreUUID";
    private static Map<Long, WeakReference<SessionController>> sessions;
    private static final long DEFAULT_TTL = 600000L;
    private static final String SESSION_MANAGER;
    private long lastActionTime;
    private long ttl = 600000L;
    private boolean lastLoginIndexed;
    private static final String METADB_I18N = "MAIN_MODULE_MANAGEMENT/roi/control/i18n";
    private Long objectNextHistoryEnsured;

    public SessionController() {
        this.sessionObjectCache = new HashMap<String, Object>();
    }

    private SessionController(SessionController sc) {
        this.checkAccessUser = sc.checkAccessUser;
        this.mainSessionController = sc.mainSessionController;
        this.userIsAdminSet = sc.userIsAdminSet;
        this.networkAccessSettings = sc.networkAccessSettings;
        this.sessionObjectCache = sc.sessionObjectCache;
        this.doNotEA = sc.doNotEA;
        this.lastActionTime = System.currentTimeMillis();
        this.ttl = sc.ttl;
        this.sequenceRemote = sc.sequenceRemote;
        this.myRootFolderId = sc.myRootFolderId;
        this.credential = sc.credential;
        this.metaDb = sc.metaDb;
        this.metaDbSessionKey = sc.metaDbSessionKey;
        this.disconnected = sc.disconnected;
        this.disabled = sc.disabled;
        this.modulInfo = sc.modulInfo;
        this.makeContentTask = sc.makeContentTask;
        this.inSynchronization = sc.inSynchronization;
        this.forceAudit = sc.forceAudit;
        this.quotaCheckDisabled = sc.quotaCheckDisabled;
        this.forceAudit = sc.forceAudit;
        this.loginUserDefaultAcl = sc.loginUserDefaultAcl;
        this.objectNextHistoryEnsured = sc.objectNextHistoryEnsured;
        this.tableSelectStatementCache = sc.tableSelectStatementCache;
        this.effectiveAttributes = sc.effectiveAttributes;
        this.allAttributes = sc.allAttributes;
        this.allClassObjects = sc.allClassObjects;
        this.allFormatObjects = sc.allFormatObjects;
        this.allClassObjectsByName = sc.allClassObjectsByName;
        this.systemSessionRemote = sc.systemSessionRemote;
        this.loginUser = sc.loginUser;
        this.loginUserId = sc.loginUserId;
        this.role = sc.role;
        this.roleId = sc.roleId;
        this.initialized = true;
        this.userIsInitialized = true;
        this.roleIsInitialized = true;
        this.isSessionInfoCreated = true;
        this.sessionId = sc.sessionId;
        this.secureSessionId = sc.secureSessionId;
        this.initialSessionId = this.sessionId;
        this.adminEnabled = sc.adminEnabled;
        this.service = sc.service;
    }

    private SessionController(SystemSessionEJB systemSessionEJB, SystemSessionRemote systemSessionRemote, SessionController sessionController) {
        this(sessionController);
        this.systemSessionRemote = systemSessionRemote;
        if (systemSessionEJB.getAdminFlag()) {
            this.setAdminEnabled(true);
        }
    }

    protected void finalize() throws Throwable {
        this.disconnect();
        super.finalize();
    }

    public static SessionInfoCheckInterface getSessionInfoCheck() {
        return sessionInfoCheck;
    }

    public void setRootFolderId(Long rootFolderId) throws Exception {
        this.myRootFolderId = rootFolderId;
        this.globalRootFolder = null;
    }

    public static void setSessionInfoCheck(SessionInfoCheckInterface sessionInfoCheck) {
        if (SessionController.sessionInfoCheck == null) {
            SessionController.sessionInfoCheck = sessionInfoCheck;
        }
    }

    public void setImportMode(boolean enable) throws Exception {
        if (!this.isAdminEnabled()) {
            throw new Exception("Only admin is allowed to do this");
        }
        importMode = enable;
    }

    public static boolean getImportMode() {
        return importMode;
    }

    public SystemSessionRemote getSystemSessionRemote() throws Exception {
        if (this.systemSessionRemote == null) {
            try {
                SystemSessionHome home = (SystemSessionHome)EJBHomeHolder.getHome("ejb/SystemSession");
                this.systemSessionRemote = home.create();
            }
            catch (Exception e) {
                ExceptionUtils.handleException(e);
            }
        }
        return this.systemSessionRemote;
    }

    public GlobalObjectClientBean getGlobalObjectById(Long id) throws Exception {
        DbPrimaryKey pk = new DbPrimaryKey();
        pk.id = id;
        return this.getGlobalObjectByPrimaryKey(pk);
    }

    public GlobalObjectClientBean[] getGlobalObjectsByUUID(String uuid) throws Exception {
        this.isConnected();
        SuperObjectClientBean[] soArr = this.getSuperObjectByAttribute(this, GlobalObjectClientBean.UUID_ATTRIBUTE, uuid.toLowerCase(), false, this.getClassObject(GlobalObjectClientBean.CLASS_NAME));
        if (soArr == null) {
            return null;
        }
        Arrays.sort(soArr, (o1, o2) -> {
            GlobalObjectClientBean gocb1 = (GlobalObjectClientBean)o1;
            GlobalObjectClientBean gocb2 = (GlobalObjectClientBean)o2;
            try {
                return gocb1.getLastModifyDate().compareTo(gocb2.getLastModifyDate());
            }
            catch (Exception e) {
                stat.debug().objectId(this.sessionId).send((Throwable)e);
                return 0;
            }
        });
        return (GlobalObjectClientBean[])Arrays.copyOf(soArr, soArr.length, GlobalObjectClientBean[].class);
    }

    public GlobalObjectClientBean getGlobalObjectByUUID(String uuid) throws Exception {
        Long id = SuperObjectClientCachedBean.getId(uuid);
        if (id != null) {
            return this.getGlobalObjectById(id);
        }
        this.isConnected();
        SuperObjectClientBean[] soArr = this.getSuperObjectByAttribute(this, GlobalObjectClientBean.UUID_ATTRIBUTE, uuid.toLowerCase(), false, this.getClassObject(GlobalObjectClientBean.CLASS_NAME));
        if (soArr != null && soArr.length > 0) {
            SuperObjectClientCachedBean.setId(uuid, soArr[0].getId());
            return (GlobalObjectClientBean)soArr[0];
        }
        return null;
    }

    public SuperObjectClientBean getSuperObjectByUUID(String uuid) throws Exception {
        this.isConnected();
        SuperObjectClientBean[] soArr = this.getSuperObjectByAttribute(this, GlobalObjectClientBean.UUID_ATTRIBUTE, uuid.toLowerCase(), false, this.getClassObject(GlobalObjectClientBean.CLASS_NAME));
        if (soArr == null || soArr.length == 0) {
            soArr = this.getSuperObjectByAttribute(this, GlobalObjectClientBean.UUID_ATTRIBUTE, uuid.toLowerCase(), false, this.getClassObject(InternalObjectClientBean.CLASS_NAME));
        }
        if (soArr != null && soArr.length > 0) {
            return soArr[0];
        }
        return null;
    }

    public InternalObjectClientBean getInternalObjectByUUID(String uuid) throws Exception {
        InternalObjectClientBean[] objs = this.getInternalObjectsByUUID(uuid);
        if (objs != null && objs.length > 0) {
            return objs[0];
        }
        return null;
    }

    public InternalObjectClientBean[] getInternalObjectsByUUID(String uuid) throws Exception {
        this.isConnected();
        SuperObjectClientBean[] soArr = this.getSuperObjectByAttribute(this, InternalObjectClientBean.UUID_ATTRIBUTE, uuid.toLowerCase(), false, this.getClassObject(InternalObjectClientBean.CLASS_NAME));
        if (soArr == null) {
            return null;
        }
        Arrays.sort(soArr, (o1, o2) -> {
            InternalObjectClientBean iocb1 = (InternalObjectClientBean)o1;
            InternalObjectClientBean iocb2 = (InternalObjectClientBean)o2;
            try {
                return iocb1.getCreateDate().compareTo(iocb2.getCreateDate());
            }
            catch (Exception e) {
                stat.debug().objectId(this.sessionId).send((Throwable)e);
                return 0;
            }
        });
        return (InternalObjectClientBean[])Arrays.copyOf(soArr, soArr.length, InternalObjectClientBean[].class);
    }

    public long getScopeAclCount(AccessControlListObjectClientBean acl) throws Exception {
        this.isConnected();
        SystemSessionRemote remote = this.getSystemSessionRemote();
        return remote.getScopeAclCount(this, acl);
    }

    public void changePasswordToDes(String userName) throws Exception {
        this.isConnected();
        SystemSessionRemote remote = this.getSystemSessionRemote();
        remote.changePasswordToDes(this, userName);
    }

    public void changeAgorumPassword(SessionController sessionController, DirectoryUserObjectClientBean user, String encodedPassword) throws Exception {
        this.isConnected();
        SystemSessionRemote remote = this.getSystemSessionRemote();
        remote.changeAgorumPassword(sessionController, user, encodedPassword);
    }

    public GlobalObjectClientBean getGlobalObjectByPrimaryKey(DbPrimaryKey pk) throws Exception {
        this.isConnected();
        SuperObjectClientCachedBean cBean = SuperObjectClientCachedBean.getCachedBean(pk.id);
        if (cBean != null) {
            ++SuperObjectClientCachedBean.cacheHitRateGlobalObjectsCached;
            if (cBean.isDeleted()) {
                return null;
            }
            GlobalObjectClientBean cb = cBean.getGlobalObjectClientBean(this);
            try {
                cb.getName();
            }
            catch (RoiException e) {
                if (e.getErrorCode() == 101) {
                    SuperObjectClientCachedBean.invalidateCachedObject(pk.id);
                }
                throw e;
            }
            if (!this.isMainAdmin() && pk.getCheckObjectAccess() && !cb.checkEffectiveAccess(4L)) {
                ExceptionUtils.handleException("No access for object with id " + cb.getId(), "agorum.roi.remote.exception.NoAccess", 21);
            }
            return cb;
        }
        ++SuperObjectClientCachedBean.cacheHitRateGlobalObjectsNotCached;
        SystemSessionRemote remote = this.getSystemSessionRemote();
        GlobalObjectClientBean cb = remote.getGlobalObjectByPrimaryKey(this, pk);
        SuperObjectClientCachedBean.setCachedBean(cb);
        return cb;
    }

    public InternalObjectClientBean getInternalObjectById(Long id) throws Exception {
        DbPrimaryKey pk = new DbPrimaryKey();
        pk.id = id;
        return this.getInternalObjectByPrimaryKey(pk);
    }

    public DataBaseObjectClientBean getDataBaseObjectById(Long id) throws Exception {
        this.isConnected();
        DataBaseObjectClientBean cb = null;
        ApplicationHashtable ah = this.getAllClassObjects();
        cb = ah.containsKey(id) ? (DataBaseObjectClientBean)ah.get(this, id) : this.getSystemSessionRemote().getDataBaseObjectById(this, id);
        return cb;
    }

    public GlobalObjectClientBean createGlobalObject(GlobalObjectClientBeanDefinition def) throws Exception {
        this.isConnected();
        GlobalObjectClientBean cb = this.getSystemSessionRemote().createGlobalObject(this, def);
        SuperObjectClientCachedBean.invalidateCachedObject(cb.getId());
        return cb;
    }

    public InternalObjectClientBean createInternalObject(InternalObjectClientBeanDefinition def) throws Exception {
        this.isConnected();
        InternalObjectClientBean cb = this.getSystemSessionRemote().createInternalObject(this, def);
        SuperObjectClientCachedBean.invalidateCachedObject(cb.getId());
        return cb;
    }

    public DataBaseObjectClientBean createDataBaseObject(DataBaseObjectClientBeanDefinition def) throws Exception {
        this.isConnected();
        DataBaseObjectClientBean cb = null;
        if (this.isAdminEnabled()) {
            cb = this.getSystemSessionRemote().createDataBaseObject(this, def);
        } else {
            ExceptionUtils.handleException("You need admin access", "agorum.roi.remote.exception.NoAdminAccess", 22);
        }
        return cb;
    }

    public void updateDataBaseObject(DataBaseObjectClientBeanDefinition def, ClassObjectClientBean classObject) throws Exception {
        this.isConnected();
        if (this.isAdminEnabled()) {
            this.getSystemSessionRemote().updateDataBaseObject(this, def, classObject);
        } else {
            ExceptionUtils.handleException("You need admin access", "agorum.roi.remote.exception.NoAdminAccess", 22);
        }
    }

    public SuperObjectClientBean createSuperObject(SuperObjectClientBeanDefinition def) throws Exception {
        this.isConnected();
        SuperObjectClientBean cb = this.getSystemSessionRemote().createSuperObject(this, def);
        return cb;
    }

    public Long findClassIdByAttribute(String attrName, Long classId) throws Exception {
        this.isConnected();
        Hashtable allAttr = (Hashtable)this.getAllAttributes().get(this, classId);
        AttributeObjectClientBean ao = (AttributeObjectClientBean)allAttr.get(attrName);
        return ao == null ? null : ao.getClassId();
    }

    public void changeCredential(String userName, String oldCred, String newCred) throws Exception {
        this.getSystemSessionRemote().changeCredential(this, userName, oldCred, newCred);
    }

    public Hashtable<String, Object> getAllAttributesFromClassId(Long classId) throws Exception {
        Hashtable hRet = (Hashtable)this.getEffectiveAttributes().get(this, classId);
        return hRet == null ? new Hashtable() : hRet;
    }

    public ClassObjectClientBean getClassObject(Long id) throws Exception {
        ApplicationHashtable allClassObjects = this.getAllClassObjects();
        this.isConnected();
        ClassObjectClientBean coRet = null;
        try {
            coRet = (ClassObjectClientBean)allClassObjects.get(this, id);
            if (coRet == null) {
                stat.debug().objectId(id).send("ClassObject not found with id: " + id);
            }
        }
        catch (Exception e) {
            stat.warning().objectId(this.sessionId).exception((Throwable)e).send("session invalid: " + this.sessionId + ", " + this.hashCode());
            throw e;
        }
        return coRet;
    }

    public ClassObjectClientBean getClassObject(String name) throws Exception {
        this.isConnected();
        name = name.toUpperCase();
        return (ClassObjectClientBean)this.getAllClassObjectsByName().get(this, name);
    }

    public ClassObjectClientBean getRootClassObjectFromClassId(Long classId) throws Exception {
        this.isConnected();
        ClassObjectClientBean cb = this.getSystemSessionRemote().getRootClassObjectFromClassId(this, classId);
        return cb;
    }

    public String[] getAllInstanceOfClassObject(String className) throws Exception {
        return this.getAllInstanceOfClassObject(this.getClassObject(className));
    }

    public String[] getAllInstanceOfClassObject(Long classId) throws Exception {
        return this.getAllInstanceOfClassObject(this.getClassObject(classId));
    }

    public String[] getAllInstanceOfClassObject(ClassObjectClientBean classObject) throws Exception {
        Vector<String> v = new Vector<String>();
        this.getSuperObjectsRecursiv(v, classObject);
        int len = v.size();
        if (len > 0) {
            return v.toArray(new String[len]);
        }
        return null;
    }

    private void getSuperObjectsRecursiv(Vector<String> v, ClassObjectClientBean classObject) throws Exception {
        v.addElement(classObject.getName());
        ApplicationHashtable h = this.getAllClassObjectsByName();
        Enumeration enumH = h.elements();
        long classId = classObject.getId();
        while (enumH.hasMoreElements()) {
            ClassObjectClientBean classObj = (ClassObjectClientBean)enumH.nextElement();
            AttributeValue avSuper = classObj.getAttribute(ClassObjectClientBean.SUPERCLASS_ATTRIBUTE);
            long superId = avSuper.getLong();
            if (classId != superId) continue;
            this.getSuperObjectsRecursiv(v, classObj);
        }
    }

    public GlobalObjectClientBean findGlobalObjectByPath(String fullPath) throws Exception {
        return this.findGlobalObjectByPath(fullPath, false);
    }

    public GlobalObjectClientBean findGlobalObjectByPath(String fullPath, boolean caseSensitive) throws Exception {
        this.isConnected();
        GlobalObjectClientBean cb = this.getSystemSessionRemote().findGlobalObjectByPath(this, fullPath, caseSensitive);
        return cb;
    }

    public GlobalObjectClientBean findGlobalObjectByPathFromRoot(String fullPath) throws Exception {
        this.isConnected();
        GlobalObjectClientBean cb = this.getSystemSessionRemote().findGlobalObjectByPathFromRoot(this, fullPath);
        return cb;
    }

    public GlobalObjectClientBean findGlobalObjectByPath(Long folderId, String fullPath) throws Exception {
        this.isConnected();
        GlobalObjectClientBean cb = this.getSystemSessionRemote().findGlobalObjectByPath(this, folderId, fullPath);
        return cb;
    }

    public GlobalObjectClientBean findGlobalObjectByPath(FolderObjectClientBean folder, String fullPath) throws Exception {
        this.isConnected();
        GlobalObjectClientBean cb = this.getSystemSessionRemote().findGlobalObjectByPath(this, folder, fullPath);
        return cb;
    }

    public GlobalObjectClientBean findGlobalObjectByPathNoLookup(FolderObjectClientBean folder, String fullPath) throws Exception {
        this.isConnected();
        GlobalObjectClientBean cb = this.getSystemSessionRemote().findGlobalObjectByPathNoLookup(this, folder, fullPath);
        return cb;
    }

    public GlobalObjectClientBean findGlobalObjectByPathOrId(String pathOrId) throws Exception {
        this.isConnected();
        Long id = null;
        try {
            id = new Long(pathOrId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (id != null) {
            return this.getGlobalObjectById(id);
        }
        return this.getSystemSessionRemote().findGlobalObjectByPath(this, pathOrId);
    }

    public GlobalObjectClientBean findGlobalObjectByPathOrIdNoLookup(String pathOrId) throws Exception {
        this.isConnected();
        Long id = null;
        try {
            id = new Long(pathOrId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (id != null) {
            return this.getGlobalObjectById(id);
        }
        return this.getSystemSessionRemote().findGlobalObjectByPathNoLookup(this, pathOrId);
    }

    public FolderObjectClientBean getRootFolder() throws Exception {
        this.isConnected();
        FolderObjectClientBean cb = null;
        if (this.globalRootFolder == null) {
            cb = this.myRootFolderId == null ? this.getSystemSessionRemote().getRootFolder(this) : (FolderObjectClientBean)this.getGlobalObjectById(this.myRootFolderId);
            this.globalRootFolder = cb;
        } else {
            cb = this.globalRootFolder;
        }
        return cb;
    }

    public FolderObjectClientBean getRealRootFolder() throws Exception {
        this.isConnected();
        FolderObjectClientBean cb = null;
        cb = this.getSystemSessionRemote().getRootFolder(this);
        return cb;
    }

    public String getCredentialString() throws Exception {
        String ntlmHash = "";
        try {
            ntlmHash = StringConverterUtils.toHexString((byte[])new NTLMEncryption().getNTLMHash(this.credential.getPassWord()));
        }
        catch (Exception e) {
            stat.debug((Throwable)e);
        }
        byte[] bytes = (this.getLoginUser().getName() + "||" + ntlmHash).getBytes(StandardCharsets.ISO_8859_1);
        return StringBase64Utils.encode((byte[])bytes).replace("\\r", "").replace("\\n", "");
    }

    public static CredentialObject getCredentialFromString(String credentialString, String modulInfo) throws Exception {
        String cred = new String(StringBase64Utils.decode((String)credentialString), StandardCharsets.ISO_8859_1);
        String user = cred.substring(0, cred.indexOf("||"));
        String pwHash = cred.substring(cred.indexOf("||") + 2);
        CredentialObject credential = new CredentialObject();
        credential.setUserName(user);
        credential.setPassWord(pwHash);
        credential.setOwnDesEncryption(true);
        credential.setUseDesEncryption(false);
        credential.setModulInfo(modulInfo);
        return credential;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionInfoObjectClientBean init(CredentialObject credential, boolean sendUnlockEvent) throws Exception {
        credential.setClearTextPassword(credential.getPassWord());
        credential.setOriginalUserName(credential.getUserName());
        this.disconnected = false;
        this.credential = credential;
        this.isInLogin = true;
        this.isInInit = true;
        try {
            this.isMainSessionController = true;
            this.sessionId = this.getSequenceId();
            this.secureSessionId = RandomIdGenerator.createId();
            if (this.initialSessionId == null) {
                this.initialSessionId = this.sessionId;
            }
            this.getSystemSessionRemote().initApplicationContainer(this);
            InitSessionReturnBean retBean = this.getSystemSessionRemote().initSession(this, credential);
            this.lastActionTime = System.currentTimeMillis();
            sessions.put(this.sessionId, new WeakReference<SessionController>(this));
            credential.setUserName(retBean.getUserName());
            this.isInLogin = false;
            try {
                if (!credential.getNotSetNtPassword()) {
                    String ntPassword = this.getSystemSessionRemote().getEncodedNTPassword(this, credential);
                    if (ntPassword != null) {
                        DirectoryUserObjectClientBean user = this.getLoginUser();
                        try {
                            String password = this.getDecodedSystemPassword(user.getName());
                            credential.setPassWord(password);
                            credential.setUseDesEncryption(true);
                        }
                        catch (Exception e) {
                            credential.setPassWord("disabled");
                            credential.setUseDesEncryption(false);
                        }
                    } else {
                        stat.debug().objectId(this.sessionId).send("ntPassword not set");
                    }
                }
            }
            catch (Exception e) {
                stat.warning().objectId(this.sessionId).send((Throwable)e);
                throw e;
            }
            if (this.getLoginUser().getAdminenabled()) {
                this.setAdminEnabled(true);
            }
            String roleName = credential.getRoleName();
            String defRoleName = null;
            DirectoryUserObjectClientBean defRole = (DirectoryUserObjectClientBean)this.getLoginUser().getDefaultRole();
            if (defRole != null) {
                defRoleName = defRole.getName();
            }
            boolean cRole = true;
            if (defRoleName != null && roleName != null && !defRoleName.equalsIgnoreCase(roleName)) {
                this.initRole(defRoleName);
                cRole = this.checkRole(this, roleName);
                this.roleIsInitialized = false;
                this.initRole(credential.getRoleName());
            } else {
                this.initRole(roleName);
                cRole = this.checkRole(this, this.getRole().getName());
            }
            if (cRole) {
                if (this.getRole().getAdminenabled()) {
                    stat.debug().objectId(this.sessionId).send("Set to adminenabled: " + this.getSessionId());
                    this.setAdminEnabled(true);
                    DirectoryUserObjectClientBean role = (DirectoryUserObjectClientBean)this.getGlobalObjectById(this.getRole().getId());
                    this.setRole(role);
                    VersionObjectClientBean version = null;
                    try {
                        SuperObjectClientBean[] soArr = this.getSuperObjectByAttribute(this, "MODUL", "Royi", false, this.getClassObject(VersionObjectClientBean.CLASS_NAME));
                        if (soArr != null) {
                            version = (VersionObjectClientBean)soArr[0];
                        }
                    }
                    catch (Exception soArr) {
                        // empty catch block
                    }
                    if (version != null && version.getVersion().equals(ACTUAL_VERSION)) {
                        stat.debug().objectId(this.sessionId).send("Version is OK");
                    } else if (version == null) {
                        stat.debug().objectId(this.sessionId).send("Install is OK");
                    } else {
                        StringBuilder sb = new StringBuilder();
                        sb.append("-------------------------------------------------\n");
                        sb.append("FATAL ERROR:\n");
                        sb.append("Version mismatch, please run an update:\n");
                        sb.append("Version is: " + version.getVersion() + " but should be:" + ACTUAL_VERSION + "\n");
                        sb.append("Make sure that you have started the prepareUpdate\n");
                        sb.append("Script, before launching the application.\n");
                        sb.append("\n");
                        sb.append("Exiting imediately...\n");
                        sb.append("-------------------------------------------------");
                        stat.error().objectId(this.sessionId).detail((Object)sb.toString()).send("FATAL VERSION MISMATCH ERROR");
                        System.err.print(sb.toString());
                        System.exit(1);
                    }
                } else {
                    this.setAdminEnabled(false);
                }
            } else {
                ExceptionUtils.handleException("Role not allowed for this user", "agorum.roi.remote.exception.RoleNotAllowed", 24);
            }
            if (!credential.getUserName().equalsIgnoreCase("roi")) {
                String acl_ModulInfo = "ACL_ModulInfo_" + credential.getModulInfo();
                if (SessionControllerAdmin.getService(SessionController.class).getAclByName(acl_ModulInfo) != null && this.getAclByName(acl_ModulInfo) == null) {
                    ExceptionUtils.handleException("User '" + credential.getUserName() + "' is locked for : " + credential.getModulInfo(), "agorum.roi.remote.exception.UserIsLocked", 204);
                }
            }
        }
        finally {
            this.isInInit = false;
        }
        try {
            if (!credential.getUserName().equalsIgnoreCase("roi")) {
                MessageUtils mu = new MessageUtils();
                mu.sendCloudEvent(this.getLoginUserId().toString(), this.getLoginUserId(), "EVENT_USER_AGORUMCOREPRO", "", 1L, null);
            }
        }
        catch (Exception e) {
            stat.warning().objectId(this.sessionId).send((Throwable)e);
        }
        return sendUnlockEvent ? SessionController.createSessionInfoObject(this, credential) : null;
    }

    public static List<LoginLogoutHandler> getLoginLogoutHandler(SessionController sessionControllerOther) throws Exception {
        ArrayList<LoginLogoutHandler> handlers = new ArrayList<LoginLogoutHandler>();
        MetaDb metaDb = sessionControllerOther.getMetaDbInstance();
        String postLoginHandler = null;
        try {
            String key = "MAIN_MODULE_MANAGEMENT/roi/control/loginlogouthandler";
            String[] bundles = metaDb.listSimplePropertyBundle(key);
            if (bundles != null) {
                for (int i = 0; i < bundles.length; ++i) {
                    postLoginHandler = metaDb.getString(key + "/" + bundles[i] + "/LoginLogoutHandlerClass");
                    if (postLoginHandler == null) continue;
                    LoginLogoutHandler plh = (LoginLogoutHandler)Class.forName(postLoginHandler).newInstance();
                    handlers.add(plh);
                }
            }
        }
        catch (Exception e) {
            stat.debug((Throwable)e);
        }
        return handlers;
    }

    private boolean checkRole(SessionController sessionController, String roleName) throws Exception {
        DirectoryObjectClientBean[] allRoles;
        DirectoryUserObjectClientBean user = sessionController.getLoginUser();
        DirectoryGroupObjectClientBean assosiatedRoles = null;
        try {
            assosiatedRoles = (DirectoryGroupObjectClientBean)user.getAssociatedRoles();
        }
        catch (Exception e) {
            stat.debug().objectId(this.sessionId).exception((Throwable)e).send("Associated Roles could not be retrieved...");
        }
        if (user.getAdminenabled()) {
            return true;
        }
        DirectoryUserObjectClientBean defaultRole = (DirectoryUserObjectClientBean)user.getDefaultRole();
        if (defaultRole == null) {
            stat.error().objectId(this.sessionId).send("Could not read default role");
            return false;
        }
        if (defaultRole.getName().equalsIgnoreCase(roleName)) {
            return true;
        }
        if (assosiatedRoles != null && (allRoles = assosiatedRoles.getAllUserMembers()) != null) {
            int len = allRoles.length;
            for (int i = 0; i < len; ++i) {
                if (allRoles[i] == null || !(allRoles[i] instanceof DirectoryUserObjectClientBean) || !allRoles[i].getName().equalsIgnoreCase(roleName)) continue;
                return true;
            }
        }
        stat.error().objectId(this.sessionId).send("The role : '" + roleName + "' is not defined within the group of entitled roles (" + (assosiatedRoles == null ? "no permission to retrieve role name" : assosiatedRoles.getName()) + ") for user (" + user.getName() + ")\n\n");
        return false;
    }

    public boolean getIsInLogin() {
        return this.isInLogin;
    }

    public InternalObjectClientBean getInternalObjectByPrimaryKey(DbPrimaryKey pk) throws Exception {
        this.isConnected();
        InternalObjectClientBean cb = this.getSystemSessionRemote().getInternalObjectByPrimaryKey(this, pk);
        return cb;
    }

    public DataBaseObjectClientBean getDataBaseObjectByPrimaryKey(DbPrimaryKey pk) throws Exception {
        this.isConnected();
        return this.getSystemSessionRemote().getDataBaseObjectByPrimaryKey(this, pk);
    }

    public static SessionController connect(CredentialObject credential) throws Exception {
        return SessionController.connect(credential, true);
    }

    public static SessionController connect(CredentialObject credential, boolean sendUnlockEvent) throws Exception {
        String url = MultiFactorAuthentication.check(credential);
        try {
            SessionController sessionController = new SessionController();
            SessionInfoObjectClientBean sessionInfo = sessionController.init(credential, sendUnlockEvent);
            if (url != null) {
                throw new MultiFactorAuthentication.Setup(url);
            }
            if (credential.getIp() != null) {
                new NetworkAccessControllerUtils(sessionController, null).handleNetworkAccessSettings();
            }
            if (sendUnlockEvent) {
                for (LoginLogoutHandler plh : SessionController.getLoginLogoutHandler(sessionController)) {
                    if (plh.postLogin(sessionController, credential, sessionInfo)) continue;
                    sessionController.disconnect();
                    throw new Exception("login not allowed through PostLoginHandler");
                }
            }
            return sessionController;
        }
        catch (RemoteException | CreateException | NamingException e) {
            stat.warning(e, "Error at Login");
            throw ExceptionUtils.get(e);
        }
        catch (Exception e) {
            stat.warning((Throwable)e);
            throw e;
        }
    }

    public void reconnect(CredentialObject credential) throws Exception {
        this.reconnect(credential, true);
    }

    public void reconnectIfNeeded() throws Exception {
        this.reconnectIfNeeded(true);
    }

    public void reconnectIfNeeded(boolean sendUnlockEvent) throws Exception {
        boolean reconnect = false;
        try {
            this.isInLogin = false;
            this.isConnected();
        }
        catch (Exception e) {
            reconnect = true;
        }
        if (reconnect) {
            this.reconnect(sendUnlockEvent);
        }
    }

    private void reconnect() throws Exception {
        this.reconnect(true);
    }

    private void reconnect(boolean sendUnlockEvent) throws Exception {
        if (this.credential.getUserName().equalsIgnoreCase("roi") && this.credential.getPassWord() != null) {
            this.credential.setPassWord(new RoiProperties().getRoiSystemPassword());
        }
        this.reconnect(this.credential, sendUnlockEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnect(CredentialObject credential, boolean sendUnlockEvent) throws Exception {
        if (this.disabled) {
            throw new Exception("Not reconnecting disabled session: " + this.sessionId);
        }
        String threadName = Thread.currentThread().getName();
        if (this.reconnectLock.writeLock().tryLock()) {
            try {
                Log.info((String)(threadName + " reconnecting session " + this.sessionId + "..."));
                this.doReconnect(credential, sendUnlockEvent);
                Log.info((String)(threadName + " reconnected session " + this.sessionId));
            }
            finally {
                this.reconnectLock.writeLock().unlock();
            }
        }
        Log.info((String)(threadName + " waiting for session " + this.sessionId + " to be reconnected..."));
        this.reconnectLock.readLock().lock();
        try {
            Log.info((String)(threadName + " finished waiting, session " + this.sessionId + " is reconnected"));
        }
        finally {
            this.reconnectLock.readLock().unlock();
        }
    }

    private void doReconnect(CredentialObject credential, boolean sendUnlockEvent) throws Exception {
        stat.info("reconnecting: old SessionId: " + this.sessionId);
        try {
            this.checkAccessUser = null;
            this.mainSessionController = null;
            this.systemSessionRemote = null;
            this.isInLogin = false;
            this.isInInit = false;
            this.userIsInitialized = false;
            this.roleIsInitialized = false;
            this.isSessionInfoCreated = false;
            this.sequenceRemote = null;
            this.myRootFolderId = null;
            this.roleId = null;
            this.loginUserId = null;
            this.globalRootFolder = null;
            this.metaDb = null;
            this.metaDbSessionKey = null;
            this.init(credential, sendUnlockEvent);
            stat.info("reconnected: new SessionId: " + this.sessionId);
        }
        catch (NamingException e) {
            stat.warning((Throwable)e, "Error at Login");
            ExceptionUtils.handleException(e);
        }
        catch (CreateException e) {
            stat.warning((Throwable)e, "Error at Login");
            ExceptionUtils.handleException(e);
        }
        catch (RemoteException e) {
            stat.warning((Throwable)e, "Error at Login");
            ExceptionUtils.handleException(e);
        }
    }

    public FormatObjectClientBean getFormatByFileName(String fileName) throws Exception {
        String extension = null;
        if (fileName.indexOf(".") >= 0) {
            extension = fileName.substring(fileName.lastIndexOf(".") + 1);
        }
        return this.getSystemSessionRemote().getFormatByExtension(this, extension);
    }

    public FormatObjectClientBean getFormatByMimeType(String mimeType) throws Exception {
        FormatObjectClientBean format = this.localFormatCache.get(mimeType);
        if (format == null) {
            Long id = formatCache.get(mimeType);
            if (id == null) {
                format = this.getSystemSessionRemote().getFormatByMimeType(this, mimeType);
                if (format != null) {
                    formatCache.put(mimeType, format.getId());
                    this.localFormatCache.put(mimeType, format);
                } else {
                    formatCache.put(mimeType, -1L);
                }
                return format;
            }
            if (id != -1L) {
                format = (FormatObjectClientBean)this.getInternalObjectById(id);
                this.localFormatCache.put(mimeType, format);
                return format;
            }
            return null;
        }
        return format;
    }

    public void isConnected() throws Exception {
        this.isConnected(true);
    }

    public void isConnected(boolean keepSessionAlive) throws Exception {
        if (this.isInLogin || Transaction.has(SESSION_MANAGER)) {
            return;
        }
        if (this.disconnected) {
            if (keepSessionAlive) {
                try {
                    this.reconnect();
                }
                catch (Exception e) {
                    stat.warning().objectId(this.sessionId).send((Throwable)e);
                    ExceptionUtils.handleException(e);
                }
            } else {
                throw new RoiException("Not connected", "agorum.roi.remote.exception.NotConnected", 32, null);
            }
        }
        if (keepSessionAlive) {
            this.lastActionTime = System.currentTimeMillis();
        }
    }

    public String getUserNameByAliasName(String aliasName) throws Exception {
        return this.getSystemSessionRemote().getUserNameByAliasName(this, aliasName);
    }

    public DirectoryUserObjectClientBean getUserByName(String userName) throws Exception {
        ClassObjectClientBean co;
        SuperObjectClientBean[] soArr;
        String realUserName = this.getUserNameByAliasName(userName);
        DirectoryUserObjectClientBean duocb = null;
        if (realUserName != null && (soArr = this.getSuperObjectByAttribute(this, DirectoryUserObjectClientBean.UNIQUENAME_ATTRIBUTE, realUserName, false, co = this.getClassObject(DirectoryUserObjectClientBean.CLASS_NAME))) != null && soArr.length > 0) {
            duocb = (DirectoryUserObjectClientBean)soArr[0];
        }
        return duocb;
    }

    public DirectoryGroupObjectClientBean getGroupByName(String groupName) throws Exception {
        if (groupName == null) {
            return null;
        }
        DirectoryGroupObjectClientBean dgocb = null;
        SuperObjectClientBean[] soArr = this.getSuperObjectByAttribute(this, GlobalObjectClientBean.NAME_ATTRIBUTE, groupName, false, this.getClassObject(DirectoryGroupObjectClientBean.CLASS_NAME));
        if (soArr != null) {
            dgocb = (DirectoryGroupObjectClientBean)soArr[0];
        }
        return dgocb;
    }

    public DirectoryUserObjectClientBean[] getAllDirectoryUsers() throws Exception {
        int len;
        DirectoryUserObjectClientBean[] duocb = null;
        SuperObjectClientBean[] socb = this.getSuperObjectByAttribute(this, GlobalObjectClientBean.NAME_ATTRIBUTE, null, false, this.getClassObject(DirectoryUserObjectClientBean.CLASS_NAME));
        if (socb != null && (len = socb.length) > 0) {
            duocb = new DirectoryUserObjectClientBean[len];
            for (int i = 0; i < len; ++i) {
                duocb[i] = (DirectoryUserObjectClientBean)socb[i];
            }
        }
        return duocb;
    }

    public DirectoryGroupObjectClientBean[] getAllDirectoryGroups() throws Exception {
        int len;
        DirectoryGroupObjectClientBean[] duocb = null;
        SuperObjectClientBean[] socb = this.getSuperObjectByAttribute(this, GlobalObjectClientBean.NAME_ATTRIBUTE, null, false, this.getClassObject(DirectoryGroupObjectClientBean.CLASS_NAME));
        if (socb != null && (len = socb.length) > 0) {
            duocb = new DirectoryGroupObjectClientBean[len];
            for (int i = 0; i < len; ++i) {
                duocb[i] = (DirectoryGroupObjectClientBean)socb[i];
            }
        }
        return duocb;
    }

    public AccessControlListObjectClientBean[] getAllAcl() throws Exception {
        int len;
        AccessControlListObjectClientBean[] allAcl = null;
        SuperObjectClientBean[] socb = this.getSuperObjectByAttribute(this, GlobalObjectClientBean.NAME_ATTRIBUTE, null, false, this.getClassObject(AccessControlListObjectClientBean.CLASS_NAME));
        if (socb != null && (len = socb.length) > 0) {
            allAcl = new AccessControlListObjectClientBean[len];
            for (int i = 0; i < len; ++i) {
                allAcl[i] = (AccessControlListObjectClientBean)socb[i];
            }
        }
        return allAcl;
    }

    public AccessControlListObjectClientBean getAclByName(String name) throws Exception {
        return this.getAclByName(name, AccessControlListObjectClientBean.CLASS_NAME);
    }

    public AccessControlListObjectClientBean getAclByName(String name, String classname) throws Exception {
        AccessControlListObjectClientBean aclocb = null;
        SuperObjectClientBean[] soArr = this.getSuperObjectByAttribute(this, GlobalObjectClientBean.NAME_ATTRIBUTE, name, false, this.getClassObject(classname));
        if (soArr != null) {
            aclocb = (AccessControlListObjectClientBean)soArr[0];
        }
        return aclocb;
    }

    public CustomAclObjectClientBean getCustomAclByName(String name) throws Exception {
        return (CustomAclObjectClientBean)this.getAclByName(name, CustomAclObjectClientBean.CLASS_NAME);
    }

    public SystemAclObjectClientBean getSystemAclByName(String name) throws Exception {
        return (SystemAclObjectClientBean)this.getAclByName(name, SystemAclObjectClientBean.CLASS_NAME);
    }

    public long getAclUsedCount(AccessControlListObjectClientBean acl) throws Exception {
        SearchClass sc = new SearchClass(this);
        sc.setClassname(new String[]{GlobalObjectClientBean.CLASS_NAME});
        sc.setAttributeEQUAL(GlobalObjectClientBean.CLASS_NAME, GlobalObjectClientBean.ACL_ATTRIBUTE, (Object)acl, false);
        sc.setCountOnly(true);
        sc.openSearch(GlobalObjectClientBean.CLASS_NAME, "AccessControlListObjectCallBack.executeBeforeDelete");
        long counter = sc.getSelectCounter();
        sc.closeSearch();
        if (counter == 0L) {
            counter = this.getScopeAclCount(acl);
        }
        return counter;
    }

    public PermissionBundleObjectClientBean getPermissionBundleByName(String name) throws Exception {
        PermissionBundleObjectClientBean pblocb = null;
        SuperObjectClientBean[] soArr = this.getSuperObjectByAttribute(this, GlobalObjectClientBean.NAME_ATTRIBUTE, name, false, this.getClassObject(PermissionBundleObjectClientBean.CLASS_NAME));
        if (soArr != null) {
            pblocb = (PermissionBundleObjectClientBean)soArr[0];
        }
        return pblocb;
    }

    public PropertyBundleObjectClientBean getPropertyBundleByName(String name) throws Exception {
        PropertyBundleCache cache = PropertyBundleCache.getInstance(this);
        PropertyBundleObjectClientBean pbocb = cache.getPropertyBundleFromCache(name);
        if (pbocb == null) {
            SuperObjectClientBean[] soArr = this.getSuperObjectByAttribute(this, GlobalObjectClientBean.NAME_ATTRIBUTE, name, false, this.getClassObject(PropertyBundleObjectClientBean.CLASS_NAME));
            if (soArr != null) {
                pbocb = (PropertyBundleObjectClientBean)soArr[0];
            }
            if (pbocb != null) {
                cache.putPropertyBundleToCache(name, pbocb);
            }
        }
        return pbocb;
    }

    public SuperObjectClientBean[] getSuperObjectByAttribute(SessionController sessionController, String attributeName, Object value, boolean ignoreCase, ClassObjectClientBean classObject) throws Exception {
        if (classObject != null) {
            return this.getSystemSessionRemote().getSuperObjectByAttribute(this, attributeName, value, ignoreCase, classObject);
        }
        return null;
    }

    public SuperObjectClientBean[] getSuperObjectByAttributes(SessionController sessionController, ClassObjectClientBean classObject, String[] attributeName, Object[] value, int[] qualification, boolean[] ignorecase, int[] clause, String[] sortAttribute, int[] sortOrder) throws Exception {
        return this.getSuperObjectByAttributes(sessionController, classObject, attributeName, value, qualification, ignorecase, clause, sortAttribute, sortOrder, -1);
    }

    public SuperObjectClientBean[] getSuperObjectByAttributes(SessionController sessionController, ClassObjectClientBean classObject, String[] attributeName, Object[] value, int[] qualification, boolean[] ignorecase, int[] clause, String[] sortAttribute, int[] sortOrder, int limit) throws Exception {
        if (classObject != null) {
            return this.getSystemSessionRemote().getSuperObjectByAttributes(sessionController, classObject, attributeName, value, qualification, ignorecase, clause, sortAttribute, sortOrder, limit);
        }
        return null;
    }

    public SuperObjectClientBean[] getSuperObjectByAttribute(SessionController sessionController, String attributeName, Object value, boolean ignoreCase, String operator, ClassObjectClientBean classObject) throws Exception {
        if (classObject != null) {
            return this.getSystemSessionRemote().getSuperObjectByAttribute(sessionController, attributeName, value, ignoreCase, operator, classObject);
        }
        return null;
    }

    public void initDirectoryUserObject(String userName) throws Exception {
        if (!this.userIsInitialized) {
            this.userIsInitialized = true;
            DirectoryUserObjectClientBean user = this.getUserByName(userName);
            if (!this.isMainAdmin()) {
                this.setReadOnlyMode(user.getReadOnlyMode());
            }
            if (!user.isLocked() || "roi".equalsIgnoreCase(userName)) {
                long time = System.currentTimeMillis();
                this.setLoginUser(user);
                long time1 = System.currentTimeMillis();
                stat.debug().objectId(this.sessionId).send("Time setDirectoryUserObject: " + (time1 - time));
            } else {
                ExceptionUtils.handleException("User " + userName + " is locked.", "agorum.roi.remote.exception.UserIsLocked", 204);
            }
        } else {
            ExceptionUtils.handleException("User has already been initialized.", "agorum.roi.remote.exception.UserIsInitialized", 205);
        }
    }

    public AccessControlListObjectClientBean createDirectoryUserAcl(DirectoryUserObjectClientBean user, String prefix) throws Exception {
        return this.createDirectoryUserAcl(user, prefix, null, true);
    }

    public AccessControlListObjectClientBean createDirectoryUserAcl(DirectoryUserObjectClientBean user, String prefix, boolean adminsAffected) throws Exception {
        return this.createDirectoryUserAcl(user, prefix, null, adminsAffected);
    }

    public AccessControlListObjectClientBean createDirectoryUserAcl(DirectoryUserObjectClientBean user, String prefix, String permission) throws Exception {
        return this.createDirectoryObjectAcl(user, prefix, permission, true);
    }

    public AccessControlListObjectClientBean createDirectoryUserAcl(DirectoryUserObjectClientBean user, String prefix, String permission, boolean adminsAffected) throws Exception {
        return this.createDirectoryObjectAcl(user, prefix, permission, adminsAffected);
    }

    public AccessControlListObjectClientBean createDirectoryObjectAcl(DirectoryObjectClientBean directoryObject, String prefix, String permission) throws Exception {
        return this.createDirectoryObjectAcl(directoryObject, prefix, permission, true);
    }

    public AccessControlListObjectClientBean createDirectoryObjectAcl(DirectoryObjectClientBean directoryObject, String prefix, String permission, boolean adminsAffected) throws Exception {
        AccessControlListObjectClientBean acl;
        boolean isUser = true;
        if (directoryObject instanceof DirectoryGroupObjectClientBean) {
            isUser = false;
        }
        if ((acl = this.getDirectoryObjectAcl(directoryObject, prefix, isUser)) == null) {
            AccessControlListObjectClientBeanDefinition aclDef = new AccessControlListObjectClientBeanDefinition(this);
            String aclPrefix = isUser ? "ACL_USER_" : "ACL_GROUP_";
            aclDef.setName(aclPrefix + prefix + "_" + directoryObject.getUUID());
            aclDef.setAdminsAffected(adminsAffected);
            AccessControlEntryObjectClientBeanDefinition ace = new AccessControlEntryObjectClientBeanDefinition(this);
            ace.setGranted(true);
            ace.setGrantee(directoryObject);
            ace.setGrantee(directoryObject);
            String permissionBundle = null;
            if (permission == null) {
                permissionBundle = PERMISSION_ALL;
            } else if (permission.equals("ALL")) {
                permissionBundle = PERMISSION_ALL;
            } else if (permission.equals("PROTECTED")) {
                permissionBundle = PERMISSION_PROTECTED;
            } else if (permission.equals("READ")) {
                permissionBundle = PERMISSION_READ;
            } else if (permission.equals("CHECK_OUT")) {
                permissionBundle = PERMISSION_CHECK_OUT;
            } else if (permission.equals("WRITE")) {
                permissionBundle = PERMISSION_WRITE;
            } else {
                throw new Exception("Permisson: " + permission + " not found");
            }
            PermissionBundleObjectClientBean pb = this.getPermissionBundleByName(permissionBundle);
            ace.addPermissionBundle(pb);
            aclDef.addGranteeOrRevokeeAceDefinition(ace);
            acl = (AccessControlListObjectClientBean)this.createGlobalObject(aclDef);
        }
        return acl;
    }

    public AccessControlListObjectClientBean getDirectoryUserAcl(DirectoryUserObjectClientBean user, String prefix) throws Exception {
        return this.getDirectoryObjectAcl(user, prefix, true);
    }

    public AccessControlListObjectClientBean getDirectoryObjectAcl(DirectoryObjectClientBean directoryObject, String prefix, boolean isUser) throws Exception {
        String aclPrefix = isUser ? "ACL_USER_" : "ACL_GROUP_";
        AccessControlListObjectClientBean acl = this.getAclByName(aclPrefix + prefix + "_" + directoryObject.getUUID());
        return acl;
    }

    public void deleteDirectoryUserAcl(DirectoryUserObjectClientBean user, String prefix) throws Exception {
        AccessControlListObjectClientBean acl = this.getAclByName("ACL_USER_" + prefix + "_" + user.getUUID());
        if (this.getScopeAclCount(acl) == 0L) {
            acl.delete();
        }
    }

    public boolean isWorldGroup(long id) throws Exception {
        return id == WORLD_GROUP;
    }

    public boolean isWorldGroup(DirectoryObjectClientBean group) throws Exception {
        return group.getId() == WORLD_GROUP;
    }

    public void resolveAffectedAcls(DirectoryGroupObjectClientBean group) throws Exception {
        try (AclUserResolver res = new AclUserResolver(this);){
            res.resolveAffectedAcls(group);
        }
    }

    public void resolveAcl(AccessControlListObjectClientBean acl) throws Exception {
        try (AclUserResolver res = new AclUserResolver(this);){
            res.resolveAcl(acl);
        }
    }

    public void resolveAdminAffectedAcls() throws Exception {
        AclUserResolver.resolveAdminAffectedAcls(this);
    }

    public void removeAdminAffectedAcls(DirectoryUserObjectClientBean user) throws Exception {
        AclUserResolver.removeAdminAffectedAcls(this, user);
    }

    public void setAdministrationModeEnabledDisabled(boolean ae, Object callerClass) throws Exception {
        if (callerClass instanceof FolderObjectEJB || callerClass instanceof SystemSessionEJB || callerClass instanceof AclUserResolver) {
            this.setAdminEnabled(ae);
        } else {
            ExceptionUtils.handleException("The given function may not set the admin mode.", "agorum.roi.remote.exception.NoAdminAccess", 22);
        }
    }

    public boolean setAdministrationModeEnabled2Disabled(boolean ae, Object callerClass) throws Exception {
        boolean b;
        boolean bl = b = !this.isAdminEnabled();
        if (callerClass instanceof FolderObjectEJB || callerClass instanceof SystemSessionEJB || callerClass instanceof AclUserResolver) {
            this.setAdminEnabled(ae);
        } else {
            ExceptionUtils.handleException("The given function may not set the admin mode.", "agorum.roi.remote.exception.NoAdminAccess", 22);
        }
        return b;
    }

    public boolean isAdminEnabled() {
        return this.adminEnabled;
    }

    public boolean isMainAdmin() {
        try {
            if (this.loginUserId != null) {
                return this.isMainAdmin(this.getLoginUserId(), this.getRoleId());
            }
        }
        catch (Exception e) {
            stat.warning().objectId(this.sessionId).exception((Throwable)e).send("Could not parse login user id");
        }
        return false;
    }

    public boolean isMainAdmin(Long userId, Long roleId) {
        try {
            return Long.valueOf(11000L).equals(userId) || Long.valueOf(11000L).equals(roleId);
        }
        catch (Exception e) {
            stat.warning().objectId(this.sessionId).exception((Throwable)e).send("Could not parse login user id");
            return false;
        }
    }

    public SessionController clone(SystemSessionEJB systemSessionEJB) throws Exception {
        return new SessionController(systemSessionEJB, this.systemSessionRemote, this);
    }

    public SessionController clone() {
        return new SessionController(this);
    }

    public DirectoryUserObjectClientBean createUser(UserManagerBean userManagerBean) throws Exception {
        this.isConnected();
        return this.systemSessionRemote.createUser(this, userManagerBean);
    }

    public ArrayList<EventAssistanceBean> getEventAssistanceList(int amount, String[] classNames, long after) throws Exception {
        this.isConnected();
        return this.systemSessionRemote.getEventAssistanceList(this, classNames, amount, after);
    }

    public ArrayList<EventAssistanceBean> getEventAssistanceList(int amount, String[] classNames, String eventType) throws Exception {
        return this.getEventAssistanceList(amount, classNames, 0L);
    }

    public ArrayList<EventAssistanceBean> getEventAssistanceList(int amount) throws Exception {
        return this.getEventAssistanceList(amount, null, 0L);
    }

    public void setEventAssistanceEntryRead(Long objectId) throws Exception {
        this.isConnected();
        this.systemSessionRemote.setEventAssistanceEntryRead(this, objectId);
    }

    public void setEventAssistanceEntryUnRead(Long objectId) throws Exception {
        this.isConnected();
        this.systemSessionRemote.setEventAssistanceEntryUnRead(this, objectId);
    }

    public void setEventAssistanceAllRead() throws Exception {
        this.isConnected();
        this.systemSessionRemote.setEventAssistanceAllRead(this);
    }

    public void eventAssistanceDeleteExpirationObjects() throws Exception {
        this.isConnected();
        this.systemSessionRemote.eventAssistanceDeleteExpirationObjects(this);
    }

    public boolean isFolder(SuperObjectClientBean clientBean) {
        boolean bRet = false;
        try {
            if (clientBean instanceof FolderObjectClientBean) {
                bRet = ((FolderObjectClientBean)clientBean).getIsFolder();
            }
        }
        catch (Exception e) {
            stat.debug().object((SystemObjectReference)clientBean).send((Throwable)e);
        }
        return bRet;
    }

    public boolean isDocument(SuperObjectClientBean clientBean) {
        boolean bRet = false;
        try {
            bRet = clientBean instanceof ContentInterface;
        }
        catch (Exception e) {
            stat.debug().object((SystemObjectReference)clientBean).send((Throwable)e);
        }
        return bRet;
    }

    public boolean isDownloadDocument(SuperObjectClientBean clientBean) {
        boolean bRet = false;
        try {
            if ((clientBean instanceof FileObjectClientBean || clientBean instanceof FolderDocumentObjectClientBean) && !(clientBean instanceof MailObjectClientBean)) {
                bRet = true;
            }
        }
        catch (Exception e) {
            stat.debug().object((SystemObjectReference)clientBean).send((Throwable)e);
        }
        return bRet;
    }

    public boolean isLegalMailAttachment(SuperObjectClientBean clientBean) {
        boolean bRet = false;
        if (clientBean != null) {
            try {
                String className = clientBean.getClassName().toUpperCase();
                Hashtable<String, String> legalMailAttachmentHash = new Hashtable<String, String>();
                try {
                    MetaDb metaDb = this.getMetaDbInstance();
                    String[] sArray = metaDb.getSimplePropertyValue("MAIN_MODULE_MANAGEMENT/roi/control/mail/AllowedMailAttachmentObjects");
                    if (sArray != null) {
                        for (String s : sArray) {
                            if (s == null || legalMailAttachmentHash.containsKey(s = s.toUpperCase())) continue;
                            legalMailAttachmentHash.put(s, "");
                        }
                    }
                }
                catch (MetaDbException e1) {
                    stat.debug().object((SystemObjectReference)clientBean).send((Throwable)e1);
                }
                if (legalMailAttachmentHash.containsKey(className)) {
                    bRet = true;
                }
            }
            catch (Exception e) {
                stat.debug().object((SystemObjectReference)clientBean).send((Throwable)e);
            }
        }
        return bRet;
    }

    public boolean isFile(SuperObjectClientBean clientBean) {
        boolean bRet = false;
        if (clientBean != null) {
            try {
                String className = clientBean.getClassName().toUpperCase();
                Hashtable<String, String> isFileHash = new Hashtable<String, String>();
                String[] sArray = MetaDbSuperCache.getSimplePropertyValues(this, "MAIN_MODULE_MANAGEMENT/roi/control/IsFile");
                if (sArray != null) {
                    for (String s : sArray) {
                        if (s == null || isFileHash.containsKey(s = s.toUpperCase())) continue;
                        isFileHash.put(s, "");
                    }
                }
                if (isFileHash.containsKey(className)) {
                    bRet = true;
                }
            }
            catch (Exception e) {
                stat.debug().object((SystemObjectReference)clientBean).send((Throwable)e);
            }
        }
        return bRet;
    }

    public Long getSequenceId() throws Exception {
        Long seqId = null;
        if (this.sessionId == 1L) {
            try {
                if (this.sequenceRemote == null) {
                    RoiSequenceIdEntityHome rsieh = (RoiSequenceIdEntityHome)EJBHomeHolder.getHome("ejb/RoiSequenceIdEntity");
                    DbRoiSequencePrimaryKey pk = new DbRoiSequencePrimaryKey();
                    pk.setSequnceIdentifier("ROI_SEQUENCE");
                    this.sequenceRemote = rsieh.findByPrimaryKey(pk);
                }
                seqId = this.sequenceRemote.getSequenceId(1L);
            }
            catch (Exception e) {
                stat.debug().objectId(this.sessionId).send((Throwable)e);
                ExceptionUtils.handleException(e);
            }
        } else {
            SequenceIdController.getInstance();
            seqId = SequenceIdController.getSequenceId();
        }
        return seqId;
    }

    public Long getSequenceIdOld(Connection conn) throws Exception {
        try {
            SequenceGeneratorHome sgh = (SequenceGeneratorHome)EJBHomeHolder.getHome("SequenceGenerator");
            SequenceGenerator sg = sgh.create();
            return new Long(sg.getCount("ROI_SEQUENCE"));
        }
        catch (Exception e) {
            stat.debug().objectId(this.sessionId).send((Throwable)e);
            ExceptionUtils.handleException(e);
            return null;
        }
    }

    public Long getInitialSessionId() {
        return this.initialSessionId;
    }

    public Long getSessionId() {
        return this.sessionId;
    }

    public String getSecureSessionId() {
        return this.secureSessionId;
    }

    public void disconnect() {
        if (this.disconnected) {
            return;
        }
        this.disconnected = true;
        this.userIsInitialized = false;
        if (this.isMainSessionController) {
            stat.info().objectId(this.sessionId).send("sessionController.disconnect(): " + this.sessionId + ", hashcode: " + this.hashCode());
            SessionUnLockService.unlock(this.sessionId, () -> {
                if (this.disconnected) {
                    try {
                        this.systemSessionRemote.remove();
                    }
                    catch (RemoteException | RemoveException e) {
                        throw new IllegalStateException(e);
                    }
                }
            });
        }
    }

    public void disable() throws Exception {
        this.disabled = true;
        this.disconnect();
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    private RoiIndexRemote getRoiIndexRemote() throws Exception {
        try {
            RoiIndexHome home = (RoiIndexHome)EJBHomeHolder.getHome("ejb/RoiIndex");
            return home.create();
        }
        catch (Exception e) {
            stat.debug().objectId(this.sessionId).send((Throwable)e);
            ExceptionUtils.handleException(e);
            return null;
        }
    }

    public List<Long> getUserAclIds(String userId) throws Exception {
        return this.getRoiIndexRemote().getUserAclIds(this, userId);
    }

    public boolean buildIndex(int amount, String indexName) throws Exception {
        stat.debug().objectId(this.sessionId).send("buildIndex: adminEnabled: " + this.isAdminEnabled() + ", loginName: " + this.getLoginUser().getName() + ", sessionId: " + this.sessionId + ", hashCode: " + this.hashCode() + ", isInLogin: " + this.isInLogin);
        if (this.isAdminEnabled() && this.getLoginUser().getName().equalsIgnoreCase("roi")) {
            return this.getRoiIndexRemote().buildIndex(this, amount, indexName);
        }
        ExceptionUtils.handleException("You need admin access", "agorum.roi.remote.exception.NoAdminAccess", 22);
        return false;
    }

    public AdvancedSearchQuery prepareAdvancedSearch(String query) throws Exception {
        return this.getRoiIndexRemote().prepareAdvancedSearch(this, query);
    }

    public void cleanupIndexHash() throws RemoteException, Exception {
        this.getRoiIndexRemote().cleanup(this);
    }

    public void exportIndex(String indexName, boolean secondIndex) throws Exception {
        this.getRoiIndexRemote().exportIndex(this, indexName, secondIndex);
    }

    public void exportFsIndex(SessionController sessionController, boolean secondIndex) throws Exception {
        this.getRoiIndexRemote().exportFsIndex(this, secondIndex);
    }

    public void closeGlobalIndexSearch() throws Exception {
        this.getRoiIndexRemote().closeGlobalIndexSearch(this);
    }

    public void importIndex(String indexName, boolean secondIndex) throws Exception {
        this.getRoiIndexRemote().importIndex(this, indexName, secondIndex);
    }

    public boolean optimize(String indexName) throws Exception {
        if (this.isAdminEnabled() && this.getLoginUser().getName().equalsIgnoreCase("roi")) {
            return this.getRoiIndexRemote().optimize(this, indexName);
        }
        ExceptionUtils.handleException("You need admin access", "agorum.roi.remote.exception.NoAdminAccess", 22);
        return false;
    }

    public List<String> getIndexTerms(String field, String query, int maxAmount) throws Exception {
        return this.getRoiIndexRemote().getTerms(this, field, query, maxAmount);
    }

    public List<String> search(String query, int limit) throws Exception {
        return this.search(query, limit, false);
    }

    public List<String> search(String query, int limit, boolean hidden) throws Exception {
        return this.getRoiIndexRemote().search(this, query, limit, hidden);
    }

    public Vector<String> indexSearch(String queryString, int maxSearchResult) throws Exception {
        return this.indexSearch(queryString, maxSearchResult, false);
    }

    public Vector<String> indexSearch(String queryString, int maxSearchResult, boolean withInfo) throws Exception {
        Vector vRet;
        try (Transaction t = new Transaction();){
            vRet = this.getRoiIndexRemote().indexSearch(this, queryString, maxSearchResult, withInfo);
            t.commit();
        }
        return vRet;
    }

    public Hashtable<String, Long> getAllTableCount() throws Exception {
        return this.getSystemSessionRemote().getAllTableCount(this);
    }

    public SessionController getSessionController() throws Exception {
        return this.mainSessionController == null ? this : this.mainSessionController;
    }

    public DirectoryUserObjectClientBean getDirectoryUserFromEmailAddress(String emailAddress) throws Exception {
        return this.getSystemSessionRemote().getDirectoryUserFromEmailAddress(this, emailAddress);
    }

    public EmailUserProfileObjectClientBean getEmailAddressFromUser(DirectoryUserObjectClientBean user) throws Exception {
        SuperObjectClientBean[] profiles = this.getSuperObjectByAttribute(this, GlobalObjectClientBean.OWNER_ATTRIBUTE, user, false, this.getClassObject(EmailUserProfileObjectClientBean.CLASS_NAME));
        if (profiles != null) {
            return (EmailUserProfileObjectClientBean)profiles[0];
        }
        return null;
    }

    public boolean isObjectExistant(String className, String name) throws Exception {
        return this.getSystemSessionRemote().isObjectExistant(this, className, name);
    }

    public GlobalObjectClientBean[] getMyDeletedObjects() throws Exception {
        return this.getSystemSessionRemote().getMyDeletedObjects(this);
    }

    public GlobalObjectClientBean[] getAllDeletedObjects() throws Exception {
        return this.getSystemSessionRemote().getAllDeletedObjects(this);
    }

    public int getIndexCounter() throws RemoteException, Exception {
        if (this.isAdminEnabled()) {
            return this.getSystemSessionRemote().getIndexCounter(this);
        }
        ExceptionUtils.handleException("You need admin access", "agorum.roi.remote.exception.NoAccess", 21);
        return -2;
    }

    public long getFreeDBSize() throws Exception {
        if (this.isAdminEnabled()) {
            return this.getSystemSessionRemote().getFreeDBSize(this);
        }
        ExceptionUtils.handleException("You need admin access", "agorum.roi.remote.exception.NoAccess", 21);
        return -1L;
    }

    public long getDBSize() throws Exception {
        return this.getSystemSessionRemote().getDbSize(this);
    }

    public long getTotalDbSize() throws Exception {
        long totalSize = -1L;
        try {
            MetaDb metaDb = this.getMetaDbInstance();
            String s = metaDb.getString("MAIN_MODULE_MANAGEMENT/roi/control/dbsettings/TotalDbSize");
            if (s != null) {
                totalSize = Long.parseLong(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return totalSize;
    }

    public AssociatedGroupOfDirectoryObject[] getAssociatedGroupOfDirectoryObject(DirectoryObjectClientBean directoryObject, int depth, boolean unique) throws Exception {
        AssociatedGroupOfDirectoryObject[] associatedGroupOfDirectoryObject = null;
        associatedGroupOfDirectoryObject = this.getSystemSessionRemote().getAssociatedGroupOfDirectoryObject(this, directoryObject, depth, unique);
        return associatedGroupOfDirectoryObject;
    }

    public AccessControlListObjectClientBean[] getAssociatedAclsOfDirectoryUser(DirectoryUserObjectClientBean directoryUserObject) throws Exception {
        AccessControlListObjectClientBean[] acls = null;
        if (this.isAdminEnabled()) {
            acls = this.getSystemSessionRemote().getAssociatedAclsOfDirectoryUser(this, directoryUserObject);
        } else {
            ExceptionUtils.handleException("You need admin access", "agorum.roi.remote.exception.NoAccess", 21);
        }
        return acls;
    }

    public AccessControlListObjectClientBean[] getAssociatedAclsOfDirectoryGroup(DirectoryGroupObjectClientBean directoryGroupObject, boolean directOnly) throws Exception {
        AccessControlListObjectClientBean[] acls = null;
        if (this.isAdminEnabled()) {
            acls = this.getSystemSessionRemote().getAssociatedAclsOfDirectoryGroup(this, directoryGroupObject, directOnly);
        } else {
            ExceptionUtils.handleException("You need admin access", "agorum.roi.remote.exception.NoAccess", 21);
        }
        return acls;
    }

    public CredentialObject getCredential() {
        return this.credential;
    }

    public static SessionController getSessionControllerById(Long sessId) {
        WeakReference<SessionController> ref = sessions.get(sessId);
        return ref == null ? null : (SessionController)ref.get();
    }

    public MetaDb getMetaDbInstance() throws MetaDbException {
        return this.getMetaDbInstance(false);
    }

    private MetaDb getMetaDbInstance(boolean onlyConnected) throws MetaDbException {
        if (this.metaDb == null) {
            MetaDbEnvironment mdbEnv = new MetaDbEnvironment();
            mdbEnv.setParameter("userName", (Object)this.credential.getUserName());
            if (this.credential.getPassWord() != null) {
                mdbEnv.setParameter("passWord", (Object)this.credential.getPassWord());
            }
            if (this.metaDbSessionKey == null) {
                mdbEnv.setParameter("sessionController", (Object)this);
                this.metaDb = MetaDb.getInstance((MetaDbEnvironment)mdbEnv, (boolean)onlyConnected);
                this.metaDbSessionKey = this.metaDb.getSessionKey();
            } else {
                mdbEnv.setSessionKey(this.metaDbSessionKey);
                this.metaDb = MetaDb.getInstance((MetaDbEnvironment)mdbEnv, (boolean)onlyConnected);
            }
        }
        return this.metaDb;
    }

    public String getDecodedSystemPassword(String userName) {
        String password = "";
        try {
            DirectoryUserObjectClientBean user = this.getUserByName(userName);
            CredentialObject credential = new CredentialObject();
            credential.setUserName(userName);
            BaseCredentialManager cm = (BaseCredentialManager)BaseCredentialManager.getCredentialManager(credential);
            String encodedPassword = this.getSystemSessionRemote().getEncodedNTPassword(this, credential);
            password = cm.getDecodedNTPassword(this, encodedPassword, user);
        }
        catch (Exception e) {
            stat.warning().objectId(this.sessionId).send((Throwable)e);
        }
        return password;
    }

    public String getWebServiceSessionId() {
        String wsSessionId = "WSSID_" + this.secureSessionId;
        WebServiceSessionBean wsBean = WebServiceSessionCache.get((String)wsSessionId);
        if (wsBean == null) {
            wsBean = new WebServiceSessionBean();
            wsBean.setWsSessionId(wsSessionId);
            wsBean.setAttribute("SessionController", (Object)this);
            WebServiceSessionCache.put((String)wsSessionId, (WebServiceSessionBean)wsBean);
        }
        return wsSessionId;
    }

    public static SessionController getWebServiceSessionController(String wsSessionId) {
        WebServiceSessionBean wsBean = WebServiceSessionCache.get((String)wsSessionId);
        if (wsBean == null) {
            return null;
        }
        return (SessionController)wsBean.getAttribute("SessionController");
    }

    public static WebServiceSessionBean getWsSessionBean(String wsSessionId) {
        return WebServiceSessionCache.get((String)wsSessionId);
    }

    public void setWebServiceSessionController(WebServiceSessionBean wsBean) {
        WebServiceSessionBean cached = WebServiceSessionCache.get((String)wsBean.getWsSessionId());
        if (cached == null) {
            cached = wsBean;
            WebServiceSessionCache.put((String)wsBean.getWsSessionId(), (WebServiceSessionBean)cached);
        }
        cached.setAttribute("SessionController", (Object)this);
    }

    public void setCheckAccessUser(DirectoryObjectClientBean user) {
        this.checkAccessUser = user;
    }

    public DirectoryObjectClientBean getCheckAccessUser() {
        return this.checkAccessUser;
    }

    public SessionInfoObjectClientBean getSessionInfoObject() throws Exception {
        return this.getSessionInfoObject(this.getSessionId());
    }

    public SessionInfoObjectClientBean getSessionInfoObject(Long sessionId) throws Exception {
        SessionInfoObjectClientBean sessionInfo = null;
        if (this.isAdminEnabled() || sessionId.longValue() == this.getSessionId().longValue()) {
            SuperObjectClientBean[] sessionInfoInternal = this.getSuperObjectByAttribute(this, "SISESSIONID", sessionId, false, this.getClassObject(SessionInfoObjectClientBean.CLASS_NAME));
            if (sessionInfoInternal != null) {
                sessionInfo = (SessionInfoObjectClientBean)sessionInfoInternal[0];
            }
        } else {
            ExceptionUtils.handleException("You need admin access", "agorum.roi.remote.exception.NoAdminAccess", 22);
        }
        return sessionInfo;
    }

    private static SessionInfoObjectClientBean createSessionInfoObject(SessionController sessionController, CredentialObject credentialObject) throws Exception {
        if (sessionInfoCheck != null) {
            sessionInfoCheck.checkSessionInfo(sessionController, credentialObject);
        }
        SessionInfoObjectClientBeanDefinition def = new SessionInfoObjectClientBeanDefinition(sessionController);
        def.setSiLoginUser(sessionController.getLoginUser());
        def.setSiSessionId(sessionController.getSessionId());
        def.setSiLoginDate(new Date());
        def.setSiLastAccessDate(new Date());
        def.setSiActive(true);
        if (credentialObject.getModulInfo() != null) {
            def.setSiModulInfo(credentialObject.getModulInfo());
        } else {
            Exception e = new Exception("Dieser Login hat noch keine ModulInfo");
            stat.warning().objectId(sessionController.sessionId).send((Throwable)e);
        }
        if (credentialObject.getClientInfo() != null) {
            def.setSiClientInfo(credentialObject.getClientInfo());
        }
        if (credentialObject.getIp() != null) {
            def.setSiIp(credentialObject.getIp());
        }
        if (credentialObject.getMac() != null) {
            def.setSiMac(credentialObject.getMac());
        }
        SessionInfoObjectClientBean sessionInfo = (SessionInfoObjectClientBean)sessionController.createInternalObject(def);
        sessionController.isSessionInfoCreated = true;
        return sessionInfo;
    }

    public String getModulInfo() throws Exception {
        if (this.modulInfo == null && this.getSessionInfoObject() != null) {
            this.modulInfo = this.getSessionInfoObject().getSiModulInfo();
        }
        return this.modulInfo;
    }

    public boolean existGlobalObjectById(Long id) throws Exception {
        return this.getSystemSessionRemote().existGlobalObjectById(this, id);
    }

    public void reInitStartup() throws Exception {
        this.getSystemSessionRemote().reInitStartup(this);
    }

    public Date getDeleteObjectsExpirationDate(GlobalObjectClientBean globalObject) throws Exception {
        return this.getDeleteObjectsExpirationDate(globalObject, DELETEOBJECTSEXPIRATIONTIMEMETADBPATH);
    }

    public Date getDeleteObjectsExpirationDate(GlobalObjectClientBean globalObject, String metaDbPath) throws Exception {
        MetaDb myMetaDb = this.getMetaDbInstance();
        long expireTime = myMetaDb.getLong(metaDbPath, -1L);
        if (expireTime == -1L) {
            expireTime = myMetaDb.getLong(DELETEOBJECTSEXPIRATIONTIMEMETADBPATH, -1L);
        }
        if (expireTime == -1L) {
            expireTime = 168L;
        }
        return new Date(System.currentTimeMillis() + expireTime * 60L * 60L * 1000L);
    }

    private void setAdminEnabled(boolean b) {
        if (!this.userIsAdminSet) {
            String lName = null;
            try {
                lName = this.getLoginUser().getName();
            }
            catch (Exception e) {
                stat.debug().objectId(this.sessionId).exception((Throwable)e).send("Could not get login user name");
            }
            if (lName != null && "roi".equalsIgnoreCase(lName)) {
                this.userIsAdminSet = true;
            }
        }
        this.adminEnabled = b;
    }

    public boolean isModuleInstalled(String name) {
        boolean installed = false;
        SuperObjectClientBean[] soArr = null;
        try {
            soArr = this.getSuperObjectByAttribute(this, "MODUL", name, false, this.getClassObject(VersionObjectClientBean.CLASS_NAME));
        }
        catch (Exception e) {
            stat.debug().objectId(this.sessionId).exception((Throwable)e).send("Unable to get module by name: " + name);
        }
        if (soArr != null && soArr.length > 0) {
            installed = true;
        }
        return installed;
    }

    public boolean getDoNotEA() {
        return this.doNotEA;
    }

    public void setDoNotEA(boolean doNotEA) {
        this.doNotEA = doNotEA;
    }

    public boolean getReadOnlyMode() {
        return this.readOnlyMode;
    }

    public void setReadOnlyMode(boolean readOnlyMode) {
        this.readOnlyMode = readOnlyMode;
    }

    public Hashtable<String, String> getNetworkAccessSettings() {
        return this.networkAccessSettings;
    }

    public void setNetworkAccessSettings(Hashtable<String, String> networkAccessSettings) {
        this.networkAccessSettings = networkAccessSettings;
    }

    public Map<String, Object> getSessionObjectCache() {
        return this.sessionObjectCache;
    }

    public Object get(Object key) {
        return this.context.get(key);
    }

    public Object put(String key, Object value) {
        return this.context.put(key, value);
    }

    public Object remove(Object key) {
        return this.context.remove(key);
    }

    public AccessControlListObjectClientBean getEntityAcl(DirectoryObjectClientBean entity, String permission, String postfix) throws Exception {
        if (entity instanceof DirectoryUserObjectClientBean) {
            return this.getUserAcl((DirectoryUserObjectClientBean)entity, permission, postfix);
        }
        if (entity instanceof DirectoryGroupObjectClientBean) {
            return this.getGroupAcl((DirectoryGroupObjectClientBean)entity, permission, postfix);
        }
        stat.warning().objectId(this.sessionId).send("getEntityAcl(): Unsupported entity: " + entity);
        return null;
    }

    public AccessControlListObjectClientBean getUserAcl(DirectoryUserObjectClientBean user, String permission, String postfix) throws Exception {
        AccessControlListObjectClientBean userAcl = null;
        String prefix = "ACL_USER_" + postfix;
        try {
            userAcl = this.getAclByName(prefix + permission + "_" + user.getUUID());
        }
        catch (Exception e2) {
            stat.warning().objectId(this.sessionId).send((Throwable)e2);
        }
        if (userAcl == null) {
            try {
                userAcl = this.createDirectoryUserAcl(user, postfix + permission, permission);
            }
            catch (Exception e) {
                stat.warning().objectId(this.sessionId).send((Throwable)e);
                throw e;
            }
        }
        return userAcl;
    }

    public void setAuditState(int auditState) {
        this.auditState = auditState;
    }

    public int getAuditState() {
        return this.auditState;
    }

    public AccessControlListObjectClientBean getGroupAcl(DirectoryGroupObjectClientBean group, String permission, String postfix) {
        AccessControlListObjectClientBean userAcl = null;
        String prefix = "ACL_GROUP_" + postfix;
        try {
            userAcl = this.getAclByName(prefix + permission + "_" + group.getUUID());
        }
        catch (Exception e1) {
            stat.warning().objectId(this.sessionId).send((Throwable)e1);
        }
        if (userAcl == null) {
            try {
                userAcl = this.createDirectoryObjectAcl(group, postfix + permission, permission);
            }
            catch (Exception e2) {
                stat.warning().objectId(this.sessionId).send((Throwable)e2);
            }
        }
        return userAcl;
    }

    public boolean makeContentTask() {
        return this.makeContentTask;
    }

    public void setMakeContentTask(boolean b) {
        this.makeContentTask = b;
    }

    public void setAuditEnable(boolean b) {
        if (b) {
            this.setAuditState(AuditUtil.ACTION_EXT_NORMAL);
        } else {
            this.setAuditState(AuditUtil.ACTION_EXT_NOT_ENTRY);
        }
    }

    public boolean isAuditEnabled() {
        return this.getAuditState() != AuditUtil.ACTION_EXT_NOT_ENTRY;
    }

    public void setInSynchronization(boolean b) throws Exception {
        if (!this.isAdminEnabled()) {
            throw new Exception("Synchronization mode is only allowed for admin-users");
        }
        this.inSynchronization = b;
    }

    public boolean isInSychronization() {
        return this.inSynchronization;
    }

    public void setForceAudit(boolean b) throws Exception {
        if (!this.isAdminEnabled()) {
            throw new Exception("Force audit is only allowed for admin-users");
        }
        this.forceAudit = b;
    }

    public boolean forceAudit() {
        return this.forceAudit;
    }

    public String getClassNameFromClassId(Long id) throws Exception {
        String classId = classNameIdMap.get(id);
        if (classId == null) {
            classId = this.getClassObject(id).getName();
            classNameIdMap.put(id, classId);
        }
        return classId;
    }

    public SuperObjectClientBean getEmptyClassObject(String classNameObj) throws Exception {
        SuperObjectClientBean soObj = null;
        try {
            String className = null;
            if (classNameMap.containsKey(classNameObj)) {
                className = classNameMap.get(classNameObj);
            } else {
                try {
                    ClassObjectClientBean classObj = this.getClassObject(classNameObj);
                    className = classObj.getClientBeanClass();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (className == null) {
                    className = "notfound";
                }
                classNameMap.put(classNameObj, className);
            }
            if (!"notfound".equals(className)) {
                soObj = (SuperObjectClientBean)ClassHolder.getClassInstance(className).newInstance();
            }
        }
        catch (Exception e) {
            stat.debug().objectId(this.sessionId).exception((Throwable)e).send("Class not found: " + classNameObj + ", do not sync this object");
        }
        return soObj;
    }

    public void setLocale(Locale newLocale) {
        this.locale = newLocale;
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        try {
            String language = this.getLoginUser().getInfoUserProfile().getLanguage();
            String country = MetaDbSuperCache.getSimplePropertyValue(this, "MAIN_MODULE_MANAGEMENT/roi/control/i18n/defaults/country", "");
            String variant = MetaDbSuperCache.getSimplePropertyValue(this, "MAIN_MODULE_MANAGEMENT/roi/control/i18n/defaults/variant", null);
            if (language != null) {
                String[] parts = language.split("_");
                if (parts.length == 1) {
                    language = parts[0];
                } else if (parts.length == 2) {
                    language = parts[0];
                    country = parts[1];
                } else if (parts.length == 3) {
                    language = parts[0];
                    country = parts[1];
                    variant = parts[2];
                }
            }
            if (variant == null) {
                variant = "";
            }
            this.locale = new Locale(language, country, variant);
        }
        catch (Exception e) {
            stat.debug().objectId(this.sessionId).send((Throwable)e);
            this.locale = Locale.ENGLISH;
        }
        return this.locale;
    }

    public boolean isQuotaCheckDisabled() {
        return this.quotaCheckDisabled;
    }

    public void setQuotaCheckDisabled(boolean b) {
        this.quotaCheckDisabled = b;
    }

    public static FolderObjectClientBean getHomeFolder(DirectoryUserObjectClientBean user) throws Exception {
        return user.getPrimaryUserProfile().getHomeFolder();
    }

    public FolderObjectClientBean getHomeFolder() throws Exception {
        return this.getLoginUser().getPrimaryUserProfile().getHomeFolder();
    }

    public SessionController getSessionControllerForUser(String ident, DirectoryUserObjectClientBean user) throws Exception {
        if (this.isAdminEnabled()) {
            CredentialObject credential = new CredentialObject();
            credential.setUserName(user.getName());
            credential.setModulInfo(ident);
            credential.setAuthInterface(new ServiceAuthInterface());
            return SessionController.connect(credential);
        }
        throw new Exception("Only admin may do this");
    }

    public SessionController asAdmin() throws Exception {
        SessionController adminSessionController = new SessionController(this);
        adminSessionController.adminEnabled = true;
        adminSessionController.setRole(this.getUserByName(new RoiProperties().getRoiSystemUser()));
        return adminSessionController;
    }

    public SessionController asUser(DirectoryUserObjectClientBean user) throws Exception {
        if (!this.isAdminEnabled()) {
            throw new Exception("only admin is allowed to do this");
        }
        SessionController userSessionController = new SessionController(this);
        userSessionController.setLoginUserWithAdminEnabled(user);
        userSessionController.loginUserId = user.getId();
        userSessionController.readOnlyMode = user.getReadOnlyMode();
        userSessionController.loginUserUuid = user.getUUID();
        userSessionController.role = null;
        userSessionController.roleId = null;
        return userSessionController;
    }

    public boolean checkAllowedIdentity(String metaDbPath) throws Exception {
        MetaDb metaDb = this.getMetaDbInstance();
        String userOrGroup = metaDb.getString(metaDbPath + "/AllowedIdentity");
        if (userOrGroup != null) {
            SessionController sessionControllerAdmin = SessionControllerAdmin.getSessionControllerAdmin("checkAllowedIdentity");
            boolean valid = this.checkIdentity(sessionControllerAdmin, this.getLoginUser().getName(), userOrGroup);
            return valid;
        }
        return true;
    }

    private boolean checkIdentity(SessionController sc, String givenUserName, String userOrGroupId) throws Exception {
        boolean valid = false;
        DirectoryObjectClientBean dObj = null;
        try {
            dObj = (DirectoryObjectClientBean)sc.getGlobalObjectById(new Long(userOrGroupId));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dObj == null) {
            try {
                dObj = sc.getUserByName(userOrGroupId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (dObj == null) {
            try {
                dObj = sc.getGroupByName(userOrGroupId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (dObj == null) {
            throw new Exception("Given user or group not found with key: " + userOrGroupId);
        }
        if (dObj instanceof DirectoryUserObjectClientBean) {
            String userName = null;
            try {
                userName = dObj.getName();
            }
            catch (Exception e) {
                throw new Exception("Error getting username of allowedIdentity", e);
            }
            if (userName.equalsIgnoreCase(givenUserName)) {
                valid = true;
            }
        } else if (dObj instanceof DirectoryGroupObjectClientBean) {
            DirectoryUserObjectClientBean loginUser = null;
            try {
                loginUser = sc.getUserByName(givenUserName);
            }
            catch (Exception e) {
                throw new Exception("User not found: " + givenUserName, e);
            }
            DirectoryGroupObjectClientBean group = (DirectoryGroupObjectClientBean)dObj;
            try {
                valid = group.checkEffectiveAccess(loginUser, 1L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return valid;
    }

    public boolean getIsInitialized() {
        return this.initialized;
    }

    public void setIsInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public Hashtable<Long, Hashtable<String, Object>> getTableSelectStatementCache() {
        return this.tableSelectStatementCache;
    }

    public ApplicationHashtable getEffectiveAttributes() throws Exception {
        return this.effectiveAttributes;
    }

    public ApplicationHashtable getAllAttributes() throws Exception {
        return this.allAttributes;
    }

    public ApplicationHashtable getAllClassObjects() throws Exception {
        return this.allClassObjects;
    }

    public ApplicationHashtable getAllFormatObjects() throws Exception {
        return this.allFormatObjects;
    }

    public ApplicationHashtable getAllClassObjectsByName() throws Exception {
        return this.allClassObjectsByName;
    }

    public void setEffectiveAttributes(ApplicationHashtable h) throws Exception {
        this.effectiveAttributes = h;
    }

    public void setAllAttributes(ApplicationHashtable h) throws Exception {
        this.allAttributes = h;
    }

    public void setAllClassObjects(ApplicationHashtable h) throws Exception {
        this.allClassObjects = h;
    }

    public void setAllFormatObjects(ApplicationHashtable h) throws Exception {
        this.allFormatObjects = h;
    }

    public void setAllClassObjectsByName(ApplicationHashtable h) throws Exception {
        this.allClassObjectsByName = h;
    }

    public void initRole(String roleName) throws Exception {
        if (!this.roleIsInitialized) {
            this.roleIsInitialized = true;
            DirectoryUserObjectClientBean role = null;
            role = roleName == null ? (DirectoryUserObjectClientBean)this.getLoginUser().getDefaultRole() : this.getUserByName(roleName);
            this.setRole(role);
        } else {
            ExceptionUtils.handleException("Role has already been initialized.", "agorum.roi.remote.exception.RoleIsInitialized", 206);
        }
    }

    public DirectoryUserObjectClientBean getLoginUser() {
        return this.loginUser;
    }

    private void setLoginUser(DirectoryUserObjectClientBean loginUser) {
        this.loginUser = loginUser;
        this.loginUserId = loginUser.getId();
        this.loginUserUuid = loginUser.getUUID();
    }

    private void setLoginUserWithAdminEnabled(DirectoryUserObjectClientBean loginUser) throws Exception {
        this.loginUser = loginUser;
        this.adminEnabled = loginUser.getAdminenabled();
    }

    public Long getLoginUserId() {
        if (this.loginUserId == null) {
            this.loginUserId = this.getLoginUser().getId();
        }
        return this.loginUserId;
    }

    public String getLoginUserUuid() {
        if (this.loginUserUuid == null) {
            this.loginUserUuid = this.getLoginUser().getUUID();
        }
        return this.loginUserUuid;
    }

    public DirectoryUserObjectClientBean getRole() throws Exception {
        if (this.role != null) {
            return this.role;
        }
        return this.getLoginUser();
    }

    private void setRole(DirectoryUserObjectClientBean role) {
        this.role = role;
        this.roleId = null;
    }

    public Long getRoleId() throws Exception {
        if (this.isInInit) {
            return this.getRole().getId();
        }
        if (this.roleId == null) {
            this.roleId = this.getRole().getId();
        }
        return this.roleId;
    }

    public AccessControlListObjectClientBean getLoginUserDefaultAcl() throws Exception {
        if (this.loginUserDefaultAcl == null) {
            this.loginUserDefaultAcl = this.loginUser.getPrimaryUserProfile().getDefaultAcl();
        }
        return this.loginUserDefaultAcl;
    }

    public boolean isInClusterMode() {
        return this.get("clusterMode") != null;
    }

    public void enableClusterMode() {
        this.put("clusterMode", "");
    }

    public void disableClusterMode() {
        this.remove("clusterMode");
    }

    public String translate(String textKey) {
        return WebResourcesHelper.getInstance().getText(this.getLocale(), textKey);
    }

    public String tryTranslate(String str) {
        String translated;
        String key;
        if (str != null && str.startsWith("_") && !(key = str.substring(1)).equals(translated = this.translate(key))) {
            return translated;
        }
        return str;
    }

    public void performanceTestDb(Map<String, PerformanceValueHolder> times, SystemCheck systemCheck) throws Exception {
        this.isConnected();
        SystemSessionRemote remote = this.getSystemSessionRemote();
        remote.performanceTestDb(this, times, systemCheck);
    }

    public String getDatabaseDriverName() throws Exception {
        this.isConnected();
        SystemSessionRemote remote = this.getSystemSessionRemote();
        return remote.getDatabaseDriverName(this);
    }

    public String getCoreUuid() {
        return MetaDbSuperCache.getSimplePropertyValue(this, METADB_CORE_UUID);
    }

    public long getTtl() {
        return this.ttl;
    }

    public void setTtl(long ttl) {
        this.ttl = ttl;
    }

    public SessionController noExpiration() {
        this.setTtl(-1L);
        return this;
    }

    public SessionController asService() {
        return this.clone().makeService();
    }

    public SessionController makeService() {
        this.service = true;
        this.doNotEA = true;
        return this;
    }

    public boolean isService() {
        return this.service;
    }

    public boolean isLastLoginIndexed() {
        return this.lastLoginIndexed;
    }

    public void setLastLoginIndexed(boolean lastLoginIndexed) {
        this.lastLoginIndexed = lastLoginIndexed;
    }

    public Long getObjectIdNextHistoryEnsured() {
        return this.objectNextHistoryEnsured;
    }

    public void resetObjectIdNextHistoryEnsured() {
        this.objectNextHistoryEnsured = null;
    }

    public SessionController getSessionWithEnsuredHistory(Long id) {
        SessionController sc = this.clone();
        sc.objectNextHistoryEnsured = id;
        return sc;
    }

    public DirectoryUserObjectClientBean getUnknownUserObject() {
        UnknownDirectoryUserObjectClientBean unknown = new UnknownDirectoryUserObjectClientBean();
        unknown.setSessionController(this);
        return unknown;
    }

    static {
        classNameIdMap = new HashMap<Long, String>();
        classNameMap = new HashMap<String, String>();
        formatCache = new ConcurrentHashMap<String, Long>();
        sessions = new ConcurrentHashMap<Long, WeakReference<SessionController>>();
        SESSION_MANAGER = SessionController.class.getName() + "_SessionManager";
        SystemTimer.ofPeriod((long)60000L).call(() -> {
            SessionController sc;
            int active = 0;
            int expired = 0;
            for (WeakReference<SessionController> ref : sessions.values()) {
                sc = (SessionController)ref.get();
                if (sc == null) continue;
                if (sc.ttl > 0L && sc.lastActionTime + sc.ttl < System.currentTimeMillis()) {
                    ++expired;
                    stat.debug("Disconnecting expired session " + sc.sessionId + " (" + sc.initialSessionId + ")");
                    try {
                        sc.disconnect();
                    }
                    catch (Exception e) {
                        stat.error((Throwable)e);
                    }
                    continue;
                }
                ++active;
            }
            stat.measure("Active sessions", (long)active);
            stat.count("Expired sessions", (long)expired);
            Iterator<WeakReference<SessionController>> iter = sessions.values().iterator();
            while (iter.hasNext()) {
                WeakReference<SessionController> ref;
                ref = iter.next();
                sc = (SessionController)ref.get();
                if (sc == null) {
                    iter.remove();
                    continue;
                }
                if (!sc.disconnected) continue;
                stat.debug("Removing disconnected session " + sc.sessionId + " (" + sc.initialSessionId + ")");
                iter.remove();
            }
            try (Transaction t = new Transaction();){
                Transaction.put(SESSION_MANAGER);
                int count = 0;
                for (WeakReference<SessionController> ref : sessions.values()) {
                    SessionController sc2 = (SessionController)ref.get();
                    if (sc2 == null) continue;
                    if (++count > 100) {
                        t.restart();
                        Transaction.put(SESSION_MANAGER);
                        count = 0;
                    }
                    if (!sc2.isSessionInfoCreated) continue;
                    try {
                        SessionInfoObjectClientBean sessionInfo = sc2.getSessionInfoObject();
                        if (sessionInfo == null) continue;
                        sessionInfo.setSiLastAccessDate(new Date(sc2.lastActionTime));
                        if (sc2.isLastLoginIndexed()) continue;
                        sessionInfo.getSiLoginUser().reIndex();
                        sc2.setLastLoginIndexed(true);
                    }
                    catch (Exception e) {
                        stat.error((Throwable)e);
                    }
                }
                t.commit();
            }
        });
    }
}

