/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.roi.common.beans.IndexObjectHolder;
import agorum.roi.ejb.common.ConnectionUtils;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.ejb.common.Transaction;
import agorum.roi.ejb.database.common.DatabaseUtils;
import agorum.roi.ejb.mbeans.TextIndexService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class TextIndexQueue {
    private static final String ME = TextIndexQueue.class.getName();

    public static void insert(int priority, long id, String uuid) throws Exception {
        IndexObjectHolder other;
        if (RoiTransactionHandler.getThreadTransaction() == null) {
            throw new IllegalStateException("Index consistency violation: Enclosing transaction required");
        }
        HashMap<Long, IndexObjectHolder> map = (HashMap<Long, IndexObjectHolder>)Transaction.get(ME);
        if (map == null) {
            map = new HashMap<Long, IndexObjectHolder>();
            Transaction.put(ME, map);
            HashMap<Long, IndexObjectHolder> myMap = map;
            Transaction.beforeCommit(ME, () -> {
                try (Connection conn = new ConnectionUtils().getConnection();){
                    for (IndexObjectHolder ioh : myMap.values()) {
                        TextIndexQueue.insert(conn, ioh);
                    }
                }
            });
            Transaction.afterCommit(ME, () -> TextIndexService.wake());
        }
        if ((other = (IndexObjectHolder)map.get(id)) != null && other.getPriority() < priority) {
            return;
        }
        map.put(id, new IndexObjectHolder(priority, id, uuid, -1L));
    }

    public static void insert(Connection conn, IndexObjectHolder ioh) throws SQLException {
        try (PreparedStatement ps = conn.prepareStatement("insert into " + ioh.getQueue() + " (id, uuid) values (?, ?)");){
            ps.setLong(1, ioh.getRawId());
            ps.setString(2, ioh.getUuid());
            ps.execute();
        }
    }

    public static List<IndexObjectHolder> collect(Connection conn, int limit) throws Exception {
        int remaining;
        ArrayList<IndexObjectHolder> work = new ArrayList<IndexObjectHolder>(limit);
        TextIndexQueue.collect(conn, 0, limit / 2, work);
        TextIndexQueue.collect(conn, 1, limit / 3, work);
        TextIndexQueue.collect(conn, 2, limit / 6, work);
        for (int i = 0; i < 3 && (remaining = limit - work.size()) > 0; ++i) {
            TextIndexQueue.collect(conn, i, remaining, work);
        }
        return work;
    }

    public static void clearDuplicates(Connection conn, IndexObjectHolder ioh) throws SQLException {
        TextIndexQueue.clearDuplicates(conn, 0, ioh);
        TextIndexQueue.clearDuplicates(conn, 1, ioh);
        TextIndexQueue.clearDuplicates(conn, 2, ioh);
    }

    public static void delete(Connection conn, IndexObjectHolder ioh) throws SQLException {
        TextIndexQueue.delete(conn, ioh.getQueue(), ioh.getRawId(), ioh.getSortId());
    }

    private static void collect(Connection conn, int priority, int limit, Collection<IndexObjectHolder> work) throws Exception {
        String queue = IndexObjectHolder.getQueue(priority);
        try (PreparedStatement ps = conn.prepareStatement(DatabaseUtils.getDatabaseInterface().limitQuery("id, uuid, sortid", queue, null, "sortid", limit));
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                work.add(new IndexObjectHolder(priority, rs.getLong(1), rs.getString(2), rs.getLong(3)));
            }
        }
    }

    private static void clearDuplicates(Connection conn, int priority, IndexObjectHolder ioh) throws SQLException {
        String queue = IndexObjectHolder.getQueue(priority);
        try (PreparedStatement ps = conn.prepareStatement("select sortid from " + queue + " where id=? and sortid<>?");){
            ps.setLong(1, ioh.getRawId());
            ps.setLong(2, ioh.getSortId());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    TextIndexQueue.delete(conn, queue, ioh.getRawId(), rs.getLong(1));
                }
            }
        }
    }

    private static void delete(Connection conn, String queue, long id, long sortId) throws SQLException {
        try (PreparedStatement ps = conn.prepareStatement("delete from " + queue + " where id=? and sortid=?");){
            ps.setLong(1, id);
            ps.setLong(2, sortId);
            ps.execute();
        }
    }
}

