/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.commons.statistic.SystemStatistic;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.statistic.TransactionStatistic;

public class Transaction
implements AutoCloseable {
    private final int timeout;
    private RoiTransactionHandler rth;
    private static final SystemStatistic stat = TransactionStatistic.getInstance();

    public Transaction() {
        this(true, -1);
    }

    public Transaction(boolean start) {
        this(start, -1);
    }

    public Transaction(int timeout) {
        this(true, timeout);
    }

    public Transaction(boolean start, int timeout) {
        this.timeout = timeout;
        if (start) {
            this.start();
        }
    }

    public void start() {
        if (this.rth != null) {
            return;
        }
        this.rth = new RoiTransactionHandler(this.timeout);
        try {
            this.rth.begin();
        }
        catch (Exception e) {
            throw new TransactionException("Could not start transaction", e);
        }
    }

    public void commit() {
        if (this.rth == null) {
            return;
        }
        try {
            this.rth.end();
        }
        catch (Exception e) {
            throw new TransactionException("Could not commit transaction", e);
        }
        this.rth = null;
    }

    public void rollback() {
        if (this.rth == null) {
            return;
        }
        try {
            this.rth.abort();
        }
        catch (Exception e) {
            throw new TransactionException("Could not roll back transaction", e);
        }
        this.rth = null;
    }

    public void restart() {
        this.commit();
        this.start();
    }

    public static void beforeCommit(String ident, RoiTransactionHandler.Handler handler) throws Exception {
        RoiTransactionHandler rth = RoiTransactionHandler.getThreadTransaction();
        if (rth != null && rth.getStage() != null && rth.getStage() != RoiTransactionHandler.Stage.BEFORE_COMMIT) {
            if (rth.getStage() == RoiTransactionHandler.Stage.WHILE_COMMIT) {
                stat.warning((Throwable)new Exception("adding beforeCommit while committing, please fix!"));
                handler.run();
            } else {
                rth.beforeCommit(ident, handler);
            }
        } else {
            handler.run();
        }
    }

    public static void beforeCommit(RoiTransactionHandler.Handler handler) throws Exception {
        Transaction.beforeCommit(null, handler);
    }

    public static void whileCommit(String ident, RoiTransactionHandler.SafeHandler handler) {
        RoiTransactionHandler rth = RoiTransactionHandler.getThreadTransaction();
        if (rth != null && rth.getStage() != null && rth.getStage() != RoiTransactionHandler.Stage.WHILE_COMMIT) {
            rth.whileCommit(ident, handler);
        } else {
            handler.run();
        }
    }

    public static void whileCommit(RoiTransactionHandler.SafeHandler handler) {
        Transaction.whileCommit(null, handler);
    }

    public static void afterCommit(String ident, RoiTransactionHandler.Handler handler) throws Exception {
        RoiTransactionHandler rth = RoiTransactionHandler.getThreadTransaction();
        if (rth != null && rth.getStage() != null) {
            rth.afterCommit(ident, handler);
        } else {
            handler.run();
        }
    }

    public static void afterCommit(RoiTransactionHandler.Handler handler) throws Exception {
        Transaction.afterCommit(null, handler);
    }

    public static void finishedCommit(String ident, RoiTransactionHandler.Handler handler) throws Exception {
        RoiTransactionHandler rth = RoiTransactionHandler.getThreadTransaction();
        if (rth != null && rth.getStage() != null) {
            rth.finishedCommit(ident, handler);
        } else {
            handler.run();
        }
    }

    public static void finishedCommit(RoiTransactionHandler.Handler handler) throws Exception {
        Transaction.finishedCommit(null, handler);
    }

    public static void beforeRollback(String ident, RoiTransactionHandler.SafeHandler handler) {
        RoiTransactionHandler rth = RoiTransactionHandler.getThreadTransaction();
        if (rth != null && rth.getStage() != null) {
            if (rth.getStage() == RoiTransactionHandler.Stage.BEFORE_ROLLBACK) {
                handler.run();
            } else if (rth.getStage() == RoiTransactionHandler.Stage.WHILE_ROLLBACK) {
                stat.warning((Throwable)new Exception("adding beforeRollback, while rolling back, please fix!"));
                handler.run();
            } else {
                rth.beforeRollback(ident, handler);
            }
        }
    }

    public static void beforeRollback(RoiTransactionHandler.SafeHandler handler) {
        Transaction.beforeRollback(null, handler);
    }

    public static void whileRollback(String ident, RoiTransactionHandler.SafeHandler handler) {
        RoiTransactionHandler rth = RoiTransactionHandler.getThreadTransaction();
        if (rth != null && rth.getStage() != null) {
            if (rth.getStage() == RoiTransactionHandler.Stage.WHILE_ROLLBACK) {
                handler.run();
            } else {
                rth.whileRollback(ident, handler);
            }
        }
    }

    public static void whileRollback(RoiTransactionHandler.SafeHandler handler) {
        Transaction.whileRollback(null, handler);
    }

    public static void afterRollback(String ident, RoiTransactionHandler.Handler handler) {
        RoiTransactionHandler rth = RoiTransactionHandler.getThreadTransaction();
        if (rth != null && rth.getStage() != null) {
            rth.afterRollback(ident, handler);
        }
    }

    public static void afterRollback(RoiTransactionHandler.Handler handler) {
        Transaction.afterRollback(null, handler);
    }

    public static void onCleanup(RoiTransactionHandler.SafeHandler handler) {
        RoiTransactionHandler rth = RoiTransactionHandler.getThreadTransaction();
        if (rth != null && rth.getStage() != null) {
            rth.onCleanUp(handler);
        } else {
            handler.run();
        }
    }

    public static Object get(Object key) {
        RoiTransactionHandler rth = RoiTransactionHandler.getThreadTransaction();
        if (rth != null) {
            return rth.get(key);
        }
        return null;
    }

    public static Object put(String key, Object value) {
        RoiTransactionHandler rth = RoiTransactionHandler.getThreadTransaction();
        if (rth != null) {
            return rth.put(key, value);
        }
        return null;
    }

    public static boolean has(Object key) {
        return Transaction.get(key) != null;
    }

    public static void put(String key) {
        Transaction.put(key, "");
    }

    public static Object remove(String key) {
        RoiTransactionHandler rth = RoiTransactionHandler.getThreadTransaction();
        if (rth != null) {
            return rth.remove(key);
        }
        return null;
    }

    @Override
    public void close() {
        this.rollback();
    }

    private static class TransactionException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public TransactionException(String message, Throwable cause) {
            super(TransactionException.chain(message, cause), cause);
        }

        private static final String chain(String message, Throwable cause) {
            String causeMessage;
            if (cause != null && (causeMessage = cause.getMessage()) != null) {
                return message + " (" + causeMessage + ")";
            }
            return message;
        }
    }
}

