/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.commons.cron.SystemTimer;
import agorum.commons.statistic.SystemObjectReference;
import agorum.commons.statistic.SystemStatistic;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.statistic.SessionControllerStatistic;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class UnlockSessionLockByTimer {
    private static final String ME = "UnlockSessionLockByTimer";
    private static final Map<Long, Long> unlockTable = new ConcurrentHashMap<Long, Long>();
    private static final SystemStatistic stat = SessionControllerStatistic.getInstance();

    public static void registerLock(GlobalObjectClientBean obj, long timeInMs) throws Exception {
        unlockTable.put(obj.getId(), System.currentTimeMillis() + timeInMs);
    }

    public static void unregisterLock(GlobalObjectClientBean obj) throws Exception {
        unlockTable.remove(obj.getId());
    }

    static {
        SystemTimer.ofPeriod((long)1000L).name(ME).call(() -> {
            long now = System.currentTimeMillis();
            for (Map.Entry<Long, Long> entry : new HashMap<Long, Long>(unlockTable).entrySet()) {
                if (entry.getValue() > now) continue;
                try {
                    GlobalObjectClientBean obj = SessionControllerAdmin.getService(ME).getGlobalObjectById(entry.getKey());
                    if (obj.getLockState() != 4) continue;
                    stat.debug().object((SystemObjectReference)obj).send("Auto-unlocking");
                    obj.unlock();
                }
                catch (Exception e) {
                    stat.error((Throwable)e);
                    unlockTable.remove(entry.getKey());
                }
            }
        });
    }
}

