/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.mbeans;

import agorum.commons.cache.GenericCache;
import agorum.commons.logging.AgorumCoreStartDescLogger;
import agorum.commons.server.ServiceUtils;
import agorum.roi.ejb.client.beans.AppUserProfileObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.ConnectionUtils;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.EventAssistanceBean;
import agorum.roi.ejb.common.EventAssistanceUtils;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.JMSEventController;
import agorum.roi.ejb.common.JMSEventListenerBean;
import agorum.roi.ejb.common.JMSEventListenerInterface;
import agorum.roi.ejb.common.MetaDbSuperCache;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.ejb.common.ServiceAuthInterface;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.mbeans.EventAssistanceServiceMBean;
import agorum.roi.ejb.messaging.common.MessageConnectionHolder;
import agorum.roi.ejb.messaging.common.MessageUtils;
import agorum.roi.exception.RoiException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;

public class EventAssistanceService
implements EventAssistanceServiceMBean,
MessageListener,
JMSEventListenerInterface {
    private SessionController sessionController = null;
    private Vector messageConnectionHolders = new Vector();
    private int count;
    private boolean isStarted = false;
    private static Hashtable userEventAssistanceEventHash = null;
    private static Hashtable userEventAssistanceExcludedHash = null;
    private static Hashtable allUsersEventAssistanceHash = null;
    private Vector queue = new Vector();
    private JMSEventListenerBean jmsBean = null;
    private JMSEventController eventController = null;
    public static boolean killTest;

    @Override
    public void start() {
        System.err.println("---------- Starting Event Assistance -------------");
        AgorumCoreStartDescLogger startLogger = new AgorumCoreStartDescLogger();
        startLogger.writeDescToFile("Starting eventassistance service...\n\n", "");
        final EventAssistanceService jmsEventListener = this;
        ServiceUtils.whenAutoUpdateFinished((Runnable)new Runnable(){

            @Override
            public void run() {
                System.err.println("EventAssistanceService: Service is started");
                try {
                    EventAssistanceService.this.connectEvents();
                    EventAssistanceService.this.jmsBean = new JMSEventListenerBean();
                    EventAssistanceService.this.jmsBean.setId("EventAssistanceService_" + jmsEventListener.hashCode());
                    EventAssistanceService.this.jmsBean.setJmsEventListener(jmsEventListener);
                    EventAssistanceService.this.eventController = JMSEventController.getInstance();
                    EventAssistanceService.this.eventController.registerListener(EventAssistanceService.this.jmsBean);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public void stop() {
        System.err.println("---------- Stopping Event Assistance -------------");
        this.disconnectEvents();
        this.jmsBean.setRemoveEvent(true);
    }

    private void connectEvents() {
        try {
            MessageUtils messageUtils = new MessageUtils();
            this.messageConnectionHolders.addElement(messageUtils.registerSubScriber(this, "updateObjectListener"));
            this.messageConnectionHolders.addElement(messageUtils.registerSubScriber(this, "createObjectListener"));
            this.messageConnectionHolders.addElement(messageUtils.registerSubScriber(this, "eventAssistanceSettingsListener"));
            this.messageConnectionHolders.addElement(messageUtils.registerSubScriber(this, "deleteObjectListener"));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private void disconnectEvents() {
        int len = this.messageConnectionHolders.size();
        MessageUtils mu = new MessageUtils();
        for (int i = 0; i < len; ++i) {
            try {
                MessageConnectionHolder messageConnectionHolder = (MessageConnectionHolder)this.messageConnectionHolders.elementAt(i);
                mu.unregisterSubScriber(messageConnectionHolder);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.messageConnectionHolders.clear();
    }

    @Override
    public void reconnectEvent() {
        this.disconnectEvents();
        this.connectEvents();
    }

    @Override
    public void sendCheckEvent() {
        this.eventController.sendMyEvent(this.jmsBean, "updateObjectListener");
    }

    private synchronized boolean isStarted() {
        if (this.isStarted) {
            return true;
        }
        this.isStarted = true;
        return false;
    }

    private synchronized Message queueing(Message msg) {
        if (msg != null) {
            block13: {
                GenericCache cache = GenericCache.getInstance((Object)this, (int)-1, (int)1000, (int)2000);
                try {
                    if (msg.getObjectProperty("NoEventAssistanceObject") != null) break block13;
                    String cacheKey = "";
                    try {
                        Long value;
                        String eventSubType;
                        String eventType = (String)msg.getObjectProperty("eventType");
                        if (eventType != null) {
                            cacheKey = eventType;
                        }
                        if ((eventSubType = (String)msg.getObjectProperty("eventSubType")) != null) {
                            cacheKey = cacheKey + "_" + eventSubType;
                        }
                        if ((value = (Long)msg.getObjectProperty("value")) != null) {
                            cacheKey = cacheKey + "_" + value;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (msg.getObjectProperty("ForceEventAssistanceObject") != null || cache.get((Object)cacheKey) == null) {
                        this.queue.addElement(msg);
                        if (!cache.contains((Object)cacheKey)) {
                            cache.put((Object)cacheKey, (Object)msg);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
            return null;
        }
        Message nextMessage = null;
        if (this.queue.size() > 0) {
            nextMessage = (Message)this.queue.elementAt(0);
            this.queue.removeElementAt(0);
            try {
                this.connect();
                MessageUtils mu = new MessageUtils();
                mu.checkMessageObject(nextMessage, this.sessionController);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return nextMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg) {
        if (SessionController.getImportMode()) {
            return;
        }
        if (this.sessionController == null) {
            try {
                this.connect();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!MetaDbSuperCache.isTrue(this.sessionController, "MAIN_MODULE_MANAGEMENT/roi/control/eventassistance/Active")) {
            return;
        }
        if (killTest) {
            System.err.println(" <<<<<<<<<<< Making a kill Test >>>>>>>>>>>");
            this.disconnectEvents();
            return;
        }
        if (!this.eventController.checkMyEvent(this.jmsBean, msg)) {
            boolean processMessage = true;
            String eventTypeGlobal = null;
            try {
                eventTypeGlobal = (String)msg.getObjectProperty("eventType");
                if (eventTypeGlobal.equals("eventAssistanceSettingsListener")) {
                    processMessage = false;
                    Long userId = (Long)msg.getObjectProperty("value");
                    this.connect();
                    DirectoryUserObjectClientBean duocb = (DirectoryUserObjectClientBean)this.sessionController.getGlobalObjectById(userId);
                    this.initOneUser(duocb, msg);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            if (processMessage) {
                this.queueing(msg);
                if (!this.isStarted()) {
                    while ((msg = this.queueing(null)) != null) {
                        String eventType = null;
                        try {
                            eventType = (String)msg.getObjectProperty("eventType");
                        }
                        catch (Exception duocb) {
                            // empty catch block
                        }
                        try {
                            Long id = (Long)msg.getObjectProperty("value");
                            boolean showAlwaysEA = false;
                            try {
                                showAlwaysEA = Boolean.parseBoolean((String)msg.getObjectProperty("ShowAlwaysEA"));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                this.connect();
                                this.init();
                                RoiTransactionHandler rth = null;
                                ConnectionUtils cu = null;
                                try {
                                    rth = new RoiTransactionHandler();
                                    rth.begin();
                                    cu = new ConnectionUtils(this.sessionController);
                                    EventAssistanceUtils eau = new EventAssistanceUtils(cu.getConnection());
                                    if (eventType.equals("deleteObjectListener")) {
                                        eau.deleteId(id);
                                    } else {
                                        eau.initBitHash();
                                        String eventSubType = (String)msg.getObjectProperty("eventSubType");
                                        if (eventSubType != null && eventSubType.equals("customEventAssistance")) {
                                            String users = (String)msg.getObjectProperty("users");
                                            this.customEventAssistance(id, "updateObjectListener", eau, users);
                                        } else {
                                            this.saveToEventAssistance(id, eventType, eau, showAlwaysEA);
                                        }
                                    }
                                    rth.end();
                                    rth = null;
                                }
                                catch (Exception e) {
                                    if (e instanceof RoiException) {
                                        String errorKey = ((RoiException)e).getErrorKey();
                                        if (!errorKey.equals("agorum.roi.remote.exception.NoEntryFound")) {
                                            e.printStackTrace(System.err);
                                        }
                                    } else {
                                        e.printStackTrace(System.err);
                                        ExceptionUtils.handleException(e);
                                    }
                                }
                                finally {
                                    try {
                                        if (rth != null) {
                                            rth.abort();
                                        }
                                    }
                                    catch (Exception exception) {}
                                    try {
                                        cu.closeConnection();
                                    }
                                    catch (Exception exception) {}
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            ++this.count;
                        }
                        catch (JMSException jmsE) {
                            jmsE.printStackTrace();
                        }
                    }
                    this.isStarted = false;
                }
            }
        }
    }

    private void saveToEventAssistance(Long id, String action, EventAssistanceUtils eau, boolean showAlwaysEA) throws Exception {
        GlobalObjectClientBean gocb = null;
        try {
            gocb = this.sessionController.getGlobalObjectById(id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (gocb != null) {
            AppUserProfileObjectClientBean profile;
            GlobalObjectClientBean realOrgObject = gocb;
            if ((gocb = gocb.getDisplayableObject()).noEventAssistanceDisplayableObject()) {
                return;
            }
            boolean performEvent = true;
            if (gocb instanceof AppUserProfileObjectClientBean && (profile = (AppUserProfileObjectClientBean)gocb).getApplication().toString().equalsIgnoreCase("EventAssistance")) {
                performEvent = false;
            }
            if (performEvent) {
                GlobalObjectClientBean orgObject = gocb;
                GlobalObjectClientBean mainObject = gocb.getMainObject();
                if (mainObject != null && mainObject.getId().longValue() != gocb.getId().longValue()) {
                    gocb = mainObject;
                }
                if (gocb != null && !gocb.noEventAssistance()) {
                    Hashtable<String, List<GlobalObjectClientBean>> folderHash = gocb.getAllFolderPathObjects();
                    Long lastModifierId = new Long(0L);
                    try {
                        lastModifierId = realOrgObject.useLastModifierForEventAssistance() ? (Long)realOrgObject.getAttribute(GlobalObjectClientBean.LASTMODIFIER_ATTRIBUTE).getAttributeValue() : (Long)orgObject.getAttribute(GlobalObjectClientBean.LASTMODIFIER_ATTRIBUTE).getAttributeValue();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    GenericCache gc = GenericCache.getInstance((Object)"Roi.EventAssistanceActive", (int)Integer.MAX_VALUE, (int)10000, (int)600000);
                    Boolean eaActive = (Boolean)gc.get((Object)lastModifierId);
                    if (eaActive == null) {
                        DirectoryUserObjectClientBean lastModifier = null;
                        lastModifier = realOrgObject.useLastModifierForEventAssistance() ? realOrgObject.getLastModifier() : orgObject.getLastModifier();
                        AppUserProfileObjectClientBean aupocb = lastModifier.getApplicationUserProfile("roi", "agorum.roi.EventAssistanceActive");
                        eaActive = Boolean.TRUE;
                        if (aupocb != null) {
                            eaActive = Boolean.valueOf(aupocb.getAppValue());
                        }
                        gc.put((Object)lastModifierId, (Object)eaActive);
                    }
                    if (eaActive.booleanValue()) {
                        Hashtable<Long, String> usersDoneHash = new Hashtable<Long, String>();
                        Enumeration<List<GlobalObjectClientBean>> enumPaths = folderHash.elements();
                        while (enumPaths.hasMoreElements()) {
                            Vector pathPieces = (Vector)enumPaths.nextElement();
                            int pathPiecesLen = pathPieces.size();
                            Enumeration enumAllUser = allUsersEventAssistanceHash.keys();
                            while (enumAllUser.hasMoreElements()) {
                                boolean makeEA;
                                Long userId = (Long)enumAllUser.nextElement();
                                if (userId == 1004006L) {
                                    System.out.println("EADebug: checking user: " + userId + ", for object: " + realOrgObject.getId());
                                }
                                if (!(makeEA = realOrgObject.makeEventAssistance(userId)) || usersDoneHash.containsKey(userId)) continue;
                                if (userId == 1004006L) {
                                    System.out.println("EADebug: should make event for object: " + realOrgObject.getId());
                                }
                                Long eaPathObjectId = null;
                                for (int i = pathPiecesLen - 1; i >= 0; --i) {
                                    Hashtable userEventId;
                                    GlobalObjectClientBean pathObject = (GlobalObjectClientBean)pathPieces.elementAt(i);
                                    if (pathObject == null) continue;
                                    Long pathObjectId = pathObject.getId();
                                    if (userEventAssistanceExcludedHash.containsKey(userId) && (userEventId = (Hashtable)userEventAssistanceExcludedHash.get(userId)).containsKey(pathObjectId) && !gocb.eventAssistanceAlways() && !showAlwaysEA) {
                                        eaPathObjectId = null;
                                        if (userId != 1004006L) break;
                                        System.out.println("EADebug: user has an exclude rule, that prevents the event for object: " + realOrgObject.getId() + ", path: " + pathObjectId + ", shoAlways: " + showAlwaysEA);
                                        break;
                                    }
                                    if (!userEventAssistanceEventHash.containsKey(userId) || !(userEventId = (Hashtable)userEventAssistanceEventHash.get(userId)).containsKey(pathObjectId) && !gocb.eventAssistanceAlways() && !showAlwaysEA || !orgObject.makeEventAssistanceSlow(userId, userEventId, pathObjectId)) continue;
                                    eaPathObjectId = pathObjectId;
                                    if (userId == 1004006L) {
                                        System.out.println("EADebug: should make event for object, cause there is a path rule: " + realOrgObject.getId() + ", path: " + pathObjectId + ", shoAlways: " + showAlwaysEA);
                                    }
                                    usersDoneHash.put(userId, "");
                                }
                                if (eaPathObjectId == null) continue;
                                int userSeq = 0;
                                Hashtable userEventId = (Hashtable)userEventAssistanceEventHash.get(userId);
                                if (!userEventId.containsKey(eaPathObjectId) && (gocb.eventAssistanceAlways() || showAlwaysEA)) {
                                    DirectoryUserObjectClientBean tmpUser = (DirectoryUserObjectClientBean)this.sessionController.getGlobalObjectById(userId);
                                    userSeq = new Integer(tmpUser.getUserSequence());
                                } else {
                                    userSeq = (Integer)userEventId.get(eaPathObjectId);
                                }
                                if (userId == 1004006L) {
                                    System.out.println("EADebug: making bit entry, userSeq: " + userSeq);
                                }
                                eau.setBitHash(userSeq);
                            }
                        }
                        EventAssistanceBean eab = new EventAssistanceBean();
                        eab.setId(orgObject.getId());
                        eab.setType(action);
                        eab.setClassName(orgObject.getClassName());
                        eau.printBitHash();
                        eau.insertBitHashToDB(eab, false);
                    }
                }
            }
        }
    }

    private void customEventAssistance(Long id, String action, EventAssistanceUtils eau, String usersString) throws Exception {
        GlobalObjectClientBean obj = null;
        try {
            obj = this.sessionController.getGlobalObjectById(id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (obj == null) {
            return;
        }
        if ((obj = obj.getDisplayableObject()).noEventAssistanceDisplayableObject()) {
            return;
        }
        String[] users = usersString.split("\\|\\|");
        if (users == null) {
            return;
        }
        int len = users.length;
        for (int i = 0; i < len; ++i) {
            eau.setBitHash(new Integer(users[i]));
        }
        EventAssistanceBean eab = new EventAssistanceBean();
        eab.setId(obj.getId());
        eab.setType(action);
        eab.setClassName(obj.getClassName());
        eau.insertBitHashToDB(eab, true);
    }

    private void connect() throws Exception {
        if (this.sessionController == null) {
            try {
                RoiProperties rp = new RoiProperties();
                CredentialObject credential = new CredentialObject();
                credential.setUserName(rp.getRoiSystemUser());
                credential.setAuthInterface(new ServiceAuthInterface());
                credential.setModulInfo("EventAssistanceService");
                this.sessionController = SessionController.connect(credential);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        } else {
            this.sessionController.reconnectIfNeeded();
        }
    }

    private void init() throws Exception {
        if (userEventAssistanceEventHash == null || userEventAssistanceExcludedHash == null) {
            userEventAssistanceEventHash = new Hashtable();
            userEventAssistanceExcludedHash = new Hashtable();
            allUsersEventAssistanceHash = new Hashtable();
            DirectoryUserObjectClientBean[] duocb = this.sessionController.getAllDirectoryUsers();
            if (duocb != null) {
                int len = duocb.length;
                for (int i = 0; i < len; ++i) {
                    this.initOneUser(duocb[i], null);
                }
            }
        }
    }

    private void initOneUser(DirectoryUserObjectClientBean duocb, Message msg) throws Exception {
        String action;
        if (duocb.getId() == 1004006L) {
            System.out.println("EADebug: reinit one user");
        }
        if (allUsersEventAssistanceHash.containsKey(duocb.getId())) {
            allUsersEventAssistanceHash.remove(duocb.getId());
        }
        AppUserProfileObjectClientBean[] appUp = duocb.getApplicationUserProfiles("EventAssistance");
        this.getEASettingsFromAppUserProfile(userEventAssistanceEventHash, appUp, duocb);
        appUp = duocb.getApplicationUserProfiles("ExcludeFromEventAssistance");
        this.getEASettingsFromAppUserProfile(userEventAssistanceExcludedHash, appUp, duocb);
        if (msg != null && (action = (String)msg.getObjectProperty("action")) != null && action.equalsIgnoreCase("eventAssistanceActive")) {
            GenericCache gc = GenericCache.getInstance((Object)"Roi.EventAssistanceActive", (int)Integer.MAX_VALUE, (int)10000, (int)600000);
            gc.remove((Object)duocb.getId());
        }
    }

    private void getEASettingsFromAppUserProfile(Hashtable eaHash, AppUserProfileObjectClientBean[] appUp, DirectoryUserObjectClientBean duocb) throws Exception {
        Long userId = duocb.getId();
        if (eaHash.containsKey(userId)) {
            eaHash.remove(userId);
        }
        if (appUp != null && appUp.length > 0) {
            Hashtable<Long, Integer> userObjectIdHash = new Hashtable<Long, Integer>();
            eaHash.put(userId, userObjectIdHash);
            if (!allUsersEventAssistanceHash.containsKey(userId)) {
                allUsersEventAssistanceHash.put(userId, "");
            }
            int len1 = appUp.length;
            for (int j = 0; j < len1; ++j) {
                try {
                    Long objId = new Long(appUp[j].getAppKeyWord());
                    if (userObjectIdHash.containsKey(objId)) continue;
                    Integer userSequence = new Integer(duocb.getUserSequence());
                    userObjectIdHash.put(objId, userSequence);
                    if (duocb.getId() != 1004006L) continue;
                    System.out.println("EADebug: add to hash: path=" + objId + ", sequence=" + userSequence);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

