/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.mbeans;

import agorum.commons.cron.Trace;
import agorum.commons.logging.AgorumCoreStartDescLogger;
import agorum.commons.server.ServiceUtils;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.ServiceAuthInterface;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.Transaction;
import agorum.roi.ejb.common.TransactionProperties;
import agorum.roi.ejb.mbeans.ExpirationDateServiceMBean;
import agorum.roi.search.SearchClass;
import java.util.Date;

public class ExpirationDateService
implements ExpirationDateServiceMBean {
    private SessionController sessionController;
    private static ExpirationDateService instance;
    public static final Date MIN_EXPIRATION;

    public static ExpirationDateService getInstance() {
        return instance;
    }

    @Override
    public void start() {
        System.err.println("----------- Starting Expiration Date Service -----------");
        if (instance == null) {
            instance = this;
        }
        AgorumCoreStartDescLogger startLogger = new AgorumCoreStartDescLogger();
        startLogger.writeDescToFile("Starting expiration date service...\n\n", "");
    }

    @Override
    public void stop() {
        System.err.println("---------- Stopping Expiration Date Service -----------");
    }

    private void connect() throws Exception {
        if (this.sessionController == null) {
            System.err.println("Not connected, so reconnect...");
            try {
                RoiProperties rp = new RoiProperties();
                CredentialObject credential = new CredentialObject();
                credential.setUserName(rp.getRoiSystemUser());
                credential.setAuthInterface(new ServiceAuthInterface());
                credential.setModulInfo("ExpirationDateService");
                this.sessionController = SessionController.connect(credential);
            }
            catch (Exception e) {
                this.sessionController = null;
            }
        } else {
            this.sessionController.reconnectIfNeeded();
        }
    }

    public void run() {
        instance.runInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInternal() {
        block38: {
            try (Trace.Auto trace = Trace.auto((String)"agorum expiration date service");){
                if (!ServiceUtils.autoupdateFinished()) break block38;
                if (SessionController.getImportMode()) {
                    trace.ended();
                    return;
                }
                System.err.println("**************************************************");
                System.err.println("ExpirationAgent: Timer has been called");
                System.err.println("**************************************************");
                try {
                    trace.working("Connecting");
                    this.connect();
                    trace.working("Searching all objects with expiration date");
                    SearchClass sc = new SearchClass(this.sessionController);
                    sc.setClassname(new String[]{GlobalObjectClientBean.CLASS_NAME});
                    sc.setAttributeGREATER_THAN(GlobalObjectClientBean.CLASS_NAME, GlobalObjectClientBean.EXPIRATIONDATE_ATTRIBUTE, (Object)MIN_EXPIRATION, false);
                    sc.setAttributeLESS_THAN(GlobalObjectClientBean.CLASS_NAME, GlobalObjectClientBean.EXPIRATIONDATE_ATTRIBUTE, (Object)new Date(), false);
                    sc.setSearchClauseAND();
                    sc.openSearch(GlobalObjectClientBean.CLASS_NAME, "ExpirationDateTimerTask.run");
                    try {
                        System.err.println("ExpirationDate SQL: " + sc.getSQL());
                        int len = sc.getSelectCounter();
                        for (int i = 0; i < len; ++i) {
                            try {
                                if (sc.next()) {
                                    this.sessionController.reconnectIfNeeded();
                                    trace.working("Deleting expired object");
                                    GlobalObjectClientBean globalObject = sc.getItem();
                                    long systemFlags = globalObject.getSystemFlags();
                                    if ((systemFlags & (GlobalObjectClientBean.SYSTEMFLAG_NOTCHANGE | GlobalObjectClientBean.SYSTEMFLAG_NOTDELETE)) == 0L) {
                                        try (Transaction t = new Transaction(TransactionProperties.getDeleteTransactionTimeout());){
                                            System.err.println(globalObject.getName() + ", " + globalObject.getId() + ": has expired, deleting");
                                            SuperObjectClientBeanDefinition def = globalObject.getNewDefinition(this.sessionController);
                                            def.setSystemOption("deleteAllReferencesFromThisObject", "");
                                            globalObject.delete(def);
                                            t.commit();
                                            continue;
                                        }
                                    }
                                    System.err.println(globalObject.getName() + ", " + globalObject.getId() + ": has expired, but may not be deleted yet, skipping");
                                    continue;
                                }
                                break;
                            }
                            catch (Exception e) {
                                e.printStackTrace(System.err);
                            }
                        }
                    }
                    finally {
                        sc.closeSearch();
                    }
                    trace.ended();
                }
                catch (Exception e) {
                    trace.failed();
                    e.printStackTrace(System.err);
                }
            }
        }
    }

    static {
        MIN_EXPIRATION = new Date(86400000L);
    }
}

