/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.mbeans;

import agorum.commons.cron.Trace;
import agorum.commons.server.ServiceUtils;
import agorum.commons.statistic.Statistic;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientCachedBean;
import agorum.roi.ejb.common.ConnectionUtils;
import agorum.roi.ejb.common.QueueUtils;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.ejb.common.Transaction;
import agorum.roi.ejb.messaging.common.MessageUtils;
import agorum.roi.statistic.metadata.MetadataInheritanceStatistic;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class MetadataInheritanceAttachedService {
    private static final String STICKY_WARNING_NO_METADATA_INHERITANCE_ATTACHED_PROGRESS = "STICKY_WARNING_NO_METADATA_INHERITANCE_ATTACHED_PROGRESS";
    private static final MetadataInheritanceStatistic stat = MetadataInheritanceStatistic.getInstance();
    private static final Thread thread = new Thread(() -> {
        Trace.Auto trace = Trace.auto((String)"metadata inheritance attached service");
        Throwable throwable = null;
        try {
            try {
                while (true) {
                    try {
                        while (true) {
                            trace.waiting("Sleeping");
                            MetadataInheritanceAttachedService.sleep(10000L);
                            trace.working("Working");
                            MetadataInheritanceAttachedService.work(trace);
                        }
                    }
                    catch (Exception e) {
                        trace.failed();
                        stat.error(e);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (trace != null) {
                if (throwable != null) {
                    try {
                        trace.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    trace.close();
                }
            }
            throw throwable3;
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sleep(long timeout) throws InterruptedException {
        Thread thread = MetadataInheritanceAttachedService.thread;
        synchronized (thread) {
            MetadataInheritanceAttachedService.thread.wait(timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wake() {
        Thread thread = MetadataInheritanceAttachedService.thread;
        synchronized (thread) {
            MetadataInheritanceAttachedService.thread.notifyAll();
        }
    }

    private static void work(Trace.Auto trace) {
        try {
            trace.starting();
            stat.debug().send("work");
            SessionController sc = SessionControllerAdmin.getService(MetadataInheritanceAttachedService.class);
            boolean hasMore = false;
            do {
                Throwable throwable;
                Connection conn4;
                Throwable throwable2;
                long minSortId;
                long id;
                block129: {
                    sc.reconnectIfNeeded();
                    stat.setServiceStatus(Statistic.ServiceStatus.RUNNING);
                    trace.working("Counting tables");
                    try (Connection conn2 = new ConnectionUtils(sc).getConnection();){
                        long queueSize = QueueUtils.count("tometadatainheritanceindex");
                        stat.measure("Metadata inheritance queue size: attached ", queueSize);
                    }
                    id = -1L;
                    minSortId = -1L;
                    throwable2 = null;
                    try (Connection conn3 = new ConnectionUtils(sc).getConnection();){
                        String minSelect = "select min(SORTID) from tometadatainheritanceindex";
                        try (PreparedStatement ps = conn3.prepareStatement(minSelect);
                             ResultSet rs = ps.executeQuery();){
                            if (rs != null && rs.next()) {
                                minSortId = rs.getLong(1);
                            }
                        }
                        if (minSortId < 0L) break block129;
                        String select = "select ID,SORTID from tometadatainheritanceindex where SORTID = ?";
                        try (PreparedStatement ps = conn3.prepareStatement(select);){
                            ps.setLong(1, minSortId);
                            try (ResultSet rs = ps.executeQuery();){
                                if (rs != null && rs.next()) {
                                    id = rs.getLong(1);
                                }
                            }
                        }
                    }
                    catch (Throwable minSelect) {
                        throwable2 = minSelect;
                        throw minSelect;
                    }
                }
                hasMore = false;
                if (id <= 0L) continue;
                throwable2 = null;
                try (Transaction t = new Transaction();){
                    conn4 = new ConnectionUtils(sc).getConnection();
                    throwable = null;
                    try {
                        QueueUtils.clearDuplicates(conn4, "tometadatainheritanceindex", id, minSortId);
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (conn4 != null) {
                            if (throwable != null) {
                                try {
                                    conn4.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            } else {
                                conn4.close();
                            }
                        }
                    }
                    t.commit();
                }
                catch (Throwable conn4) {
                    throwable2 = conn4;
                    throw conn4;
                }
                stat.debug().objectId(Long.valueOf(id)).send("handling object");
                hasMore = true;
                try {
                    MetadataInheritanceAttachedService.handleAllAttached(sc, id);
                }
                catch (Exception e) {
                    stat.error().detail((Object)"An error has occurred in MetaDataInheritanceAttachedService.").objectId(Long.valueOf(id)).exception((Throwable)e).send("MetaData inheritance queue not progressing");
                }
                t = new Transaction();
                throwable2 = null;
                try {
                    conn4 = new ConnectionUtils(sc).getConnection();
                    throwable = null;
                    try {
                        QueueUtils.remove(conn4, "tometadatainheritanceindex", id, minSortId);
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (conn4 != null) {
                            if (throwable != null) {
                                try {
                                    conn4.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                            } else {
                                conn4.close();
                            }
                        }
                    }
                    t.commit();
                }
                catch (Throwable throwable7) {
                    throwable2 = throwable7;
                    throw throwable7;
                }
                finally {
                    if (t != null) {
                        if (throwable2 != null) {
                            try {
                                t.close();
                            }
                            catch (Throwable throwable8) {
                                throwable2.addSuppressed(throwable8);
                            }
                        } else {
                            t.close();
                        }
                    }
                }
            } while (hasMore);
            stat.setServiceStatus(Statistic.ServiceStatus.STOPPED);
            stat.clearStickyLogEntry(STICKY_WARNING_NO_METADATA_INHERITANCE_ATTACHED_PROGRESS);
        }
        catch (Throwable e) {
            stat.error().detail((Object)"An error has occurred in MetaDataInheritanceAttachedService that prevented the metadata inheritance queue from being processed.").exception(e).sticky(STICKY_WARNING_NO_METADATA_INHERITANCE_ATTACHED_PROGRESS).send("MetaData inheritance queue not progressing");
        }
    }

    private static void handleAllAttached(SessionController sessionController, long id) throws Exception {
        GlobalObjectClientBean obj;
        try {
            obj = sessionController.getGlobalObjectById(new Long(id));
        }
        catch (Exception e) {
            return;
        }
        try (Connection conn = new ConnectionUtils().getConnection();
             PreparedStatement ps = conn.prepareStatement("select r.leftobject from relationobject r, attributerelationobject a where r.id=a.id and r.rightobject=?");){
            ps.setLong(1, obj.getId());
            try (ResultSet rs = ps.executeQuery();){
                Long moId = obj.getMainObjectId();
                int amount = 0;
                try (Transaction t = new Transaction(-1);){
                    while (rs.next()) {
                        try {
                            MetadataInheritanceAttachedService.clearCache(moId, sessionController.getGlobalObjectById(rs.getLong(1)));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (++amount <= 1000) continue;
                        t.restart();
                        amount = 0;
                    }
                    t.commit();
                }
            }
        }
    }

    private static void clearCache(Long mainObjId, GlobalObjectClientBean object) throws Exception {
        MessageUtils mu = new MessageUtils();
        if (!mainObjId.equals(object.getId())) {
            SuperObjectClientCachedBean.invalidateCachedObject(object.getId());
            mu.sendUpdatePathEvent(object, null);
        }
        for (SuperObjectClientBean subObject : object.getIndexSubObjects()) {
            if (!(subObject instanceof GlobalObjectClientBean) || subObject.equals(object)) continue;
            MetadataInheritanceAttachedService.clearCache(mainObjId, (GlobalObjectClientBean)subObject);
        }
    }

    static {
        stat.setServiceStatus(Statistic.ServiceStatus.NOT_STARTED_YET);
        ServiceUtils.whenAutoUpdateFinished(thread::start);
    }
}

