/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.mbeans;

import agorum.commons.cron.SystemTimer;
import agorum.commons.logging.AgorumCoreStartDescLogger;
import agorum.commons.server.ServiceUtils;
import agorum.commons.utils.ObjectChangeInfo;
import agorum.roi.ejb.common.JMSEventController;
import agorum.roi.ejb.common.JMSEventListenerBean;
import agorum.roi.ejb.common.JMSEventListenerInterface;
import agorum.roi.ejb.mbeans.ObjectChangeServiceMBean;
import agorum.roi.ejb.messaging.common.MessageConnectionHolder;
import agorum.roi.ejb.messaging.common.MessageUtils;
import java.util.ArrayList;
import java.util.List;
import javax.jms.Message;
import javax.jms.MessageListener;

public class ObjectChangeService
implements ObjectChangeServiceMBean,
MessageListener,
JMSEventListenerInterface {
    private List<MessageConnectionHolder> messageConnectionHolders = new ArrayList<MessageConnectionHolder>();
    private boolean isStarted = false;
    private List<Message> queue = new ArrayList<Message>();
    private SystemTimer objectChangeRemovalTimer = null;
    private JMSEventListenerBean jmsBean = null;
    private JMSEventController eventController = null;
    public static boolean killTest = false;

    @Override
    public void start() {
        System.out.println("---------- Starting ObjectChange Service -------------");
        AgorumCoreStartDescLogger startLogger = new AgorumCoreStartDescLogger();
        startLogger.writeDescToFile("Starting object change service...\n\n", "");
        final ObjectChangeService jmsEventListener = this;
        ServiceUtils.whenStarted((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    ObjectChangeService.this.connectEvents();
                    ObjectChangeService.this.jmsBean = new JMSEventListenerBean();
                    ObjectChangeService.this.jmsBean.setId("ObjectChangeService_" + jmsEventListener.hashCode());
                    ObjectChangeService.this.jmsBean.setJmsEventListener(jmsEventListener);
                    ObjectChangeService.this.eventController = JMSEventController.getInstance();
                    ObjectChangeService.this.eventController.registerListener(ObjectChangeService.this.jmsBean);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public void stop() {
        System.out.println("---------- Stopping ObjectChange Service  -------------");
        this.objectChangeRemovalTimer.cancel();
        this.disconnectEvents();
        this.jmsBean.setRemoveEvent(true);
    }

    private void connectEvents() {
        try {
            killTest = false;
            MessageUtils messageUtils = new MessageUtils();
            this.messageConnectionHolders.add(messageUtils.registerSubScriber(this, "updateObjectListener"));
            this.messageConnectionHolders.add(messageUtils.registerSubScriber(this, "addRelationListener"));
            this.messageConnectionHolders.add(messageUtils.registerSubScriber(this, "removeRelationListener"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void disconnectEvents() {
        MessageUtils mu = new MessageUtils();
        for (MessageConnectionHolder messageConnectionHolder : this.messageConnectionHolders) {
            try {
                mu.unregisterSubScriber(messageConnectionHolder);
            }
            catch (Exception exception) {}
        }
        this.messageConnectionHolders.clear();
    }

    @Override
    public void reconnectEvent() {
        this.disconnectEvents();
        this.connectEvents();
    }

    @Override
    public void sendCheckEvent() {
    }

    private synchronized boolean isStarted() {
        if (this.isStarted) {
            return true;
        }
        this.isStarted = true;
        return false;
    }

    private synchronized Message queueing(Message msg) {
        if (msg != null) {
            if (!this.eventController.checkMyEvent(this.jmsBean, msg)) {
                this.queue.add(msg);
            }
            return null;
        }
        Message nextMessage = null;
        if (this.queue.size() > 0) {
            nextMessage = this.queue.get(0);
            this.queue.remove(0);
        }
        return nextMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg) {
        this.queueing(msg);
        if (!this.isStarted()) {
            try {
                while ((msg = this.queueing(null)) != null) {
                    try {
                        Object object = msg.getObjectProperty("value");
                        long id = 0L;
                        if (object instanceof Long) {
                            id = (Long)object;
                        }
                        String className = (String)msg.getObjectProperty("className");
                        msg.getObjectProperty("eventType");
                        Object rightId = msg.getObjectProperty("valueRightObject");
                        ObjectChangeInfo changeInfo = new ObjectChangeInfo();
                        changeInfo.id = id;
                        changeInfo.className = className;
                        changeInfo.eventType = (String)msg.getObjectProperty("eventType");
                        if (rightId != null) {
                            changeInfo.rightId = (Long)rightId;
                        }
                        changeInfo.timeStamp = System.currentTimeMillis();
                        ObjectChangeInfo.changeInfos.add(changeInfo);
                    }
                    catch (Exception jmsE) {
                        jmsE.printStackTrace();
                    }
                }
            }
            finally {
                this.isStarted = false;
            }
        }
    }
}

