/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.mbeans;

import agorum.commons.cron.SystemTimer;
import agorum.commons.cron.Trace;
import agorum.commons.logging.AgorumCoreStartDescLogger;
import agorum.commons.server.ServiceUtils;
import agorum.roi.ejb.common.ConnectionUtils;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.JMSEventController;
import agorum.roi.ejb.common.JMSEventListenerBean;
import agorum.roi.ejb.common.JMSEventListenerInterface;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.ejb.common.ServiceAuthInterface;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.mbeans.OldToPathIndexServiceMBean;
import agorum.roi.ejb.messaging.common.MessageBean;
import agorum.roi.ejb.messaging.common.MessageConnectionHolder;
import agorum.roi.ejb.messaging.common.MessageUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Vector;
import javax.jms.Message;
import javax.jms.MessageListener;

public class OldToPathIndexService
implements OldToPathIndexServiceMBean,
MessageListener,
JMSEventListenerInterface {
    private Vector messageConnectionHolders = new Vector();
    private boolean isStarted = false;
    private Vector queue = new Vector();
    private ArrayList idList = new ArrayList();
    private SystemTimer toIndexTimer = null;
    private JMSEventListenerBean jmsBean = null;
    private JMSEventController eventController = null;
    public static boolean killTest = false;
    private SessionController sessionController = null;
    private boolean firstRun = true;

    @Override
    public void start() {
        System.err.println("---------- Starting ToPathIndex Service -------------");
        AgorumCoreStartDescLogger startLogger = new AgorumCoreStartDescLogger();
        startLogger.writeDescToFile("Starting topathindex service...\n\n", "");
        final OldToPathIndexService jmsEventListener = this;
        ServiceUtils.whenStarted((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    OldToPathIndexService.this.connect();
                    OldToPathIndexService.this.connectEvents();
                    System.err.println("ToPathIndexService: Server is started, sessionController: " + OldToPathIndexService.this.sessionController);
                    OldToPathIndexService.this.jmsBean = new JMSEventListenerBean();
                    OldToPathIndexService.this.jmsBean.setId("ToPathIndexService_" + jmsEventListener.hashCode());
                    OldToPathIndexService.this.jmsBean.setJmsEventListener(jmsEventListener);
                    OldToPathIndexService.this.eventController = JMSEventController.getInstance();
                    OldToPathIndexService.this.eventController.registerListener(OldToPathIndexService.this.jmsBean);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                OldToPathIndexService.this.toIndexTimer = SystemTimer.ofPeriod((long)1000L).name("ToIndexTimer").call((Runnable)new ToIndexTimerTask());
            }
        });
    }

    @Override
    public void stop() {
        System.err.println("---------- Stopping ToPathIndex Service  -------------");
        this.toIndexTimer.cancel();
        this.disconnectEvents();
        this.jmsBean.setRemoveEvent(true);
    }

    private void connectEvents() {
        try {
            killTest = false;
            MessageUtils messageUtils = new MessageUtils();
            this.messageConnectionHolders.addElement(messageUtils.registerSubScriber(this, "updateToPathListener"));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private void disconnectEvents() {
        int len = this.messageConnectionHolders.size();
        MessageUtils mu = new MessageUtils();
        for (int i = 0; i < len; ++i) {
            try {
                MessageConnectionHolder messageConnectionHolder = (MessageConnectionHolder)this.messageConnectionHolders.elementAt(i);
                mu.unregisterSubScriber(messageConnectionHolder);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.messageConnectionHolders.clear();
    }

    @Override
    public void reconnectEvent() {
        this.disconnectEvents();
        this.connectEvents();
    }

    @Override
    public void sendCheckEvent() {
        this.eventController.sendMyEvent(this.jmsBean, "updateToPathListener");
    }

    private synchronized boolean isStarted() {
        if (this.isStarted) {
            return true;
        }
        this.isStarted = true;
        return false;
    }

    private synchronized Message queueing(Message msg) {
        if (msg != null) {
            if (!this.eventController.checkMyEvent(this.jmsBean, msg)) {
                this.queue.addElement(msg);
            }
            return null;
        }
        Message nextMessage = null;
        if (this.queue.size() > 0) {
            nextMessage = (Message)this.queue.elementAt(0);
            this.queue.removeElementAt(0);
        }
        return nextMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg) {
        if (SessionController.getImportMode()) {
            return;
        }
        this.queueing(msg);
        if (!this.isStarted()) {
            try {
                while ((msg = this.queueing(null)) != null) {
                    try {
                        if (SessionController.getImportMode()) {
                            break;
                        }
                        this.connect();
                        Long id = (Long)msg.getObjectProperty("value");
                        ArrayList arrayList = this.idList;
                        synchronized (arrayList) {
                            this.idList.add(id);
                        }
                    }
                    catch (Exception jmsE) {
                        jmsE.printStackTrace();
                    }
                }
            }
            finally {
                this.isStarted = false;
            }
        }
    }

    private void connect() throws Exception {
        if (this.sessionController == null) {
            try {
                RoiProperties rp = new RoiProperties();
                CredentialObject credential = new CredentialObject();
                credential.setUserName(rp.getRoiSystemUser());
                credential.setAuthInterface(new ServiceAuthInterface());
                credential.setModulInfo("PathIndexService");
                this.sessionController = SessionController.connect(credential);
            }
            catch (Exception exception) {}
        } else {
            this.sessionController.reconnectIfNeeded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToPathIndexTable() throws Exception {
        ArrayList arrayList = this.idList;
        synchronized (arrayList) {
            RoiTransactionHandler rth = null;
            int len = this.idList.size();
            Statement ps = null;
            Statement psel = null;
            String insert = null;
            Connection conn = null;
            if (len > 0) {
                ConnectionUtils cu = new ConnectionUtils(null);
                try {
                    rth = new RoiTransactionHandler();
                    rth.begin();
                    conn = cu.getConnection();
                    for (int i = 0; i < len; ++i) {
                        Long id = (Long)this.idList.get(0);
                        this.idList.remove(0);
                        String select = "select * from topathindex where ID = ?";
                        psel = conn.prepareStatement(select);
                        psel.setLong(1, id);
                        ResultSet rs = psel.executeQuery();
                        if (!rs.next()) {
                            insert = "insert into topathindex (ID) values (?)";
                            ps = conn.prepareStatement(insert);
                            System.out.println("PathIndex: added to topathindex: " + id);
                            ps.setLong(1, id);
                            ps.execute();
                            ps.close();
                            ps = null;
                        }
                        rs.close();
                        rs = null;
                        psel.close();
                        psel = null;
                    }
                    MessageUtils messageUtils = new MessageUtils();
                    MessageBean mb = new MessageBean();
                    mb.setObjectProperty("value", "path");
                    mb.setObjectProperty("eventType", "pathIndexListener");
                    messageUtils.publishToTopic("pathIndexListener", mb, true);
                    rth.end();
                    rth = null;
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
                finally {
                    try {
                        if (ps != null) {
                            ps.close();
                        }
                        ps = null;
                        if (psel != null) {
                            psel.close();
                        }
                        psel = null;
                        cu.closeConnection();
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                    try {
                        if (rth != null) {
                            rth.abort();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private class ToIndexTimerTask
    implements Runnable {
        private ToIndexTimerTask() {
        }

        @Override
        public void run() {
            Throwable throwable;
            Trace.Auto trace;
            block19: {
                block20: {
                    block21: {
                        trace = Trace.auto((String)"Write path index task");
                        throwable = null;
                        if (!SessionController.getImportMode()) break block19;
                        trace.ended();
                        if (trace == null) break block20;
                        if (throwable == null) break block21;
                        try {
                            trace.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block20;
                    }
                    trace.close();
                }
                return;
            }
            try {
                try {
                    if (OldToPathIndexService.this.idList.size() > 0) {
                        trace.working("Writing path index");
                        OldToPathIndexService.this.writeToPathIndexTable();
                    }
                    if (OldToPathIndexService.this.firstRun) {
                        trace.working("Initializing");
                        OldToPathIndexService.this.firstRun = false;
                        MessageUtils messageUtils = new MessageUtils();
                        MessageBean mb = new MessageBean();
                        mb.setObjectProperty("value", "path");
                        mb.setObjectProperty("eventType", "pathIndexListener");
                        messageUtils.publishToTopic("pathIndexListener", mb, true);
                    }
                    trace.ended();
                }
                catch (Exception e) {
                    trace.failed();
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                throw throwable4;
            }
            finally {
                if (trace != null) {
                    if (throwable != null) {
                        try {
                            trace.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        trace.close();
                    }
                }
            }
        }
    }
}

